/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.event;

import java.awt.geom.Point2D;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.jhotdraw.draw.AbstractFigure;

public class SetBoundsEdit
extends AbstractUndoableEdit {
    private AbstractFigure owner;
    private Point2D.Double oldAnchor;
    private Point2D.Double oldLead;
    private Point2D.Double newAnchor;
    private Point2D.Double newLead;

    public SetBoundsEdit(AbstractFigure owner, Point2D.Double oldAnchor, Point2D.Double oldLead, Point2D.Double newAnchor, Point2D.Double newLead) {
        this.owner = owner;
        this.oldAnchor = oldAnchor;
        this.oldLead = oldLead;
        this.newAnchor = newAnchor;
        this.newLead = newLead;
    }

    @Override
    public String getPresentationName() {
        return "Abmessungen \u00e4ndern";
    }

    @Override
    public boolean addEdit(UndoableEdit anEdit) {
        if (anEdit instanceof SetBoundsEdit) {
            SetBoundsEdit that = (SetBoundsEdit)anEdit;
            if (that.owner == this.owner) {
                this.newAnchor = that.newAnchor;
                this.newLead = that.newLead;
                that.die();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean replaceEdit(UndoableEdit anEdit) {
        if (anEdit instanceof SetBoundsEdit) {
            SetBoundsEdit that = (SetBoundsEdit)anEdit;
            if (that.owner == this.owner) {
                that.oldAnchor = this.oldAnchor;
                that.oldLead = this.oldLead;
                this.die();
                return true;
            }
        }
        return false;
    }

    @Override
    public void redo() throws CannotRedoException {
        super.redo();
        this.owner.willChange();
        this.owner.setBounds(this.newAnchor, this.newLead);
        this.owner.changed();
    }

    @Override
    public void undo() throws CannotUndoException {
        super.undo();
        this.owner.willChange();
        this.owner.setBounds(this.oldAnchor, this.oldLead);
        this.owner.changed();
    }
}

