/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.handle;

import java.awt.Cursor;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.KeyEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.Collection;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.event.TransformEdit;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.HandleAttributeKeys;
import org.jhotdraw.draw.handle.LocatorHandle;
import org.jhotdraw.draw.locator.Locator;
import org.jhotdraw.draw.locator.RelativeLocator;

public class MoveHandle
extends LocatorHandle {
    private Point2D.Double oldPoint;

    public MoveHandle(Figure owner, Locator locator) {
        super(owner, locator);
    }

    public static void addMoveHandles(Figure f, Collection<Handle> handles) {
        handles.add(MoveHandle.southEast(f));
        handles.add(MoveHandle.southWest(f));
        handles.add(MoveHandle.northEast(f));
        handles.add(MoveHandle.northWest(f));
    }

    @Override
    public void draw(Graphics2D g) {
        if (this.getOwner().isTransformable()) {
            this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.MOVE_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.MOVE_HANDLE_STROKE_COLOR));
        } else {
            this.drawRectangle(g, this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_FILL_COLOR), this.getEditor().getHandleAttribute(HandleAttributeKeys.NULL_HANDLE_STROKE_COLOR));
        }
    }

    @Override
    public Cursor getCursor() {
        return Cursor.getPredefinedCursor(this.getOwner().isTransformable() ? 13 : 0);
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
        this.oldPoint = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(anchor));
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
        Figure f = this.getOwner();
        if (f.isTransformable()) {
            Point2D.Double newPoint = this.view.getConstrainer().constrainPoint(this.view.viewToDrawing(lead));
            AffineTransform tx = new AffineTransform();
            tx.translate(newPoint.x - this.oldPoint.x, newPoint.y - this.oldPoint.y);
            f.willChange();
            f.transform(tx);
            f.changed();
            this.oldPoint = newPoint;
        }
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
        if (this.getOwner().isTransformable()) {
            AffineTransform tx = new AffineTransform();
            tx.translate(lead.x - anchor.x, lead.y - anchor.y);
            this.fireUndoableEditHappened(new TransformEdit(this.getOwner(), tx));
        }
    }

    @Override
    public void keyPressed(KeyEvent evt) {
        Figure f = this.getOwner();
        if (f.isTransformable()) {
            AffineTransform tx = new AffineTransform();
            switch (evt.getKeyCode()) {
                case 38: {
                    tx.translate(0.0, -1.0);
                    evt.consume();
                    break;
                }
                case 40: {
                    tx.translate(0.0, 1.0);
                    evt.consume();
                    break;
                }
                case 37: {
                    tx.translate(-1.0, 0.0);
                    evt.consume();
                    break;
                }
                case 39: {
                    tx.translate(1.0, 0.0);
                    evt.consume();
                }
            }
            f.willChange();
            f.transform(tx);
            f.changed();
            this.fireUndoableEditHappened(new TransformEdit(f, tx));
        }
    }

    public static Handle south(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.south());
    }

    public static Handle southEast(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.southEast());
    }

    public static Handle southWest(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.southWest());
    }

    public static Handle north(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.north());
    }

    public static Handle northEast(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.northEast());
    }

    public static Handle northWest(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.northWest());
    }

    public static Handle east(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.east());
    }

    public static Handle west(Figure owner) {
        return new MoveHandle(owner, RelativeLocator.west());
    }
}

