/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.locator;

import java.awt.geom.Point2D;
import org.jhotdraw.draw.BezierFigure;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.locator.Locator;
import org.jhotdraw.geom.Dimension2DDouble;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMOutput;
import org.jhotdraw.xml.DOMStorable;

public class BezierLabelLocator
implements Locator,
DOMStorable {
    private double relativePosition;
    private double angle;
    private double distance;

    public BezierLabelLocator() {
    }

    public BezierLabelLocator(double relativePosition, double angle, double distance) {
        this.relativePosition = relativePosition;
        this.angle = angle;
        this.distance = distance;
    }

    @Override
    public Point2D.Double locate(Figure owner) {
        return this.getRelativePoint((BezierFigure)owner);
    }

    @Override
    public Point2D.Double locate(Figure owner, Figure label) {
        Point2D.Double relativePoint = this.getRelativeLabelPoint((BezierFigure)owner, label);
        return relativePoint;
    }

    public Point2D.Double getRelativePoint(BezierFigure owner) {
        Point2D.Double point = owner.getPointOnPath((float)this.relativePosition, 3.0);
        Point2D.Double nextPoint = owner.getPointOnPath(this.relativePosition < 0.5 ? (float)this.relativePosition + 0.1f : (float)this.relativePosition - 0.1f, 3.0);
        double dir = Math.atan2(nextPoint.y - point.y, nextPoint.x - point.x);
        if (this.relativePosition >= 0.5) {
            dir += Math.PI;
        }
        double alpha = dir + this.angle;
        Point2D.Double p = new Point2D.Double(point.x + this.distance * Math.cos(alpha), point.y + this.distance * Math.sin(alpha));
        if (Double.isNaN(p.x)) {
            p = point;
        }
        return p;
    }

    public Point2D.Double getRelativeLabelPoint(BezierFigure owner, Figure label) {
        Point2D.Double point = owner.getPointOnPath((float)this.relativePosition, 3.0);
        if (point == null) {
            return new Point2D.Double(0.0, 0.0);
        }
        Point2D.Double nextPoint = owner.getPointOnPath(this.relativePosition < 0.5 ? (float)this.relativePosition + 0.1f : (float)this.relativePosition - 0.1f, 3.0);
        double dir = Math.atan2(nextPoint.y - point.y, nextPoint.x - point.x);
        if (this.relativePosition >= 0.5) {
            dir += Math.PI;
        }
        double alpha = dir + this.angle;
        Point2D.Double p = new Point2D.Double(point.x + this.distance * Math.cos(alpha), point.y + this.distance * Math.sin(alpha));
        if (Double.isNaN(p.x)) {
            p = point;
        }
        Dimension2DDouble labelDim = label.getPreferredSize();
        if (this.relativePosition == 0.5 && p.x >= point.x - this.distance / 2.0 && p.x <= point.x + this.distance / 2.0) {
            if (p.y >= point.y) {
                return new Point2D.Double(p.x - labelDim.width / 2.0, p.y);
            }
            return new Point2D.Double(p.x - labelDim.width / 2.0, p.y - labelDim.height);
        }
        if (p.x >= point.x) {
            if (p.y >= point.y) {
                return new Point2D.Double(p.x, p.y);
            }
            return new Point2D.Double(p.x, p.y - labelDim.height);
        }
        if (p.y >= point.y) {
            return new Point2D.Double(p.x - labelDim.width, p.y);
        }
        return new Point2D.Double(p.x - labelDim.width, p.y - labelDim.height);
    }

    @Override
    public void read(DOMInput in) {
        this.relativePosition = in.getAttribute("relativePosition", 0.0);
        this.angle = in.getAttribute("angle", 0.0);
        this.distance = in.getAttribute("distance", 0);
    }

    @Override
    public void write(DOMOutput out) {
        out.addAttribute("relativePosition", this.relativePosition);
        out.addAttribute("angle", this.angle);
        out.addAttribute("distance", this.distance);
    }
}

