/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.draw.text;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.JTextField;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.TextHolderFigure;
import org.jhotdraw.draw.event.FigureAdapter;
import org.jhotdraw.draw.event.FigureEvent;
import org.jhotdraw.draw.event.FigureListener;

public class FloatingTextField {
    @Nullable
    private TextHolderFigure editedFigure;
    private JTextField textField;
    private DrawingView view;
    private FigureListener figureHandler = new FigureAdapter(){

        @Override
        public void attributeChanged(FigureEvent e) {
            FloatingTextField.this.updateWidget();
        }
    };

    public FloatingTextField() {
        this.textField = new JTextField(20);
    }

    public void requestFocus() {
        this.textField.requestFocus();
    }

    public void createOverlay(DrawingView view, TextHolderFigure figure) {
        view.getComponent().add((Component)this.textField, 0);
        this.textField.setText(figure.getText());
        this.textField.setColumns(figure.getTextColumns());
        this.textField.selectAll();
        this.textField.setVisible(true);
        this.editedFigure = figure;
        this.editedFigure.addFigureListener(this.figureHandler);
        this.view = view;
        this.updateWidget();
    }

    protected void updateWidget() {
        Font font = this.editedFigure.getFont();
        font = font.deriveFont(font.getStyle(), (float)((double)this.editedFigure.getFontSize() * this.view.getScaleFactor()));
        this.textField.setFont(font);
        this.textField.setForeground(this.editedFigure.getTextColor());
        this.textField.setBackground(this.editedFigure.getFillColor());
        Rectangle2D.Double fDrawBounds = this.editedFigure.getBounds();
        Point2D.Double fDrawLoc = new Point2D.Double(fDrawBounds.getX(), fDrawBounds.getY());
        if (this.editedFigure.get(AttributeKeys.TRANSFORM) != null) {
            this.editedFigure.get(AttributeKeys.TRANSFORM).transform(fDrawLoc, fDrawLoc);
        }
        Point fViewLoc = this.view.drawingToView(fDrawLoc);
        Rectangle fViewBounds = this.view.drawingToView(fDrawBounds);
        fViewBounds.x = fViewLoc.x;
        fViewBounds.y = fViewLoc.y;
        Dimension tfDim = this.textField.getPreferredSize();
        Insets tfInsets = this.textField.getInsets();
        float fontBaseline = this.textField.getGraphics().getFontMetrics(font).getMaxAscent();
        double fBaseline = this.editedFigure.getBaseline() * this.view.getScaleFactor();
        this.textField.setBounds(fViewBounds.x - tfInsets.left, fViewBounds.y - tfInsets.top - (int)((double)fontBaseline - fBaseline), Math.max(fViewBounds.width + tfInsets.left + tfInsets.right, tfDim.width), Math.max(fViewBounds.height + tfInsets.top + tfInsets.bottom, tfDim.height));
    }

    public Insets getInsets() {
        return this.textField.getInsets();
    }

    public void addActionListener(ActionListener listener) {
        this.textField.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.textField.removeActionListener(listener);
    }

    public String getText() {
        return this.textField.getText();
    }

    public Dimension getPreferredSize(int cols) {
        this.textField.setColumns(cols);
        return this.textField.getPreferredSize();
    }

    public void endOverlay() {
        this.view.getComponent().requestFocus();
        if (this.textField != null) {
            this.textField.setVisible(false);
            this.view.getComponent().remove(this.textField);
            Rectangle bounds = this.textField.getBounds();
            this.view.getComponent().repaint(bounds.x, bounds.y, bounds.width, bounds.height);
        }
        if (this.editedFigure != null) {
            this.editedFigure.removeFigureListener(this.figureHandler);
            this.editedFigure = null;
        }
    }
}

