/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui.plaf.palette.colorchooser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JSlider;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import org.jhotdraw.color.HSVColorSpace;
import org.jhotdraw.color.JColorWheel;
import org.jhotdraw.gui.plaf.palette.PaletteLookAndFeel;
import org.jhotdraw.gui.plaf.palette.PalettePanelUI;
import org.jhotdraw.gui.plaf.palette.colorchooser.PaletteColorSliderModel;

public class PaletteColorWheelChooser
extends AbstractColorChooserPanel
implements UIResource {
    private JColorWheel colorWheel;
    private PaletteColorSliderModel ccModel = new PaletteColorSliderModel(new HSVColorSpace());
    private int updatingChooser;
    private JSlider brightnessSlider;

    private void initComponents() {
        this.brightnessSlider = new JSlider();
        this.setBorder(BorderFactory.createEmptyBorder(4, 6, 6, 6));
        this.setLayout(new BorderLayout());
        this.brightnessSlider.setMajorTickSpacing(50);
        this.brightnessSlider.setOrientation(1);
        this.brightnessSlider.setPaintTicks(true);
        this.add((Component)this.brightnessSlider, "East");
    }

    @Override
    protected void buildChooser() {
        this.initComponents();
        this.setUI(PalettePanelUI.createUI(this));
        int textSliderGap = PaletteLookAndFeel.getInstance().getInt("ColorChooser.textSliderGap");
        if (textSliderGap != 0) {
            BorderLayout layout = (BorderLayout)this.getLayout();
            layout.setHgap(textSliderGap);
        }
        this.colorWheel = new JColorWheel();
        this.add(this.colorWheel);
        this.ccModel.configureSlider(2, this.brightnessSlider);
        this.brightnessSlider.setMaximum(200);
        this.colorWheel.setModel(this.ccModel);
        this.ccModel.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent evt) {
                PaletteColorWheelChooser.this.setColorToModel(PaletteColorWheelChooser.this.ccModel.getColor());
            }
        });
    }

    @Override
    public String getDisplayName() {
        return PaletteLookAndFeel.getInstance().getString("ColorChooser.colorWheel");
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return PaletteLookAndFeel.getInstance().getIcon("ColorChooser.colorWheelIcon");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return this.getLargeDisplayIcon();
    }

    @Override
    public void updateChooser() {
        ++this.updatingChooser;
        this.ccModel.setColor(this.getColorFromModel());
        --this.updatingChooser;
    }

    public void setColorToModel(Color color) {
        if (this.updatingChooser == 0) {
            this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

