/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.net;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.security.InvalidParameterException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Random;

public class ClientHttpRequest {
    URLConnection connection;
    @Nullable
    OutputStream os = null;
    Map<String, String> cookies = new HashMap<String, String>();
    String rawCookies = "";
    private static Random random = new Random();
    String boundary = "---------------------------" + ClientHttpRequest.randomString() + ClientHttpRequest.randomString() + ClientHttpRequest.randomString();

    protected void connect() throws IOException {
        if (this.os == null) {
            this.os = this.connection.getOutputStream();
        }
    }

    protected void write(char c) throws IOException {
        this.connect();
        this.os.write(c);
    }

    protected void write(String s) throws IOException {
        this.connect();
        this.os.write(s.getBytes("UTF-8"));
    }

    protected void newline() throws IOException {
        this.connect();
        this.write("\r\n");
    }

    protected void writeln(String s) throws IOException {
        this.connect();
        this.write(s);
        this.newline();
    }

    protected static String randomString() {
        return Long.toString(random.nextLong(), 36);
    }

    private void boundary() throws IOException {
        this.write("--");
        this.write(this.boundary);
    }

    public ClientHttpRequest(URLConnection connection) throws IOException {
        this.connection = connection;
        connection.setDoOutput(true);
        connection.setDoInput(true);
        connection.setRequestProperty("Content-Type", "multipart/form-data; boundary=" + this.boundary);
    }

    public ClientHttpRequest(URL url) throws IOException {
        this(url.openConnection());
    }

    public ClientHttpRequest(String urlString) throws IOException {
        this(new URL(urlString));
    }

    private void postCookies() {
        StringBuffer cookieList = new StringBuffer(this.rawCookies);
        Iterator<Map.Entry<String, String>> i = this.cookies.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<String, String> entry = i.next();
            cookieList.append(entry.getKey().toString() + "=" + entry.getValue());
            if (!i.hasNext()) continue;
            cookieList.append("; ");
        }
        if (cookieList.length() > 0) {
            this.connection.setRequestProperty("Cookie", cookieList.toString());
        }
    }

    public void setCookies(String rawCookies) throws IOException {
        this.rawCookies = rawCookies == null ? "" : rawCookies;
        this.cookies.clear();
    }

    public void setCookie(String name, String value) throws IOException {
        this.cookies.put(name, value);
    }

    public void setCookies(Map<String, String> cookies) throws IOException {
        if (cookies == null) {
            return;
        }
        this.cookies.putAll(cookies);
    }

    public void setCookies(String[] cookies) throws IOException {
        if (cookies == null) {
            return;
        }
        for (int i = 0; i < cookies.length - 1; i += 2) {
            this.setCookie(cookies[i], cookies[i + 1]);
        }
    }

    private void writeName(String name) throws IOException {
        this.newline();
        this.write("Content-Disposition: form-data; name=\"");
        this.write(name);
        this.write('\"');
    }

    public void setParameter(String name, String value) throws IOException {
        if (name == null) {
            throw new InvalidParameterException("setParameter(" + name + "," + value + ") name must not be null");
        }
        if (value == null) {
            throw new InvalidParameterException("setParameter(" + name + "," + value + ") value must not be null");
        }
        this.boundary();
        this.writeName(name);
        this.newline();
        this.newline();
        this.writeln(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void pipe(InputStream in, OutputStream out) throws IOException {
        byte[] buf = new byte[500000];
        int total = 0;
        InputStream inputStream = in;
        synchronized (inputStream) {
            int nread;
            while ((nread = in.read(buf, 0, buf.length)) >= 0) {
                out.write(buf, 0, nread);
                total += nread;
            }
        }
        out.flush();
        buf = null;
    }

    public void setParameter(String name, String filename, InputStream is) throws IOException {
        this.boundary();
        this.writeName(name);
        this.write("; filename=\"");
        this.write(filename);
        this.write('\"');
        this.newline();
        this.write("Content-Type: ");
        String type = URLConnection.guessContentTypeFromName(filename);
        if (type == null) {
            type = "application/octet-stream";
        }
        this.writeln(type);
        this.newline();
        ClientHttpRequest.pipe(is, this.os);
        this.newline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setParameter(String name, File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            this.setParameter(name, file.getPath(), in);
        }
        finally {
            in.close();
        }
    }

    public void setParameter(String name, Object object) throws IOException {
        if (object instanceof File) {
            this.setParameter(name, (File)object);
        } else {
            this.setParameter(name, object.toString());
        }
    }

    public void setParameters(Map parameters) throws IOException {
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                this.setParameter(entry.getKey().toString(), entry.getValue());
            }
        }
    }

    public void setParameters(Object[] parameters) throws IOException {
        if (parameters != null) {
            for (int i = 0; i < parameters.length - 1; i += 2) {
                this.setParameter(parameters[i].toString(), parameters[i + 1]);
            }
        }
    }

    private InputStream doPost() throws IOException {
        this.boundary();
        this.writeln("--");
        this.os.close();
        return this.connection.getInputStream();
    }

    public InputStream post() throws IOException {
        this.postCookies();
        return this.doPost();
    }

    public InputStream post(Map parameters) throws IOException {
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public InputStream post(Object[] parameters) throws IOException {
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public InputStream post(Map<String, String> cookies, Map parameters) throws IOException {
        this.setCookies(cookies);
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public InputStream post(String raw_cookies, Map parameters) throws IOException {
        this.setCookies(raw_cookies);
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public InputStream post(String[] cookies, Object[] parameters) throws IOException {
        this.setCookies(cookies);
        this.postCookies();
        this.setParameters(parameters);
        return this.doPost();
    }

    public InputStream post(String name, Object value) throws IOException {
        this.postCookies();
        this.setParameter(name, value);
        return this.doPost();
    }

    public InputStream post(String name1, Object value1, String name2, Object value2) throws IOException {
        this.postCookies();
        this.setParameter(name1, value1);
        this.setParameter(name2, value2);
        return this.doPost();
    }

    public InputStream post(String name1, Object value1, String name2, Object value2, String name3, Object value3) throws IOException {
        this.postCookies();
        this.setParameter(name1, value1);
        this.setParameter(name2, value2);
        this.setParameter(name3, value3);
        return this.doPost();
    }

    public InputStream post(String name1, Object value1, String name2, Object value2, String name3, Object value3, String name4, Object value4) throws IOException {
        this.postCookies();
        this.setParameter(name1, value1);
        this.setParameter(name2, value2);
        this.setParameter(name3, value3);
        this.setParameter(name4, value4);
        return this.doPost();
    }

    public static InputStream post(URL url, Map parameters) throws IOException {
        return new ClientHttpRequest(url).post(parameters);
    }

    public static InputStream post(URL url, Object[] parameters) throws IOException {
        return new ClientHttpRequest(url).post(parameters);
    }

    public static InputStream post(URL url, Map<String, String> cookies, Map parameters) throws IOException {
        return new ClientHttpRequest(url).post(cookies, parameters);
    }

    public static InputStream post(URL url, String[] cookies, Object[] parameters) throws IOException {
        return new ClientHttpRequest(url).post(cookies, parameters);
    }

    public static InputStream post(URL url, String name1, Object value1) throws IOException {
        return new ClientHttpRequest(url).post(name1, value1);
    }

    public static InputStream post(URL url, String name1, Object value1, String name2, Object value2) throws IOException {
        return new ClientHttpRequest(url).post(name1, value1, name2, value2);
    }

    public static InputStream post(URL url, String name1, Object value1, String name2, Object value2, String name3, Object value3) throws IOException {
        return new ClientHttpRequest(url).post(name1, value1, name2, value2, name3, value3);
    }

    public static InputStream post(URL url, String name1, Object value1, String name2, Object value2, String name3, Object value3, String name4, Object value4) throws IOException {
        return new ClientHttpRequest(url).post(name1, value1, name2, value2, name3, value3, name4, value4);
    }
}

