/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.figures;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import org.jhotdraw.draw.AbstractAttributedCompositeFigure;
import org.jhotdraw.draw.AttributeKey;
import org.jhotdraw.draw.AttributeKeys;
import org.jhotdraw.draw.ConnectionFigure;
import org.jhotdraw.draw.DrawingView;
import org.jhotdraw.draw.Figure;
import org.jhotdraw.draw.connector.Connector;
import org.jhotdraw.draw.handle.Handle;
import org.jhotdraw.draw.handle.TransformHandleKit;
import org.jhotdraw.geom.BezierPath;
import org.jhotdraw.geom.Geom;
import org.jhotdraw.geom.GrowStroke;
import org.jhotdraw.geom.Shapes;
import org.jhotdraw.samples.odg.Gradient;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.ODGConstants;
import org.jhotdraw.samples.odg.figures.ODGBezierFigure;
import org.jhotdraw.samples.odg.figures.ODGFigure;
import org.jhotdraw.samples.odg.figures.ODGPathOutlineHandle;
import org.jhotdraw.util.ResourceBundleUtil;

public class ODGPathFigure
extends AbstractAttributedCompositeFigure
implements ODGFigure {
    @Nullable
    private transient Path2D.Double cachedPath;
    private static final boolean DEBUG = false;

    public ODGPathFigure() {
        this.add(new ODGBezierFigure());
        ODGAttributeKeys.setDefaults(this);
    }

    @Override
    public void draw(Graphics2D g) {
        double opacity = this.get(ODGAttributeKeys.OPACITY);
        if ((opacity = Math.min(Math.max(0.0, opacity), 1.0)) != 0.0) {
            if (opacity != 1.0) {
                Rectangle2D.Double drawingArea = this.getDrawingArea();
                Rectangle clipBounds = g.getClipBounds();
                if (clipBounds != null) {
                    Rectangle2D.intersect(drawingArea, clipBounds, drawingArea);
                }
                if (!drawingArea.isEmpty()) {
                    BufferedImage buf = new BufferedImage(Math.max(1, (int)((2.0 + drawingArea.width) * g.getTransform().getScaleX())), Math.max(1, (int)((2.0 + drawingArea.height) * g.getTransform().getScaleY())), 2);
                    Graphics2D gr = buf.createGraphics();
                    gr.scale(g.getTransform().getScaleX(), g.getTransform().getScaleY());
                    gr.translate((int)(-drawingArea.x), (int)(-drawingArea.y));
                    gr.setRenderingHints(g.getRenderingHints());
                    this.drawFigure(gr);
                    gr.dispose();
                    Composite savedComposite = g.getComposite();
                    g.setComposite(AlphaComposite.getInstance(3, (float)opacity));
                    g.drawImage(buf, (int)drawingArea.x, (int)drawingArea.y, 2 + (int)drawingArea.width, 2 + (int)drawingArea.height, null);
                    g.setComposite(savedComposite);
                }
            } else {
                this.drawFigure(g);
            }
        }
    }

    @Override
    public void drawFigure(Graphics2D g) {
        Paint paint;
        AffineTransform savedTransform = null;
        if (this.get(ODGAttributeKeys.TRANSFORM) != null) {
            savedTransform = g.getTransform();
            g.transform((AffineTransform)this.get(ODGAttributeKeys.TRANSFORM));
        }
        if (this.get(ODGAttributeKeys.FILL_STYLE) != ODGConstants.FillStyle.NONE && (paint = ODGAttributeKeys.getFillPaint(this)) != null) {
            g.setPaint(paint);
            this.drawFill(g);
        }
        if (this.get(ODGAttributeKeys.STROKE_STYLE) != ODGConstants.StrokeStyle.NONE && (paint = ODGAttributeKeys.getStrokePaint(this)) != null) {
            g.setPaint(paint);
            g.setStroke(ODGAttributeKeys.getStroke(this));
            this.drawStroke(g);
        }
        if (this.get(ODGAttributeKeys.TRANSFORM) != null) {
            g.setTransform(savedTransform);
        }
    }

    @Override
    public void drawFill(Graphics2D g) {
        boolean isClosed = (Boolean)this.getChild(0).get(ODGAttributeKeys.PATH_CLOSED);
        if (isClosed) {
            g.fill(this.getPath());
        }
    }

    @Override
    public void drawStroke(Graphics2D g) {
        g.draw(this.getPath());
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.cachedPath = null;
        this.cachedDrawingArea = null;
    }

    protected Path2D.Double getPath() {
        if (this.cachedPath == null) {
            this.cachedPath = new Path2D.Double();
            this.cachedPath.setWindingRule(this.get(ODGAttributeKeys.WINDING_RULE) == AttributeKeys.WindingRule.EVEN_ODD ? 0 : 1);
            for (Figure child : this.getChildren()) {
                ODGBezierFigure b = (ODGBezierFigure)child;
                this.cachedPath.append(b.getBezierPath(), false);
            }
        }
        return this.cachedPath;
    }

    @Override
    public Rectangle2D.Double getDrawingArea() {
        if (this.cachedDrawingArea == null) {
            Rectangle2D rx;
            double strokeTotalWidth = AttributeKeys.getStrokeTotalWidth(this);
            double width = strokeTotalWidth / 2.0;
            if ((Integer)this.get(ODGAttributeKeys.STROKE_JOIN) == 0) {
                width *= ((Double)this.get(ODGAttributeKeys.STROKE_MITER_LIMIT)).doubleValue();
            } else if ((Integer)this.get(ODGAttributeKeys.STROKE_CAP) != 0) {
                width += strokeTotalWidth * 2.0;
            }
            Path2D.Double gp = this.getPath();
            Rectangle2D strokeRect = new Rectangle2D.Double(0.0, 0.0, width, width);
            if (this.get(ODGAttributeKeys.TRANSFORM) != null) {
                gp = (Path2D.Double)gp.clone();
                gp.transform((AffineTransform)this.get(ODGAttributeKeys.TRANSFORM));
                strokeRect = ((AffineTransform)this.get(ODGAttributeKeys.TRANSFORM)).createTransformedShape(strokeRect).getBounds2D();
            }
            Rectangle2D.Double r = (rx = gp.getBounds2D()) instanceof Rectangle2D.Double ? (Rectangle2D.Double)rx : new Rectangle2D.Double(rx.getX(), rx.getY(), rx.getWidth(), rx.getHeight());
            Geom.grow(r, ((RectangularShape)strokeRect).getWidth(), ((RectangularShape)strokeRect).getHeight());
            this.cachedDrawingArea = r;
        }
        return (Rectangle2D.Double)this.cachedDrawingArea.clone();
    }

    @Override
    public boolean contains(Point2D.Double p) {
        this.getPath();
        if (this.get(ODGAttributeKeys.TRANSFORM) != null) {
            try {
                p = (Point2D.Double)((AffineTransform)this.get(ODGAttributeKeys.TRANSFORM)).inverseTransform(p, new Point2D.Double());
            }
            catch (NoninvertibleTransformException ex) {
                ex.printStackTrace();
            }
        }
        boolean isClosed = (Boolean)this.getChild(0).get(ODGAttributeKeys.PATH_CLOSED);
        double tolerance = Math.max(2.0, AttributeKeys.getStrokeTotalWidth(this) / 2.0);
        if (isClosed) {
            if (this.getPath().contains(p)) {
                return true;
            }
            double grow = AttributeKeys.getPerpendicularHitGrowth(this) * 2.0;
            GrowStroke gs = new GrowStroke(grow, AttributeKeys.getStrokeTotalWidth(this) * (Double)this.get(ODGAttributeKeys.STROKE_MITER_LIMIT));
            if (gs.createStrokedShape(this.getPath()).contains(p)) {
                return true;
            }
            if (isClosed) {
                return false;
            }
        }
        return !isClosed && Shapes.outlineContains(this.getPath(), p, tolerance);
    }

    @Override
    public void setBounds(Point2D.Double anchor, Point2D.Double lead) {
        if (this.getChildCount() == 1 && this.getChild(0).getNodeCount() <= 2) {
            ODGBezierFigure b = this.getChild(0);
            b.setBounds(anchor, lead);
            this.invalidate();
        } else {
            super.setBounds(anchor, lead);
        }
    }

    @Override
    public void transform(AffineTransform tx) {
        if (this.get(ODGAttributeKeys.TRANSFORM) != null || (tx.getType() & 1) != tx.getType()) {
            if (this.get(ODGAttributeKeys.TRANSFORM) == null) {
                ODGAttributeKeys.TRANSFORM.setClone(this, tx);
            } else {
                AffineTransform t = (AffineTransform)ODGAttributeKeys.TRANSFORM.getClone(this);
                t.preConcatenate(tx);
                this.set(ODGAttributeKeys.TRANSFORM, t);
            }
        } else {
            Gradient g;
            for (Figure f : this.getChildren()) {
                f.transform(tx);
            }
            if (this.get(ODGAttributeKeys.FILL_GRADIENT) != null && !this.get(ODGAttributeKeys.FILL_GRADIENT).isRelativeToFigureBounds()) {
                g = ODGAttributeKeys.FILL_GRADIENT.getClone(this);
                g.transform(tx);
                this.set(ODGAttributeKeys.FILL_GRADIENT, g);
            }
            if (this.get(ODGAttributeKeys.STROKE_GRADIENT) != null && !this.get(ODGAttributeKeys.STROKE_GRADIENT).isRelativeToFigureBounds()) {
                g = ODGAttributeKeys.STROKE_GRADIENT.getClone(this);
                g.transform(tx);
                this.set(ODGAttributeKeys.STROKE_GRADIENT, g);
            }
        }
        this.invalidate();
    }

    @Override
    public void restoreTransformTo(Object geometry) {
        this.invalidate();
        Object[] restoreData = (Object[])geometry;
        ArrayList paths = (ArrayList)restoreData[0];
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            this.getChild(i).setBezierPath((BezierPath)paths.get(i));
        }
        ODGAttributeKeys.TRANSFORM.setClone(this, (AffineTransform)restoreData[1]);
        ODGAttributeKeys.FILL_GRADIENT.setClone(this, (Gradient)restoreData[2]);
        ODGAttributeKeys.STROKE_GRADIENT.setClone(this, (Gradient)restoreData[3]);
    }

    @Override
    public Object getTransformRestoreData() {
        ArrayList<BezierPath> paths = new ArrayList<BezierPath>(this.getChildCount());
        int n = this.getChildCount();
        for (int i = 0; i < n; ++i) {
            paths.add(this.getChild(i).getBezierPath());
        }
        return new Object[]{paths, ODGAttributeKeys.TRANSFORM.getClone(this), ODGAttributeKeys.FILL_GRADIENT.getClone(this), ODGAttributeKeys.STROKE_GRADIENT.getClone(this)};
    }

    @Override
    public <T> void set(AttributeKey<T> key, T newValue) {
        super.set(key, newValue);
        this.invalidate();
    }

    @Override
    protected <T> void setAttributeOnChildren(AttributeKey<T> key, T newValue) {
    }

    @Override
    public boolean isEmpty() {
        for (Figure child : this.getChildren()) {
            ODGBezierFigure b = (ODGBezierFigure)child;
            if (b.getNodeCount() <= 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public Collection<Handle> createHandles(int detailLevel) {
        LinkedList<Handle> handles = new LinkedList<Handle>();
        switch (detailLevel % 2) {
            case 0: {
                handles.add(new ODGPathOutlineHandle(this));
                for (Figure child : this.getChildren()) {
                    handles.addAll(((ODGBezierFigure)child).createHandles(this, detailLevel));
                }
                break;
            }
            case 1: {
                TransformHandleKit.addTransformHandles(this, handles);
                break;
            }
        }
        return handles;
    }

    @Override
    public Collection<Action> getActions(Point2D.Double p) {
        final ResourceBundleUtil labels = ResourceBundleUtil.getBundle("org.jhotdraw.samples.odg.Labels");
        LinkedList<Action> actions = new LinkedList<Action>();
        if (this.get(ODGAttributeKeys.TRANSFORM) != null) {
            actions.add(new AbstractAction(labels.getString("edit.removeTransform.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    ODGPathFigure.this.willChange();
                    ODGPathFigure.this.fireUndoableEditHappened(ODGAttributeKeys.TRANSFORM.setUndoable(ODGPathFigure.this, null));
                    ODGPathFigure.this.changed();
                }
            });
            actions.add(new AbstractAction(labels.getString("edit.flattenTransform.text")){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    final Object restoreData = ODGPathFigure.this.getTransformRestoreData();
                    AbstractUndoableEdit edit = new AbstractUndoableEdit(){

                        @Override
                        public String getPresentationName() {
                            return labels.getString("flattenTransform");
                        }

                        @Override
                        public void undo() throws CannotUndoException {
                            super.undo();
                            ODGPathFigure.this.willChange();
                            ODGPathFigure.this.restoreTransformTo(restoreData);
                            ODGPathFigure.this.changed();
                        }

                        @Override
                        public void redo() throws CannotRedoException {
                            super.redo();
                            ODGPathFigure.this.willChange();
                            ODGPathFigure.this.restoreTransformTo(restoreData);
                            ODGPathFigure.this.flattenTransform();
                            ODGPathFigure.this.changed();
                        }
                    };
                    ODGPathFigure.this.willChange();
                    ODGPathFigure.this.flattenTransform();
                    ODGPathFigure.this.changed();
                    ODGPathFigure.this.fireUndoableEditHappened(edit);
                }
            });
        }
        actions.add(new AbstractAction(labels.getString("closePath")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (Figure child : ODGPathFigure.this.getChildren()) {
                    ODGPathFigure.this.willChange();
                    ODGPathFigure.this.getDrawing().fireUndoableEditHappened(ODGAttributeKeys.PATH_CLOSED.setUndoable(child, true));
                    ODGPathFigure.this.changed();
                }
            }
        });
        actions.add(new AbstractAction(labels.getString("openPath")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                for (Figure child : ODGPathFigure.this.getChildren()) {
                    ODGPathFigure.this.willChange();
                    ODGPathFigure.this.getDrawing().fireUndoableEditHappened(ODGAttributeKeys.PATH_CLOSED.setUndoable(child, false));
                    ODGPathFigure.this.changed();
                }
            }
        });
        actions.add(new AbstractAction(labels.getString("windingRule.evenOdd")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ODGPathFigure.this.willChange();
                ODGPathFigure.this.getDrawing().fireUndoableEditHappened(ODGAttributeKeys.WINDING_RULE.setUndoable(ODGPathFigure.this, AttributeKeys.WindingRule.EVEN_ODD));
                ODGPathFigure.this.changed();
            }
        });
        actions.add(new AbstractAction(labels.getString("windingRule.nonZero")){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ODGPathFigure.this.willChange();
                ODGPathFigure.this.getDrawing().fireUndoableEditHappened(ODGAttributeKeys.WINDING_RULE.setUndoable(ODGPathFigure.this, AttributeKeys.WindingRule.NON_ZERO));
                ODGPathFigure.this.changed();
            }
        });
        return actions;
    }

    @Override
    public Connector findConnector(Point2D.Double p, ConnectionFigure prototype) {
        return null;
    }

    @Override
    public Connector findCompatibleConnector(Connector c, boolean isStartConnector) {
        return null;
    }

    @Override
    public boolean handleMouseClick(Point2D.Double p, MouseEvent evt, DrawingView view) {
        if (evt.getClickCount() == 2 && view.getHandleDetailLevel() % 2 == 0) {
            for (Figure child : this.getChildren()) {
                ODGBezierFigure bf = (ODGBezierFigure)child;
                int index = bf.getBezierPath().findSegment(p, 5.0 / view.getScaleFactor());
                if (index == -1) continue;
                bf.handleMouseClick(p, evt, view);
                evt.consume();
                return true;
            }
        }
        return false;
    }

    @Override
    public void add(int index, Figure figure) {
        super.add(index, (ODGBezierFigure)figure);
    }

    @Override
    public ODGBezierFigure getChild(int index) {
        return (ODGBezierFigure)super.getChild(index);
    }

    @Override
    public ODGPathFigure clone() {
        ODGPathFigure that = (ODGPathFigure)super.clone();
        return that;
    }

    public void flattenTransform() {
        this.willChange();
        AffineTransform tx = (AffineTransform)this.get(ODGAttributeKeys.TRANSFORM);
        if (tx != null) {
            for (Figure child : this.getChildren()) {
                ((ODGBezierFigure)child).transform(tx);
                ((ODGBezierFigure)child).flattenTransform();
            }
        }
        this.set(ODGAttributeKeys.TRANSFORM, null);
        this.changed();
    }
}

