/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.samples.odg.figures;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import org.jhotdraw.draw.handle.AbstractHandle;
import org.jhotdraw.samples.odg.ODGAttributeKeys;
import org.jhotdraw.samples.odg.figures.ODGPathFigure;

public class ODGPathOutlineHandle
extends AbstractHandle {
    private static final Color HANDLE_FILL_COLOR = new Color(43263);
    private static final Color HANDLE_STROKE_COLOR = Color.WHITE;

    public ODGPathOutlineHandle(ODGPathFigure owner) {
        super(owner);
    }

    @Override
    public ODGPathFigure getOwner() {
        return (ODGPathFigure)super.getOwner();
    }

    @Override
    protected Rectangle basicGetBounds() {
        return this.view.drawingToView(this.getOwner().getDrawingArea());
    }

    @Override
    public boolean contains(Point p) {
        return false;
    }

    @Override
    public void trackStart(Point anchor, int modifiersEx) {
    }

    @Override
    public void trackStep(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public void trackEnd(Point anchor, Point lead, int modifiersEx) {
    }

    @Override
    public void draw(Graphics2D g) {
        Shape bounds = this.getOwner().getPath();
        if (this.getOwner().get(ODGAttributeKeys.TRANSFORM) != null) {
            bounds = ((AffineTransform)this.getOwner().get(ODGAttributeKeys.TRANSFORM)).createTransformedShape(bounds);
        }
        bounds = this.view.getDrawingToViewTransform().createTransformedShape(bounds);
        g.setColor(HANDLE_FILL_COLOR);
        g.draw(bounds);
    }
}

