/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.xml;

import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import net.n3.nanoxml.IXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLParserFactory;
import org.jhotdraw.app.Disposable;
import org.jhotdraw.xml.DOMFactory;
import org.jhotdraw.xml.DOMInput;
import org.jhotdraw.xml.DOMStorable;

public class NanoXMLDOMInput
implements DOMInput,
Disposable {
    private HashMap<String, Object> idobjects = new HashMap();
    @Nullable
    private XMLElement document;
    private XMLElement current;
    private DOMFactory factory;
    private Stack<XMLElement> stack = new Stack();

    public NanoXMLDOMInput(DOMFactory factory, InputStream in) throws IOException {
        this(factory, new InputStreamReader(in, "UTF8"));
    }

    public NanoXMLDOMInput(DOMFactory factory, Reader in) throws IOException {
        this.factory = factory;
        try {
            IXMLParser parser = XMLParserFactory.createDefaultXMLParser();
            StdXMLReader reader = new StdXMLReader(in);
            parser.setReader(reader);
            this.document = new XMLElement();
            this.current = (XMLElement)parser.parse();
            if (this.current != null) {
                this.document.addChild(this.current);
            }
            this.current = this.document;
        }
        catch (Exception e) {
            IOException error = new IOException(e.getMessage());
            error.initCause(e);
            throw error;
        }
    }

    @Override
    public String getTagName() {
        return this.current.getName();
    }

    @Override
    public String getAttribute(String name, String defaultValue) {
        return this.current.getAttribute(name, defaultValue);
    }

    @Override
    public List<String> getInheritedAttribute(String name) {
        LinkedList<String> values = new LinkedList<String>();
        for (XMLElement node : this.stack) {
            String value = node.getAttribute(name, null);
            values.add(value);
        }
        String value = this.current.getAttribute(name, null);
        values.add(value);
        return values;
    }

    @Override
    public String getText() {
        return this.getText(null);
    }

    @Override
    public String getText(String defaultValue) {
        String value = this.current.getContent();
        return value == null ? defaultValue : value;
    }

    @Override
    public int getAttribute(String name, int defaultValue) {
        String value = this.current.getAttribute(name, null);
        return value == null || value.length() == 0 ? defaultValue : Long.decode(value).intValue();
    }

    @Override
    public double getAttribute(String name, double defaultValue) {
        String value = this.current.getAttribute(name, null);
        return value == null || value.length() == 0 ? defaultValue : Double.parseDouble(value);
    }

    @Override
    public boolean getAttribute(String name, boolean defaultValue) {
        String value = this.current.getAttribute(name, null);
        return value == null || value.length() == 0 ? defaultValue : Boolean.valueOf(value);
    }

    @Override
    public int getElementCount() {
        return this.current.getChildrenCount();
    }

    @Override
    public int getElementCount(String tagName) {
        int count = 0;
        ArrayList list = this.current.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement node = (XMLElement)list.get(i);
            if (!node.getName().equals(tagName)) continue;
            ++count;
        }
        return count;
    }

    @Override
    public void openElement(int index) {
        this.stack.push(this.current);
        ArrayList list = this.current.getChildren();
        this.current = (XMLElement)list.get(index);
    }

    @Override
    public void openElement(String tagName) throws IOException {
        ArrayList list = this.current.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement node = (XMLElement)list.get(i);
            if (!node.getName().equals(tagName)) continue;
            this.stack.push(this.current);
            this.current = node;
            return;
        }
        throw new IOException("no such element:" + tagName);
    }

    @Override
    public void openElement(String tagName, int index) throws IOException {
        int count = 0;
        ArrayList list = this.current.getChildren();
        for (int i = 0; i < list.size(); ++i) {
            XMLElement node = (XMLElement)list.get(i);
            if (!node.getName().equals(tagName) || count++ != index) continue;
            this.stack.push(this.current);
            this.current = node;
            return;
        }
        throw new IOException("no such element:" + tagName + " at index:" + index);
    }

    @Override
    public void closeElement() {
        this.current = this.stack.pop();
    }

    @Override
    public Object readObject() throws IOException {
        return this.readObject(0);
    }

    @Override
    public Object readObject(int index) throws IOException {
        Object o;
        this.openElement(index);
        String ref = this.getAttribute("ref", null);
        String id = this.getAttribute("id", null);
        if (ref != null && id != null) {
            throw new IOException("Element has both an id and a ref attribute: <" + this.getTagName() + " id=\"" + id + "\" ref=\"" + ref + "\"> in line number " + this.current.getLineNr());
        }
        if (id != null && this.idobjects.containsKey(id)) {
            throw new IOException("Duplicate id attribute: <" + this.getTagName() + " id=\"" + id + "\"> in line number " + this.current.getLineNr());
        }
        if (ref != null && !this.idobjects.containsKey(ref)) {
            throw new IOException("Referenced element not found: <" + this.getTagName() + " ref=\"" + ref + "\"> in line number " + this.current.getLineNr());
        }
        if (ref != null) {
            o = this.idobjects.get(ref);
        } else {
            o = this.factory.read(this);
            if (id != null) {
                this.idobjects.put(id, o);
            }
            if (o instanceof DOMStorable) {
                ((DOMStorable)o).read(this);
            }
        }
        this.closeElement();
        return o;
    }

    @Override
    public void dispose() {
        if (this.document != null) {
            this.document.dispose();
            this.document = null;
        }
    }
}

