/*
 * Decompiled with CFR 0.152.
 */
import adapter.Image5DAdapter;
import adapter.ImageAdapter;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.ImageCanvas;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.gui.OvalRoi;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import ij.io.OpenDialog;
import ij.io.Opener;
import ij.io.SaveDialog;
import ij.measure.ResultsTable;
import ij.plugin.filter.Duplicater;
import ij.plugin.frame.PlugInFrame;
import ij.process.ImageProcessor;
import ij.process.StackConverter;
import ij.util.Tools;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.SystemColor;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.StringTokenizer;

public class Manual_Tracking
extends PlugInFrame
implements ActionListener,
ItemListener,
MouseListener {
    double calxy = 0.129;
    double calz = 0.3;
    double calt = 2.0;
    int cent = 5;
    int dotsize = 5;
    double linewidth = 1.0;
    int fontsize = 12;
    Color[] col = new Color[]{Color.blue, Color.green, Color.red, Color.cyan, Color.magenta, Color.yellow, Color.white};
    int i;
    int j;
    int k;
    int l;
    int m;
    int n;
    String txt;
    static Frame instance;
    Font bold = new Font("", 3, 12);
    Panel panel;
    Button butAdd;
    Button butDlp;
    Button butEnd;
    Button butDel;
    Choice trackdel;
    Button butDelAll;
    Checkbox checkPath;
    Choice choicecent;
    Checkbox checkCent;
    Label labelCorr;
    Button butAddRef;
    Button butDelRef;
    Label titleRef;
    Checkbox checkShowRef;
    Checkbox checkRef;
    Button butOvd;
    Button butOvl;
    Button butOvdl;
    Button butOverdots;
    Button butOverlines;
    Button butOverboth;
    Checkbox checkText;
    Button butLoad;
    Checkbox checkParam;
    Button butRetrieveZ;
    Label labelEmpty1;
    Label labelEmpty2;
    Label labelEmpty3;
    Label labelEmpty4;
    Label labelParam;
    Label labelEmpty5;
    Label labelTime;
    TextField caltfield;
    Choice choicecalt;
    Label labelxy;
    TextField calxyfield;
    Choice choicecalxy;
    Label labelz;
    TextField calzfield;
    Label labelEmpty6;
    Label labelCent;
    Label labelPix;
    TextField centsize;
    Label labelDot;
    TextField dotsizefield;
    Label labelEmpty7;
    Label labelLine;
    TextField linewidthfield;
    Label labelEmpty8;
    Label labelFont;
    TextField fontsizefield;
    Label labelEmpty9;
    ImagePlus img;
    String imgtitle;
    int Width;
    int Height;
    int Depth;
    int Slice;
    String SliceTitle;
    ImageCanvas canvas;
    ImagePlus ip;
    ImageStack stack;
    ImageWindow win;
    StackConverter sc;
    Duplicater dp;
    boolean islistening = false;
    int[] xRoi;
    int[] yRoi;
    Roi roi;
    int Nbtrack = 1;
    int NbPoint = 1;
    int ox;
    int oy;
    int PixVal;
    int prevx;
    int prevy;
    double Distance;
    double Velocity;
    int pprevx;
    int pprevy;
    boolean trackZ;
    String commentCorr;
    boolean islisteningRef = false;
    boolean RefSet = false;
    int DirIndex = 1;
    int refx = 0;
    int refy = 0;
    Roi roiRef;
    GenericDialog gd;
    GenericDialog gd1;
    GenericDialog gd2;
    GenericDialog VRMLgd;
    OpenDialog od;
    SaveDialog sd;
    String FileName;
    String File;
    String dir;
    ResultsTable rt;
    ResultsTable rtmp;
    String[] head = new String[]{"Track n\u00b0", "Slice n\u00b0", "X", "Y", "Distance", "Velocity", "Pixel Value"};
    ResultsTable rt3D;
    BufferedReader in;
    String line;
    StringTokenizer Token;
    String[] CentringArray = new String[]{"No centring correction", "Barycentre in signal box", "Max intensity in signal box"};
    int Centring;
    int sglBoxx;
    int sglBoxy;
    int sglBoxz;
    int bkgdBoxx;
    int bkgdBoxy;
    int bkgdBoxz;
    String[] QuantificationArray = new String[]{"No background correction", "Bkgd box centred on sgl box", "Bkgd box on top left", "Bkgd box on top right", "Bkgd box on bottom left", "Bkgd box on bottom right"};
    int Quantification;
    boolean DoQuantification;
    boolean DoBleachCorr;
    boolean DoVRML;
    int tmpx;
    int tmpy;
    int tmpz;
    int tmpttl;
    int tmppixval;
    int limsx1;
    int limsx2;
    int limsy1;
    int limsy2;
    int limsz1;
    int limsz2;
    double sizeSgl;
    int limbx1;
    int limbx2;
    int limby1;
    int limby2;
    int limbz1;
    int limbz2;
    double sizeBkgd;
    double Qsgl;
    double Qbkgd;
    double Qttl;
    double Qttl0;
    double QSglBkgdCorr;
    double QSglBkgdBleachCorr;
    String[] StaticArray = new String[]{"None", "Trajectories", "Objects"};
    String[] DynamicArray = new String[]{"None", "Objects", "Objects & Static Trajectories", "Objects & Progressive Trajectories"};
    String Static;
    String Dynamic;
    boolean StaticView;
    boolean StaticViewObj;
    boolean StaticViewTraj;
    boolean DynamicView;
    boolean DynamicViewStaticTraj;
    boolean DynamicViewDynamicTraj;
    String dirVRMLstat;
    OutputStreamWriter oswStat;
    String dirVRMLdynam;
    OutputStreamWriter oswDynam;
    String[] vrmlCol = new String[]{"0 0 1", "0 1 0", "1 0 0", "0.5 1 1", "1 0.5 1", "1 1 0", "1 1 1"};
    int x;
    int y;
    int z;
    int xOld;
    int yOld;
    int zOld;
    int[][] VRMLarray;
    int vrmlCount;
    double DistOfView;
    double minTime;
    double maxTime;
    int countBefore;
    int countAfter;
    int countTtl;
    String key;
    int Tag;
    int TagOld;
    String point;
    int pointNb;
    String pointKey;
    String lastPoint;
    protected ImageAdapter adapter;

    public Manual_Tracking() {
        super("Tracking");
        instance = this;
        try {
            Class.forName("sc.fiji.i5d.gui.Image5DWindow");
            this.adapter = new Image5DAdapter();
        }
        catch (ClassNotFoundException e) {
            this.adapter = new ImageAdapter();
        }
        this.panel = new Panel();
        this.panel.setLayout(new GridLayout(0, 3));
        this.panel.setBackground(SystemColor.control);
        this.panel.add(new Label());
        Label title = new Label();
        title.setText("Tracking :");
        title.setFont(this.bold);
        this.panel.add(title);
        this.panel.add(new Label());
        this.butAdd = new Button("Add track");
        this.butAdd.addActionListener(this);
        this.panel.add(this.butAdd);
        this.butDlp = new Button("Delete last point");
        this.butDlp.addActionListener(this);
        this.panel.add(this.butDlp);
        this.butEnd = new Button("End track");
        this.butEnd.addActionListener(this);
        this.panel.add(this.butEnd);
        this.butDel = new Button("Delete track n\u00b0");
        this.butDel.addActionListener(this);
        this.panel.add(this.butDel);
        this.trackdel = new Choice();
        this.panel.add(this.trackdel);
        this.butDelAll = new Button("Delete all tracks");
        this.butDelAll.addActionListener(this);
        this.panel.add(this.butDelAll);
        this.panel.add(new Label());
        this.checkPath = new Checkbox("Show path ?", false);
        this.checkPath.addItemListener(this);
        this.panel.add(this.checkPath);
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        Label title3 = new Label();
        title3.setText("Centring Correction:");
        title3.setFont(this.bold);
        this.panel.add(title3);
        this.panel.add(new Label());
        this.panel.add(new Label("Centring option :"));
        this.choicecent = new Choice();
        this.choicecent.add("Local maximum");
        this.choicecent.add("Local minimum");
        this.choicecent.add("Local barycentre");
        this.panel.add(this.choicecent);
        this.labelCorr = new Label();
        this.panel.add(this.labelCorr);
        this.panel.add(new Label());
        this.checkCent = new Checkbox("Use centring correction ?", false);
        this.checkCent.addItemListener(this);
        this.panel.add(this.checkCent);
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        Label title4 = new Label();
        title4.setText("Directionality :");
        title4.setFont(this.bold);
        this.panel.add(title4);
        this.panel.add(new Label());
        this.butAddRef = new Button("Add reference");
        this.butAddRef.addActionListener(this);
        this.panel.add(this.butAddRef);
        this.butDelRef = new Button("Delete reference");
        this.butDelRef.addActionListener(this);
        this.panel.add(this.butDelRef);
        this.titleRef = new Label();
        this.titleRef.setText("No reference set");
        this.panel.add(this.titleRef);
        this.panel.add(new Label());
        this.checkShowRef = new Checkbox("Show reference ?", false);
        this.checkShowRef.addItemListener(this);
        this.panel.add(this.checkShowRef);
        this.checkRef = new Checkbox("Use directionality ?", false);
        this.checkRef.addItemListener(this);
        this.panel.add(this.checkRef);
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        Label title2 = new Label();
        title2.setText("Drawing :");
        title2.setFont(this.bold);
        this.panel.add(title2);
        this.panel.add(new Label());
        this.butOvd = new Button("Dots");
        this.butOvd.addActionListener(this);
        this.panel.add(this.butOvd);
        this.butOvl = new Button("Progressive Lines");
        this.butOvl.addActionListener(this);
        this.panel.add(this.butOvl);
        this.butOvdl = new Button("Dots & Lines");
        this.butOvdl.addActionListener(this);
        this.panel.add(this.butOvdl);
        this.butOverdots = new Button("Overlay Dots");
        this.butOverdots.addActionListener(this);
        this.panel.add(this.butOverdots);
        this.butOverlines = new Button("Overlay Lines");
        this.butOverlines.addActionListener(this);
        this.panel.add(this.butOverlines);
        this.butOverboth = new Button("Overlay Dots & Lines");
        this.butOverboth.addActionListener(this);
        this.panel.add(this.butOverboth);
        this.panel.add(new Label());
        this.checkText = new Checkbox("Show text ?", false);
        this.checkText.addItemListener(this);
        this.panel.add(this.checkText);
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.panel.add(new Label());
        this.butLoad = new Button("Load Previous Track File");
        this.butLoad.addActionListener(this);
        this.panel.add(this.butLoad);
        this.checkParam = new Checkbox("Show parameters ?", true);
        this.checkParam.addItemListener(this);
        this.panel.add(this.checkParam);
        this.butRetrieveZ = new Button("Retrieve Z Coordinates");
        this.butRetrieveZ.addActionListener(this);
        this.panel.add(this.butRetrieveZ);
        this.labelEmpty1 = new Label();
        this.labelEmpty2 = new Label();
        this.labelEmpty3 = new Label();
        this.labelEmpty4 = new Label();
        this.labelEmpty5 = new Label();
        this.labelEmpty6 = new Label();
        this.labelEmpty7 = new Label();
        this.labelEmpty8 = new Label();
        this.labelEmpty9 = new Label();
        this.panel.add(this.labelEmpty1);
        this.panel.add(this.labelEmpty2);
        this.panel.add(this.labelEmpty3);
        this.panel.add(this.labelEmpty4);
        this.labelParam = new Label("Parameters :");
        this.labelParam.setFont(this.bold);
        this.panel.add(this.labelParam);
        this.panel.add(this.labelEmpty5);
        this.labelTime = new Label("Time Interval :");
        this.panel.add(this.labelTime);
        this.caltfield = new TextField(Double.toString(this.calt));
        this.panel.add(this.caltfield);
        this.choicecalt = new Choice();
        this.choicecalt.add("sec");
        this.choicecalt.add("min");
        this.choicecalt.add("unit");
        this.panel.add(this.choicecalt);
        this.labelxy = new Label("x/y calibration :");
        this.panel.add(this.labelxy);
        this.calxyfield = new TextField(Double.toString(this.calxy));
        this.panel.add(this.calxyfield);
        this.choicecalxy = new Choice();
        this.choicecalxy.add("nm");
        this.choicecalxy.add("\u00b5m");
        this.choicecalxy.add("unit");
        this.choicecalxy.select("\u00b5m");
        this.panel.add(this.choicecalxy);
        this.labelz = new Label("z calibration :");
        this.panel.add(this.labelz);
        this.calzfield = new TextField(Double.toString(this.calz));
        this.panel.add(this.calzfield);
        this.panel.add(this.labelEmpty6);
        this.labelCent = new Label("Search square size for centring:");
        this.panel.add(this.labelCent);
        this.centsize = new TextField(Double.toString(this.cent));
        this.panel.add(this.centsize);
        this.labelPix = new Label(" pixels");
        this.panel.add(this.labelPix);
        this.labelDot = new Label("Dot size :");
        this.panel.add(this.labelDot);
        this.dotsizefield = new TextField(Double.toString(this.dotsize));
        this.panel.add(this.dotsizefield);
        this.panel.add(this.labelEmpty7);
        this.labelLine = new Label("Line width :");
        this.panel.add(this.labelLine);
        this.linewidthfield = new TextField(Double.toString(this.linewidth));
        this.panel.add(this.linewidthfield);
        this.panel.add(this.labelEmpty8);
        this.labelFont = new Label("Font size :");
        this.panel.add(this.labelFont);
        this.fontsizefield = new TextField(Double.toString(this.fontsize));
        this.panel.add(this.fontsizefield);
        this.panel.add(this.labelEmpty9);
        this.add(this.panel, "Center");
        this.pack();
        this.show();
        IJ.showProgress((int)2, (int)1);
        this.rt = new ResultsTable();
    }

    protected void moveTo(ImagePlus img, int position) {
        if (this.trackZ) {
            this.adapter.setSlice(img, position);
        } else {
            this.adapter.setFrame(img, position);
        }
    }

    protected int getPosition(ImagePlus img) {
        if (this.trackZ) {
            return this.adapter.getSlice(img);
        }
        return this.adapter.getFrame(img);
    }

    protected int getMaxPosition(ImagePlus img) {
        if (this.trackZ) {
            return img.getNSlices();
        }
        return img.getNFrames();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.checkPath) {
            if (this.checkPath.getState()) {
                this.img.setRoi(this.roi);
            } else {
                this.img.killRoi();
            }
            this.checkShowRef.setState(false);
        }
        if (e.getSource() == this.checkCent) {
            if (!this.checkCent.getState()) {
                this.commentCorr = "";
            }
            this.labelCorr.setText(this.commentCorr);
        }
        if (e.getSource() == this.checkShowRef) {
            if (this.checkShowRef.getState()) {
                if (!this.RefSet) {
                    IJ.showMessage((String)"!!! Warning !!!", (String)" No reference set:\nClick on 'Add reference' first !!!");
                    this.checkShowRef.setState(false);
                    return;
                }
                this.dotsize = (int)Tools.parseDouble((String)this.dotsizefield.getText());
                this.roiRef = new OvalRoi(this.refx - this.dotsize, this.refy - this.dotsize, 2 * this.dotsize, 2 * this.dotsize);
                this.img.setRoi(this.roiRef);
            } else {
                this.img.killRoi();
            }
            this.checkPath.setState(false);
        }
        if (e.getSource() == this.checkParam) {
            if (!this.checkParam.getState()) {
                this.HideParam();
            } else {
                this.ShowParam();
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butAdd) {
            if (this.islistening) {
                IJ.showMessage((String)"This operation can't be completed:\na track is already being followed...");
                return;
            }
            this.HideParam();
            this.img = WindowManager.getCurrentImage();
            this.imgtitle = this.img.getTitle();
            if (this.imgtitle.indexOf(".") != -1) {
                this.imgtitle = this.imgtitle.substring(0, this.imgtitle.indexOf("."));
            }
            this.calt = Tools.parseDouble((String)this.caltfield.getText());
            this.calxy = Tools.parseDouble((String)this.calxyfield.getText());
            if (this.calt == 0.0 || this.calxy == 0.0) {
                IJ.showMessage((String)"Error", (String)"Calibration values\nshould not be equal to zero !!!");
                this.ShowParam();
                return;
            }
            IJ.setTool((int)7);
            this.trackZ = this.img.getNSlices() > 1 && this.img.getNFrames() == 1;
            this.xRoi = new int[this.getMaxPosition(this.img)];
            this.yRoi = new int[this.getMaxPosition(this.img)];
            if (this.img == null) {
                IJ.showMessage((String)"Error", (String)"Man,\nYou're in deep troubles:\nno opened stack...");
                return;
            }
            this.win = this.img.getWindow();
            this.canvas = this.win.getCanvas();
            this.moveTo(this.img, 1);
            this.NbPoint = 1;
            IJ.showProgress((int)2, (int)1);
            this.canvas.addMouseListener((MouseListener)this);
            this.islistening = true;
            return;
        }
        if (e.getSource() == this.butDlp) {
            this.gd = new GenericDialog("Delete last point");
            this.gd.addMessage("Are you sure you want to \ndelete last point ?");
            this.gd.showDialog();
            if (this.gd.wasCanceled()) {
                return;
            }
            this.rtmp = new ResultsTable();
            this.i = 0;
            while (this.i < this.rt.getCounter()) {
                this.rtmp.incrementCounter();
                this.j = 0;
                while (this.j < 7) {
                    this.rtmp.addValue(this.j, (double)this.rt.getValue(this.j, this.i));
                    ++this.j;
                }
                ++this.i;
            }
            this.rt.reset();
            this.i = 0;
            while (this.i < this.head.length) {
                this.rt.setHeading(this.i, this.head[this.i]);
                ++this.i;
            }
            this.i = 0;
            while (this.i < this.rtmp.getCounter() - 1) {
                this.rt.incrementCounter();
                this.j = 0;
                while (this.j < 7) {
                    this.rt.addValue(this.j, (double)this.rtmp.getValue(this.j, this.i));
                    ++this.j;
                }
                ++this.i;
            }
            this.rt.show("Results from " + this.imgtitle + " in " + this.choicecalxy.getItem(this.choicecalxy.getSelectedIndex()) + " per " + this.choicecalt.getItem(this.choicecalt.getSelectedIndex()));
            if (!this.islistening) {
                --this.Nbtrack;
                this.trackdel.remove("" + (int)this.rt.getValue(0, this.rt.getCounter() - 1));
                this.canvas.addMouseListener((MouseListener)this);
                this.islistening = true;
            }
            this.prevx = (int)this.rt.getValue(2, this.rt.getCounter() - 1);
            this.prevy = (int)this.rt.getValue(3, this.rt.getCounter() - 1);
            this.moveTo(this.img, (int)this.rt.getValue(1, this.rt.getCounter() - 1) + 1);
            IJ.showStatus((String)"Last Point Deleted !");
        }
        if (e.getSource() == this.butEnd) {
            this.trackdel.add("" + this.Nbtrack);
            ++this.Nbtrack;
            this.canvas.removeMouseListener((MouseListener)this);
            this.islistening = false;
            IJ.showStatus((String)"Tracking is over");
            IJ.showProgress((int)2, (int)1);
            return;
        }
        if (e.getSource() == this.butDel) {
            this.canvas.removeMouseListener((MouseListener)this);
            this.islistening = false;
            int tracktodelete = (int)Tools.parseDouble((String)this.trackdel.getItem(this.trackdel.getSelectedIndex()));
            this.gd = new GenericDialog("Delete Track n\u00b0" + tracktodelete);
            this.gd.addMessage("Do you want to \ndelete track n\u00b0" + tracktodelete + " ?");
            this.gd.showDialog();
            if (this.gd.wasCanceled()) {
                return;
            }
            this.rtmp = new ResultsTable();
            this.i = 0;
            while (this.i < this.rt.getCounter()) {
                int nbtrack = (int)this.rt.getValue(0, this.i);
                if (nbtrack != tracktodelete) {
                    this.rtmp.incrementCounter();
                    this.j = 0;
                    while (this.j < 7) {
                        this.rtmp.addValue(this.j, (double)this.rt.getValue(this.j, this.i));
                        ++this.j;
                    }
                }
                ++this.i;
            }
            this.rt.reset();
            this.i = 0;
            while (this.i < this.head.length) {
                this.rt.setHeading(this.i, this.head[this.i]);
                ++this.i;
            }
            this.i = 0;
            while (this.i < this.rtmp.getCounter()) {
                this.rt.incrementCounter();
                this.j = 0;
                while (this.j < 7) {
                    if (this.j == 0 & this.rtmp.getValue(0, this.i) > (float)tracktodelete) {
                        this.rt.addValue(this.j, (double)(this.rtmp.getValue(this.j, this.i) - 1.0f));
                    } else {
                        this.rt.addValue(this.j, (double)this.rtmp.getValue(this.j, this.i));
                    }
                    ++this.j;
                }
                ++this.i;
            }
            this.rt.show("Results from " + this.imgtitle + " in " + this.choicecalxy.getItem(this.choicecalxy.getSelectedIndex()) + " per " + this.choicecalt.getItem(this.choicecalt.getSelectedIndex()));
            this.trackdel.removeAll();
            this.i = 1;
            while ((float)this.i < this.rt.getValue(0, this.rt.getCounter() - 1) + 1.0f) {
                this.trackdel.add("" + this.i);
                ++this.i;
            }
            IJ.showStatus((String)("Track n\u00b0" + tracktodelete + " Deleted !"));
            this.Nbtrack = (int)this.rt.getValue(0, this.rt.getCounter() - 1) + 1;
        }
        if (e.getSource() == this.butDelAll) {
            this.canvas.removeMouseListener((MouseListener)this);
            this.islistening = false;
            IJ.showProgress((int)2, (int)1);
            IJ.showStatus((String)"Tracking is over");
            this.gd = new GenericDialog("Delete All Tracks");
            this.gd.addMessage("Do you want to \ndelete all measurements ?");
            this.gd.showDialog();
            if (this.gd.wasCanceled()) {
                return;
            }
            this.rt.reset();
            this.rt.show("Results from " + this.imgtitle + " in " + this.choicecalxy.getItem(this.choicecalxy.getSelectedIndex()) + " per " + this.choicecalt.getItem(this.choicecalt.getSelectedIndex()));
            this.trackdel.removeAll();
            IJ.showStatus((String)"All Tracks Deleted !");
            this.Nbtrack = 1;
            return;
        }
        if (e.getSource() == this.butAddRef) {
            if (this.islistening) {
                this.gd = new GenericDialog("!!! Warning !!!");
                this.gd.addMessage("Adding an origin will end your current track.\nDo you want to continue ?");
                this.gd.showDialog();
                if (this.gd.wasCanceled()) {
                    return;
                }
                this.trackdel.add("" + this.Nbtrack);
                ++this.Nbtrack;
                this.canvas.removeMouseListener((MouseListener)this);
                this.islistening = false;
                IJ.showStatus((String)"Tracking is over");
                IJ.showProgress((int)2, (int)1);
            }
            this.img = WindowManager.getCurrentImage();
            if (this.img == null) {
                IJ.showMessage((String)"Error", (String)"Man,\nYou're in deep troubles:\nno opened stack...");
                return;
            }
            if (this.RefSet) {
                this.gd1 = new GenericDialog("!!! Warning !!!");
                this.gd1.addMessage("An origin has already been defined.\nAre you sure you want to delete it ?");
                this.gd1.showDialog();
                if (this.gd1.wasCanceled()) {
                    return;
                }
            }
            this.gd2 = new GenericDialog("Define reference");
            this.gd2.addMessage("Click on the pixel \nto be considered as reference");
            this.gd2.showDialog();
            if (this.gd2.wasCanceled()) {
                return;
            }
            ImageWindow win = this.img.getWindow();
            this.canvas = win.getCanvas();
            this.NbPoint = 1;
            this.islisteningRef = true;
            this.canvas.addMouseListener((MouseListener)this);
            this.islistening = true;
            return;
        }
        if (e.getSource() == this.butDelRef) {
            this.gd = new GenericDialog("!!! Warning !!!");
            this.gd.addMessage("Are you sure you want to delete the reference ?");
            this.gd.showDialog();
            if (this.gd.wasCanceled()) {
                return;
            }
            this.refx = 0;
            this.refy = 0;
            this.RefSet = false;
            this.checkCent.setState(false);
            IJ.showStatus((String)"Reference deleted!");
            this.titleRef.setText("No reference set");
            return;
        }
        if (e.getSource() == this.butOvd || e.getSource() == this.butOvl || e.getSource() == this.butOvdl) {
            this.img.killRoi();
            this.canvas.removeMouseListener((MouseListener)this);
            this.islistening = false;
            if (e.getSource() == this.butOvd) {
                this.txt = "Dots ";
            }
            if (e.getSource() == this.butOvl) {
                this.txt = "Progressive Lines ";
            }
            if (e.getSource() == this.butOvdl) {
                this.txt = "Dots & Lines ";
            }
            this.ip = NewImage.createRGBImage((String)(this.txt + this.imgtitle), (int)this.img.getWidth(), (int)this.img.getHeight(), (int)this.img.getStackSize(), (int)1);
            this.ip.show();
            this.stack = this.ip.getStack();
            if (e.getSource() == this.butOvd || e.getSource() == this.butOvdl) {
                this.Dots();
            }
            if (e.getSource() == this.butOvl || e.getSource() == this.butOvdl) {
                this.ProLines();
            }
            IJ.showStatus((String)(this.txt + this.imgtitle + " Created !"));
            return;
        }
        if (e.getSource() == this.butOverdots || e.getSource() == this.butOverlines || e.getSource() == this.butOverboth) {
            this.img.killRoi();
            this.canvas.removeMouseListener((MouseListener)this);
            this.islistening = false;
            if (e.getSource() == this.butOverdots) {
                this.txt = "Overlay Dots ";
            }
            if (e.getSource() == this.butOverlines) {
                this.txt = "Overlay Progressive Lines ";
            }
            if (e.getSource() == this.butOverboth) {
                this.txt = "Overlay Dots & Lines ";
            }
            this.ip = new Duplicater().duplicateStack(this.img, this.txt + this.imgtitle);
            this.ip.show();
            new StackConverter(this.ip).convertToRGB();
            this.stack = this.ip.getStack();
            if (e.getSource() == this.butOverdots || e.getSource() == this.butOverboth) {
                this.Dots();
            }
            if (e.getSource() == this.butOverlines || e.getSource() == this.butOverboth) {
                this.ProLines();
            }
            IJ.showStatus((String)(this.txt + this.imgtitle + " Created !"));
            return;
        }
        if (e.getSource() == this.butLoad) {
            this.gd = new GenericDialog("Load Previous Track File");
            this.gd.addMessage("Are you sure you want to \nload a previous Track file ?\nAll non saved data will be lost");
            this.gd.showDialog();
            if (this.gd.wasCanceled()) {
                return;
            }
            this.img = WindowManager.getCurrentImage();
            this.Width = this.img.getWidth();
            this.Height = this.img.getHeight();
            this.imgtitle = this.img.getTitle();
            if (this.imgtitle.indexOf(".") != -1) {
                this.imgtitle = this.imgtitle.substring(0, this.imgtitle.indexOf("."));
            }
            this.od = new OpenDialog("Select the track file", "");
            if (this.od.getFileName() == null) {
                return;
            }
            this.File = this.od.getFileName();
            this.FileName = this.File.substring(0, this.File.indexOf("."));
            this.dir = this.od.getDirectory();
            this.i = 0;
            this.rt.reset();
            try {
                if (this.i == 0) {
                    this.in = new BufferedReader(new FileReader(this.dir + this.File));
                }
                this.in.readLine();
                while ((this.line = this.in.readLine()) != null) {
                    this.i = 0;
                    this.Token = new StringTokenizer(this.line);
                    this.rt.incrementCounter();
                    while (this.Token.hasMoreTokens()) {
                        if (this.i != 0) {
                            this.rt.addValue(this.i - 1, Tools.parseDouble((String)this.Token.nextToken()));
                        } else {
                            this.Token.nextToken();
                        }
                        ++this.i;
                    }
                }
            }
            catch (IOException f) {
                IJ.error((String)"Error...");
            }
            this.i = 0;
            while (this.i < this.head.length) {
                this.rt.setHeading(this.i, this.head[this.i]);
                ++this.i;
            }
            this.trackdel.removeAll();
            this.Nbtrack = (int)this.rt.getValue(0, this.rt.getCounter() - 1) + 1;
            this.i = 1;
            while (this.i < this.Nbtrack) {
                this.trackdel.add("" + this.i);
                ++this.i;
            }
            this.rt.show("Results from " + this.imgtitle + " in " + this.choicecalxy.getItem(this.choicecalxy.getSelectedIndex()) + " per " + this.choicecalt.getItem(this.choicecalt.getSelectedIndex()));
            ImageWindow win = this.img.getWindow();
            this.canvas = win.getCanvas();
        }
        if (e.getSource() == this.butRetrieveZ) {
            if (IJ.versionLessThan((String)"1.34k")) {
                IJ.showMessage((String)"To use this functionality, ImageJ version must be 1.34k or higher.\nSave your track file, update ImageJ, reload the stack and track file,\nand try again.");
                return;
            }
            this.img = WindowManager.getCurrentImage();
            this.img = WindowManager.getCurrentImage();
            this.imgtitle = this.img.getTitle();
            if (this.imgtitle.indexOf(".") != -1) {
                this.imgtitle = this.imgtitle.substring(0, this.imgtitle.indexOf("."));
            }
            this.calt = Tools.parseDouble((String)this.caltfield.getText());
            this.calxy = Tools.parseDouble((String)this.calxyfield.getText());
            this.calz = Tools.parseDouble((String)this.calzfield.getText());
            if (this.calt == 0.0 || this.calxy == 0.0 || this.calz == 0.0) {
                IJ.showMessage((String)"Error", (String)"Calibration values\nshould not be equal to zero !!!");
                return;
            }
            if (this.img == null || this.rt.getCounter() == 0) {
                IJ.showMessage((String)"Error", (String)"No opened stack or No tracking data");
                return;
            }
            this.gd = new GenericDialog("Retrieve Z Coordinate");
            this.gd.addChoice("Centring Correction", this.CentringArray, this.CentringArray[0]);
            this.gd.addMessage("Size of signal box (pixels):");
            this.gd.addNumericField("Width", 5.0, 0);
            this.gd.addNumericField("Height", 5.0, 0);
            this.gd.addNumericField("Depth", 3.0, 0);
            this.gd.addMessage("Size of background box (pixels):");
            this.gd.addNumericField("Width", 7.0, 0);
            this.gd.addNumericField("Height", 7.0, 0);
            this.gd.addNumericField("Depth", 5.0, 0);
            this.gd.addMessage("");
            this.gd.addCheckbox("Do quantification", true);
            this.gd.addChoice("Quantification settings", this.QuantificationArray, this.QuantificationArray[1]);
            this.gd.addMessage("");
            this.gd.addCheckbox("Do bleaching correction", true);
            this.gd.addMessage("");
            this.gd.addCheckbox("Export 3D+t data as a VRML file", true);
            this.gd.showDialog();
            if (this.gd.wasCanceled()) {
                return;
            }
            this.Centring = this.gd.getNextChoiceIndex();
            this.sglBoxx = (int)this.gd.getNextNumber() / 2;
            this.sglBoxy = (int)this.gd.getNextNumber() / 2;
            this.sglBoxz = (int)this.gd.getNextNumber() / 2;
            this.bkgdBoxx = (int)this.gd.getNextNumber() / 2;
            this.bkgdBoxy = (int)this.gd.getNextNumber() / 2;
            this.bkgdBoxz = (int)this.gd.getNextNumber() / 2;
            this.DoQuantification = this.gd.getNextBoolean();
            this.Quantification = this.gd.getNextChoiceIndex();
            this.DoBleachCorr = this.gd.getNextBoolean();
            this.DoVRML = this.gd.getNextBoolean();
            this.od = new OpenDialog("Select the stacks' source folder", "", "---Source Folder---");
            if (this.od.getDirectory() == null) {
                return;
            }
            this.dir = this.od.getDirectory();
            ResultsTable rt3D = new ResultsTable();
            this.TagOld = 0;
            if (this.DoVRML) {
                this.Static = "";
                this.StaticView = true;
                this.StaticViewTraj = false;
                this.StaticViewObj = false;
                this.Dynamic = "";
                this.DynamicView = true;
                this.DynamicViewStaticTraj = false;
                this.VRMLgd = new GenericDialog("VRML file");
                this.VRMLgd.addChoice("Static view", this.StaticArray, this.StaticArray[1]);
                this.VRMLgd.addMessage("");
                this.VRMLgd.addChoice("Dynamic view", this.DynamicArray, this.DynamicArray[1]);
                this.VRMLgd.showDialog();
                if (this.VRMLgd.wasCanceled()) {
                    return;
                }
                switch (this.VRMLgd.getNextChoiceIndex()) {
                    case 0: {
                        this.StaticView = false;
                        break;
                    }
                    case 1: {
                        this.StaticViewTraj = true;
                        this.Static = "_static-Trajectories.wrl";
                        break;
                    }
                    case 2: {
                        this.StaticViewObj = true;
                        this.Static = "_static-Objects.wrl";
                    }
                }
                switch (this.VRMLgd.getNextChoiceIndex()) {
                    case 0: {
                        this.DynamicView = false;
                        break;
                    }
                    case 1: {
                        this.Dynamic = "_dynamic-Objects.wrl";
                        break;
                    }
                    case 2: {
                        this.DynamicViewStaticTraj = true;
                        this.Dynamic = "_dynamic-Objects & Static Trajectories.wrl";
                        break;
                    }
                    case 3: {
                        this.DynamicViewDynamicTraj = true;
                        this.Dynamic = "_dynamic-Objects & Dynamic Trajectories.wrl";
                    }
                }
                if (!this.StaticView && !this.DynamicView) {
                    this.DoVRML = false;
                }
            }
            if (this.DoVRML) {
                this.sd = new SaveDialog("Select destination folder for the VRML file", "---VRML Files Destination Folder---", "");
                this.FileName = this.imgtitle;
                if (this.FileName.indexOf(".") != -1) {
                    this.FileName = this.FileName.substring(0, this.FileName.indexOf("."));
                }
                if (this.StaticView) {
                    this.dirVRMLstat = this.sd.getDirectory() + this.FileName + this.Static;
                }
                if (this.DynamicView) {
                    this.dirVRMLdynam = this.sd.getDirectory() + this.FileName + this.Dynamic;
                }
                this.VRMLarray = new int[this.rt.getCounter()][5];
            }
            String[] head3D = new String[]{"Track n\u00b0", "Timepoint (" + this.choicecalt.getItem(this.choicecalt.getSelectedIndex()) + ")", "X", "Y", "Z", "Distance", "Velocity", "Quantif sgl", "Nb voxels sgl (" + (this.sglBoxx * 2 + 1) + "x" + (this.sglBoxy * 2 + 1) + "x" + (this.sglBoxz * 2 + 1) + " px)", "Quantif bkgd", "Nb voxels bkgd (" + (this.bkgdBoxx * 2 + 1) + "x" + (this.bkgdBoxy * 2 + 1) + "x" + (this.bkgdBoxz * 2 + 1) + " px)", "Sgl bkgd corr", "Sgl bkgd bleach corr", "Quantif ttl"};
            this.i = 0;
            while (this.i < head3D.length) {
                rt3D.setHeading(this.i, head3D[this.i]);
                ++this.i;
            }
            this.i = 0;
            while (this.i < this.rt.getCounter()) {
                IJ.showProgress((int)this.i, (int)(this.rt.getCounter() - 1));
                rt3D.incrementCounter();
                this.Tag = (int)this.rt.getValue(0, this.i);
                this.Slice = (int)this.rt.getValue(1, this.i);
                this.x = (int)this.rt.getValue(2, this.i);
                this.y = (int)this.rt.getValue(3, this.i);
                this.z = 0;
                this.PixVal = (int)this.rt.getValue(6, this.i);
                this.SliceTitle = this.img.getStack().getSliceLabel(this.Slice);
                if (this.SliceTitle == null) {
                    IJ.showMessage((String)"Error", (String)"Each z projection (slice) must carry\nthe corresponding filename as a label");
                    IJ.showProgress((int)2, (int)1);
                    return;
                }
                File f = new File(this.dir + "/" + this.SliceTitle);
                if (!f.isDirectory()) {
                    this.ip = new Opener().openImage(this.dir, this.SliceTitle);
                    if (this.ip != null) {
                        this.Width = this.ip.getWidth();
                        this.Height = this.ip.getHeight();
                        this.Depth = this.ip.getStackSize();
                        this.j = 1;
                        while (this.j < this.ip.getStackSize() + 1) {
                            this.ip.setSlice(this.j);
                            if (this.PixVal == this.ip.getProcessor().getPixel(this.x, this.y)) {
                                this.z = this.j;
                            }
                            ++this.j;
                        }
                        if (this.Centring != 0) {
                            this.Center3D();
                        }
                        rt3D.addValue(0, (double)this.Tag);
                        rt3D.addValue(1, (double)(this.Slice - 1) * this.calt);
                        rt3D.addValue(2, (double)this.x);
                        rt3D.addValue(3, (double)this.y);
                        rt3D.addValue(4, (double)this.z);
                        if (this.DoVRML) {
                            this.VRMLarray[this.i][0] = this.Tag;
                            this.VRMLarray[this.i][1] = (int)Math.round((double)(this.Slice - 1) * this.calt);
                            this.VRMLarray[this.i][2] = this.x;
                            this.VRMLarray[this.i][3] = this.y;
                            this.VRMLarray[this.i][4] = this.z;
                        }
                        if (this.Tag != this.TagOld || rt3D.getCounter() == 1) {
                            if (this.minTime > (double)(this.Slice - 1) * this.calt) {
                                this.minTime = (double)(this.Slice - 1) * this.calt;
                            }
                            rt3D.addValue(5, -1.0);
                            rt3D.addValue(6, -1.0);
                        } else {
                            if (this.maxTime < (double)(this.Slice - 1) * this.calt) {
                                this.maxTime = (double)(this.Slice - 1) * this.calt;
                            }
                            this.Distance = Math.sqrt(Math.pow(this.calxy * (double)(this.x - this.xOld), 2.0) + Math.pow(this.calxy * (double)(this.y - this.yOld), 2.0) + Math.pow(this.calz * (double)(this.z - this.zOld), 2.0));
                            this.Velocity = this.Distance / this.calt;
                            rt3D.addValue(5, this.Distance);
                            rt3D.addValue(6, this.Velocity);
                        }
                        if (this.DoQuantification) {
                            this.quantify();
                            if (this.Tag != this.TagOld) {
                                this.Qttl0 = this.Qttl;
                            }
                            rt3D.addValue(7, this.Qsgl);
                            rt3D.addValue(8, this.sizeSgl);
                            rt3D.addValue(9, this.Qbkgd);
                            rt3D.addValue(10, this.sizeBkgd);
                            rt3D.addValue(11, this.QSglBkgdCorr);
                            if (this.DoBleachCorr) {
                                this.QSglBkgdBleachCorr = this.QSglBkgdCorr * this.Qttl0 / this.Qttl;
                                rt3D.addValue(12, this.QSglBkgdBleachCorr);
                                rt3D.addValue(13, this.Qttl);
                            }
                        }
                    }
                }
                this.TagOld = this.Tag;
                this.xOld = this.x;
                this.yOld = this.y;
                this.zOld = this.z;
                this.ip.flush();
                ++this.i;
            }
            if (this.DoQuantification) {
                rt3D.show("3D Results from " + this.imgtitle + " in " + this.choicecalxy.getItem(this.choicecalxy.getSelectedIndex()) + " per " + this.choicecalt.getItem(this.choicecalt.getSelectedIndex()) + ", " + this.CentringArray[this.Centring] + ", " + this.QuantificationArray[this.Quantification]);
            } else {
                rt3D.show("3D Results from " + this.imgtitle + " in " + this.choicecalxy.getItem(this.choicecalxy.getSelectedIndex()) + " per " + this.choicecalt.getItem(this.choicecalt.getSelectedIndex()) + ", " + this.CentringArray[this.Centring]);
            }
            if (this.DoVRML) {
                this.DoVRML();
            }
            IJ.showProgress((int)2, (int)1);
        }
    }

    @Override
    public void mouseReleased(MouseEvent m) {
        if (!this.islisteningRef) {
            IJ.showProgress((int)this.getPosition(this.img), (int)this.getMaxPosition(this.img));
            if (this.trackZ) {
                IJ.showStatus((String)("Tracking slice " + this.adapter.getSlice(this.img) + " of " + this.img.getNSlices()));
            } else {
                IJ.showStatus((String)("Tracking frame " + this.adapter.getFrame(this.img) + " of " + this.img.getNFrames()));
            }
            if (this.Nbtrack == 1 && this.NbPoint == 1) {
                this.i = 0;
                while (this.i < this.head.length) {
                    this.rt.setHeading(this.i, this.head[this.i]);
                    ++this.i;
                }
            }
        }
        this.img.killRoi();
        this.checkShowRef.setState(false);
        int x = m.getX();
        int y = m.getY();
        this.ox = this.canvas.offScreenX(x);
        this.oy = this.canvas.offScreenY(y);
        if (this.checkCent.getState()) {
            this.Center2D();
        }
        if (this.islisteningRef) {
            this.canvas.removeMouseListener((MouseListener)this);
            this.islistening = false;
            this.islisteningRef = false;
            this.refx = this.ox;
            this.refy = this.oy;
            IJ.showStatus((String)("Reference set to (" + this.refx + "," + this.refy + ")"));
            this.titleRef.setText("Reference set to (" + this.refx + "," + this.refy + ")");
            this.RefSet = true;
            this.checkRef.setState(true);
            this.dotsize = (int)Tools.parseDouble((String)this.dotsizefield.getText());
            this.roiRef = new OvalRoi(this.refx - this.dotsize, this.refy - this.dotsize, 2 * this.dotsize, 2 * this.dotsize);
            this.img.setRoi(this.roiRef);
            this.checkShowRef.setState(true);
            return;
        }
        this.xRoi[this.NbPoint - 1] = this.ox;
        this.yRoi[this.NbPoint - 1] = this.oy;
        if (this.NbPoint == 1) {
            this.Distance = -1.0;
            this.Velocity = -1.0;
        } else {
            this.Distance = this.calxy * Math.sqrt(Math.pow(this.ox - this.prevx, 2.0) + Math.pow(this.oy - this.prevy, 2.0));
            this.Velocity = this.Distance / this.calt;
        }
        if (this.checkRef.getState()) {
            this.Directionnality();
        }
        this.PixVal = this.img.getProcessor().getPixel(this.ox, this.oy);
        this.rt.incrementCounter();
        double[] doub = new double[]{this.Nbtrack, this.img.getCurrentSlice(), this.ox, this.oy, this.Distance, this.Velocity, this.PixVal};
        this.i = 0;
        while (this.i < doub.length) {
            this.rt.addValue(this.i, doub[this.i]);
            ++this.i;
        }
        this.rt.show("Results from " + this.imgtitle + " in " + this.choicecalxy.getItem(this.choicecalxy.getSelectedIndex()) + " per " + this.choicecalt.getItem(this.choicecalt.getSelectedIndex()));
        if (this.getPosition(this.img) < this.getMaxPosition(this.img)) {
            ++this.NbPoint;
            this.moveTo(this.img, this.getPosition(this.img) + 1);
            if (this.Distance != 0.0) {
                this.pprevx = this.prevx;
                this.pprevy = this.prevy;
            }
            this.prevx = this.ox;
            this.prevy = this.oy;
            this.roi = new PolygonRoi(this.xRoi, this.yRoi, this.NbPoint - 1, 6);
            if (this.checkPath.getState()) {
                this.img.setRoi(this.roi);
            }
        } else {
            this.trackdel.add("" + this.Nbtrack);
            ++this.Nbtrack;
            this.img.setRoi(this.roi);
            this.canvas.removeMouseListener((MouseListener)this);
            this.islistening = false;
            this.checkCent.setState(false);
            IJ.showStatus((String)"Tracking is over");
            return;
        }
    }

    @Override
    public void mousePressed(MouseEvent m) {
    }

    @Override
    public void mouseExited(MouseEvent m) {
    }

    @Override
    public void mouseClicked(MouseEvent m) {
    }

    @Override
    public void mouseEntered(MouseEvent m) {
    }

    void HideParam() {
        this.checkParam.setState(false);
        this.panel.remove(this.labelEmpty1);
        this.panel.remove(this.labelEmpty2);
        this.panel.remove(this.labelEmpty3);
        this.panel.remove(this.labelEmpty4);
        this.panel.remove(this.labelParam);
        this.panel.remove(this.labelEmpty5);
        this.panel.remove(this.labelTime);
        this.panel.remove(this.caltfield);
        this.panel.remove(this.choicecalt);
        this.panel.remove(this.labelxy);
        this.panel.remove(this.calxyfield);
        this.panel.remove(this.choicecalxy);
        this.panel.remove(this.labelz);
        this.panel.remove(this.calzfield);
        this.panel.remove(this.labelEmpty6);
        this.panel.remove(this.labelCent);
        this.panel.remove(this.centsize);
        this.panel.remove(this.labelPix);
        this.panel.remove(this.labelDot);
        this.panel.remove(this.dotsizefield);
        this.panel.remove(this.labelEmpty7);
        this.panel.remove(this.labelLine);
        this.panel.remove(this.linewidthfield);
        this.panel.remove(this.labelEmpty8);
        this.panel.remove(this.labelFont);
        this.panel.remove(this.fontsizefield);
        this.panel.remove(this.labelEmpty9);
        this.pack();
        this.show();
    }

    void ShowParam() {
        this.checkParam.setState(true);
        this.panel.add(this.labelEmpty1);
        this.panel.add(this.labelEmpty2);
        this.panel.add(this.labelEmpty3);
        this.panel.add(this.labelEmpty4);
        this.panel.add(this.labelParam);
        this.panel.add(this.labelEmpty5);
        this.panel.add(this.labelTime);
        this.panel.add(this.caltfield);
        this.panel.add(this.choicecalt);
        this.panel.add(this.labelxy);
        this.panel.add(this.calxyfield);
        this.panel.add(this.choicecalxy);
        this.panel.add(this.labelz);
        this.panel.add(this.calzfield);
        this.panel.add(this.labelEmpty6);
        this.panel.add(this.labelCent);
        this.panel.add(this.centsize);
        this.panel.add(this.labelPix);
        this.panel.add(this.labelDot);
        this.panel.add(this.dotsizefield);
        this.panel.add(this.labelEmpty7);
        this.panel.add(this.labelLine);
        this.panel.add(this.linewidthfield);
        this.panel.add(this.labelEmpty8);
        this.panel.add(this.labelFont);
        this.panel.add(this.fontsizefield);
        this.panel.add(this.labelEmpty9);
        this.pack();
        this.show();
    }

    void Center2D() {
        int lim = (int)(Tools.parseDouble((String)this.centsize.getText()) / 2.0);
        int pixval = this.img.getProcessor().getPixel(this.ox, this.oy);
        double xb = 0.0;
        double yb = 0.0;
        double sum = 0.0;
        this.commentCorr = "(" + this.ox + "," + this.oy + ") > (";
        this.i = this.ox - lim;
        while (this.i < this.ox + lim + 1) {
            this.j = this.oy - lim;
            while (this.j < this.oy + lim + 1) {
                if (this.img.getProcessor().getPixel(this.i, this.j) > pixval && this.choicecent.getSelectedIndex() == 0) {
                    this.ox = this.i;
                    this.oy = this.j;
                    pixval = this.img.getProcessor().getPixel(this.ox, this.oy);
                }
                if (this.img.getProcessor().getPixel(this.i, this.j) < pixval && this.choicecent.getSelectedIndex() == 1) {
                    this.ox = this.i;
                    this.oy = this.j;
                    pixval = this.img.getProcessor().getPixel(this.ox, this.oy);
                }
                xb += (double)(this.i * this.img.getProcessor().getPixel(this.i, this.j));
                yb += (double)(this.j * this.img.getProcessor().getPixel(this.i, this.j));
                sum += (double)this.img.getProcessor().getPixel(this.i, this.j);
                ++this.j;
            }
            ++this.i;
        }
        xb /= sum;
        yb /= sum;
        if (this.choicecent.getSelectedIndex() == 2) {
            this.ox = (int)xb;
            this.oy = (int)yb;
        }
        this.commentCorr = this.commentCorr + this.ox + "," + this.oy + ")";
        this.labelCorr.setText(this.commentCorr);
    }

    void Directionnality() {
        if (!this.RefSet) {
            IJ.showMessage((String)"!!! Warning !!!", (String)" No reference set:\nClick on 'Add reference' first !!!");
            this.checkRef.setState(false);
            return;
        }
        if (this.NbPoint == 2) {
            this.DirIndex = 1;
            this.pprevx = this.refx;
            this.pprevy = this.refy;
        }
        if (this.NbPoint > 1) {
            double angle2;
            double angle1 = this.roi.getAngle(this.pprevx, this.pprevy, this.prevx, this.prevy);
            double angle = Math.abs(180.0 - Math.abs(angle1 - (angle2 = this.roi.getAngle(this.prevx, this.prevy, this.ox, this.oy))));
            if (angle > 180.0) {
                angle = 360.0 - angle;
            }
            if (angle < 90.0) {
                this.DirIndex = -this.DirIndex;
            }
            this.Distance *= (double)this.DirIndex;
            this.Velocity *= (double)this.DirIndex;
        }
    }

    void Dots() {
        this.dotsize = (int)Tools.parseDouble((String)this.dotsizefield.getText());
        this.j = 0;
        int nbtrackold = 1;
        this.i = 0;
        while (this.i < this.rt.getCounter()) {
            int nbtrack = (int)this.rt.getValue(0, this.i);
            int nbslices = (int)this.rt.getValue(1, this.i);
            int cx = (int)this.rt.getValue(2, this.i);
            int cy = (int)this.rt.getValue(3, this.i);
            if (nbtrack != nbtrackold) {
                ++this.j;
            }
            if (this.j > 6) {
                this.j = 0;
            }
            ImageProcessor ip = this.stack.getProcessor(nbslices);
            ip.setColor(this.col[this.j]);
            ip.setLineWidth(this.dotsize);
            ip.drawDot(cx, cy);
            if (this.checkText.getState()) {
                Font font = new Font("SansSerif", 0, (int)Tools.parseDouble((String)this.fontsizefield.getText()));
                ip.setFont(font);
                ip.drawString("" + nbtrack, cx + (this.dotsize - 5) / 2, cy - (this.dotsize - 5) / 2);
            }
            nbtrackold = nbtrack;
            ++this.i;
        }
    }

    void ProLines() {
        this.linewidth = Tools.parseDouble((String)this.linewidthfield.getText());
        this.j = 0;
        this.k = 1;
        int cxold = 0;
        int cyold = 0;
        int nbtrackold = 1;
        this.i = 0;
        while (this.i < this.rt.getCounter()) {
            int nbtrack = (int)this.rt.getValue(0, this.i);
            int nbslices = (int)this.rt.getValue(1, this.i);
            int cx = (int)this.rt.getValue(2, this.i);
            int cy = (int)this.rt.getValue(3, this.i);
            int lim = this.img.getStackSize() + 1;
            if (nbtrack != nbtrackold) {
                ++this.j;
                this.k = 1;
            }
            for (int n = nbtrack; n < this.rt.getCounter(); ++n) {
                if ((int)this.rt.getValue(0, n) != nbtrack) continue;
                lim = (int)this.rt.getValue(1, n);
            }
            if (this.j > 6) {
                this.j = 0;
            }
            for (int m = nbslices; m < lim + 1; ++m) {
                if (this.k == 1) {
                    cxold = cx;
                    cyold = cy;
                }
                ImageProcessor ip = this.stack.getProcessor(m);
                ip.setColor(this.col[this.j]);
                ip.setLineWidth((int)this.linewidth);
                ip.drawLine(cxold, cyold, cx, cy);
                nbtrackold = nbtrack;
                ++this.k;
            }
            cxold = cx;
            cyold = cy;
            ++this.i;
        }
    }

    void Center3D() {
        this.tmpx = 0;
        this.tmpy = 0;
        this.tmpz = 0;
        this.PixVal = 0;
        this.tmpttl = 0;
        this.Qttl = 0.0;
        this.limsx1 = this.x - this.sglBoxx;
        if (this.limsx1 < 0) {
            this.limsx1 = 0;
        }
        this.limsx2 = this.x + this.sglBoxx;
        if (this.limsx2 > this.Width - 1) {
            this.limsx2 = this.Width - 1;
        }
        this.limsy1 = this.y - this.sglBoxy;
        if (this.limsy1 < 0) {
            this.limsy1 = 0;
        }
        this.limsy2 = this.y + this.sglBoxy;
        if (this.limsy2 > this.Height - 1) {
            this.limsy2 = this.Height - 1;
        }
        this.limsz1 = this.z - this.sglBoxz;
        if (this.limsz1 < 1) {
            this.limsz1 = 1;
        }
        this.limsz2 = this.z + this.sglBoxz;
        if (this.limsz2 > this.ip.getNSlices()) {
            this.limsz2 = this.ip.getNSlices();
        }
        this.l = this.limsz1;
        while (this.l < this.limsz2 + 1) {
            this.moveTo(this.ip, this.l);
            this.m = this.limsy1;
            while (this.m < this.limsy2 + 1) {
                this.n = this.limsx1;
                while (this.n < this.limsx2 + 1) {
                    this.tmppixval = this.ip.getProcessor().getPixel(this.n, this.m);
                    if (this.Centring == 1) {
                        this.tmpx += this.n * this.tmppixval;
                        this.tmpy += this.m * this.tmppixval;
                        this.tmpz += this.l * this.tmppixval;
                        this.tmpttl += this.tmppixval;
                    }
                    if (this.Centring == 2 && this.tmppixval > this.PixVal) {
                        this.PixVal = this.tmppixval;
                        this.tmpx = this.n;
                        this.tmpy = this.m;
                        this.tmpz = this.l;
                        this.tmpttl = 1;
                    }
                    ++this.n;
                }
                ++this.m;
            }
            ++this.l;
        }
        this.x = this.tmpx / this.tmpttl;
        this.y = this.tmpy / this.tmpttl;
        this.z = this.tmpz / this.tmpttl;
    }

    void quantify() {
        this.Qsgl = 0.0;
        this.sizeSgl = 0.0;
        this.Qbkgd = 0.0;
        this.sizeBkgd = 0.0;
        this.Qttl = 0.0;
        this.limsx1 = this.x - this.sglBoxx;
        if (this.limsx1 < 0) {
            this.limsx1 = 0;
        }
        this.limsx2 = this.x + this.sglBoxx;
        if (this.limsx2 > this.Width - 1) {
            this.limsx2 = this.Width - 1;
        }
        this.limsy1 = this.y - this.sglBoxy;
        if (this.limsy1 < 0) {
            this.limsy1 = 0;
        }
        this.limsy2 = this.y + this.sglBoxy;
        if (this.limsy2 > this.Height - 1) {
            this.limsy2 = this.Height - 1;
        }
        this.limsz1 = this.z - this.sglBoxz;
        if (this.limsz1 < 1) {
            this.limsz1 = 1;
        }
        this.limsz2 = this.z + this.sglBoxz;
        if (this.limsz2 > this.getMaxPosition(this.ip)) {
            this.limsz2 = this.getMaxPosition(this.ip);
        }
        if (this.Quantification == 1) {
            this.limbx1 = this.x - this.bkgdBoxx;
            this.limbx2 = this.x + this.bkgdBoxx;
            this.limby1 = this.y - this.bkgdBoxy;
            this.limby2 = this.y + this.bkgdBoxy;
        }
        if (this.Quantification == 2) {
            this.limbx1 = 0;
            this.limbx2 = this.bkgdBoxx * 2;
            this.limby1 = 0;
            this.limby2 = this.bkgdBoxy * 2;
        }
        if (this.Quantification == 3) {
            this.limbx1 = this.Width - 2 * this.bkgdBoxx;
            this.limbx2 = this.Width;
            this.limby1 = 0;
            this.limby2 = this.bkgdBoxy * 2;
        }
        if (this.Quantification == 4) {
            this.limbx1 = 0;
            this.limbx2 = this.bkgdBoxx * 2;
            this.limby1 = this.Height - 2 * this.bkgdBoxy;
            this.limby2 = this.Height;
        }
        if (this.Quantification == 5) {
            this.limbx1 = this.Width - 2 * this.bkgdBoxx;
            this.limbx2 = this.Width;
            this.limby1 = this.Height - 2 * this.bkgdBoxy;
            this.limby2 = this.Height;
        }
        if (this.limbx1 < 0) {
            this.limbx1 = 0;
        }
        if (this.limbx2 > this.Width - 1) {
            this.limbx2 = this.Width - 1;
        }
        if (this.limby1 < 0) {
            this.limby1 = 0;
        }
        if (this.limby2 > this.Height - 1) {
            this.limby2 = this.Height - 1;
        }
        this.limbz1 = this.z - this.bkgdBoxz;
        if (this.limbz1 < 1) {
            this.limbz1 = 1;
        }
        this.limbz2 = this.z + this.bkgdBoxz;
        if (this.limbz2 > this.getMaxPosition(this.ip)) {
            this.limbz2 = this.getMaxPosition(this.ip);
        }
        this.l = this.limsz1;
        while (this.l < this.limsz2 + 1) {
            this.moveTo(this.ip, this.l);
            this.m = this.limsy1;
            while (this.m < this.limsy2 + 1) {
                this.n = this.limsx1;
                while (this.n < this.limsx2 + 1) {
                    this.Qsgl += (double)this.ip.getProcessor().getPixel(this.n, this.m);
                    this.sizeSgl += 1.0;
                    ++this.n;
                }
                ++this.m;
            }
            ++this.l;
        }
        if (this.Quantification > 0) {
            this.l = this.limbz1;
            while (this.l < this.limbz2 + 1) {
                this.moveTo(this.ip, this.l);
                this.m = this.limby1;
                while (this.m < this.limby2 + 1) {
                    this.n = this.limbx1;
                    while (this.n < this.limbx2 + 1) {
                        this.Qbkgd += (double)this.ip.getProcessor().getPixel(this.n, this.m);
                        this.sizeBkgd += 1.0;
                        ++this.n;
                    }
                    ++this.m;
                }
                ++this.l;
            }
        } else {
            this.sizeBkgd = 1.0;
        }
        this.QSglBkgdCorr = this.Qsgl - this.Qbkgd * this.sizeSgl / this.sizeBkgd;
        if (this.DoBleachCorr) {
            this.l = 1;
            while (this.l < this.ip.getStackSize() + 1) {
                this.ip.setSlice(this.l);
                this.m = 0;
                while (this.m < this.Height) {
                    this.n = 0;
                    while (this.n < this.Width) {
                        this.Qttl += (double)this.ip.getProcessor().getPixel(this.n, this.m);
                        ++this.n;
                    }
                    ++this.m;
                }
                ++this.l;
            }
        }
    }

    void DoVRML() {
        try {
            if (this.StaticView) {
                this.oswStat = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(this.dirVRMLstat)));
            }
            if (this.DynamicView) {
                this.oswDynam = new OutputStreamWriter(new BufferedOutputStream(new FileOutputStream(this.dirVRMLdynam)));
            }
            this.vrmlCount = -1;
            this.TagOld = 0;
            this.DistOfView = Math.max(Math.sqrt(Math.pow((double)this.Width * this.calxy / 2.0, 2.0) + Math.pow((double)this.Depth * this.calz / 2.0, 2.0)), Math.sqrt(Math.pow((double)this.Height * this.calxy / 2.0, 2.0) + Math.pow((double)this.Depth * this.calz / 2.0, 2.0)));
            this.DistOfView = Math.max(Math.sqrt(Math.pow((double)this.Width * this.calxy / 2.0, 2.0) + Math.pow((double)this.Height * this.calxy / 2.0, 2.0)), this.DistOfView);
            if (this.DynamicView) {
                this.oswDynam.write("#VRML V2.0 utf8\n");
                this.oswDynam.write("\n");
                this.oswDynam.write("Viewpoint{\n");
                this.oswDynam.write("position " + (double)this.Width * this.calxy / 2.0 + " " + (double)this.Height * this.calxy / 2.0 + " " + -3.0 * this.DistOfView + "\n");
                this.oswDynam.write("orientation 1 0 0 3.1415926535897932384626433832795\n");
                this.oswDynam.write("description \"XY view\"}\n");
                this.oswDynam.write("Viewpoint{\n");
                this.oswDynam.write("position " + (double)this.Width * this.calxy / 2.0 + " " + 3.0 * this.DistOfView + " " + (double)this.Depth * this.calz / 2.0 + "\n");
                this.oswDynam.write("orientation -1 0 0 1.5707963267948966192313216916398\n");
                this.oswDynam.write("description \"XZ view\"}\n");
                this.oswDynam.write("Viewpoint{");
                this.oswDynam.write("position " + 3.0 * this.DistOfView + " " + (double)this.Height * this.calxy / 2.0 + " " + (double)this.Depth * this.calz / 2.0 + "\n");
                this.oswDynam.write("orientation 0.57735026918962576450914878050196 0.57735026918962576450914878050196 0.57735026918962576450914878050196 2.0943951023931954923084289221863\n");
                this.oswDynam.write("description \"YZ view\"}\n");
                this.oswDynam.write("Transform{\n");
                this.oswDynam.write("translation " + (double)this.Width * this.calxy / 2.0 + " " + (double)this.Height * this.calxy / 2.0 + " " + (double)this.ip.getStackSize() * this.calz / 2.0 + "\n");
                this.oswDynam.write("children[\n");
                this.oswDynam.write("Shape{\n");
                this.oswDynam.write("appearance Appearance{\n");
                this.oswDynam.write("material Material{diffuseColor 1 1 1\n");
                this.oswDynam.write("transparency 0.75}}\n");
                this.oswDynam.write("geometry Box{size " + (double)this.Width * this.calxy + " " + (double)this.Height * this.calxy + " " + (double)this.ip.getStackSize() * this.calz + "}}]}\n");
                this.oswDynam.write("\n");
            }
            if (this.StaticView) {
                this.oswStat.write("#VRML V2.0 utf8\n");
                this.oswStat.write("\n");
                this.oswStat.write("Viewpoint{\n");
                this.oswStat.write("position " + (double)this.Width * this.calxy / 2.0 + " " + (double)this.Height * this.calxy / 2.0 + " " + -3.0 * this.DistOfView + "\n");
                this.oswStat.write("orientation 1 0 0 3.1415926535897932384626433832795\n");
                this.oswStat.write("description \"XY view\"}\n");
                this.oswStat.write("Viewpoint{\n");
                this.oswStat.write("position " + (double)this.Width * this.calxy / 2.0 + " " + 3.0 * this.DistOfView + " " + (double)this.Depth * this.calz / 2.0 + "\n");
                this.oswStat.write("orientation -1 0 0 1.5707963267948966192313216916398\n");
                this.oswStat.write("description \"XZ view\"}\n");
                this.oswStat.write("Viewpoint{");
                this.oswStat.write("position " + 3.0 * this.DistOfView + " " + (double)this.Height * this.calxy / 2.0 + " " + (double)this.Depth * this.calz / 2.0 + "\n");
                this.oswStat.write("orientation 0.57735026918962576450914878050196 0.57735026918962576450914878050196 0.57735026918962576450914878050196 2.0943951023931954923084289221863\n");
                this.oswStat.write("description \"YZ view\"}\n");
                this.oswStat.write("Transform{\n");
                this.oswStat.write("translation " + (double)this.Width * this.calxy / 2.0 + " " + (double)this.Height * this.calxy / 2.0 + " " + (double)this.ip.getStackSize() * this.calz / 2.0 + "\n");
                this.oswStat.write("children[\n");
                this.oswStat.write("Shape{\n");
                this.oswStat.write("appearance Appearance{\n");
                this.oswStat.write("material Material{diffuseColor 1 1 1\n");
                this.oswStat.write("transparency 0.75}}\n");
                this.oswStat.write("geometry Box{size " + (double)this.Width * this.calxy + " " + (double)this.Height * this.calxy + " " + (double)this.ip.getStackSize() * this.calz + "}}]}\n");
                this.oswStat.write("\n");
            }
            this.key = "key [\n";
            for (double tmp = this.minTime; tmp < this.maxTime + this.calt; tmp += this.calt) {
                this.key = this.key + " " + (tmp - this.minTime) / (this.maxTime - this.minTime);
                ++this.countTtl;
            }
            this.key = this.key + "]\n";
            this.i = 0;
            while (this.i < this.rt.getCounter()) {
                this.Tag = this.VRMLarray[this.i][0];
                if (this.Tag != this.TagOld) {
                    ++this.vrmlCount;
                    this.point = "";
                    this.pointNb = 0;
                    this.pointKey = "";
                    this.lastPoint = "";
                    this.countBefore = 0;
                    this.countAfter = 0;
                    if (this.vrmlCount > 6) {
                        this.vrmlCount = 0;
                    }
                    if (this.DynamicView) {
                        this.oswDynam.write("DEF TRACK" + this.VRMLarray[this.i][0] + " Transform{\n");
                        this.oswDynam.write("children[\n");
                        this.oswDynam.write("Shape{\n");
                        this.oswDynam.write("appearance Appearance{\n");
                        this.oswDynam.write("material Material{diffuseColor " + this.vrmlCol[this.vrmlCount] + "}}\n");
                        this.oswDynam.write("geometry Sphere {radius " + Tools.parseDouble((String)this.dotsizefield.getText()) * this.calxy + "}}]}\n");
                        this.oswDynam.write("\n");
                        this.oswDynam.write("DEF TRACK" + this.VRMLarray[this.i][0] + "_clock TimeSensor{\n");
                        this.oswDynam.write("cycleInterval 5\n");
                        this.oswDynam.write("loop TRUE\n");
                        this.oswDynam.write("stopTime -1}\n");
                        this.oswDynam.write("\n");
                        this.oswDynam.write("DEF TRACK" + this.VRMLarray[this.i][0] + "_positions PositionInterpolator{\n");
                        this.oswDynam.write(this.key + "\n");
                        this.oswDynam.write("keyValue [\n");
                    }
                    this.j = 0;
                    while ((double)this.j < (double)this.VRMLarray[this.i][1] / this.calt) {
                        if (this.DynamicView) {
                            this.oswDynam.write(this.calxy * (double)this.VRMLarray[this.i][2] + " " + this.calxy * (double)this.VRMLarray[this.i][3] + " " + this.calz * (double)this.VRMLarray[this.i][4] + ",\n");
                        }
                        this.point = this.point + this.calxy * (double)this.VRMLarray[this.i][2] + " " + this.calxy * (double)this.VRMLarray[this.i][3] + " " + this.calz * (double)this.VRMLarray[this.i][4] + ", ";
                        this.pointKey = this.pointKey + this.point;
                        this.k = this.pointNb;
                        while (this.k < this.countTtl) {
                            this.pointKey = this.pointKey + this.calxy * (double)this.VRMLarray[this.i][2] + " " + this.calxy * (double)this.VRMLarray[this.i][3] + " " + this.calz * (double)this.VRMLarray[this.i][4] + ", ";
                            ++this.k;
                        }
                        this.pointKey = this.pointKey + "\n";
                        ++this.pointNb;
                        ++this.countBefore;
                        ++this.j;
                    }
                }
                if (this.StaticView && this.StaticViewObj) {
                    this.oswStat.write("Transform{\n");
                    this.oswStat.write("translation " + this.calxy * (double)this.VRMLarray[this.i][2] + " " + this.calxy * (double)this.VRMLarray[this.i][3] + " " + this.calz * (double)this.VRMLarray[this.i][4] + ",\n");
                    this.oswStat.write("children[\n");
                    this.oswStat.write("Shape{\n");
                    this.oswStat.write("appearance Appearance{\n");
                    this.oswStat.write("material Material{diffuseColor " + this.vrmlCol[this.vrmlCount] + "}}\n");
                    this.oswStat.write("geometry Sphere {radius " + Tools.parseDouble((String)this.dotsizefield.getText()) * this.calxy + "}}]\n}");
                    this.oswStat.write("\n");
                }
                if (this.DynamicView) {
                    this.oswDynam.write(this.calxy * (double)this.VRMLarray[this.i][2] + " " + this.calxy * (double)this.VRMLarray[this.i][3] + " " + this.calz * (double)this.VRMLarray[this.i][4] + ",\n");
                }
                this.point = this.point + this.calxy * (double)this.VRMLarray[this.i][2] + " " + this.calxy * (double)this.VRMLarray[this.i][3] + " " + this.calz * (double)this.VRMLarray[this.i][4] + ", ";
                this.pointKey = this.pointKey + this.point;
                this.k = this.pointNb + 1;
                while (this.k < this.countTtl) {
                    this.pointKey = this.pointKey + this.calxy * (double)this.VRMLarray[this.i][2] + " " + this.calxy * (double)this.VRMLarray[this.i][3] + " " + this.calz * (double)this.VRMLarray[this.i][4] + ", ";
                    ++this.k;
                }
                this.pointKey = this.pointKey + "\n";
                ++this.countAfter;
                ++this.pointNb;
                if (this.i != this.rt.getCounter() - 1 && this.VRMLarray[this.i][0] != this.VRMLarray[this.i + 1][0] || this.i == this.rt.getCounter() - 1) {
                    this.k = 0;
                    while (this.k < this.countTtl) {
                        this.lastPoint = this.lastPoint + this.calxy * (double)this.VRMLarray[this.i][2] + " " + this.calxy * (double)this.VRMLarray[this.i][3] + " " + this.calz * (double)this.VRMLarray[this.i][4] + ", ";
                        ++this.k;
                    }
                    if (this.DynamicView) {
                        this.j = 0;
                        while (this.j < this.countTtl - (this.countBefore + this.countAfter)) {
                            this.oswDynam.write(this.calxy * (double)this.VRMLarray[this.i][2] + " " + this.calxy * (double)this.VRMLarray[this.i][3] + " " + this.calz * (double)this.VRMLarray[this.i][4] + ",\n");
                            this.pointKey = this.pointKey + this.lastPoint + "\n";
                            ++this.j;
                        }
                        this.oswDynam.write("]}\n");
                        this.oswDynam.write("\n");
                        this.oswDynam.write("ROUTE TRACK" + this.VRMLarray[this.i][0] + "_clock.fraction_changed TO TRACK" + this.VRMLarray[this.i][0] + "_positions.set_fraction\n");
                        this.oswDynam.write("ROUTE TRACK" + this.VRMLarray[this.i][0] + "_positions.value_changed TO TRACK" + this.VRMLarray[this.i][0] + ".translation\n");
                        this.oswDynam.write("\n");
                        this.oswDynam.write("DEF TRACK" + this.VRMLarray[this.i][0] + "_scale PositionInterpolator{\n");
                        this.oswDynam.write(this.key + "\n");
                        this.oswDynam.write("keyValue [\n");
                        this.j = 0;
                        while (this.j < this.countBefore) {
                            this.oswDynam.write("0 0 0,\n");
                            ++this.j;
                        }
                        this.j = 0;
                        while (this.j < this.countAfter) {
                            this.oswDynam.write("1 1 1,\n");
                            ++this.j;
                        }
                        this.j = 0;
                        while (this.j < this.countTtl - (this.countBefore + this.countAfter)) {
                            this.oswDynam.write("0 0 0,\n");
                            ++this.j;
                        }
                        this.oswDynam.write("]}\n");
                        this.oswDynam.write("\n");
                        this.oswDynam.write("ROUTE TRACK" + this.VRMLarray[this.i][0] + "_clock.fraction_changed TO TRACK" + this.VRMLarray[this.i][0] + "_scale.set_fraction\n");
                        this.oswDynam.write("ROUTE TRACK" + this.VRMLarray[this.i][0] + "_scale.value_changed TO TRACK" + this.VRMLarray[this.i][0] + ".scale\n");
                        this.oswDynam.write("\n");
                        if (this.DynamicViewStaticTraj || this.DynamicViewDynamicTraj) {
                            this.oswDynam.write("Shape{\n");
                            this.oswDynam.write("geometry IndexedLineSet{\n");
                            this.oswDynam.write("coord DEF TRAJ" + this.VRMLarray[this.i][0] + " Coordinate{\n");
                            if (this.DynamicViewStaticTraj) {
                                this.oswDynam.write("point[\n" + this.point + "]");
                            }
                            this.oswDynam.write("}\ncoordIndex[");
                        }
                    }
                    if (this.StaticView && this.StaticViewTraj) {
                        this.oswStat.write("Shape{\n");
                        this.oswStat.write("geometry IndexedLineSet{\n");
                        this.oswStat.write("coord Coordinate{\n");
                        this.oswStat.write("point[\n");
                        this.oswStat.write(this.point + "]}\n");
                        this.oswStat.write("coordIndex[");
                    }
                    this.j = 0;
                    while (this.j < this.countTtl) {
                        if (this.DynamicView && this.DynamicViewDynamicTraj) {
                            this.oswDynam.write(this.j + " ");
                        }
                        if (this.DynamicView && this.DynamicViewStaticTraj && this.j < this.pointNb) {
                            this.oswDynam.write(this.j + " ");
                        }
                        if (this.StaticView && this.StaticViewTraj && this.j < this.pointNb) {
                            this.oswStat.write(this.j + " ");
                        }
                        ++this.j;
                    }
                    if (this.DynamicView && (this.DynamicViewStaticTraj || this.DynamicViewDynamicTraj)) {
                        this.oswDynam.write("-1]\n");
                        this.oswDynam.write("color Color{color[" + this.vrmlCol[this.vrmlCount] + "]}\n");
                        this.oswDynam.write("colorPerVertex FALSE}}\n");
                        this.oswDynam.write("\n");
                    }
                    if (this.DynamicView && this.DynamicViewDynamicTraj) {
                        this.oswDynam.write("DEF TRAJ" + this.VRMLarray[this.i][0] + "_coord CoordinateInterpolator{\n");
                        this.oswDynam.write(this.key);
                        this.oswDynam.write("keyValue[\n" + this.pointKey + "]}\n");
                        this.oswDynam.write("ROUTE TRACK" + this.VRMLarray[this.i][0] + "_clock.fraction_changed TO TRAJ" + this.VRMLarray[this.i][0] + "_coord.set_fraction\n");
                        this.oswDynam.write("ROUTE TRAJ" + this.VRMLarray[this.i][0] + "_coord.value_changed TO TRAJ" + this.VRMLarray[this.i][0] + ".point\n\n");
                    }
                    if (this.StaticView && this.StaticViewTraj) {
                        this.oswStat.write("-1]\n");
                        this.oswStat.write("color Color{color[" + this.vrmlCol[this.vrmlCount] + "]}\n");
                        this.oswStat.write("colorPerVertex FALSE}}\n");
                        this.oswStat.write("\n");
                    }
                }
                this.TagOld = this.Tag;
                ++this.i;
            }
            this.oswStat.close();
            this.oswDynam.close();
        }
        catch (IOException e) {
            IJ.error((String)"Error writing VRML file");
        }
    }
}

