/*
 * Decompiled with CFR 0.152.
 */
package amira;

import amira.AmiraParameters;
import amira.AmiraTable;
import ij.IJ;
import ij.ImageStack;
import java.awt.image.ColorModel;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;

public class AmiraMeshDecoder {
    private int width;
    private int height;
    private int numSlices;
    private int mode;
    public final int RAW = 0;
    public final int RLE = 1;
    public final int ZLIB = 2;
    public final int ASCII = 3;
    public AmiraParameters parameters;
    private RandomAccessFile file;
    private long endOffsetOfPreamble;
    private String line;
    boolean shortData = false;
    ByteOrder byteOrder = ByteOrder.nativeOrder();
    private byte[] rleOverrun;
    private int rleOverrunLength;
    private InflaterInputStream zStream;
    private BufferedInputStream in;
    private int zLength;
    private String fileName;
    private String[] colFormat;
    private String[] colName;

    public void AmiraMeshDecoder() {
        this.numSlices = -1;
        this.height = -1;
        this.width = -1;
        this.endOffsetOfPreamble = -1L;
        this.rleOverrunLength = 0;
    }

    public boolean open(String fileName) {
        try {
            Matcher zMatcher;
            block13: {
                File file1 = new File(fileName);
                this.file = new RandomAccessFile(file1, "r");
                this.fileName = file1.getName();
                Pattern latticePattern = Pattern.compile("define Lattice ([0-9]+) ([0-9]+) ([0-9]+).*");
                boolean firstLine = true;
                Pattern firstLinePattern = Pattern.compile("^\\s*#.*AmiraMesh.*$");
                do {
                    Matcher m;
                    IJ.showStatus((String)"Reading AmiraMesh file header...");
                    if (!this.readPreambleLine()) {
                        return false;
                    }
                    if (firstLine) {
                        Matcher firstLineMatcher = firstLinePattern.matcher(this.line);
                        if (!firstLineMatcher.matches() && !this.line.startsWith("# Avizo")) {
                            throw new Exception("This doesn't look like an AmiraMesh file; the first line must be a comment containing the text 'AmiraMesh' or 'Avizo'.");
                        }
                        firstLine = false;
                        if (this.line.contains("LITTLE-ENDIAN")) {
                            this.byteOrder = ByteOrder.LITTLE_ENDIAN;
                        }
                        if (this.line.contains("BIG-ENDIAN")) {
                            this.byteOrder = ByteOrder.BIG_ENDIAN;
                        }
                    }
                    if (!(m = latticePattern.matcher(this.line)).matches()) continue;
                    this.width = Integer.decode(m.group(1));
                    this.height = Integer.decode(m.group(2));
                    this.numSlices = Integer.decode(m.group(3));
                    break block13;
                } while (!this.line.startsWith("# AmiraMesh 3D ASCII"));
                this.mode = 3;
            }
            while (this.readPreambleLine() && (this.line.length() < 11 || !this.line.substring(0, 10).equals("Parameters"))) {
            }
            String parametersString = this.line;
            while (this.readPreambleLine()) {
                parametersString = parametersString + this.line + "\n";
            }
            IJ.showStatus((String)"Setting Amira parameters...");
            this.parameters = new AmiraParameters(parametersString);
            if (this.mode == 3) {
                this.parseColumns(parametersString);
            }
            IJ.showStatus((String)"Checking enconding mode...");
            Pattern rlePattern = Pattern.compile(".*HxByteRLE.*", 40);
            if (rlePattern.matcher(parametersString).matches()) {
                this.mode = 1;
            }
            if ((zMatcher = Pattern.compile(".*HxZip,([0-9]+).*", 40).matcher(parametersString)).matches()) {
                this.mode = 2;
                this.zLength = Integer.parseInt(zMatcher.group(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.error((String)e.toString());
            return false;
        }
        return true;
    }

    private boolean readPreambleLine() {
        if (this.file == null || this.endOffsetOfPreamble > 0L) {
            return false;
        }
        if (!this.readLine()) {
            return false;
        }
        if (this.line.startsWith("Lattice {")) {
            if (this.line.startsWith("Lattice { ushort") || this.line.startsWith("Lattice { short")) {
                this.shortData = true;
            }
            return true;
        }
        if (this.line != "" && this.line.charAt(0) == '@') {
            try {
                this.endOffsetOfPreamble = this.file.getFilePointer();
            }
            catch (Exception e) {
                IJ.error((String)("error: " + e.toString()));
            }
            return false;
        }
        return true;
    }

    private boolean readLine() {
        this.line = "";
        try {
            int input;
            while ((input = this.file.read()) >= 0 && input != 13 && input != 10) {
                this.line = this.line + String.valueOf((char)input);
            }
            while ((input = this.file.read()) >= 0 && input == 13 && input == 10) {
            }
            this.file.seek(this.file.getFilePointer() - 1L);
        }
        catch (Exception e) {
            IJ.error((String)("error: " + e.toString()));
            return false;
        }
        return true;
    }

    private void parseColumns(String p) {
        int index = p.lastIndexOf(64) + 1;
        int index2 = index + 1;
        while (Character.isDigit(p.charAt(index2))) {
            ++index2;
        }
        int numCols = Integer.parseInt(p.substring(index, index2));
        this.colFormat = new String[numCols];
        this.colName = new String[numCols];
        for (int i = numCols; i > 0; --i) {
            index2 = p.lastIndexOf(10, index);
            int index3 = p.indexOf(123, index2);
            while (p.charAt(index3 - 1) == ' ') {
                --index3;
            }
            this.colName[i - 1] = p.substring(index2 + 1, index3);
            ++index3;
            while (p.charAt(index3) == ' ' || p.charAt(index3) == '{') {
                ++index3;
            }
            int index4 = p.indexOf(32, index3);
            this.colFormat[i - 1] = p.substring(index3, index4);
            index = p.lastIndexOf(64, index2);
        }
    }

    public int readRLE(byte[] pixels, int offset, int length) throws IOException {
        if (this.rleOverrun == null) {
            this.rleOverrun = new byte[256];
        }
        if (this.rleOverrunLength > 0) {
            int i;
            for (i = 0; length > 0 && i < this.rleOverrunLength; --length, ++i) {
                pixels[offset] = this.rleOverrun[i];
                ++offset;
            }
            if (i < this.rleOverrunLength) {
                int j = 0;
                while (i + j < this.rleOverrunLength) {
                    this.rleOverrun[j] = this.rleOverrun[i + j];
                    ++j;
                }
                this.rleOverrunLength -= i;
            }
            this.rleOverrunLength = 0;
            return i;
        }
        this.file.read(this.rleOverrun, 0, 1);
        if (this.rleOverrun[0] == 0) {
            IJ.log((String)("byte at offset " + this.file.getFilePointer() + " is 0!"));
            throw new IOException("unexpected zero");
        }
        if (this.rleOverrun[0] < 0) {
            this.rleOverrun[0] = (byte)(this.rleOverrun[0] & 0x7F);
            if (this.rleOverrun[0] > length) {
                this.file.read(pixels, offset, length);
                this.rleOverrunLength = this.rleOverrun[0] - length;
                this.file.read(this.rleOverrun, 0, this.rleOverrunLength);
                return length;
            }
            this.file.read(pixels, offset, this.rleOverrun[0]);
            return this.rleOverrun[0];
        }
        this.file.read(pixels, offset, 1);
        if (this.rleOverrun[0] > length) {
            int i;
            for (i = 1; i < length; ++i) {
                pixels[offset + i] = pixels[offset];
            }
            this.rleOverrunLength = this.rleOverrun[0] - length;
            for (i = 0; i < this.rleOverrunLength; ++i) {
                this.rleOverrun[i] = pixels[offset];
            }
            return length;
        }
        for (int i = 1; i < this.rleOverrun[0]; ++i) {
            pixels[offset + i] = pixels[offset];
        }
        return this.rleOverrun[0];
    }

    public int readZlib(byte[] pixels, int offset, int length) throws IOException {
        if (this.zStream == null) {
            this.in = new BufferedInputStream(new FileInputStream(this.file.getFD()));
            this.zStream = new InflaterInputStream(this.in, new Inflater(), length);
        }
        return this.zStream.read(pixels, offset, length);
    }

    public ImageStack getStack() {
        if (this.file == null || this.endOffsetOfPreamble < 0L) {
            return null;
        }
        int extra = this.shortData ? 2 : 1;
        ColorModel colorModel = this.parameters.getColorModel();
        ImageStack stack = colorModel == null ? new ImageStack(this.width, this.height) : new ImageStack(this.width, this.height, colorModel);
        try {
            this.file.seek(this.endOffsetOfPreamble);
            for (int z = 0; z < this.numSlices; ++z) {
                int length;
                int offset;
                byte[] buffer = new byte[this.width * this.height * extra];
                if (this.mode == 1) {
                    int count;
                    offset = 0;
                    for (length = this.width * this.height * extra; (count = this.readRLE(buffer, offset, length)) < length; length -= count) {
                        offset += count;
                    }
                } else if (this.mode == 2) {
                    int count;
                    offset = 0;
                    for (length = this.width * this.height * extra; (count = this.readZlib(buffer, offset, length)) < length && count >= 0; length -= count) {
                        offset += count;
                    }
                } else {
                    this.file.read(buffer, 0, this.width * this.height * extra);
                }
                if (this.shortData) {
                    short[] shortBuffer = new short[this.width * this.height];
                    ByteBuffer.wrap(buffer).order(this.byteOrder).asShortBuffer().get(shortBuffer);
                    stack.addSlice(null, (Object)shortBuffer);
                } else {
                    stack.addSlice(null, (Object)buffer);
                }
                IJ.showStatus((String)("Reading slice " + (z + 1) + "/" + this.numSlices + "..."));
                IJ.showProgress((int)(z + 1), (int)this.numSlices);
            }
            if (this.mode == 2) {
                this.zStream.close();
                this.in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.error((String)("internal: " + e.toString()));
        }
        IJ.showProgress((double)1.0);
        return stack;
    }

    public ImageStack getStackFast() {
        if (this.file == null || this.endOffsetOfPreamble < 0L) {
            return null;
        }
        int extra = this.shortData ? 2 : 1;
        ColorModel colorModel = this.parameters.getColorModel();
        ImageStack stack = colorModel == null ? new ImageStack(this.width, this.height) : new ImageStack(this.width, this.height, colorModel);
        byte[] buffer = null;
        try {
            this.file.seek(this.endOffsetOfPreamble);
            int length = this.width * this.height * this.numSlices * extra;
            buffer = new byte[length];
            if (this.mode == 1 ? this.readRLE(buffer, 0, length) < length : (this.mode == 2 ? this.readZlib(buffer, 0, length) < length : this.file.read(buffer, 0, length) < length)) {
                return null;
            }
            if (this.mode == 2) {
                this.zStream.close();
                this.in.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            IJ.error((String)("internal: " + e.toString()));
        }
        if (null != buffer) {
            for (int z = 0; z < this.numSlices; ++z) {
                byte[] pixels = new byte[this.width * this.height * extra];
                System.arraycopy(buffer, z * pixels.length, pixels, 0, pixels.length);
                if (this.shortData) {
                    short[] shortBuffer = new short[this.width * this.height];
                    ByteBuffer.wrap(pixels).order(this.byteOrder).asShortBuffer().get(shortBuffer);
                    stack.addSlice(null, (Object)shortBuffer);
                } else {
                    stack.addSlice(null, (Object)pixels);
                }
                IJ.showProgress((int)(z + 1), (int)this.numSlices);
            }
        }
        IJ.showProgress((double)1.0);
        return stack;
    }

    public boolean isTable() {
        return this.mode == 3;
    }

    public AmiraTable getTable() {
        try {
            int numRows = Integer.parseInt(this.parameters.getProperty("numRows"));
            this.file.seek(this.endOffsetOfPreamble);
            String[] data = new String[numRows];
            int numCols = this.colName.length;
            for (int i = 0; i < numCols; ++i) {
                for (int j = 0; j < numRows; ++j) {
                    String value;
                    if (this.colFormat[i].equals("byte")) {
                        int c;
                        value = "";
                        while (this.readLine() && (c = Integer.parseInt(this.line.trim())) != 0) {
                            value = value + Character.toString((char)c);
                        }
                    } else {
                        this.readLine();
                        value = this.line;
                    }
                    if (i == 0) {
                        data[j] = value;
                        continue;
                    }
                    int n = j;
                    data[n] = data[n] + "\t" + value;
                }
                while (i < this.colName.length - 1 && this.readLine() && (this.line == "" || this.line.charAt(0) != '@')) {
                }
            }
            String headings = this.colName[0];
            for (int i = 1; i < this.colName.length; ++i) {
                headings = headings + "\t" + this.colName[i];
            }
            String wholeData = data.length > 0 ? data[0] : "";
            for (int i = 1; i < numRows; ++i) {
                wholeData = wholeData + "\n" + data[i];
            }
            AmiraTable result = new AmiraTable(this.fileName, headings, wholeData);
            this.parameters.setParameters(result.properties);
            return result;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("internal: ", e);
        }
    }
}

