/*
 * Decompiled with CFR 0.152.
 */
package amira;

import amira.AmiraTable;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Macro;
import ij.Menus;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.macro.Interpreter;
import ij.measure.Calibration;
import java.awt.Frame;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AmiraParameters {
    public static final String INFO = "Info";
    private int width;
    private int height;
    private int depth;
    private static Pattern parameterKeyPattern;
    private static Pattern parameterStringValuePattern;
    private static Pattern parameterStringValuePattern2;
    private static Pattern parameterGroupValuePattern;
    private static Pattern parameterGroupEndPattern;
    private static Pattern colorPattern;
    private Properties parameters;
    private Vector<String> materials;
    String line;
    public static String defaultMaterialsString;

    public AmiraParameters(ImagePlus imp) {
        this.parameters = new Properties();
        if (AmiraParameters.isAmiraMesh(imp) || imp.getProperty(INFO) != null) {
            this.line = "Parameters {\n" + (String)imp.getProperty(INFO) + "}\n";
            this.parseParameters(this.parameters);
        }
        this.initializeMaterials();
        this.initDefaults(imp);
    }

    public AmiraParameters(Properties properties) {
        this.parameters = new Properties();
        this.parameters.putAll((Map<?, ?>)properties);
    }

    public AmiraParameters(String text) {
        this.line = text;
        this.parameters = new Properties();
        this.parseParameters(this.parameters);
        this.initializeMaterials();
        if (this.parameters.get("Parameters") == null) {
            this.initDefaults(1, 1, 1);
        }
    }

    private void initDefaults(int width, int height, int depth) {
        this.initDefaults(width, height, depth, 1.0, 1.0, 1.0);
    }

    private void initDefaults(int width, int height, int depth, double voxelWidth, double voxelHeight, double voxelDepth) {
        this.width = width;
        this.height = height;
        this.depth = depth;
        Hashtable<String, String> table = (Hashtable<String, String>)this.parameters.get("Parameters");
        if (table == null) {
            table = new Hashtable<String, String>();
            this.parameters.put("Parameters", table);
        }
        table.put("BoundingBox", "0.0 " + (double)width * voxelWidth + " 0.0 " + (double)height * voxelHeight + " 0.0 " + (double)depth * voxelDepth);
        table.put("CoordType", "\"uniform\"");
        table.put("Content", "\"" + width + "x" + height + "x" + depth + " byte, uniform coordinates\"");
    }

    public void initDefaults(ImagePlus imp) {
        ImageStack stack = imp.getStack();
        if (stack == null) {
            this.initDefaults(imp.getWidth(), imp.getHeight(), 1);
        } else {
            this.initDefaults(stack.getWidth(), stack.getHeight(), stack.getSize());
        }
        Calibration cal = imp.getCalibration();
        if (cal != null) {
            int zPosToGet = (stack == null ? 1 : stack.getSize()) - 1;
            if (zPosToGet == 0) {
                zPosToGet = 1;
            }
            this.put("BoundingBox", cal.getX(0.0) + " " + cal.getX((double)(imp.getWidth() - 1)) + " " + cal.getY(0.0) + " " + cal.getY((double)(imp.getHeight() - 1)) + " " + cal.getZ(0.0) + " " + cal.getZ((double)zPosToGet));
        }
    }

    public static boolean isAmiraMesh(ImagePlus imp) {
        Object info1 = imp.getProperty(INFO);
        if (info1 == null || !(info1 instanceof String)) {
            return false;
        }
        String info = (String)info1;
        return info.indexOf("CoordType") >= 0;
    }

    public static final boolean isAmiraLabelfield(ImagePlus imp) {
        Object info1 = imp.getProperty(INFO);
        if (info1 == null || !(info1 instanceof String)) {
            return false;
        }
        String info = (String)info1;
        return info.indexOf("Materials") >= 0;
    }

    public static boolean isAmiraLabelfield(Properties p) {
        return p != null && p.get("Parameters") != null && ((Hashtable)p.get("Parameters")).get("Materials") != null;
    }

    private void assertPatternsInitialized() {
        if (parameterKeyPattern == null) {
            parameterKeyPattern = Pattern.compile("\\A[ \t\n]*([-A-Za-z0-9_]+)[ \t]*(.*)\\z", 32);
            parameterStringValuePattern = Pattern.compile("\\A([^\n]*?)([,}]?)\n(.*)\\z", 32);
            parameterStringValuePattern2 = Pattern.compile("\\A\"([^\"]*?)(\")\n(.*)\\z", 32);
            parameterGroupValuePattern = Pattern.compile("\\A\\{(.*)\\z", 32);
            parameterGroupEndPattern = Pattern.compile("\\A[ \t\n]*}(.*)\\z", 32);
            colorPattern = Pattern.compile("^([0-9]*(\\.[0-9]*e?-?[0-9]*)?)[ \t]+([0-9]*(\\.[0-9]*e?-?[0-9]*)?)[ \t]+([0-9]*(\\.[0-9]*e?-?[0-9]*)?)");
        }
    }

    private boolean parseParameters(Hashtable map) {
        return this.parseParameters(map, false);
    }

    private boolean parseParameters(Hashtable map, boolean isMaterial) {
        this.assertPatternsInitialized();
        Matcher m = parameterKeyPattern.matcher(this.line);
        if (m.matches()) {
            String key = m.group(1);
            this.line = m.group(2);
            Matcher m3 = parameterGroupValuePattern.matcher(this.line);
            if (m3.matches()) {
                if (isMaterial) {
                    if (this.materials == null) {
                        this.materials = new Vector();
                    }
                    this.materials.add(key);
                }
                this.line = m3.group(1);
                Hashtable subMap = new Hashtable();
                map.put(key, subMap);
                while (this.parseParameters(subMap, key.equals("Materials"))) {
                }
                return true;
            }
            Matcher m2 = parameterStringValuePattern2.matcher(this.line);
            if (!m2.matches()) {
                m2 = parameterStringValuePattern.matcher(this.line);
            }
            if (m2.matches()) {
                String value = m2.group(1);
                String end = m2.group(2);
                this.line = m2.group(3);
                map.put(key, value);
                return !end.equals("}");
            }
            System.err.println("Warning: empty value for key " + key);
            map.put(key, "");
            return true;
        }
        Matcher m4 = parameterGroupEndPattern.matcher(this.line);
        if (m4.matches()) {
            this.line = m4.group(1);
            return false;
        }
        System.err.println("This shouldn't happen: no key, and no '}': " + this.line);
        return false;
    }

    public Object get(String key) {
        Hashtable table = (Hashtable)this.parameters.get("Parameters");
        return table.get(key);
    }

    public void put(String key, Object value) {
        Hashtable table = (Hashtable)this.parameters.get("Parameters");
        table.put(key, value);
    }

    void initializeMaterials() {
        String list;
        if (this.materials == null) {
            this.materials = new Vector();
        }
        if ((list = (String)this.parameters.get("MaterialList")) == null) {
            list = "";
            for (int i = 0; i < this.materials.size(); ++i) {
                list = list + (i > 0 ? "," : "") + this.materials.get(i);
            }
            this.parameters.put("MaterialList", list);
        } else {
            this.materials.clear();
            StringTokenizer t = new StringTokenizer(list, ",");
            while (t.hasMoreTokens()) {
                this.materials.add(t.nextToken());
            }
        }
    }

    public String toString() {
        String list = "";
        String prefix = "\t";
        Hashtable t = (Hashtable)this.parameters.get("Parameters");
        if (t == null) {
            return list;
        }
        Enumeration e = t.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            list = list + prefix + key + " " + this.getProperty(t, key, prefix) + "\n";
        }
        return list;
    }

    public String getProperty(String key) {
        if (key == null) {
            return "";
        }
        return this.getProperty((Hashtable)this.parameters.get("Parameters"), key, "");
    }

    public String getProperty(Hashtable map, String key, String prefix) {
        Enumeration<Object> e;
        Object value = map.get(key);
        if (value == null) {
            return "\"\"";
        }
        if (value instanceof String) {
            return (String)value;
        }
        String end = prefix + "}";
        prefix = prefix + "\t";
        String result = "{";
        String sep = "\n";
        Hashtable subMap = (Hashtable)value;
        Enumeration<Object> enumeration = e = key.equals("Materials") ? this.materials.elements() : subMap.keys();
        while (e.hasMoreElements()) {
            String subKey = (String)e.nextElement();
            String subValue = this.getProperty(subMap, subKey, prefix);
            result = result + sep + prefix + subKey + " " + subValue;
            if (!subValue.equals("") && !subValue.endsWith("}")) {
                sep = ",\n";
                continue;
            }
            sep = "\n";
        }
        result = result + "\n" + end;
        return result;
    }

    public ColorModel getColorModel() {
        if (this.materials == null || this.materials.size() == 0) {
            return null;
        }
        byte[] r = new byte[256];
        byte[] g = new byte[256];
        byte[] b = new byte[256];
        for (int i = 0; i < this.getMaterialCount(); ++i) {
            double[] color = this.getMaterialColor(i);
            r[i] = (byte)Math.round(color[0] * 255.0);
            g[i] = (byte)Math.round(color[1] * 255.0);
            b[i] = (byte)Math.round(color[2] * 255.0);
        }
        return new IndexColorModel(8, 256, r, g, b);
    }

    public void setParameters(ImagePlus ip) {
        this.setParameters(ip, true);
    }

    public void setParameters(ImagePlus ip, boolean setCalib) {
        ColorModel c;
        ip.setProperty(INFO, (Object)this.toString());
        if (setCalib) {
            this.setCalibration(ip);
        }
        if ((c = this.getColorModel()) == null) {
            byte[] rLUT = new byte[256];
            byte[] gLUT = new byte[256];
            byte[] bLUT = new byte[256];
            for (int i = 0; i < 256; ++i) {
                rLUT[i] = (byte)i;
                gLUT[i] = (byte)i;
                bLUT[i] = (byte)i;
            }
            c = new IndexColorModel(8, 256, rLUT, gLUT, bLUT);
        }
        ip.getProcessor().setColorModel(c);
        if (ip.getStackSize() > 1) {
            ip.getStack().setColorModel(c);
        }
    }

    public void setParameters(Properties prop) {
        Enumeration<Object> e = this.parameters.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            prop.put(key, this.parameters.get(key));
        }
    }

    public boolean changeLabelfieldToGray() {
        Hashtable m = (Hashtable)this.parameters.get("Parameters");
        if (this.parameters.get("MaterialList") == null && this.materials == null && (m == null || m.get("Materials") == null)) {
            return false;
        }
        if (m != null) {
            m.remove("Materials");
        }
        this.materials = null;
        this.parameters.remove("MaterialList");
        return true;
    }

    public int addMaterial(String name, double red, double green, double blue) {
        Hashtable m = this.getMaterials();
        if (m == null) {
            m = new Hashtable();
            ((Hashtable)this.parameters.get("Parameters")).put("Materials", m);
        }
        Hashtable<String, String> color = new Hashtable<String, String>();
        color.put("Color", red + " " + green + " " + blue);
        m.put(name, color);
        if (this.materials == null) {
            this.materials = new Vector();
        }
        this.materials.add(name);
        String list = (String)this.parameters.get("MaterialList");
        if (list == null) {
            this.initializeMaterials();
        } else {
            this.parameters.put("MaterialList", list + "," + name);
        }
        return this.materials.size() - 1;
    }

    public String[] getMaterialList() {
        int count = this.getMaterialCount();
        String[] materialList = new String[count];
        for (int i = 0; i < count; ++i) {
            materialList[i] = this.getMaterialName(i);
        }
        return materialList;
    }

    public Hashtable getMaterials() {
        return (Hashtable)this.get("Materials");
    }

    public int getMaterialCount() {
        return this.materials.size();
    }

    public String getMaterialName(int id) {
        return this.materials.get(id);
    }

    public int getMaterialID(String name) {
        for (int i = 0; i < this.materials.size(); ++i) {
            if (!name.equals(this.materials.get(i))) continue;
            return i;
        }
        return -1;
    }

    public double[] getMaterialColor(int id) {
        double[] result = new double[3];
        this.assertPatternsInitialized();
        Hashtable m2 = (Hashtable)this.getMaterials().get(this.materials.get(id));
        Object value = m2.get("Color");
        if (value == null) {
            result[2] = 0.0;
            result[1] = 0.0;
            result[0] = 0.0;
        } else {
            Matcher matcher = colorPattern.matcher((String)value);
            if (matcher.matches()) {
                result[0] = Double.parseDouble(matcher.group(1));
                result[1] = Double.parseDouble(matcher.group(3));
                result[2] = Double.parseDouble(matcher.group(5));
            } else {
                result[2] = 0.0;
                result[1] = 0.0;
                result[0] = 0.0;
            }
        }
        return result;
    }

    public boolean editMaterial(int id, String name, double red, double green, double blue) {
        if (id < 0 || this.materials == null || id >= this.materials.size()) {
            return false;
        }
        if (name == null) {
            name = this.getMaterialName(id);
        }
        double[] color = this.getMaterialColor(id);
        if (red < 0.0 || red > 1.0) {
            red = color[0];
        }
        if (green < 0.0 || green > 1.0) {
            green = color[1];
        }
        if (blue < 0.0 || blue > 1.0) {
            blue = color[2];
        }
        this.materials.set(id, name);
        Hashtable<String, String> c = new Hashtable<String, String>();
        c.put("Color", red + " " + green + " " + blue);
        this.getMaterials().put(name, c);
        return true;
    }

    public void setCalibration(ImagePlus image) {
        this.width = image.getWidth();
        this.height = image.getHeight();
        ImageStack stack = image.getStack();
        this.depth = stack == null ? 1 : stack.getSize();
        Calibration cal = image.getCalibration();
        if (cal == null) {
            cal = new Calibration();
            image.setCalibration(cal);
        }
        this.setCalibration(cal);
    }

    public void setCalibration(Calibration cal) {
        String boundingBoxString = (String)this.get("BoundingBox");
        if (boundingBoxString == null) {
            return;
        }
        StringTokenizer boundingBox = new StringTokenizer(boundingBoxString);
        if (boundingBox.hasMoreTokens()) {
            cal.xOrigin = -Double.parseDouble(boundingBox.nextToken());
        }
        if (boundingBox.hasMoreTokens()) {
            double d = cal.pixelWidth = this.width != 1 ? (Double.parseDouble(boundingBox.nextToken()) + cal.xOrigin) / (double)(this.width - 1) : Double.parseDouble(boundingBox.nextToken()) + cal.xOrigin;
            if (cal.pixelWidth != 0.0) {
                cal.xOrigin /= cal.pixelWidth;
            }
        }
        if (boundingBox.hasMoreTokens()) {
            cal.yOrigin = -Double.parseDouble(boundingBox.nextToken());
        }
        if (boundingBox.hasMoreTokens()) {
            double d = cal.pixelHeight = this.height != 1 ? (Double.parseDouble(boundingBox.nextToken()) + cal.yOrigin) / (double)(this.height - 1) : Double.parseDouble(boundingBox.nextToken()) + cal.yOrigin;
            if (cal.pixelHeight != 0.0) {
                cal.yOrigin /= cal.pixelHeight;
            }
        }
        if (boundingBox.hasMoreTokens()) {
            cal.zOrigin = -Double.parseDouble(boundingBox.nextToken());
        }
        if (boundingBox.hasMoreTokens()) {
            double d = cal.pixelDepth = this.depth != 1 ? (Double.parseDouble(boundingBox.nextToken()) + cal.zOrigin) / (double)(this.depth - 1) : Double.parseDouble(boundingBox.nextToken()) + cal.zOrigin;
            if (cal.pixelDepth != 0.0) {
                cal.zOrigin /= cal.pixelDepth;
            }
        }
    }

    public static boolean addImageList(GenericDialog g, String title, String type, IsA isA) {
        ImagePlus im;
        Vector<String> vector = new Vector<String>();
        int i = 1;
        while ((im = WindowManager.getImage((int)i)) != null) {
            if (isA.isA(im)) {
                vector.add(im.getTitle());
            }
            ++i;
        }
        if (vector.size() < 1) {
            IJ.error((String)("No " + type + " available"));
            return false;
        }
        AmiraParameters.addChoice(g, title, vector);
        return true;
    }

    public static boolean addAmiraMeshList(GenericDialog g, String title) {
        return AmiraParameters.addImageList(g, title, "AmiraMesh", new IsA(){

            @Override
            public boolean isA(Object o) {
                ImagePlus im = (ImagePlus)o;
                return AmiraParameters.isAmiraMesh(im);
            }
        });
    }

    public static boolean addAmiraLabelsList(GenericDialog g, String t) {
        return AmiraParameters.addImageList(g, t, "AmiraLabel", new IsA(){

            @Override
            public boolean isA(Object o) {
                ImagePlus im = (ImagePlus)o;
                return AmiraParameters.isAmiraLabelfield(im);
            }
        });
    }

    public static boolean addAmiraTableList(GenericDialog g, String t) {
        int i;
        Vector<String> vector = new Vector<String>();
        MenuBar mbar = Menus.getMenuBar();
        Menu menu = null;
        for (i = 0; i < mbar.getMenuCount(); ++i) {
            if (!mbar.getMenu(i).getLabel().equals("Window")) continue;
            menu = mbar.getMenu(i);
            break;
        }
        if (menu == null) {
            throw new RuntimeException("no Window menu?");
        }
        for (i = 0; i < menu.getItemCount(); ++i) {
            String title = menu.getItem(i).getLabel();
            Frame frame = WindowManager.getFrame((String)title);
            if (frame == null || !(frame instanceof AmiraTable)) continue;
            vector.add(title);
        }
        if (vector.size() < 1) {
            IJ.error((String)"No AmiraTable available");
            return false;
        }
        AmiraParameters.addChoice(g, t, vector);
        return true;
    }

    public static int addWindowList(GenericDialog g, String title, boolean onlyWithAmiraParameters) {
        Vector<String> v = new Vector<String>();
        if (Interpreter.isBatchMode()) {
            v.add(Macro.getValue((String)Macro.getOptions(), (String)"window", (String)"(null)"));
        } else {
            int count = WindowManager.getWindowCount();
            for (int i = 0; i < count; ++i) {
                ImagePlus img = WindowManager.getImage((int)(i + 1));
                if (onlyWithAmiraParameters && !AmiraParameters.isAmiraMesh(img)) continue;
                v.add(img.getTitle());
            }
        }
        ImagePlus image = WindowManager.getCurrentImage();
        if (image != null) {
            return AmiraParameters.addChoice(g, title, v, image.getTitle());
        }
        return AmiraParameters.addChoice(g, title, v);
    }

    public static int addChoice(GenericDialog g, String title, Vector v) {
        return AmiraParameters.addChoice(g, title, v, v.size() > 0 ? (String)v.get(0) : "");
    }

    public static int addChoice(GenericDialog g, String title, Vector v, String defaultValue) {
        String[] list = new String[v.size()];
        boolean hasDefault = false;
        for (int i = 0; i < list.length; ++i) {
            list[i] = (String)v.get(i);
            if (!list[i].equals(defaultValue)) continue;
            hasDefault = true;
        }
        if (!hasDefault) {
            String[] newList = new String[list.length + 1];
            System.arraycopy(list, 0, newList, 1, list.length);
            list = newList;
            list[0] = defaultValue;
        }
        g.addChoice(title, list, defaultValue);
        return list.length;
    }

    public Material getMaterial(int id) {
        return new Material(this.getMaterialName(id), id, this.getMaterialColor(id));
    }

    public static AmiraParameters defaultMaterials() {
        return new AmiraParameters("Parameters {\n" + defaultMaterialsString + "}\n");
    }

    public static String[] getWindowList() {
        int i;
        Vector<String> v = new Vector<String>();
        MenuBar mbar = Menus.getMenuBar();
        Menu menu = null;
        for (i = 0; i < mbar.getMenuCount(); ++i) {
            if (!mbar.getMenu(i).getLabel().equals("Window")) continue;
            menu = mbar.getMenu(i);
            break;
        }
        if (menu == null) {
            throw new RuntimeException("no Window menu?");
        }
        for (i = 0; i < WindowManager.getWindowCount(); ++i) {
            ImagePlus img = WindowManager.getImage((int)(i + 1));
            v.add(img.getTitle());
        }
        for (i = 0; i < menu.getItemCount(); ++i) {
            String title = menu.getItem(i).getLabel();
            if (WindowManager.getFrame((String)title) == null) continue;
            v.add(title);
        }
        String[] result = new String[v.size()];
        for (int i2 = 0; i2 < result.length; ++i2) {
            result[i2] = (String)v.get(i2);
        }
        return result;
    }

    static {
        defaultMaterialsString = "    Materials {\n        Exterior {\n            Id 1\n        }\n        medulla_r {\n            Id -1,\n            Color 1 0 0,\n            Name \"outer_medulla_r\",\n            Group \"OL_r\"\n        }\n        medulla_l {\n            Id -1,\n            Color 1 0 0,\n            Name \"outer_medulla_l\",\n            Group \"OL_l\"\n        }\n        lobula_r {\n            Group \"OL_r\",\n            Color 1 0.552326 0\n        }\n        lobula_l {\n            Id -1,\n            Color 1 0.552326 0,\n            Group \"OL_l\"\n        }\n        lobula_plate_r {\n            Id -1,\n            Color 1 0.796512 0,\n            Group \"OL_r\"\n        }\n        lobula_plate_l {\n            Id -1,\n            Color 1 0.802326 0,\n            Group \"OL_l\"\n        }\n        mushroom_body_r {\n            Id -1,\n            Color 0.401163 0.0988372 0\n        }\n        mushroom_body_l {\n            Id -1,\n            Color 0.401163 0.104651 0\n        }\n        ellipsoid_body {\n            Id -1,\n            Color 0 0.619 0,\n            Group \"CC\"\n        }\n        noduli {\n            Id -1,\n            Color 0.598837 1 0,\n            Group \"CC\"\n        }\n        fan_shaped_body {\n            Id -1,\n            Color 0.110465 1 0.0404624,\n            Group \"CC\"\n        }\n        protocerebral_bridge {\n            Id -1,\n            Color 0 0.373 0,\n            Name \"protocebral_bridge\",\n            Group \"CC\"\n        }\n        antennal_lobe_r {\n            Id 18,\n            Color 0.156863 0.45098 0.8\n        }\n        antennal_lobe_l {\n            Id 19,\n            Color 0.156863 0.45098 0.8\n        }\n        lateral_horn_r {\n            Id 18,\n            Color 0.57 0.3534 0.171,\n            Name \"lateral horn\"\n        }\n        lateral_horn_l {\n            Id 19,\n            Color 0.57 0.352944 0.171\n        }\n    }\n";
    }

    public static class Material {
        public final String name;
        public final int id;
        public final double[] colors;

        public Material(String name, int id, double[] colors) {
            this.name = name;
            this.id = id;
            this.colors = colors;
        }

        public String toString() {
            return this.name;
        }
    }

    public static interface IsA {
        public boolean isA(Object var1);
    }
}

