/*
 * Decompiled with CFR 0.152.
 */
package distance;

import distance.PixelPairs;

public class MutualInformation
implements PixelPairs {
    private float minimum;
    private float maximum;
    private float width;
    long[] joint;
    private int count;
    private int bins;
    float h1;
    float h2;
    float h12;

    public MutualInformation(float minimumValue, float maximumValue, int bins) {
        this.minimum = minimumValue;
        this.maximum = maximumValue;
        this.width = maximumValue - minimumValue;
        this.bins = bins;
    }

    public MutualInformation() {
        this(0.0f, 255.0f, 256);
    }

    @Override
    public void reset() {
        this.joint = new long[this.bins * this.bins];
        this.count = 0;
    }

    @Override
    public void add(float v1, float v2) {
        int i1 = (int)Math.floor((v1 - this.minimum) * (float)this.bins / this.width);
        int i2 = (int)Math.floor((v2 - this.minimum) * (float)this.bins / this.width);
        if (i1 >= this.bins) {
            i1 = this.bins - 1;
        }
        if (i2 >= this.bins) {
            i2 = this.bins - 1;
        }
        int n = i1 * this.bins + i2;
        this.joint[n] = this.joint[n] + 1L;
        ++this.count;
    }

    public float getEntropy1() {
        return this.h1;
    }

    public float getEntropy2() {
        return this.h2;
    }

    public float getJointEntropy() {
        return this.h12;
    }

    public float mutualInformation() {
        float h12 = 0.0f;
        float h1 = 0.0f;
        float h2 = 0.0f;
        for (int i = 0; i < this.bins; ++i) {
            long p1 = 0L;
            long p2 = 0L;
            for (int j = 0; j < this.bins; ++j) {
                float p = (float)this.joint[i * this.bins + j] / (float)this.count;
                if (p > 0.0f) {
                    h12 = (float)((double)h12 - (double)p * (Math.log(p) / Math.log(2.0)));
                }
                p1 += this.joint[i * this.bins + j];
                p2 += this.joint[j * this.bins + i];
            }
            if (p1 > 0L) {
                float p = (float)p1 / (float)this.count;
                h1 = (float)((double)h1 - (double)p * (Math.log(p) / Math.log(2.0)));
            }
            if (p2 <= 0L) continue;
            float p = (float)p2 / (float)this.count;
            h2 = (float)((double)h2 - (double)p * (Math.log(p) / Math.log(2.0)));
        }
        this.h1 = h1;
        this.h2 = h2;
        this.h12 = h12;
        return h1 + h2 - h12;
    }

    @Override
    public float distance() {
        float result = -this.mutualInformation();
        return result;
    }

    public void printJointMatrix() {
        for (int i = 0; i < this.bins; ++i) {
            for (int j = 0; j < this.bins; ++j) {
                System.out.println("[" + i + "," + j + "]: " + this.joint[i * this.bins + j]);
            }
        }
    }
}

