/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.ComputeCurvatures;
import features.GaussianGenerationCallback;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;

public abstract class HessianEvalueProcessor
implements GaussianGenerationCallback {
    protected boolean normalize = false;
    protected double sigma = 1.0;
    protected boolean useCalibration = false;

    @Override
    public void proportionDone(double d) {
        IJ.showProgress((double)d);
    }

    public abstract float measureFromEvalues2D(float[] var1);

    public abstract float measureFromEvalues3D(float[] var1);

    public void setSigma(double newSigma) {
        this.sigma = newSigma;
    }

    public ImagePlus generateImage(ImagePlus original) {
        Calibration calibration = original.getCalibration();
        float sepX = 1.0f;
        float sepY = 1.0f;
        float sepZ = 1.0f;
        if (this.useCalibration && calibration != null) {
            sepX = (float)calibration.pixelWidth;
            sepY = (float)calibration.pixelHeight;
            sepZ = (float)calibration.pixelDepth;
        }
        double minimumSeparation = Math.min(sepX, Math.min(sepY, sepX));
        ComputeCurvatures c = new ComputeCurvatures(original, this.sigma, this, this.useCalibration);
        IJ.showStatus((String)("Convolving with Gaussian \u03c3=" + this.sigma + " (min. pixel separation: " + minimumSeparation + ")..."));
        c.run();
        int width = original.getWidth();
        int height = original.getHeight();
        int depth = original.getStackSize();
        ImageStack stack = new ImageStack(width, height);
        float[] evalues = new float[3];
        IJ.showStatus((String)"Calculating Hessian eigenvalues at each point...");
        float minResult = Float.MAX_VALUE;
        float maxResult = Float.MIN_VALUE;
        if (depth == 1) {
            float[] slice = new float[width * height];
            for (int y = 1; y < height - 1; ++y) {
                for (int x = 1; x < width - 1; ++x) {
                    boolean real = c.hessianEigenvaluesAtPoint2D(x, y, true, evalues, this.normalize, false, sepX, sepY);
                    int index = y * width + x;
                    float value = 0.0f;
                    if (real) {
                        value = this.measureFromEvalues2D(evalues);
                    }
                    slice[index] = value;
                    if (value < minResult) {
                        minResult = value;
                    }
                    if (!(value > maxResult)) continue;
                    maxResult = value;
                }
                IJ.showProgress((double)(1.0 / (double)height));
            }
            FloatProcessor fp = new FloatProcessor(width, height);
            fp.setPixels((Object)slice);
            stack.addSlice(null, (ImageProcessor)fp);
        } else {
            for (int z = 0; z < depth; ++z) {
                float[] slice = new float[width * height];
                if (z >= 1 && z < depth - 1) {
                    for (int y = 1; y < height - 1; ++y) {
                        for (int x = 1; x < width - 1; ++x) {
                            boolean real = c.hessianEigenvaluesAtPoint3D(x, y, z, true, evalues, this.normalize, false, sepX, sepY, sepZ);
                            int index = y * width + x;
                            float value = 0.0f;
                            if (real) {
                                value = this.measureFromEvalues3D(evalues);
                            }
                            slice[index] = value;
                            if (value < minResult) {
                                minResult = value;
                            }
                            if (!(value > maxResult)) continue;
                            maxResult = value;
                        }
                    }
                }
                FloatProcessor fp = new FloatProcessor(width, height);
                fp.setPixels((Object)slice);
                stack.addSlice(null, (ImageProcessor)fp);
                IJ.showProgress((double)((double)z / (double)depth));
            }
        }
        IJ.showProgress((double)1.0);
        ImagePlus result = new ImagePlus("processed " + original.getTitle(), stack);
        result.setCalibration(calibration);
        result.getProcessor().setMinAndMax((double)minResult, (double)maxResult);
        result.updateAndDraw();
        return result;
    }
}

