/*
 * Decompiled with CFR 0.152.
 */
package features;

import features.HessianEvalueProcessor;

public class TubenessProcessor
extends HessianEvalueProcessor {
    public TubenessProcessor(boolean useCalibration) {
        this.useCalibration = useCalibration;
    }

    public TubenessProcessor(double sigma, boolean useCalibration) {
        this.sigma = sigma;
        this.useCalibration = useCalibration;
    }

    @Override
    public float measureFromEvalues2D(float[] evalues) {
        if (evalues[1] >= 0.0f) {
            return 0.0f;
        }
        return Math.abs(evalues[1]);
    }

    @Override
    public float measureFromEvalues3D(float[] evalues) {
        if (evalues[1] >= 0.0f || evalues[2] >= 0.0f) {
            return 0.0f;
        }
        return (float)Math.sqrt(evalues[2] * evalues[1]);
    }
}

