/*
 * Decompiled with CFR 0.152.
 */
package landmarks;

import client.ArchiveClient;
import ij.IJ;
import ij.gui.YesNoCancelDialog;
import ij.io.OpenDialog;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.ListIterator;
import landmarks.NamePoints;
import landmarks.NamedPointSet;
import landmarks.NamedPointWorld;

class PointsDialog
extends Dialog
implements ActionListener,
WindowListener {
    Label[] coordinateLabels;
    Button[] markButtons;
    Button[] showButtons;
    Button[] resetButtons;
    Button[] fineTuneButtons;
    Button[] renameButtons;
    Button[] deleteButtons;
    Button registerRigid;
    Button registerAffine;
    Button registerBookstein;
    HashMap<Button, Integer> buttonToAction;
    HashMap<Button, Integer> buttonToIndex;
    static final int MARK = 1;
    static final int SHOW = 2;
    static final int RESET = 3;
    static final int FINE_TUNE = 4;
    static final int RENAME = 5;
    static final int DELETE = 6;
    Label instructions;
    Panel pointsPanel;
    Panel buttonsPanel;
    Panel templatePanel;
    Panel registrationPanel;
    Checkbox overlayResult;
    NamePoints plugin;
    ArchiveClient archiveClient;
    Label templateFileName;
    Button chooseTemplate;
    Button setAsDefaultTemplate;
    Button clearTemplate;
    String defaultInstructions = "Mark the current point selection as:";
    Button saveButton;
    Button loadButton;
    Button igsSaveButton;
    Button resetButton;
    Button closeButton;
    Button getMyButton;
    Button getAnyButton;
    Button uploadButton;
    Button addButton;

    public void recreatePointsPanel() {
        NamedPointSet points = this.plugin.points;
        for (Component c : this.pointsPanel.getComponents()) {
            if (!(c instanceof Button)) continue;
            ((Button)c).removeActionListener(this);
        }
        this.pointsPanel.removeAll();
        this.coordinateLabels = new Label[points.size()];
        this.markButtons = new Button[points.size()];
        this.showButtons = new Button[points.size()];
        this.resetButtons = new Button[points.size()];
        this.fineTuneButtons = new Button[points.size()];
        this.renameButtons = new Button[points.size()];
        this.deleteButtons = new Button[points.size()];
        this.buttonToIndex = new HashMap();
        this.buttonToAction = new HashMap();
        this.pointsPanel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        int counter = 0;
        ListIterator i = points.listIterator();
        while (i.hasNext()) {
            Button b;
            NamedPointWorld p = (NamedPointWorld)i.next();
            c.gridx = 0;
            c.gridy = counter;
            c.anchor = 22;
            this.markButtons[counter] = b = new Button(p.getName());
            b.addActionListener(this);
            this.buttonToIndex.put(b, counter);
            this.buttonToAction.put(b, 1);
            this.pointsPanel.add((Component)b, c);
            c.anchor = 21;
            ++c.gridx;
            this.coordinateLabels[counter] = new Label("<unset>");
            this.pointsPanel.add((Component)this.coordinateLabels[counter], c);
            c.anchor = 21;
            ++c.gridx;
            this.showButtons[counter] = b = new Button("Show");
            b.addActionListener(this);
            b.setEnabled(false);
            this.buttonToIndex.put(b, counter);
            this.buttonToAction.put(b, 2);
            this.pointsPanel.add((Component)b, c);
            c.anchor = 21;
            ++c.gridx;
            this.resetButtons[counter] = b = new Button("Reset");
            b.addActionListener(this);
            b.setEnabled(false);
            this.buttonToIndex.put(b, counter);
            this.buttonToAction.put(b, 3);
            this.pointsPanel.add((Component)b, c);
            c.anchor = 21;
            ++c.gridx;
            this.renameButtons[counter] = b = new Button("Rename");
            b.addActionListener(this);
            b.setEnabled(true);
            this.buttonToIndex.put(b, counter);
            this.buttonToAction.put(b, 5);
            this.pointsPanel.add((Component)b, c);
            c.anchor = 21;
            ++c.gridx;
            this.deleteButtons[counter] = b = new Button("Delete");
            b.addActionListener(this);
            b.setEnabled(true);
            this.buttonToIndex.put(b, counter);
            this.buttonToAction.put(b, 6);
            this.pointsPanel.add((Component)b, c);
            if (p.set) {
                this.setCoordinateLabel(counter, p.x, p.y, p.z);
            }
            ++counter;
        }
    }

    public PointsDialog(String title, ArchiveClient archiveClient, String loadedTemplateFilename, NamePoints plugin) {
        super((Frame)IJ.getInstance(), title, false);
        this.addWindowListener(this);
        this.plugin = plugin;
        this.archiveClient = archiveClient;
        this.setLayout(new GridBagLayout());
        GridBagConstraints outerc = new GridBagConstraints();
        Panel instructionsPanel = new Panel();
        this.pointsPanel = new Panel();
        this.buttonsPanel = new Panel();
        this.instructions = new Label(this.defaultInstructions);
        instructionsPanel.setLayout(new BorderLayout());
        instructionsPanel.add((Component)this.instructions, "West");
        outerc.gridx = 0;
        ++outerc.gridy;
        outerc.anchor = 21;
        outerc.fill = 2;
        this.add((Component)instructionsPanel, outerc);
        this.recreatePointsPanel();
        ++outerc.gridy;
        outerc.anchor = 10;
        this.add((Component)this.pointsPanel, outerc);
        ++outerc.gridy;
        this.add((Component)new Label(""), outerc);
        this.addButton = new Button("Add New Point");
        this.addButton.addActionListener(this);
        this.buttonsPanel.add(this.addButton);
        if (archiveClient == null) {
            this.saveButton = new Button("Save");
            this.saveButton.addActionListener(this);
            this.loadButton = new Button("Load");
            this.loadButton.addActionListener(this);
            this.igsSaveButton = new Button("Export to CMTK");
            this.igsSaveButton.addActionListener(this);
            this.resetButton = new Button("Reset All");
            this.resetButton.addActionListener(this);
            this.closeButton = new Button("Close");
            this.closeButton.addActionListener(this);
            this.buttonsPanel.add(this.saveButton);
            this.buttonsPanel.add(this.loadButton);
            this.buttonsPanel.add(this.igsSaveButton);
            this.buttonsPanel.add(this.resetButton);
            this.buttonsPanel.add(this.closeButton);
        } else {
            this.getMyButton = new Button("Get My Most Recent Annotation");
            this.getMyButton.addActionListener(this);
            this.getAnyButton = new Button("Get Most Recent Annotation");
            this.getAnyButton.addActionListener(this);
            this.uploadButton = new Button("Upload");
            this.uploadButton.addActionListener(this);
            this.buttonsPanel.add(this.getMyButton);
            this.buttonsPanel.add(this.getAnyButton);
            this.buttonsPanel.add(this.uploadButton);
        }
        ++outerc.gridy;
        this.add((Component)this.buttonsPanel, outerc);
        this.templatePanel = new Panel();
        this.templatePanel.add(new Label("Template File:"));
        this.templateFileName = plugin.templateImageFilename == null || plugin.templateImageFilename.length() == 0 ? new Label("[None chosen]") : new Label(plugin.templateImageFilename);
        if (loadedTemplateFilename != null) {
            this.templateFileName.setText(loadedTemplateFilename);
        }
        this.templatePanel.add(this.templateFileName);
        this.chooseTemplate = new Button("Choose");
        this.chooseTemplate.addActionListener(this);
        this.templatePanel.add(this.chooseTemplate);
        this.setAsDefaultTemplate = new Button("Set As Default");
        this.setAsDefaultTemplate.addActionListener(this);
        this.templatePanel.add(this.setAsDefaultTemplate);
        this.clearTemplate = new Button("Clear Template");
        this.clearTemplate.addActionListener(this);
        this.templatePanel.add(this.clearTemplate);
        ++outerc.gridy;
        outerc.anchor = 21;
        outerc.fill = 0;
        this.add((Component)this.templatePanel, outerc);
        this.registrationPanel = new Panel();
        this.registrationPanel.setLayout(new GridBagLayout());
        GridBagConstraints rc = new GridBagConstraints();
        rc.gridx = 0;
        rc.gridy = 0;
        this.registrationPanel.add((Component)new Label("Register to template based on common points:"), rc);
        this.registerRigid = new Button("Best Rigid Registration");
        this.registerAffine = new Button("Affine Registration From Best 4 Points");
        this.registerBookstein = new Button("Thin-Plate Spline Registration");
        ++rc.gridx;
        this.registrationPanel.add((Component)this.registerRigid, rc);
        this.registerRigid.addActionListener(this);
        ++rc.gridx;
        this.registrationPanel.add((Component)this.registerAffine, rc);
        this.registerAffine.addActionListener(this);
        ++rc.gridx;
        this.registrationPanel.add((Component)this.registerBookstein, rc);
        this.registerBookstein.addActionListener(this);
        this.overlayResult = new Checkbox("Overlay result");
        rc.gridx = 0;
        rc.gridy = 1;
        this.registrationPanel.add((Component)this.overlayResult, rc);
        ++outerc.gridy;
        this.add((Component)this.registrationPanel, outerc);
        this.pack();
        this.setVisible(true);
    }

    public void reset(int i) {
        assert (i > 0);
        assert (i < this.coordinateLabels.length);
        this.coordinateLabels[i].setText("<unset>");
        this.showButtons[i].setEnabled(false);
        this.resetButtons[i].setEnabled(false);
        this.pack();
    }

    public void setCoordinateLabel(int i, double x, double y, double z) {
        DecimalFormat f = new DecimalFormat("0.000");
        String newText = "";
        newText = newText + "x: " + f.format(x) + ", y: " + f.format(y) + ", z: " + f.format(z);
        this.coordinateLabels[i].setText(newText);
        this.showButtons[i].setEnabled(true);
        this.resetButtons[i].setEnabled(true);
    }

    public void setFineTuning(boolean busy) {
        if (busy) {
            this.instructions.setText("Fine tuning... (may take some time)");
            this.pointsPanel.setEnabled(false);
            this.buttonsPanel.setEnabled(false);
            this.templatePanel.setEnabled(false);
            this.registrationPanel.setEnabled(false);
        } else {
            this.instructions.setText(this.defaultInstructions);
            this.pointsPanel.setEnabled(true);
            this.buttonsPanel.setEnabled(true);
            this.templatePanel.setEnabled(true);
            this.registrationPanel.setEnabled(true);
        }
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source = e.getSource();
        Integer index = this.buttonToIndex.get(source);
        if (index != null) {
            int i = index;
            int action = this.buttonToAction.get(source);
            switch (action) {
                case 1: {
                    this.plugin.mark(i);
                    return;
                }
                case 2: {
                    this.plugin.show(i);
                    return;
                }
                case 3: {
                    this.plugin.reset(i);
                    return;
                }
                case 4: {
                    this.plugin.fineTune(i);
                    return;
                }
                case 5: {
                    this.plugin.rename(i);
                    return;
                }
                case 6: {
                    this.plugin.delete(i);
                    return;
                }
            }
        }
        if (source == this.addButton) {
            this.plugin.addNewPoint();
        } else if (source == this.closeButton) {
            this.closeSafely();
        } else if (source == this.saveButton) {
            this.plugin.save(".points");
        } else if (source == this.loadButton) {
            this.plugin.load();
        } else if (source == this.igsSaveButton) {
            this.plugin.save(".landmarks");
        } else if (source == this.resetButton) {
            this.plugin.reset();
        } else if (source == this.uploadButton) {
            this.plugin.upload();
        } else if (source == this.chooseTemplate) {
            String templateImageFilename;
            OpenDialog od;
            String openTitle = "Select template image file...";
            File templateImageFile = null;
            if (this.plugin.templateImageFilename != null && this.plugin.templateImageFilename.length() > 0) {
                templateImageFile = new File(this.plugin.templateImageFilename);
            }
            if ((od = templateImageFile == null ? new OpenDialog(openTitle, null) : new OpenDialog(openTitle, templateImageFile.getParent(), templateImageFile.getName())).getFileName() != null && this.plugin.useTemplate(templateImageFilename = od.getDirectory() + od.getFileName())) {
                this.templateFileName.setText(templateImageFilename);
                this.pack();
            }
        } else if (source == this.setAsDefaultTemplate) {
            this.plugin.setDefaultTemplate();
        } else if (source == this.clearTemplate) {
            this.plugin.useTemplate(null);
            this.templateFileName.setText("[None chosen]");
            this.pack();
        } else if (source == this.registerRigid) {
            this.plugin.doRegistration(2);
        } else if (source == this.registerAffine) {
            this.plugin.doRegistration(1);
        } else if (source == this.registerBookstein) {
            this.plugin.doRegistration(3);
        }
    }

    public void closeSafely() {
        YesNoCancelDialog d;
        if (this.plugin.unsaved && !(d = new YesNoCancelDialog((Frame)IJ.getInstance(), "Really quit?", "There are unsaved changes. Do you really want to quit?")).yesPressed()) {
            return;
        }
        this.plugin.stopFineTuneThreads();
        this.dispose();
    }

    @Override
    public void windowClosing(WindowEvent e) {
        System.out.println("Got windowClosing...");
        this.closeSafely();
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }
}

