/*
 * Decompiled with CFR 0.152.
 */
package stacks;

import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.measure.Calibration;
import ij.process.ByteProcessor;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.image.ColorModel;
import java.util.ArrayList;
import stacks.CropDialog;
import stacks.ThreePaneCropCanvas;
import stacks.ThreePanes;
import stacks.ThreePanesCanvas;

public class ThreePaneCrop
extends ThreePanes {
    public static final String PLUGIN_VERSION = "1.2";
    int max_x_offscreen;
    int min_x_offscreen;
    int max_y_offscreen;
    int min_y_offscreen;
    int max_z_offscreen;
    int min_z_offscreen;
    protected int overall_min_x;
    protected int overall_max_x;
    protected int overall_min_y;
    protected int overall_max_y;
    protected int overall_min_z;
    protected int overall_max_z;
    CropDialog dialog;
    boolean changeOrigin;

    @Override
    public ThreePanesCanvas createCanvas(ImagePlus imagePlus, int plane) {
        return new ThreePaneCropCanvas(imagePlus, this, plane);
    }

    public void setCropAbove(double above) {
        int min_x_above = Integer.MAX_VALUE;
        int max_x_above = Integer.MIN_VALUE;
        int min_y_above = Integer.MAX_VALUE;
        int max_y_above = Integer.MIN_VALUE;
        int min_z_above = Integer.MAX_VALUE;
        int max_z_above = Integer.MIN_VALUE;
        ImageStack stack = this.xy.getStack();
        int width = this.xy.getWidth();
        int height = this.xy.getHeight();
        int depth = this.xy.getStackSize();
        int type = this.xy.getType();
        for (int z = 0; z < depth; ++z) {
            switch (type) {
                case 0: 
                case 3: {
                    int y;
                    int x;
                    byte[] slice_bytes = (byte[])stack.getPixels(z + 1);
                    for (x = 0; x < width; ++x) {
                        for (y = 0; y < height; ++y) {
                            int value = slice_bytes[y * width + x] & 0xFF;
                            if (!((double)value > above)) continue;
                            if (x < min_x_above) {
                                min_x_above = x;
                            }
                            if (y < min_y_above) {
                                min_y_above = y;
                            }
                            if (z < min_z_above) {
                                min_z_above = z;
                            }
                            if (x > max_x_above) {
                                max_x_above = x;
                            }
                            if (y > max_y_above) {
                                max_y_above = y;
                            }
                            if (z <= max_z_above) continue;
                            max_z_above = z;
                        }
                    }
                    break;
                }
                case 1: {
                    int y;
                    int x;
                    short[] slice_shorts = (short[])stack.getPixels(z + 1);
                    for (x = 0; x < width; ++x) {
                        for (y = 0; y < height; ++y) {
                            short value = slice_shorts[y * width + x];
                            if (!((double)value > above)) continue;
                            if (x < min_x_above) {
                                min_x_above = x;
                            }
                            if (y < min_y_above) {
                                min_y_above = y;
                            }
                            if (z < min_z_above) {
                                min_z_above = z;
                            }
                            if (x > max_x_above) {
                                max_x_above = x;
                            }
                            if (y > max_y_above) {
                                max_y_above = y;
                            }
                            if (z <= max_z_above) continue;
                            max_z_above = z;
                        }
                    }
                }
                case 4: {
                    int y;
                    int x;
                    int[] slice_ints = (int[])stack.getPixels(z + 1);
                    for (x = 0; x < width; ++x) {
                        for (y = 0; y < height; ++y) {
                            int raw_value = slice_ints[y * width + x];
                            int r = (raw_value & 0xFF0000) >> 16;
                            int g = (raw_value & 0xFF00) >> 8;
                            int b = raw_value & 0xFF;
                            int value = (r + g + b) / 3;
                            if (!((double)value > above)) continue;
                            if (x < min_x_above) {
                                min_x_above = x;
                            }
                            if (y < min_y_above) {
                                min_y_above = y;
                            }
                            if (z < min_z_above) {
                                min_z_above = z;
                            }
                            if (x > max_x_above) {
                                max_x_above = x;
                            }
                            if (y > max_y_above) {
                                max_y_above = y;
                            }
                            if (z <= max_z_above) continue;
                            max_z_above = z;
                        }
                    }
                    break;
                }
                case 2: {
                    int y;
                    int x;
                    float[] slice_floats = (float[])stack.getPixels(z + 1);
                    for (x = 0; x < width; ++x) {
                        for (y = 0; y < height; ++y) {
                            float value = slice_floats[y * width + x];
                            if (!((double)value > above)) continue;
                            if (x < min_x_above) {
                                min_x_above = x;
                            }
                            if (y < min_y_above) {
                                min_y_above = y;
                            }
                            if (z < min_z_above) {
                                min_z_above = z;
                            }
                            if (x > max_x_above) {
                                max_x_above = x;
                            }
                            if (y > max_y_above) {
                                max_y_above = y;
                            }
                            if (z <= max_z_above) continue;
                            max_z_above = z;
                        }
                    }
                    break;
                }
            }
            IJ.showProgress((double)((float)z / (float)depth));
        }
        IJ.showProgress((double)1.0);
        if (min_x_above == Integer.MAX_VALUE) {
            IJ.error((String)("There were no voxels with value greater than " + above));
            return;
        }
        this.setCropCuboid(min_x_above, max_x_above, min_y_above, max_y_above, min_z_above, max_z_above);
        this.repaintAllPanes();
    }

    public void performMultipleCrops(ArrayList<ImagePlus> images) {
        for (ImagePlus imp : images) {
            ImagePlus newImagePlus = ThreePaneCrop.performCrop(imp, this.min_x_offscreen, this.max_x_offscreen, this.min_y_offscreen, this.max_y_offscreen, this.min_z_offscreen, this.max_z_offscreen, this.changeOrigin);
            newImagePlus.show();
        }
    }

    public static ImagePlus performCrop(ImagePlus imp, int min_x, int max_x, int min_y, int max_y, int min_z, int max_z, boolean adjust_origin) {
        int original_width = imp.getWidth();
        int new_width = max_x - min_x + 1;
        int new_height = max_y - min_y + 1;
        int first_slice = min_z + 1;
        int last_slice = max_z + 1;
        ImageStack stack = imp.getStack();
        ImageStack new_stack = new ImageStack(new_width, new_height);
        int type = imp.getType();
        ColorModel cm = null;
        if (3 == type) {
            cm = stack.getColorModel();
        }
        switch (type) {
            case 0: 
            case 3: {
                Object[] new_slice;
                int slice;
                for (slice = first_slice; slice <= last_slice; ++slice) {
                    byte[] slice_bytes = (byte[])stack.getPixels(slice);
                    new_slice = new byte[new_width * new_height];
                    for (int y = min_y; y <= max_y; ++y) {
                        System.arraycopy(slice_bytes, y * original_width + min_x, new_slice, (y - min_y) * new_width, new_width);
                    }
                    ByteProcessor bp = new ByteProcessor(new_width, new_height);
                    bp.setPixels((Object)new_slice);
                    new_stack.addSlice(null, (ImageProcessor)bp);
                    IJ.showProgress((double)((slice - first_slice) / (last_slice - first_slice + 1)));
                }
                break;
            }
            case 1: {
                Object[] new_slice;
                int slice;
                for (slice = first_slice; slice <= last_slice; ++slice) {
                    short[] slice_shorts = (short[])stack.getPixels(slice);
                    new_slice = new short[new_width * new_height];
                    for (int y = min_y; y <= max_y; ++y) {
                        System.arraycopy(slice_shorts, y * original_width + min_x, new_slice, (y - min_y) * new_width, new_width);
                    }
                    ShortProcessor sp = new ShortProcessor(new_width, new_height);
                    sp.setPixels((Object)new_slice);
                    new_stack.addSlice(null, (ImageProcessor)sp);
                    IJ.showProgress((double)((slice - first_slice) / (last_slice - first_slice + 1)));
                }
                break;
            }
            case 4: {
                Object[] new_slice;
                int slice;
                for (slice = first_slice; slice <= last_slice; ++slice) {
                    int[] slice_ints = (int[])stack.getPixels(slice);
                    new_slice = new int[new_width * new_height];
                    for (int y = min_y; y <= max_y; ++y) {
                        System.arraycopy(slice_ints, y * original_width + min_x, new_slice, (y - min_y) * new_width, new_width);
                    }
                    ColorProcessor cp = new ColorProcessor(new_width, new_height);
                    cp.setPixels((Object)new_slice);
                    new_stack.addSlice(null, (ImageProcessor)cp);
                    IJ.showProgress((double)((slice - first_slice) / (last_slice - first_slice + 1)));
                }
                break;
            }
            case 2: {
                Object[] new_slice;
                int slice;
                for (slice = first_slice; slice <= last_slice; ++slice) {
                    float[] slice_floats = (float[])stack.getPixels(slice);
                    new_slice = new float[new_width * new_height];
                    for (int y = min_y; y <= max_y; ++y) {
                        System.arraycopy(slice_floats, y * original_width + min_x, new_slice, (y - min_y) * new_width, new_width);
                    }
                    FloatProcessor fp = new FloatProcessor(new_width, new_height);
                    fp.setPixels((Object)new_slice);
                    new_stack.addSlice(null, (ImageProcessor)fp);
                    IJ.showProgress((double)((slice - first_slice) / (last_slice - first_slice + 1)));
                }
                break;
            }
        }
        if (3 == type && cm != null) {
            new_stack.setColorModel(cm);
        }
        IJ.showProgress((double)1.0);
        ImagePlus imagePlus = new ImagePlus("cropped " + imp.getTitle(), new_stack);
        Calibration oldCalibration = imp.getCalibration();
        if (oldCalibration != null) {
            Calibration newCalibration = (Calibration)oldCalibration.clone();
            if (adjust_origin) {
                newCalibration.xOrigin -= (double)min_x;
                newCalibration.yOrigin -= (double)min_y;
                newCalibration.zOrigin -= (double)min_z;
            }
            if (newCalibration != null) {
                imagePlus.setCalibration(newCalibration);
            }
        }
        if (imp.getProperty("Info") != null) {
            imagePlus.setProperty("Info", imp.getProperty("Info"));
        }
        imagePlus.setFileInfo(imp.getOriginalFileInfo());
        return imagePlus;
    }

    public void cancel() {
        this.closeAndReset();
    }

    public void setCropCuboid(int min_x, int max_x, int min_y, int max_y, int min_z, int max_z) {
        min_x = Math.max(min_x, this.overall_min_x);
        min_y = Math.max(min_y, this.overall_min_y);
        min_z = Math.max(min_z, this.overall_min_z);
        max_x = Math.min(max_x, this.overall_max_x);
        max_y = Math.min(max_y, this.overall_max_y);
        max_z = Math.min(max_z, this.overall_max_z);
        ((ThreePaneCropCanvas)this.xy_canvas).setCropBounds(min_x, max_x, min_y, max_y);
        if (!this.single_pane) {
            ((ThreePaneCropCanvas)this.xz_canvas).setCropBounds(min_x, max_x, min_z, max_z);
            ((ThreePaneCropCanvas)this.zy_canvas).setCropBounds(min_z, max_z, min_y, max_y);
        }
        this.min_x_offscreen = min_x;
        this.max_x_offscreen = max_x;
        this.min_y_offscreen = min_y;
        this.max_y_offscreen = max_y;
        this.min_z_offscreen = min_z;
        this.max_z_offscreen = max_z;
        this.dialog.updateCropBounds(this.min_x_offscreen, this.max_x_offscreen, this.min_y_offscreen, this.max_y_offscreen, this.min_z_offscreen, this.max_z_offscreen);
    }

    @Override
    public void initialize(ImagePlus imagePlus) {
        this.checkMemory(imagePlus, 3);
        boolean singleSlice = imagePlus.getStackSize() == 1;
        GenericDialog gd = new GenericDialog("Three Pane Crop (v1.2)");
        gd.addMessage("Cropping: " + imagePlus.getTitle());
        if (!singleSlice) {
            gd.addCheckbox("Three pane view?", true);
        }
        gd.addCheckbox("Change origin?", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.single_pane = singleSlice || !gd.getNextBoolean();
        this.changeOrigin = gd.getNextBoolean();
        super.initialize(imagePlus);
        this.overall_min_x = 0;
        this.overall_min_y = 0;
        this.overall_min_z = 0;
        this.overall_max_x = imagePlus.getWidth() - 1;
        this.overall_max_y = imagePlus.getHeight() - 1;
        this.overall_max_z = imagePlus.getStackSize() - 1;
        this.dialog = new CropDialog("Crop Options", this);
        this.setCropCuboid(0, imagePlus.getWidth() - 1, 0, imagePlus.getHeight() - 1, 0, imagePlus.getStackSize() - 1);
    }

    public void handleDraggedTo(int off_screen_x, int off_screen_y, int dragging, int in_plane) {
        int[] point = new int[3];
        this.findPointInStack(off_screen_x, off_screen_y, in_plane, point);
        if (in_plane == 0 && dragging == 1) {
            int new_min_x = Math.min(point[0], this.max_x_offscreen);
            int new_min_y = Math.min(point[1], this.max_y_offscreen);
            this.setCropCuboid(new_min_x, this.max_x_offscreen, new_min_y, this.max_y_offscreen, this.min_z_offscreen, this.max_z_offscreen);
        } else if (in_plane == 0 && dragging == 3) {
            int new_min_x = Math.min(point[0], this.max_x_offscreen);
            int new_max_y = Math.max(point[1], this.min_y_offscreen);
            this.setCropCuboid(new_min_x, this.max_x_offscreen, this.min_y_offscreen, new_max_y, this.min_z_offscreen, this.max_z_offscreen);
        } else if (in_plane == 0 && dragging == 2) {
            int new_max_x = Math.max(point[0], this.min_x_offscreen);
            int new_min_y = Math.min(point[1], this.max_y_offscreen);
            this.setCropCuboid(this.min_x_offscreen, new_max_x, new_min_y, this.max_y_offscreen, this.min_z_offscreen, this.max_z_offscreen);
        } else if (in_plane == 0 && dragging == 4) {
            int new_max_x = Math.max(point[0], this.min_x_offscreen);
            int new_max_y = Math.max(point[1], this.min_y_offscreen);
            this.setCropCuboid(this.min_x_offscreen, new_max_x, this.min_y_offscreen, new_max_y, this.min_z_offscreen, this.max_z_offscreen);
        } else if (in_plane == 1 && dragging == 1) {
            int new_min_x = Math.min(point[0], this.max_x_offscreen);
            int new_min_z = Math.min(point[2], this.max_z_offscreen);
            this.setCropCuboid(new_min_x, this.max_x_offscreen, this.min_y_offscreen, this.max_y_offscreen, new_min_z, this.max_z_offscreen);
        } else if (in_plane == 1 && dragging == 2) {
            int new_max_x = Math.max(point[0], this.min_x_offscreen);
            int new_min_z = Math.min(point[2], this.max_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, new_max_x, this.min_y_offscreen, this.max_y_offscreen, new_min_z, this.max_z_offscreen);
        } else if (in_plane == 1 && dragging == 3) {
            int new_min_x = Math.min(point[0], this.max_x_offscreen);
            int new_max_z = Math.max(point[2], this.min_z_offscreen);
            this.setCropCuboid(new_min_x, this.max_x_offscreen, this.min_y_offscreen, this.max_y_offscreen, this.min_z_offscreen, new_max_z);
        } else if (in_plane == 1 && dragging == 4) {
            int new_max_x = Math.max(point[0], this.min_x_offscreen);
            int new_max_z = Math.max(point[2], this.min_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, new_max_x, this.min_y_offscreen, this.max_y_offscreen, this.min_z_offscreen, new_max_z);
        } else if (in_plane == 2 && dragging == 1) {
            int new_min_y = Math.min(point[1], this.max_y_offscreen);
            int new_min_z = Math.min(point[2], this.max_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, this.max_x_offscreen, new_min_y, this.max_y_offscreen, new_min_z, this.max_z_offscreen);
        } else if (in_plane == 2 && dragging == 2) {
            int new_min_y = Math.min(point[1], this.max_y_offscreen);
            int new_max_z = Math.max(point[2], this.min_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, this.max_x_offscreen, new_min_y, this.max_y_offscreen, this.min_z_offscreen, new_max_z);
        } else if (in_plane == 2 && dragging == 3) {
            int new_max_y = Math.max(point[1], this.min_y_offscreen);
            int new_min_z = Math.min(point[2], this.max_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, this.max_x_offscreen, this.min_y_offscreen, new_max_y, new_min_z, this.max_z_offscreen);
        } else if (in_plane == 2 && dragging == 4) {
            int new_max_y = Math.max(point[1], this.min_y_offscreen);
            int new_max_z = Math.max(point[2], this.min_z_offscreen);
            this.setCropCuboid(this.min_x_offscreen, this.max_x_offscreen, this.min_y_offscreen, new_max_y, this.min_z_offscreen, new_max_z);
        }
        this.repaintAllPanes();
    }
}

