/*
 * Decompiled with CFR 0.152.
 */
package util;

import ij.ImagePlus;
import ij.ImageStack;

public class Limits {
    public static float[] getStackLimits(ImagePlus imagePlus) {
        return Limits.getStackLimits(imagePlus, false);
    }

    public static float[] getStackLimits(ImagePlus imagePlus, boolean mustBeFinite) {
        int depth = imagePlus.getStackSize();
        ImageStack stack = imagePlus.getStack();
        int bitDepth = imagePlus.getBitDepth();
        int type = imagePlus.getType();
        if (type == 4) {
            throw new RuntimeException("Limits.getStackLimits can't do anything sensible with RGB images");
        }
        float minValue = Float.MAX_VALUE;
        float maxValue = Float.MIN_VALUE;
        for (int z = 0; z < depth; ++z) {
            int i;
            Object[] pixels;
            if (8 == bitDepth) {
                pixels = (byte[])stack.getPixels(z + 1);
                for (i = 0; i < pixels.length; ++i) {
                    int value = pixels[i] & 0xFF;
                    if ((float)value > maxValue) {
                        maxValue = value;
                    }
                    if (!((float)value < minValue)) continue;
                    minValue = value;
                }
                continue;
            }
            if (type == 1) {
                pixels = (short[])stack.getPixels(z + 1);
                for (i = 0; i < pixels.length; ++i) {
                    byte value = pixels[i];
                    if ((float)value > maxValue) {
                        maxValue = value;
                    }
                    if (!((float)value < minValue)) continue;
                    minValue = value;
                }
                continue;
            }
            if (type != 2) continue;
            pixels = (float[])stack.getPixels(z + 1);
            for (i = 0; i < pixels.length; ++i) {
                byte value = pixels[i];
                if (mustBeFinite && (Float.isNaN(value) || Float.isInfinite(value))) continue;
                if (value > maxValue) {
                    maxValue = value;
                }
                if (!(value < minValue)) continue;
                minValue = value;
            }
        }
        float[] result = new float[]{minValue, maxValue};
        return result;
    }
}

