/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.ImagePlus;
import ij.measure.Calibration;
import java.util.StringTokenizer;
import java.util.Vector;
import math3d.FloatMatrixN;
import math3d.JacobiFloat;
import math3d.Point3d;
import math3d.Triangle;

public class FloatMatrix {
    public float x;
    public float y;
    public float z;
    protected float a00;
    protected float a01;
    protected float a02;
    protected float a03;
    protected float a10;
    protected float a11;
    protected float a12;
    protected float a13;
    protected float a20;
    protected float a21;
    protected float a22;
    protected float a23;

    public FloatMatrix() {
    }

    public FloatMatrix(float f) {
        this.a11 = this.a22 = f;
        this.a00 = this.a22;
    }

    public FloatMatrix(float[][] m) {
        if (m.length != 3 && m.length != 4 || m[0].length != 4) {
            throw new RuntimeException("Wrong dimensions: " + m.length + "x" + m[0].length);
        }
        this.a00 = m[0][0];
        this.a01 = m[0][1];
        this.a02 = m[0][2];
        this.a03 = m[0][3];
        this.a10 = m[1][0];
        this.a11 = m[1][1];
        this.a12 = m[1][2];
        this.a13 = m[1][3];
        this.a20 = m[2][0];
        this.a21 = m[2][1];
        this.a22 = m[2][2];
        this.a23 = m[2][3];
    }

    public FloatMatrix(FloatMatrix f) {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.a00 = f.a00;
        this.a01 = f.a01;
        this.a02 = f.a02;
        this.a03 = f.a03;
        this.a10 = f.a10;
        this.a11 = f.a11;
        this.a12 = f.a12;
        this.a13 = f.a13;
        this.a20 = f.a20;
        this.a21 = f.a21;
        this.a22 = f.a22;
        this.a23 = f.a23;
    }

    public FloatMatrix copyFrom(FloatMatrix f) {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.a00 = f.a00;
        this.a01 = f.a01;
        this.a02 = f.a02;
        this.a03 = f.a03;
        this.a10 = f.a10;
        this.a11 = f.a11;
        this.a12 = f.a12;
        this.a13 = f.a13;
        this.a20 = f.a20;
        this.a21 = f.a21;
        this.a22 = f.a22;
        this.a23 = f.a23;
        return this;
    }

    public boolean isJustTranslation() {
        FloatMatrix toTest = new FloatMatrix(this);
        toTest.a03 -= this.a03;
        toTest.a13 -= this.a13;
        toTest.a23 -= this.a23;
        return toTest.isIdentity();
    }

    public boolean noTranslation() {
        float eps = 1.0E-10f;
        return Math.abs(this.a03) < eps && Math.abs(this.a13) < eps && Math.abs(this.a23) < eps;
    }

    public FloatMatrix composeWith(FloatMatrix followedBy) {
        FloatMatrix A = this;
        FloatMatrix B = followedBy;
        FloatMatrix result = new FloatMatrix();
        result.a00 = A.a00 * B.a00 + A.a10 * B.a01 + A.a20 * B.a02;
        result.a10 = A.a00 * B.a10 + A.a10 * B.a11 + A.a20 * B.a12;
        result.a20 = A.a00 * B.a20 + A.a10 * B.a21 + A.a20 * B.a22;
        result.a01 = A.a01 * B.a00 + A.a11 * B.a01 + A.a21 * B.a02;
        result.a11 = A.a01 * B.a10 + A.a11 * B.a11 + A.a21 * B.a12;
        result.a21 = A.a01 * B.a20 + A.a11 * B.a21 + A.a21 * B.a22;
        result.a02 = A.a02 * B.a00 + A.a12 * B.a01 + A.a22 * B.a02;
        result.a12 = A.a02 * B.a10 + A.a12 * B.a11 + A.a22 * B.a12;
        result.a22 = A.a02 * B.a20 + A.a12 * B.a21 + A.a22 * B.a22;
        result.a03 = A.a03 * B.a00 + A.a13 * B.a01 + A.a23 * B.a02 + B.a03;
        result.a13 = A.a03 * B.a10 + A.a13 * B.a11 + A.a23 * B.a12 + B.a13;
        result.a23 = A.a03 * B.a20 + A.a13 * B.a21 + A.a23 * B.a22 + B.a23;
        return result;
    }

    public FloatMatrix[] decompose() {
        FloatMatrix[] result = new FloatMatrix[2];
        result[0].a00 = this.a00;
        result[0].a01 = this.a01;
        result[0].a02 = this.a02;
        result[0].a10 = this.a10;
        result[0].a11 = this.a11;
        result[0].a12 = this.a12;
        result[0].a20 = this.a20;
        result[0].a21 = this.a21;
        result[0].a22 = this.a22;
        result[1].a03 = this.a03;
        result[1].a13 = this.a13;
        result[1].a23 = this.a23;
        return result;
    }

    public FloatMatrix plus(FloatMatrix other) {
        FloatMatrix result = new FloatMatrix();
        result.a00 = other.a00 + this.a00;
        result.a01 = other.a01 + this.a01;
        result.a02 = other.a02 + this.a02;
        result.a03 = other.a03 + this.a03;
        result.a10 = other.a10 + this.a10;
        result.a11 = other.a11 + this.a11;
        result.a12 = other.a12 + this.a12;
        result.a13 = other.a13 + this.a13;
        result.a20 = other.a20 + this.a20;
        result.a21 = other.a21 + this.a21;
        result.a22 = other.a22 + this.a22;
        result.a23 = other.a23 + this.a23;
        return result;
    }

    public void apply(float x, float y, float z) {
        this.x = x * this.a00 + y * this.a01 + z * this.a02 + this.a03;
        this.y = x * this.a10 + y * this.a11 + z * this.a12 + this.a13;
        this.z = x * this.a20 + y * this.a21 + z * this.a22 + this.a23;
    }

    public void apply(Point3d p) {
        this.x = (float)(p.x * (double)this.a00 + p.y * (double)this.a01 + p.z * (double)this.a02 + (double)this.a03);
        this.y = (float)(p.x * (double)this.a10 + p.y * (double)this.a11 + p.z * (double)this.a12 + (double)this.a13);
        this.z = (float)(p.x * (double)this.a20 + p.y * (double)this.a21 + p.z * (double)this.a22 + (double)this.a23);
    }

    public void apply(float[] p) {
        this.x = p[0] * this.a00 + p[1] * this.a01 + p[2] * this.a02 + this.a03;
        this.y = p[0] * this.a10 + p[1] * this.a11 + p[2] * this.a12 + this.a13;
        this.z = p[0] * this.a20 + p[1] * this.a21 + p[2] * this.a22 + this.a23;
    }

    public void applyWithoutTranslation(float x, float y, float z) {
        this.x = x * this.a00 + y * this.a01 + z * this.a02;
        this.y = x * this.a10 + y * this.a11 + z * this.a12;
        this.z = x * this.a20 + y * this.a21 + z * this.a22;
    }

    public void applyWithoutTranslation(Point3d p) {
        this.x = (float)(p.x * (double)this.a00 + p.y * (double)this.a01 + p.z * (double)this.a02);
        this.y = (float)(p.x * (double)this.a10 + p.y * (double)this.a11 + p.z * (double)this.a12);
        this.z = (float)(p.x * (double)this.a20 + p.y * (double)this.a21 + p.z * (double)this.a22);
    }

    public Point3d getResult() {
        return new Point3d(this.x, this.y, this.z);
    }

    public FloatMatrix scale(float x, float y, float z) {
        FloatMatrix result = new FloatMatrix();
        result.a00 = this.a00 * x;
        result.a01 = this.a01 * x;
        result.a02 = this.a02 * x;
        result.a03 = this.a03 * x;
        result.a10 = this.a10 * y;
        result.a11 = this.a11 * y;
        result.a12 = this.a12 * y;
        result.a13 = this.a13 * y;
        result.a20 = this.a20 * z;
        result.a21 = this.a21 * z;
        result.a22 = this.a22 * z;
        result.a23 = this.a23 * z;
        return result;
    }

    public FloatMatrix times(FloatMatrix o) {
        FloatMatrix result = new FloatMatrix();
        result.a00 = o.a00 * this.a00 + o.a10 * this.a01 + o.a20 * this.a02;
        result.a10 = o.a00 * this.a10 + o.a10 * this.a11 + o.a20 * this.a12;
        result.a20 = o.a00 * this.a20 + o.a10 * this.a21 + o.a20 * this.a22;
        result.a01 = o.a01 * this.a00 + o.a11 * this.a01 + o.a21 * this.a02;
        result.a11 = o.a01 * this.a10 + o.a11 * this.a11 + o.a21 * this.a12;
        result.a21 = o.a01 * this.a20 + o.a11 * this.a21 + o.a21 * this.a22;
        result.a02 = o.a02 * this.a00 + o.a12 * this.a01 + o.a22 * this.a02;
        result.a12 = o.a02 * this.a10 + o.a12 * this.a11 + o.a22 * this.a12;
        result.a22 = o.a02 * this.a20 + o.a12 * this.a21 + o.a22 * this.a22;
        this.apply(o.a03, o.a13, o.a23);
        result.a03 = this.x;
        result.a13 = this.y;
        result.a23 = this.z;
        return result;
    }

    public float det() {
        float sub00 = this.a11 * this.a22 - this.a12 * this.a21;
        float sub01 = this.a10 * this.a22 - this.a12 * this.a20;
        float sub02 = this.a10 * this.a21 - this.a11 * this.a20;
        float sub10 = this.a01 * this.a22 - this.a02 * this.a21;
        float sub11 = this.a00 * this.a22 - this.a02 * this.a20;
        float sub12 = this.a00 * this.a21 - this.a01 * this.a20;
        float sub20 = this.a01 * this.a12 - this.a02 * this.a11;
        float sub21 = this.a00 * this.a12 - this.a02 * this.a10;
        float sub22 = this.a00 * this.a11 - this.a01 * this.a10;
        return this.a00 * sub00 - this.a01 * sub01 + this.a02 * sub02;
    }

    private FloatMatrix invert3x3() {
        float sub00 = this.a11 * this.a22 - this.a12 * this.a21;
        float sub01 = this.a10 * this.a22 - this.a12 * this.a20;
        float sub02 = this.a10 * this.a21 - this.a11 * this.a20;
        float sub10 = this.a01 * this.a22 - this.a02 * this.a21;
        float sub11 = this.a00 * this.a22 - this.a02 * this.a20;
        float sub12 = this.a00 * this.a21 - this.a01 * this.a20;
        float sub20 = this.a01 * this.a12 - this.a02 * this.a11;
        float sub21 = this.a00 * this.a12 - this.a02 * this.a10;
        float sub22 = this.a00 * this.a11 - this.a01 * this.a10;
        float det = this.a00 * sub00 - this.a01 * sub01 + this.a02 * sub02;
        FloatMatrix result = new FloatMatrix();
        result.a00 = sub00 / det;
        result.a01 = -sub10 / det;
        result.a02 = sub20 / det;
        result.a10 = -sub01 / det;
        result.a11 = sub11 / det;
        result.a12 = -sub21 / det;
        result.a20 = sub02 / det;
        result.a21 = -sub12 / det;
        result.a22 = sub22 / det;
        return result;
    }

    public FloatMatrix inverse() {
        FloatMatrix result = this.invert3x3();
        result.apply(-this.a03, -this.a13, -this.a23);
        result.a03 = result.x;
        result.a13 = result.y;
        result.a23 = result.z;
        return result;
    }

    public static FloatMatrix rotate(float angle, int axis) {
        FloatMatrix result = new FloatMatrix();
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        switch (axis) {
            case 0: {
                result.a11 = result.a22 = c;
                result.a21 = s;
                result.a12 = -result.a21;
                result.a00 = 1.0f;
                break;
            }
            case 1: {
                result.a00 = result.a22 = c;
                result.a20 = s;
                result.a02 = -result.a20;
                result.a11 = 1.0f;
                break;
            }
            case 2: {
                result.a00 = result.a11 = c;
                result.a10 = s;
                result.a01 = -result.a10;
                result.a22 = 1.0f;
                break;
            }
            default: {
                throw new RuntimeException("Illegal axis: " + axis);
            }
        }
        return result;
    }

    public static FloatMatrix rotateFromTo(float aX, float aY, float aZ, float bX, float bY, float bZ) {
        float l = (float)Math.sqrt(aX * aX + aY * aY + aZ * aZ);
        aX /= l;
        aY /= l;
        aZ /= l;
        l = (float)Math.sqrt(bX * bX + bY * bY + bZ * bZ);
        float cX = aY * (bZ /= l) - aZ * (bY /= l);
        float cY = aZ * (bX /= l) - aX * bZ;
        float cZ = aX * bY - aY * bX;
        float pX = cY * aZ - cZ * aY;
        float pY = cZ * aX - cX * aZ;
        float pZ = cX * aY - cY * aX;
        float qX = cY * bZ - cZ * bY;
        float qY = cZ * bX - cX * bZ;
        float qZ = cX * bY - cY * bX;
        FloatMatrix result = new FloatMatrix();
        result.a00 = aX;
        result.a01 = aY;
        result.a02 = aZ;
        result.a10 = cX;
        result.a11 = cY;
        result.a12 = cZ;
        result.a20 = pX;
        result.a21 = pY;
        result.a22 = pZ;
        FloatMatrix transp = new FloatMatrix();
        transp.a00 = bX;
        transp.a01 = cX;
        transp.a02 = qX;
        transp.a10 = bY;
        transp.a11 = cY;
        transp.a12 = qY;
        transp.a20 = bZ;
        transp.a21 = cZ;
        transp.a22 = qZ;
        return transp.times(result);
    }

    public static float dotProduct(float[] a, float[] b) {
        float result = 0.0f;
        if (a.length != b.length) {
            throw new IllegalArgumentException("In dotProduct, the vectors must be of the same length.");
        }
        if (a.length < 1) {
            throw new IllegalArgumentException("Can't dotProduct vectors of zero length.");
        }
        for (int i = 0; i < a.length; ++i) {
            result += a[i] * b[i];
        }
        return result;
    }

    public static float sizeSquared(float[] a) {
        return FloatMatrix.dotProduct(a, a);
    }

    public static float size(float[] a) {
        return (float)Math.sqrt(FloatMatrix.dotProduct(a, a));
    }

    public static float angleBetween(float[] v1, float[] v2) {
        return (float)Math.acos(FloatMatrix.dotProduct(v1, v2) / (FloatMatrix.size(v1) * FloatMatrix.size(v2)));
    }

    public static float[] crossProduct(float[] a, float[] b) {
        float[] result = new float[]{a[1] * b[2] - a[2] * b[1], a[2] * b[0] - a[0] * b[2], a[0] * b[1] - a[1] * b[0]};
        return result;
    }

    public static float[] normalize(float[] a) {
        float magnitude = FloatMatrix.size(a);
        float[] result = new float[a.length];
        for (int i = 0; i < a.length; ++i) {
            result[i] = a[i] / magnitude;
        }
        return result;
    }

    public static FloatMatrix rotateToAlignVectors(float[] v2_template, float[] v1_template, float[] v2_domain, float[] v1_domain) {
        float angleBetween = FloatMatrix.angleBetween(v2_domain, v2_template);
        float[] normal = FloatMatrix.crossProduct(v2_domain, v2_template);
        float[] normalUnit = FloatMatrix.normalize(normal);
        FloatMatrix rotation = FloatMatrix.rotateAround(normalUnit[0], normalUnit[1], normalUnit[2], angleBetween);
        float scale_v2_domain = FloatMatrix.dotProduct(v1_domain, v2_domain) / FloatMatrix.sizeSquared(v2_domain);
        float[] v1_orthogonal_domain = new float[]{v1_domain[0] - scale_v2_domain * v2_domain[0], v1_domain[1] - scale_v2_domain * v2_domain[1], v1_domain[2] - scale_v2_domain * v2_domain[2]};
        float scale_v2_template = FloatMatrix.dotProduct(v1_template, v2_template) / FloatMatrix.sizeSquared(v2_template);
        float[] v1_orthogonal_template = new float[]{v1_template[0] - scale_v2_template * v2_template[0], v1_template[1] - scale_v2_template * v2_template[1], v1_template[2] - scale_v2_template * v2_template[2]};
        rotation.apply(v1_orthogonal_domain[0], v1_orthogonal_domain[1], v1_orthogonal_domain[2]);
        float[] v1_orthogonal_domain_rotated = new float[]{rotation.x, rotation.y, rotation.z};
        float angleBetweenV1sA = FloatMatrix.angleBetween(v1_orthogonal_domain_rotated, v1_orthogonal_template);
        float[] normalToV1sA = FloatMatrix.crossProduct(v1_orthogonal_domain_rotated, v1_orthogonal_template);
        float[] normalToV1sAUnit = FloatMatrix.normalize(normalToV1sA);
        FloatMatrix secondRotationA = FloatMatrix.rotateAround(normalToV1sAUnit[0], normalToV1sAUnit[1], normalToV1sAUnit[2], angleBetweenV1sA);
        return rotation.composeWith(secondRotationA);
    }

    public static FloatMatrix rotateAround(float nx, float ny, float nz, float angle) {
        FloatMatrix r = new FloatMatrix();
        float c = (float)Math.cos(angle);
        float s = (float)Math.sin(angle);
        r.a00 = -(c - 1.0f) * nx * nx + c;
        r.a01 = -(c - 1.0f) * nx * ny - s * nz;
        r.a02 = -(c - 1.0f) * nx * nz + s * ny;
        r.a03 = 0.0f;
        r.a10 = -(c - 1.0f) * nx * ny + s * nz;
        r.a11 = -(c - 1.0f) * ny * ny + c;
        r.a12 = -(c - 1.0f) * ny * nz - s * nx;
        r.a13 = 0.0f;
        r.a20 = -(c - 1.0f) * nx * nz - s * ny;
        r.a21 = -(c - 1.0f) * ny * nz + s * nx;
        r.a22 = -(c - 1.0f) * nz * nz + c;
        r.a23 = 0.0f;
        return r;
    }

    public static FloatMatrix rotateEuler(float a1, float a2, float a3) {
        FloatMatrix r = new FloatMatrix();
        float c1 = (float)Math.cos(a1);
        float s1 = (float)Math.sin(a1);
        float c2 = (float)Math.cos(a2);
        float s2 = (float)Math.sin(a2);
        float c3 = (float)Math.cos(a3);
        float s3 = (float)Math.sin(a3);
        r.a00 = c3 * c1 - c2 * s1 * s3;
        r.a01 = -s3 * c1 - c2 * s1 * c3;
        r.a02 = s2 * s1;
        r.a03 = 0.0f;
        r.a10 = c3 * s1 + c2 * c1 * s3;
        r.a11 = -s3 * s1 + c2 * c1 * c3;
        r.a12 = -s2 * c1;
        r.a13 = 0.0f;
        r.a20 = s2 * s3;
        r.a21 = s2 * c3;
        r.a22 = c2;
        r.a23 = 0.0f;
        return r;
    }

    public static FloatMatrix rotateEulerAt(float a1, float a2, float a3, float cx, float cy, float cz) {
        FloatMatrix r = new FloatMatrix();
        float c1 = (float)Math.cos(a1);
        float s1 = (float)Math.sin(a1);
        float c2 = (float)Math.cos(a2);
        float s2 = (float)Math.sin(a2);
        float c3 = (float)Math.cos(a3);
        float s3 = (float)Math.sin(a3);
        r.a00 = c3 * c1 - c2 * s1 * s3;
        r.a01 = -s3 * c1 - c2 * s1 * c3;
        r.a02 = s2 * s1;
        r.a03 = 0.0f;
        r.a10 = c3 * s1 + c2 * c1 * s3;
        r.a11 = -s3 * s1 + c2 * c1 * c3;
        r.a12 = -s2 * c1;
        r.a13 = 0.0f;
        r.a20 = s2 * s3;
        r.a21 = s2 * c3;
        r.a22 = c2;
        r.a23 = 0.0f;
        r.apply(cx, cy, cz);
        r.a03 = cx - r.x;
        r.a13 = cy - r.y;
        r.a23 = cz - r.z;
        return r;
    }

    public void guessEulerParameters(float[] parameters) {
        if (parameters.length != 6) {
            throw new IllegalArgumentException("Need 6 parameters, got " + parameters.length);
        }
        this.guessEulerParameters(parameters, null);
    }

    public void guessEulerParameters(float[] parameters, Point3d center) {
        if (center != null && parameters.length != 9) {
            throw new IllegalArgumentException("Need 9 parameters, got " + parameters.length);
        }
        if (this.a21 == 0.0f && this.a20 == 0.0f) {
            parameters[2] = 0.0f;
            parameters[1] = 0.0f;
            parameters[0] = (float)Math.atan2(this.a10, this.a00);
        } else {
            parameters[2] = (float)Math.atan2(this.a20, this.a21);
            parameters[1] = (float)Math.atan2(Math.sqrt(this.a21 * this.a21 + this.a20 * this.a20), this.a22);
            parameters[0] = (float)Math.atan2(this.a02, -this.a12);
        }
        if (center != null) {
            parameters[6] = (float)center.x;
            parameters[7] = (float)center.y;
            parameters[8] = (float)center.z;
            this.apply(center);
            parameters[3] = this.x - (float)center.x;
            parameters[4] = this.y - (float)center.y;
            parameters[5] = this.z - (float)center.z;
            return;
        }
        if (this.a03 == 0.0f && this.a13 == 0.0f && this.a23 == 0.0f) {
            parameters[5] = 0.0f;
            parameters[4] = 0.0f;
            parameters[3] = 0.0f;
        } else {
            this.apply(this.a03, this.a13, this.a23);
            Triangle t = new Triangle(new Point3d(0.0, 0.0, 0.0), new Point3d(this.a03, this.a13, this.a23), new Point3d(this.x, this.y, this.z));
            t.calculateCircumcenter2();
            parameters[3] = (float)t.center.x;
            parameters[4] = (float)t.center.y;
            parameters[5] = (float)t.center.z;
        }
    }

    public static FloatMatrix translate(float x, float y, float z) {
        FloatMatrix result = new FloatMatrix();
        result.a22 = 1.0f;
        result.a11 = 1.0f;
        result.a00 = 1.0f;
        result.a03 = x;
        result.a13 = y;
        result.a23 = z;
        return result;
    }

    public static FloatMatrix bestLinear(Point3d[] x, Point3d[] y) {
        if (x.length != y.length) {
            throw new RuntimeException("different lengths");
        }
        if (x.length != 4) {
            throw new RuntimeException("The arrays passed to bestLinear must be of length 4");
        }
        float[][] a = new float[4][4];
        float[][] b = new float[4][4];
        for (int i = 0; i < a.length; ++i) {
            float[] fArray = a[0];
            fArray[0] = fArray[0] + (float)(x[i].x * x[i].x);
            float[] fArray2 = a[0];
            fArray2[1] = fArray2[1] + (float)(x[i].x * x[i].y);
            float[] fArray3 = a[0];
            fArray3[2] = fArray3[2] + (float)(x[i].x * x[i].z);
            float[] fArray4 = a[0];
            fArray4[3] = fArray4[3] + (float)x[i].x;
            float[] fArray5 = a[1];
            fArray5[1] = fArray5[1] + (float)(x[i].y * x[i].y);
            float[] fArray6 = a[1];
            fArray6[2] = fArray6[2] + (float)(x[i].y * x[i].z);
            float[] fArray7 = a[1];
            fArray7[3] = fArray7[3] + (float)x[i].y;
            float[] fArray8 = a[2];
            fArray8[2] = fArray8[2] + (float)(x[i].z * x[i].z);
            float[] fArray9 = a[2];
            fArray9[3] = fArray9[3] + (float)x[i].z;
            float[] fArray10 = b[0];
            fArray10[0] = fArray10[0] + (float)(x[i].x * y[i].x);
            float[] fArray11 = b[0];
            fArray11[1] = fArray11[1] + (float)(x[i].y * y[i].x);
            float[] fArray12 = b[0];
            fArray12[2] = fArray12[2] + (float)(x[i].z * y[i].x);
            float[] fArray13 = b[0];
            fArray13[3] = fArray13[3] + (float)y[i].x;
            float[] fArray14 = b[1];
            fArray14[0] = fArray14[0] + (float)(x[i].x * y[i].y);
            float[] fArray15 = b[1];
            fArray15[1] = fArray15[1] + (float)(x[i].y * y[i].y);
            float[] fArray16 = b[1];
            fArray16[2] = fArray16[2] + (float)(x[i].z * y[i].y);
            float[] fArray17 = b[1];
            fArray17[3] = fArray17[3] + (float)y[i].y;
            float[] fArray18 = b[2];
            fArray18[0] = fArray18[0] + (float)(x[i].x * y[i].z);
            float[] fArray19 = b[2];
            fArray19[1] = fArray19[1] + (float)(x[i].y * y[i].z);
            float[] fArray20 = b[2];
            fArray20[2] = fArray20[2] + (float)(x[i].z * y[i].z);
            float[] fArray21 = b[2];
            fArray21[3] = fArray21[3] + (float)y[i].z;
        }
        a[1][0] = a[0][1];
        a[2][0] = a[0][2];
        a[2][1] = a[1][2];
        a[3][0] = a[0][3];
        a[3][1] = a[1][3];
        a[3][2] = a[2][3];
        a[3][3] = 1.0f;
        FloatMatrixN.invert(a);
        float[][] r = FloatMatrixN.times(b, a);
        FloatMatrix result = new FloatMatrix();
        result.a00 = r[0][0];
        result.a01 = r[0][1];
        result.a02 = r[0][2];
        result.a03 = r[0][3];
        result.a10 = r[1][0];
        result.a11 = r[1][1];
        result.a12 = r[1][2];
        result.a13 = r[1][3];
        result.a20 = r[2][0];
        result.a21 = r[2][1];
        result.a22 = r[2][2];
        result.a23 = r[2][3];
        return result;
    }

    public static FloatMatrix bestRigid(Point3d[] set1, Point3d[] set2) {
        return FloatMatrix.bestRigid(set1, set2, true);
    }

    public static FloatMatrix bestRigid(Point3d[] set1, Point3d[] set2, boolean allowScaling) {
        if (set1.length != set2.length) {
            throw new RuntimeException("different lengths");
        }
        float c2z = 0.0f;
        float c2y = 0.0f;
        float c2x = 0.0f;
        float c1z = 0.0f;
        float c1y = 0.0f;
        float c1x = 0.0f;
        for (int i = 0; i < set1.length; ++i) {
            c1x += (float)set1[i].x;
            c1y += (float)set1[i].y;
            c1z += (float)set1[i].z;
            c2x += (float)set2[i].x;
            c2y += (float)set2[i].y;
            c2z += (float)set2[i].z;
        }
        c1x /= (float)set1.length;
        c1y /= (float)set1.length;
        c1z /= (float)set1.length;
        c2x /= (float)set1.length;
        c2y /= (float)set1.length;
        c2z /= (float)set1.length;
        float s = 1.0f;
        if (allowScaling) {
            float r2 = 0.0f;
            float r1 = 0.0f;
            for (int i = 0; i < set1.length; ++i) {
                float x1 = (float)set1[i].x - c1x;
                float y1 = (float)set1[i].y - c1y;
                float z1 = (float)set1[i].z - c1z;
                float x2 = (float)set2[i].x - c2x;
                float y2 = (float)set2[i].y - c2y;
                float z2 = (float)set2[i].z - c2z;
                r1 += x1 * x1 + y1 * y1 + z1 * z1;
                r2 += x2 * x2 + y2 * y2 + z2 * z2;
            }
            s = (float)Math.sqrt(r2 / r1);
        }
        float Szz = 0.0f;
        float Szy = 0.0f;
        float Szx = 0.0f;
        float Syz = 0.0f;
        float Syy = 0.0f;
        float Syx = 0.0f;
        float Sxz = 0.0f;
        float Sxy = 0.0f;
        float Sxx = 0.0f;
        for (int i = 0; i < set1.length; ++i) {
            float x1 = ((float)set1[i].x - c1x) * s;
            float y1 = ((float)set1[i].y - c1y) * s;
            float z1 = ((float)set1[i].z - c1z) * s;
            float x2 = (float)set2[i].x - c2x;
            float y2 = (float)set2[i].y - c2y;
            float z2 = (float)set2[i].z - c2z;
            Sxx += x1 * x2;
            Sxy += x1 * y2;
            Sxz += x1 * z2;
            Syx += y1 * x2;
            Syy += y1 * y2;
            Syz += y1 * z2;
            Szx += z1 * x2;
            Szy += z1 * y2;
            Szz += z1 * z2;
        }
        float[][] N = new float[4][4];
        N[0][0] = Sxx + Syy + Szz;
        N[0][1] = Syz - Szy;
        N[0][2] = Szx - Sxz;
        N[0][3] = Sxy - Syx;
        N[1][0] = Syz - Szy;
        N[1][1] = Sxx - Syy - Szz;
        N[1][2] = Sxy + Syx;
        N[1][3] = Szx + Sxz;
        N[2][0] = Szx - Sxz;
        N[2][1] = Sxy + Syx;
        N[2][2] = -Sxx + Syy - Szz;
        N[2][3] = Syz + Szy;
        N[3][0] = Sxy - Syx;
        N[3][1] = Szx + Sxz;
        N[3][2] = Syz + Szy;
        N[3][3] = -Sxx - Syy + Szz;
        JacobiFloat jacobi = new JacobiFloat(N);
        float[][] eigenvectors = jacobi.getEigenVectors();
        float[] eigenvalues = jacobi.getEigenValues();
        int index = 0;
        for (int i = 1; i < 4; ++i) {
            if (!(eigenvalues[i] > eigenvalues[index])) continue;
            index = i;
        }
        float[] q = eigenvectors[index];
        float q0 = q[0];
        float qx = q[1];
        float qy = q[2];
        float qz = q[3];
        FloatMatrix result = new FloatMatrix();
        result.a00 = s * (q0 * q0 + qx * qx - qy * qy - qz * qz);
        result.a01 = s * 2.0f * (qx * qy - q0 * qz);
        result.a02 = s * 2.0f * (qx * qz + q0 * qy);
        result.a10 = s * 2.0f * (qy * qx + q0 * qz);
        result.a11 = s * (q0 * q0 - qx * qx + qy * qy - qz * qz);
        result.a12 = s * 2.0f * (qy * qz - q0 * qx);
        result.a20 = s * 2.0f * (qz * qx - q0 * qy);
        result.a21 = s * 2.0f * (qz * qy + q0 * qx);
        result.a22 = s * (q0 * q0 - qx * qx - qy * qy + qz * qz);
        result.apply(c1x, c1y, c1z);
        result.a03 = c2x - result.x;
        result.a13 = c2y - result.y;
        result.a23 = c2z - result.z;
        return result;
    }

    public static FloatMatrix average(FloatMatrix[] array) {
        FloatMatrix result = new FloatMatrix();
        int n = 0;
        for (int i = 0; i < array.length; ++i) {
            if (array[i] == null) continue;
            ++n;
            result.a00 += array[i].a00;
            result.a01 += array[i].a01;
            result.a02 += array[i].a02;
            result.a03 += array[i].a03;
            result.a10 += array[i].a10;
            result.a11 += array[i].a11;
            result.a12 += array[i].a12;
            result.a13 += array[i].a13;
            result.a20 += array[i].a20;
            result.a21 += array[i].a21;
            result.a22 += array[i].a22;
            result.a23 += array[i].a23;
        }
        if (n > 0) {
            result.a00 /= (float)n;
            result.a01 /= (float)n;
            result.a02 /= (float)n;
            result.a03 /= (float)n;
            result.a10 /= (float)n;
            result.a11 /= (float)n;
            result.a12 /= (float)n;
            result.a13 /= (float)n;
            result.a20 /= (float)n;
            result.a21 /= (float)n;
            result.a22 /= (float)n;
            result.a23 /= (float)n;
        }
        return result;
    }

    public float[] rowwise16() {
        return new float[]{this.a00, this.a01, this.a02, this.a03, this.a10, this.a11, this.a12, this.a13, this.a20, this.a21, this.a22, this.a23, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public static FloatMatrix parseMatrix(String m) {
        FloatMatrix matrix = new FloatMatrix();
        StringTokenizer tokenizer = new StringTokenizer(m);
        try {
            boolean is4x4Columns = true;
            matrix.a00 = Float.parseFloat(tokenizer.nextToken());
            matrix.a10 = Float.parseFloat(tokenizer.nextToken());
            matrix.a20 = Float.parseFloat(tokenizer.nextToken());
            float dummy = Float.parseFloat(tokenizer.nextToken());
            if (dummy != 0.0f) {
                is4x4Columns = false;
                matrix.a03 = dummy;
            }
            matrix.a01 = Float.parseFloat(tokenizer.nextToken());
            matrix.a11 = Float.parseFloat(tokenizer.nextToken());
            matrix.a21 = Float.parseFloat(tokenizer.nextToken());
            dummy = Float.parseFloat(tokenizer.nextToken());
            if (is4x4Columns && dummy != 0.0f) {
                is4x4Columns = false;
            }
            if (!is4x4Columns) {
                matrix.a13 = dummy;
            }
            matrix.a02 = Float.parseFloat(tokenizer.nextToken());
            matrix.a12 = Float.parseFloat(tokenizer.nextToken());
            matrix.a22 = Float.parseFloat(tokenizer.nextToken());
            dummy = Float.parseFloat(tokenizer.nextToken());
            if (is4x4Columns && dummy != 0.0f) {
                is4x4Columns = false;
            }
            if (!is4x4Columns) {
                matrix.a23 = dummy;
            }
            if (is4x4Columns) {
                if (!tokenizer.hasMoreTokens()) {
                    is4x4Columns = false;
                }
            } else if (tokenizer.hasMoreTokens()) {
                throw new RuntimeException("Not a uniform matrix: " + m);
            }
            if (is4x4Columns) {
                matrix.a03 = Float.parseFloat(tokenizer.nextToken());
                matrix.a13 = Float.parseFloat(tokenizer.nextToken());
                matrix.a23 = Float.parseFloat(tokenizer.nextToken());
                if (Float.parseFloat(tokenizer.nextToken()) != 1.0f) {
                    throw new RuntimeException("Not a uniform matrix: " + m);
                }
            } else {
                dummy = matrix.a01;
                matrix.a01 = matrix.a10;
                matrix.a10 = dummy;
                dummy = matrix.a02;
                matrix.a02 = matrix.a20;
                matrix.a20 = dummy;
                dummy = matrix.a12;
                matrix.a12 = matrix.a21;
                matrix.a21 = dummy;
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return matrix;
    }

    public static FloatMatrix[] parseMatrices(String m) {
        Vector<FloatMatrix> vector = new Vector<FloatMatrix>();
        StringTokenizer tokenizer = new StringTokenizer(m, ",");
        while (tokenizer.hasMoreTokens()) {
            String matrix = tokenizer.nextToken().trim();
            if (matrix.equals("")) {
                vector.add(null);
                continue;
            }
            vector.add(FloatMatrix.parseMatrix(matrix));
        }
        FloatMatrix[] result = new FloatMatrix[vector.size()];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (FloatMatrix)vector.get(i);
        }
        return result;
    }

    public static FloatMatrix fromCalibration(ImagePlus image) {
        Calibration calib = image.getCalibration();
        FloatMatrix result = new FloatMatrix();
        result.a00 = (float)Math.abs(calib.pixelWidth);
        result.a11 = (float)Math.abs(calib.pixelHeight);
        result.a22 = (float)Math.abs(calib.pixelDepth);
        result.a03 = (float)calib.xOrigin;
        result.a13 = (float)calib.yOrigin;
        result.a23 = (float)calib.zOrigin;
        return result;
    }

    public static FloatMatrix translateToCenter(ImagePlus image) {
        Calibration calib = image.getCalibration();
        FloatMatrix result = new FloatMatrix();
        result.a00 = 1.0f;
        result.a11 = 1.0f;
        result.a22 = 1.0f;
        result.a03 = (float)(calib.xOrigin + calib.pixelWidth * (double)image.getWidth() / 2.0);
        result.a13 = (float)(calib.yOrigin + calib.pixelHeight * (double)image.getHeight() / 2.0);
        result.a23 = (float)(calib.yOrigin + calib.pixelDepth * (double)image.getStack().getSize() / 2.0);
        return result;
    }

    public final boolean isIdentity() {
        return this.isIdentity(1.0E-10f);
    }

    public final boolean equals(FloatMatrix other) {
        float eps = 1.0E-10f;
        return eps > Math.abs(this.a00 - other.a00) && eps > Math.abs(this.a01 - other.a01) && eps > Math.abs(this.a02 - other.a02) && eps > Math.abs(this.a03 - other.a03) && eps > Math.abs(this.a10 - other.a10) && eps > Math.abs(this.a11 - other.a11) && eps > Math.abs(this.a12 - other.a12) && eps > Math.abs(this.a13 - other.a13) && eps > Math.abs(this.a20 - other.a20) && eps > Math.abs(this.a21 - other.a21) && eps > Math.abs(this.a22 - other.a22) && eps > Math.abs(this.a23 - other.a23);
    }

    public final boolean isIdentity(float eps) {
        return eps > Math.abs(this.a00 - 1.0f) && eps > Math.abs(this.a11 - 1.0f) && eps > Math.abs(this.a22 - 1.0f) && eps > Math.abs(this.a01) && eps > Math.abs(this.a02) && eps > Math.abs(this.a03) && eps > Math.abs(this.a10) && eps > Math.abs(this.a12) && eps > Math.abs(this.a13) && eps > Math.abs(this.a20) && eps > Math.abs(this.a21) && eps > Math.abs(this.a23);
    }

    public void copyToFlatFloatArray(float[] result) {
        result[0] = this.a00;
        result[1] = this.a01;
        result[2] = this.a02;
        result[3] = this.a03;
        result[4] = this.a10;
        result[5] = this.a11;
        result[6] = this.a12;
        result[7] = this.a13;
        result[8] = this.a20;
        result[9] = this.a21;
        result[10] = this.a22;
        result[11] = this.a23;
    }

    public void setFromFlatFloatArray(float[] result) {
        this.a00 = result[0];
        this.a01 = result[1];
        this.a02 = result[2];
        this.a03 = result[3];
        this.a10 = result[4];
        this.a11 = result[5];
        this.a12 = result[6];
        this.a13 = result[7];
        this.a20 = result[8];
        this.a21 = result[9];
        this.a22 = result[10];
        this.a23 = result[11];
    }

    public String resultToString() {
        return "" + this.x + " " + this.y + " " + this.z;
    }

    public String toStringIndented(String indent) {
        String result = indent + this.a00 + ", " + this.a01 + ", " + this.a02 + ", " + this.a03 + "\n";
        result = result + indent + this.a10 + ", " + this.a11 + ", " + this.a12 + ", " + this.a13 + "\n";
        result = result + indent + this.a20 + ", " + this.a21 + ", " + this.a22 + ", " + this.a23 + "\n";
        return result;
    }

    public String toString() {
        return "" + this.a00 + " " + this.a01 + " " + this.a02 + " " + this.a03 + "   " + this.a10 + " " + this.a11 + " " + this.a12 + " " + this.a13 + "   " + this.a20 + " " + this.a21 + " " + this.a22 + " " + this.a23 + "   ";
    }

    public String toStringForAmira() {
        return "" + this.a00 + " " + this.a10 + " " + this.a20 + " 0 " + this.a01 + " " + this.a11 + " " + this.a21 + " 0 " + this.a02 + " " + this.a12 + " " + this.a22 + " 0 " + this.a03 + " " + this.a13 + " " + this.a23 + " 1";
    }

    public static void main(String[] args) {
        FloatMatrix ma = FloatMatrix.rotateFromTo(1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f);
        ma.apply(0.0f, 0.0f, 1.0f);
        System.err.println("expect 0 0 1: " + ma.x + " " + ma.y + " " + ma.z);
        ma.apply(1.0f, 0.0f, 0.0f);
        System.err.println("expect 0 1 0: " + ma.x + " " + ma.y + " " + ma.z);
        ma.apply(0.0f, 1.0f, 0.0f);
        System.err.println("expect -1 0 0: " + ma.x + " " + ma.y + " " + ma.z);
    }
}

