/*
 * Decompiled with CFR 0.152.
 */
package vib;

import distance.PixelPairs;
import distance.TwoValues;
import ij.ImagePlus;
import ij.measure.Calibration;
import java.util.ArrayList;
import java.util.StringTokenizer;
import math3d.Point3d;
import vib.FastMatrix;
import vib.InterpolatedImage;
import vib.RegistrationOptimizer;
import vib.TransformedImage;
import vib.VIB;

public class RigidRegistration {
    String[] materials1;
    String[] materials2;
    protected boolean verbose = false;
    static FastMatrix lastResult;

    public static int guessLevelFromWidth(int width) {
        int level = 0;
        while (width >> level > 20) {
            ++level;
        }
        return level;
    }

    public FastMatrix rigidRegistration(TransformedImage trans, String materialBBox, String initial, int mat1, int mat2, boolean noOptimization, int level, int stopLevel, double tolerance, int nInitialPositions, boolean showTransformed, boolean showDifferenceImage, boolean fastButInaccurate, ArrayList<ImagePlus> alsoTransform) {
        FastMatrix matrix;
        if (mat1 >= 0) {
            trans.narrowSearchToMaterial(mat1, 10);
        }
        Point3d center = null;
        if (materialBBox != null && !materialBBox.equals("")) {
            center = this.parseMaterialBBox(trans, materialBBox);
        }
        double[] params = null;
        if (initial != null && !initial.equals("")) {
            params = new double[9];
            try {
                if (center == null) {
                    center = this.getCenter(trans.transform, mat1);
                }
                FastMatrix m = FastMatrix.parseMatrix(initial);
                if (mat2 >= 0) {
                    m.apply(center);
                    Point3d p = this.getCenter(trans.orig, mat2);
                    p = p.minus(m.getResult());
                    m = FastMatrix.translate(p.x, p.y, p.z).times(m);
                }
                m.guessEulerParameters(params, center);
            }
            catch (Exception e) {
                StringTokenizer t = new StringTokenizer(initial);
                for (int i = 0; i < 9; ++i) {
                    params[i] = Double.parseDouble(t.nextToken());
                }
            }
        }
        if (!noOptimization) {
            Optimizer opt = fastButInaccurate ? new FastOptimizer(trans, level, stopLevel, tolerance, this.verbose) : new Optimizer(trans, level, stopLevel, tolerance, this.verbose);
            opt.eulerParameters = params;
            if (opt.eulerParameters == null) {
                FastMatrix[] results = new FastMatrix[nInitialPositions];
                double[] badnees = new double[nInitialPositions];
                for (int i = 0; i < nInitialPositions; ++i) {
                    opt.eulerParameters = null;
                    results[i] = opt.doRegister(level - stopLevel, i);
                    badnees[i] = opt.calculateBadness(results[i]);
                }
                double best = Double.MAX_VALUE;
                int bestIndex = -1;
                for (int i = 0; i < badnees.length; ++i) {
                    if (!(badnees[i] < best)) continue;
                    best = badnees[i];
                    bestIndex = i;
                }
                matrix = results[bestIndex];
                if (this.verbose) {
                    System.out.println("winner was " + (bestIndex + 1) + " with matrix" + matrix);
                    System.out.println("... and score: " + badnees[bestIndex]);
                }
            } else {
                matrix = opt.doRegister(level - stopLevel);
            }
            opt = null;
        } else {
            try {
                matrix = FastMatrix.parseMatrix(initial);
            }
            catch (Exception e) {
                StringTokenizer t = new StringTokenizer(initial);
                for (int i = 0; i < 9; ++i) {
                    params[i] = Double.parseDouble(t.nextToken());
                }
                matrix = RegistrationOptimizer.getEulerMatrix(params);
            }
        }
        trans.setTransformation(matrix);
        if (this.verbose) {
            VIB.println(matrix.toString());
        }
        if (showTransformed) {
            trans.getTransformed().show();
        }
        if (showDifferenceImage) {
            trans.getDifferenceImage().show();
        }
        ImagePlus template = trans.getTemplate();
        PixelPairs measure = trans.measure;
        trans = null;
        System.gc();
        System.gc();
        if (alsoTransform != null) {
            for (ImagePlus toTransform : alsoTransform) {
                TransformedImage transOther = new TransformedImage(template, toTransform);
                transOther.measure = measure;
                transOther.measure.reset();
                transOther.setTransformation(matrix);
                ImagePlus result = transOther.getTransformed();
                transOther = null;
                System.gc();
                System.gc();
                result.setTitle("Transformed " + toTransform.getTitle());
                result.show();
            }
        }
        return matrix;
    }

    Point3d parseMaterialBBox(TransformedImage trans, String bbox) {
        StringTokenizer t = new StringTokenizer(bbox);
        try {
            Point3d center = new Point3d();
            center.x = Double.parseDouble(t.nextToken());
            center.y = Double.parseDouble(t.nextToken());
            center.z = Double.parseDouble(t.nextToken());
            double x0 = Double.parseDouble(t.nextToken());
            double x1 = Double.parseDouble(t.nextToken());
            double y0 = Double.parseDouble(t.nextToken());
            double y1 = Double.parseDouble(t.nextToken());
            double z0 = Double.parseDouble(t.nextToken());
            double z1 = Double.parseDouble(t.nextToken());
            FastMatrix toOrig = trans.fromOrig.inverse();
            toOrig.apply(x0, y0, z0);
            Point3d llf = toOrig.getResult();
            toOrig.apply(x1, y1, z1);
            Point3d urb = toOrig.getResult();
            trans.narrowBBox((int)llf.x - 10, (int)Math.ceil(urb.x) + 10, (int)llf.y - 10, (int)Math.ceil(urb.y) + 10, (int)llf.z - 10, (int)Math.ceil(urb.z) + 10);
            return center;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
    }

    Point3d getCenter(InterpolatedImage ii, int mat1) {
        if (mat1 >= 0) {
            return ii.getCenterOfGravity(mat1);
        }
        return ii.getCenterOfGravity();
    }

    public static String getLastResult() {
        return lastResult.toStringForAmira();
    }

    static class FastOptimizer
    extends Optimizer {
        private int centerX;
        private int centerY;
        private int centerZ;
        private Point3d start;
        private Point3d stop;
        private Point3d current = new Point3d();

        public FastOptimizer(TransformedImage trans, int startLevel, int stopLevel, double tol, boolean verbose) {
            super(trans, startLevel, stopLevel, tol, verbose);
        }

        @Override
        public void getInitialCenters() {
            super.getInitialCenters();
            Calibration calib = this.t.orig.getImage().getCalibration();
            this.centerX = (int)Math.round((this.origC.x - calib.xOrigin) / calib.pixelWidth);
            this.centerY = (int)Math.round((this.origC.y - calib.yOrigin) / calib.pixelHeight);
            this.centerZ = (int)Math.round((this.origC.z - calib.zOrigin) / calib.pixelDepth);
        }

        public void initStartStop(int i0, int j0, int k0, int i1, int j1, int k1) {
            this.t.matrix.apply(i0, j0, k0);
            this.start = this.t.matrix.getResult();
            this.t.matrix.apply(i1, j1, k1);
            this.stop = this.t.matrix.getResult().minus(this.start);
        }

        public void calculateCurrent(int i, int total) {
            this.current.x = this.start.x + (double)i * this.stop.x / (double)total;
            this.current.y = this.start.y + (double)i * this.stop.y / (double)total;
            this.current.z = this.start.z + (double)i * this.stop.z / (double)total;
        }

        @Override
        public double calculateBadness(FastMatrix matrix) {
            float vTrans;
            float vOrig;
            int j;
            int i;
            this.t.setTransformation(matrix);
            this.t.measure.reset();
            for (i = 0; i < this.t.orig.w; ++i) {
                this.initStartStop(i, 0, this.centerZ, i, this.t.orig.h, this.centerZ);
                for (j = 0; j < this.t.orig.h; ++j) {
                    this.calculateCurrent(j, this.t.orig.h);
                    vOrig = this.t.orig.getNoInterpol(i, j, this.centerZ);
                    vTrans = (float)this.t.transform.interpol.get(this.current.x, this.current.y, this.current.z);
                    this.t.measure.add(vOrig, vTrans);
                }
            }
            for (i = 0; i < this.t.orig.d; ++i) {
                this.initStartStop(0, this.centerY, i, this.t.orig.w, this.centerY, i);
                for (j = 0; j < this.t.orig.w; ++j) {
                    this.calculateCurrent(j, this.t.orig.w);
                    vOrig = this.t.orig.getNoInterpol(j, this.centerY, i);
                    vTrans = (float)this.t.transform.interpol.get(this.current.x, this.current.y, this.current.z);
                    this.t.measure.add(vOrig, vTrans);
                }
            }
            for (i = 0; i < this.t.orig.d; ++i) {
                this.initStartStop(this.centerX, 0, i, this.centerX, this.t.orig.h, i);
                for (j = 0; j < this.t.orig.h; ++j) {
                    this.calculateCurrent(j, this.t.orig.h);
                    vOrig = this.t.orig.getNoInterpol(this.centerX, j, i);
                    vTrans = (float)this.t.transform.interpol.get(this.current.x, this.current.y, this.current.z);
                    this.t.measure.add(vOrig, vTrans);
                }
            }
            return this.t.measure.distance();
        }
    }

    static class Optimizer
    extends RegistrationOptimizer {
        TransformedImage t;
        int start;
        int stop;
        double tolerance;

        public Optimizer(TransformedImage trans, int startLevel, int stopLevel, double tol, boolean verbose) {
            this.verbose = verbose;
            this.t = stopLevel < 2 ? trans : trans.resample(1 << stopLevel - 1);
            this.start = startLevel;
            this.stop = stopLevel;
            this.tolerance = tol;
        }

        public FastMatrix doRegister(int level) {
            return this.doRegister(level, 0);
        }

        public FastMatrix doRegister(int level, int initialGuessPlace) {
            if (level > 0) {
                TransformedImage backup = this.t;
                this.t = this.t.resample(2);
                this.t.setTransformation(this.doRegister(level - 1));
                this.t = backup;
                System.gc();
                System.gc();
            }
            if (this.verbose) {
                VIB.println("level is " + (this.start - level));
            }
            double factor = 1 << this.start - level;
            int minFactor = 1 << this.start;
            this.angleMax = 0.7853981633974483 * factor / (double)minFactor;
            this.translateMax = 20.0 * factor / (double)minFactor;
            if (this.eulerParameters == null) {
                this.eulerParameters = this.searchInitialEulerParams()[initialGuessPlace];
            }
            return this.doRegister(this.tolerance / factor);
        }

        @Override
        public void getInitialCenters() {
            if (this.t.measure instanceof TwoValues) {
                TwoValues d = (TwoValues)this.t.measure;
                int m1 = d.getMaterial(0);
                int m2 = d.getMaterial(1);
                this.transC = this.t.transform.getCenterOfGravity(m1);
                this.origC = this.t.orig.getCenterOfGravity(m2);
            } else {
                this.transC = this.t.transform.getCenterOfGravity();
                this.origC = this.t.orig.getCenterOfGravity();
            }
        }

        @Override
        public double calculateBadness(FastMatrix matrix) {
            this.t.setTransformation(matrix);
            return this.t.getDistance();
        }
    }
}

