/*
 * Decompiled with CFR 0.152.
 */
package vib;

import ij.IJ;
import ij.gui.ImageWindow;
import ij.gui.NewImage;
import ij.measure.Measurements;
import ij.plugin.filter.Analyzer;
import ij.process.ImageProcessor;
import ij.text.TextWindow;
import java.awt.Button;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Rectangle;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.CharArrayWriter;
import java.io.PrintWriter;

public class ShowHistogram
extends ImageWindow
implements Measurements,
ActionListener,
ClipboardOwner {
    static final int WIN_WIDTH = 300;
    static final int WIN_HEIGHT = 240;
    static final int HIST_WIDTH = 256;
    static final int HIST_HEIGHT = 128;
    static final int BAR_HEIGHT = 12;
    static final int XMARGIN = 20;
    static final int YMARGIN = 10;
    protected double[] histogram;
    protected double histMin;
    protected double binSize;
    protected Rectangle frame = null;
    protected Button list;
    protected Button save;
    protected Button copy;
    protected Button log;
    protected Label value;
    protected Label count;
    protected static String defaultDirectory = null;
    protected int decimalPlaces;
    protected int digits;
    protected int newMinCount;
    protected int newMaxCount;
    protected int plotScale = 1;
    protected boolean logScale;
    protected int yMax;
    public static int nBins = 256;

    public ShowHistogram(double[] histogram, double histMin, double binSize) {
        super(NewImage.createByteImage((String)"Histogram", (int)300, (int)240, (int)1, (int)4));
        this.histogram = histogram;
        this.histMin = histMin;
        this.binSize = binSize;
        this.showHistogram(0.0, 0.0);
    }

    public ShowHistogram(long[] histogram, int histMin) {
        super(NewImage.createByteImage((String)"Histogram", (int)300, (int)240, (int)1, (int)4));
        this.histogram = new double[histogram.length];
        for (int i = 0; i < histogram.length; ++i) {
            this.histogram[i] = histogram[i];
        }
        this.histMin = histMin;
        this.binSize = 1.0;
        this.showHistogram(0.0, 0.0);
    }

    public void showHistogram(double min, double max) {
        this.setup();
        this.drawHistogram(this.imp.getProcessor());
        this.imp.updateAndDraw();
    }

    public void setup() {
        Panel buttons = new Panel();
        buttons.setLayout(new FlowLayout(2));
        this.list = new Button("List");
        this.list.addActionListener(this);
        buttons.add(this.list);
        this.copy = new Button("Copy");
        this.copy.addActionListener(this);
        buttons.add(this.copy);
        this.log = new Button("Log");
        this.log.addActionListener(this);
        buttons.add(this.log);
        Panel valueAndCount = new Panel();
        valueAndCount.setLayout(new GridLayout(2, 1));
        this.value = new Label("                  ");
        this.value.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.value);
        this.count = new Label("                  ");
        this.count.setFont(new Font("Monospaced", 0, 12));
        valueAndCount.add(this.count);
        buttons.add(valueAndCount);
        this.add(buttons);
        this.pack();
    }

    public void mouseMoved(int x, int y) {
        if (this.value == null || this.count == null) {
            return;
        }
        if (this.frame != null && x >= this.frame.x && x <= this.frame.x + this.frame.width) {
            if ((x -= this.frame.x) > 255) {
                x = 255;
            }
            int index = (int)((double)x * (double)this.histogram.length / 256.0);
            this.value.setText("  Value: " + IJ.d2s((double)(this.histMin + (double)index * this.binSize), (int)this.digits));
            this.count.setText("  Count: " + this.histogram[index]);
        } else {
            this.value.setText("");
            this.count.setText("");
        }
    }

    protected void drawHistogram(ImageProcessor ip) {
        double minCount2 = this.histogram[0];
        double maxCount2 = this.histogram[0];
        int mode2 = 0;
        ip.setColor(Color.black);
        ip.setLineWidth(1);
        this.decimalPlaces = Analyzer.getPrecision();
        this.digits = this.binSize != 1.0 ? this.decimalPlaces : 0;
        for (int i = 1; i < this.histogram.length; ++i) {
            if (this.histogram[i] > maxCount2) {
                maxCount2 = this.histogram[i];
                mode2 = i;
                continue;
            }
            if (!(this.histogram[i] < minCount2)) continue;
            minCount2 = this.histogram[i];
        }
        this.drawPlot(minCount2, maxCount2, ip);
        int x = 21;
        int y = 140;
        this.drawText(ip, x, y += 27);
    }

    void drawPlot(double minCount, double maxCount, ImageProcessor ip) {
        if (maxCount <= minCount) {
            maxCount = minCount + 1.0;
        }
        this.newMinCount = (int)minCount;
        this.newMaxCount = (int)maxCount;
        System.err.println("min/max: " + minCount + "/" + maxCount);
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        for (int i = 0; i < 256; ++i) {
            int index = (int)((double)i * (double)this.histogram.length / 256.0);
            int y = (int)(128.0 * (this.histogram[index] - minCount) / (maxCount - minCount));
            if (y > 128) {
                y = 128;
            }
            ip.drawLine(i + 20, 138, i + 20, 138 - y);
        }
    }

    void drawLogPlot(int maxCount, ImageProcessor ip) {
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.drawRect(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height + 1);
        double max = Math.log(maxCount);
        ip.setColor(Color.gray);
        for (int i = 0; i < 256; ++i) {
            int y;
            int index = (int)((double)i * (double)this.histogram.length / 256.0);
            int n = y = this.histogram[index] == 0.0 ? 0 : (int)(128.0 * Math.log(this.histogram[index]) / max);
            if (y > 128) {
                y = 128;
            }
            ip.drawLine(i + 20, 138, i + 20, 138 - y);
        }
        ip.setColor(Color.black);
    }

    void drawText(ImageProcessor ip, int x, int y) {
        ip.setFont(new Font("SansSerif", 0, 12));
        ip.setAntialiasedText(true);
        double hmin = this.histMin;
        double hmax = this.histMin + this.binSize * (double)(this.histogram.length - 1);
        ip.drawString(this.d2s(hmin), x - 4, y);
        ip.drawString(this.d2s(hmax), x + 256 - this.getWidth(hmax, ip) + 10, y);
        this.binSize = Math.abs(this.binSize);
        boolean showBins = this.binSize != 1.0;
        int col1 = 25;
        int col2 = 148;
        int row1 = y + 25;
        if (showBins) {
            row1 -= 8;
        }
        int row2 = row1 + 15;
        int row3 = row2 + 15;
        int row4 = row3 + 15;
        ip.drawString("Count: " + this.histogram.length, col1, row1);
        double total = 0.0;
        double mean = 0.0;
        double var = 0.0;
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        for (int i = 0; i < this.histogram.length; ++i) {
            mean += (double)i * this.histogram[i];
            var += (double)(i * i) * this.histogram[i];
            total += this.histogram[i];
            if (min > this.histogram[i]) {
                min = this.histogram[i];
            }
            if (!(max < this.histogram[i])) continue;
            max = this.histogram[i];
        }
        if (total > 0.0) {
            mean /= total;
            var /= total;
        }
        double stdDev = Math.sqrt(var - mean * mean) * this.binSize;
        mean = this.histMin + mean * this.binSize;
        ip.drawString("Mean: " + this.d2s(mean), col1, row2);
        ip.drawString("StdDev: " + this.d2s(stdDev), col1, row3);
        ip.drawString("Min: " + this.d2s(min), col2, row1);
        ip.drawString("Max: " + this.d2s(max), col2, row2);
        if (showBins) {
            ip.drawString("Bins: " + this.d2s(this.histogram.length), col1, row4);
            ip.drawString("Bin Width: " + this.d2s(this.binSize), col2, row4);
        }
    }

    String d2s(double d) {
        if (d == Double.MAX_VALUE || d == -1.7976931348623157E308) {
            return "0";
        }
        if (Double.isNaN(d)) {
            return "NaN";
        }
        if (Double.isInfinite(d)) {
            return "Infinity";
        }
        if ((double)((int)d) == d) {
            return IJ.d2s((double)d, (int)0);
        }
        return IJ.d2s((double)d, (int)this.decimalPlaces);
    }

    int getWidth(double d, ImageProcessor ip) {
        return ip.getStringWidth(this.d2s(d));
    }

    protected void showList() {
        StringBuffer sb = new StringBuffer();
        String vheading = this.binSize == 1.0 ? "value" : "bin start";
        for (int i = 0; i < this.histogram.length; ++i) {
            sb.append(IJ.d2s((double)(this.histMin + (double)i * this.binSize), (int)this.digits) + "\t" + this.histogram[i] + "\n");
        }
        TextWindow tw = new TextWindow(this.getTitle(), vheading + "\tcount", sb.toString(), 200, 400);
    }

    protected void copyToClipboard() {
        Clipboard systemClipboard = null;
        try {
            systemClipboard = this.getToolkit().getSystemClipboard();
        }
        catch (Exception e) {
            systemClipboard = null;
        }
        if (systemClipboard == null) {
            IJ.error((String)"Unable to copy to Clipboard.");
            return;
        }
        IJ.showStatus((String)"Copying histogram values...");
        CharArrayWriter aw = new CharArrayWriter(this.histogram.length * 4);
        PrintWriter pw = new PrintWriter(aw);
        for (int i = 0; i < this.histogram.length; ++i) {
            pw.print(IJ.d2s((double)(this.histMin + (double)i * this.binSize), (int)this.digits) + "\t" + this.histogram[i] + "\n");
        }
        String text = aw.toString();
        pw.close();
        StringSelection contents = new StringSelection(text);
        systemClipboard.setContents(contents, this);
        IJ.showStatus((String)(text.length() + " characters copied to Clipboard"));
    }

    void replot() {
        this.logScale = !this.logScale;
        ImageProcessor ip = this.imp.getProcessor();
        this.frame = new Rectangle(20, 10, 256, 128);
        ip.setColor(Color.white);
        ip.setRoi(this.frame.x - 1, this.frame.y, this.frame.width + 2, this.frame.height);
        ip.fill();
        ip.resetRoi();
        ip.setColor(Color.black);
        if (this.logScale) {
            this.drawLogPlot(this.newMaxCount, ip);
            this.drawPlot(this.newMinCount, this.newMaxCount, ip);
        } else {
            this.drawPlot(this.newMinCount, this.newMaxCount, ip);
        }
        this.imp.updateAndDraw();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object b = e.getSource();
        if (b == this.list) {
            this.showList();
        } else if (b == this.copy) {
            this.copyToClipboard();
        } else if (b == this.log) {
            this.replot();
        }
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }

    public double[] getHistogram() {
        return this.histogram;
    }
}

