/*
 * Decompiled with CFR 0.152.
 */
package vib.app;

import java.io.File;
import java.util.ArrayList;
import java.util.StringTokenizer;

public class FileGroup
extends ArrayList<File> {
    public String name;

    public FileGroup(String name) {
        this.name = name;
    }

    public void copy(FileGroup fg) {
        this.name = fg.name;
        this.clear();
        this.addAll(fg);
    }

    @Override
    public String toString() {
        String result = this.name + ":";
        for (int i = 0; i < this.size(); ++i) {
            result = result + " " + ((File)this.get(i)).getName();
        }
        return result;
    }

    public int getIndex(String name) {
        for (int i = 0; i < this.size(); ++i) {
            if (!((File)this.get(i)).getName().equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean add(String name) {
        return this.add(new File(name));
    }

    public void debug() {
        System.out.println("" + this);
    }

    public String toCSV() {
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                buf.append(',');
            }
            buf.append(((File)this.get(i)).getAbsolutePath());
        }
        return buf.toString();
    }

    public boolean fromCSV(String s) {
        boolean success = true;
        this.clear();
        StringTokenizer st = new StringTokenizer(s, ",");
        while (st.hasMoreTokens()) {
            String path = st.nextToken();
            File file = new File(path);
            if (this.add(file)) continue;
            success = false;
        }
        return success;
    }

    @Override
    public FileGroup clone() {
        FileGroup clone = new FileGroup(this.name);
        clone.addAll(this);
        return clone;
    }
}

