/*
 * Decompiled with CFR 0.152.
 */
package vib.app;

import ij.IJ;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import vib.app.FileGroup;

public class Options {
    public static final String CONFIG_FILE = "options.config";
    public static final int GREY = 0;
    public static final int LABEL_SURFACE = 1;
    public static final int CENTER = 2;
    public static final int LABEL_DIFFUSION = 3;
    public static final String[] TRANSFORMS = new String[]{"VIBgreyTransformation", "VIBlabelSurfaceTransformation", "VIBcenterTransformation", "VIBlabelDiffusionTransformation"};
    public static final String[] TRANSFORM_LABELS = new String[]{"RegistrationTransformation", "LabelSurfaceTransformation", "SCenterTransformation", "SLabelTransformation"};
    public String workingDirectory;
    public FileGroup fileGroup;
    public String templatePath;
    public int numChannels = 2;
    public int refChannel = 2;
    public int resamplingFactor = 1;
    public int transformationMethod = 3;

    public Options() {
        this.fileGroup = new FileGroup("NewFilegroup");
    }

    public Options(String dirname) {
        this.workingDirectory = dirname;
        File dir = new File(dirname);
        if (!dir.exists()) {
            dir.mkdir();
        } else {
            File optionsFile = new File(dirname, CONFIG_FILE);
            if (optionsFile.exists()) {
                this.loadFrom(optionsFile.getAbsolutePath());
            }
        }
        if (this.fileGroup == null) {
            this.fileGroup = new FileGroup("NewFilegroup");
        }
    }

    public Options(File dir) {
        this(dir.getAbsolutePath());
    }

    public void setTransformationMethod(String method) {
        for (int i = 0; i < TRANSFORMS.length; ++i) {
            if (!TRANSFORMS[i].equals(method)) continue;
            this.transformationMethod = i;
            return;
        }
        throw new RuntimeException("Unknown method: " + method);
    }

    public boolean needsLabels() {
        return Options.needsLabels(this.transformationMethod);
    }

    public static boolean needsLabels(int method) {
        return method != 0;
    }

    public boolean isTransformationValid(String method) {
        for (int i = 0; i < TRANSFORMS.length; ++i) {
            if (!TRANSFORMS[i].equals(method)) continue;
            return true;
        }
        return false;
    }

    public boolean isValid() {
        File dir = new File(this.workingDirectory);
        return !this.fileGroup.isEmpty() && this.templatePath != null && new File(this.templatePath).exists() && this.numChannels > 0 && this.refChannel > 0 && this.refChannel <= this.numChannels && dir.exists() && dir.isDirectory() && this.transformationMethod >= 0 && this.transformationMethod <= 3;
    }

    public Options clone() {
        Options clone = new Options();
        clone.copy(this);
        return clone;
    }

    public void copy(Options options) {
        this.workingDirectory = options.workingDirectory;
        this.templatePath = options.templatePath;
        this.numChannels = options.numChannels;
        this.refChannel = options.refChannel;
        this.fileGroup = options.fileGroup;
        this.transformationMethod = options.transformationMethod;
        this.resamplingFactor = options.resamplingFactor;
    }

    public void saveTo(String path) {
        Properties p = new Properties();
        p.setProperty("template", this.templatePath);
        p.setProperty("numChannels", "" + this.numChannels);
        p.setProperty("refChannel", "" + this.refChannel);
        p.setProperty("resamplingFactor", "" + this.resamplingFactor);
        p.setProperty("transformationMethod", TRANSFORMS[this.transformationMethod]);
        p.setProperty("fileGroup", this.fileGroup.toCSV());
        try {
            FileOutputStream out = new FileOutputStream(path);
            p.store(out, "Created by the VIB application");
        }
        catch (FileNotFoundException e) {
            IJ.showMessage((String)("Can't find file " + path));
        }
        catch (IOException e) {
            IJ.showMessage((String)("Can't write to file " + path));
        }
    }

    static int getInt(Properties p, String key, int default_value) {
        String value = p.getProperty(key);
        if (value == null) {
            return default_value;
        }
        return Integer.parseInt(value);
    }

    public void loadFrom(String path) {
        Properties p = new Properties();
        try {
            File file = new File(path);
            p.load(new FileInputStream(file));
            this.workingDirectory = file.getParentFile().getAbsolutePath();
        }
        catch (FileNotFoundException e) {
            IJ.showMessage((String)("Can't find file " + path));
            return;
        }
        catch (IOException e) {
            IJ.showMessage((String)("Can't read from file " + path));
            return;
        }
        this.templatePath = p.getProperty("template", "");
        this.numChannels = Options.getInt(p, "numChannels", 2);
        this.refChannel = Options.getInt(p, "refChannel", 2);
        String t = p.getProperty("transformationMethod");
        try {
            this.setTransformationMethod(t);
        }
        catch (Exception e) {
            this.transformationMethod = 3;
        }
        this.resamplingFactor = Options.getInt(p, "resamplingFactor", 1);
        if (!this.fileGroup.fromCSV(p.getProperty("fileGroup", ""))) {
            IJ.showMessage((String)"Not all files specified in the file group exist.");
        }
        if (!this.isValid()) {
            IJ.showMessage((String)"There occured an error while setting the options. I set some of them, but you should check them manually.");
            return;
        }
    }

    public String toString() {
        return "Options:\nworkingDirectory = " + this.workingDirectory + "\ntemplate = " + this.templatePath + "\nnumChannels = " + this.numChannels + "\nrefChannel = " + this.refChannel + "\ntransformationMethod = " + this.transformationMethod + "\nresamplingFactor = " + this.resamplingFactor + "\nfileGroup: " + this.fileGroup;
    }

    public void debug() {
        System.out.print("\n" + this);
    }

    public static void main(String[] args) {
        System.out.println("Options");
        if (args.length > 0) {
            Options o = new Options();
            if (args[0].equals("--save") && args.length > 1) {
                o.saveTo(args[1]);
            } else {
                o.loadFrom(args[0]);
            }
            o.debug();
        }
    }
}

