/*
 * Decompiled with CFR 0.152.
 */
package vib.oldregistration;

import ij.ImagePlus;
import landmarks.NamedPointSet;
import math3d.Point3d;
import util.BatchOpener;
import util.FileAndChannel;

public abstract class RegistrationAlgorithm {
    public boolean keepSourceImages;
    public ImagePlus[] sourceImages;
    boolean validTransformation = false;

    public ImagePlus getTemplate() {
        return this.sourceImages[0];
    }

    public ImagePlus getDomain() {
        return this.sourceImages[1];
    }

    public ImagePlus getModel() {
        return this.sourceImages[0];
    }

    public ImagePlus getFloating() {
        return this.sourceImages[1];
    }

    public void loadImages(FileAndChannel f0, FileAndChannel f1) {
        ImagePlus[] f0imps = BatchOpener.open(f0.getPath());
        ImagePlus[] f1imps = BatchOpener.open(f1.getPath());
        this.sourceImages = new ImagePlus[2];
        this.sourceImages[0] = f0imps[f0.getChannelZeroIndexed()];
        this.sourceImages[1] = f1imps[f1.getChannelZeroIndexed()];
        this.invalidateTransformation();
    }

    public void invalidateTransformation() {
        this.validTransformation = false;
    }

    public void validateTransformation() {
        this.validTransformation = true;
    }

    public boolean isTransformationValid() {
        return this.validTransformation;
    }

    public void setImages(ImagePlus template, ImagePlus domain) {
        if (this.sourceImages == null) {
            this.sourceImages = new ImagePlus[2];
        }
        this.sourceImages[0] = template;
        this.sourceImages[1] = domain;
        this.invalidateTransformation();
    }

    public void generateTransformation() {
        throw new RuntimeException("generateTransformation() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public void transformDomainToTemplate(int x, int y, int z, ImagePoint result) {
        throw new RuntimeException("transformDomainToTemplate() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public void transformDomainToTemplateWorld(double x, double y, double z, Point3d result) {
        throw new RuntimeException("transformDomainToTemplateWorld() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public void transformTemplateToDomain(int x, int y, int z, ImagePoint result) {
        throw new RuntimeException("transformTemplateToDomain() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public void transformTemplateToDomainWorld(double x, double y, double z, Point3d result) {
        throw new RuntimeException("transformTemplateToDomainWorld() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public ImagePlus register() {
        throw new RuntimeException("register() not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public ImagePlus register(NamedPointSet templatePointSet, NamedPointSet floatingPointSet) {
        throw new RuntimeException("register(NamedPointSet,NamedPointSet) not implemented for this objects of this class (" + this.getClass() + ")");
    }

    public static class ImagePoint {
        public int x;
        public int y;
        public int z;
    }
}

