/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.kymographBuilder;

import ij.gui.Line;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import java.util.ArrayList;
import java.util.List;
import sc.fiji.kymographBuilder.Segment;

public class LinesBuilder {
    private Roi roi;
    List<Segment> lines;
    private int lineWidth;
    private List<Integer> linesLength;
    private List<double[]> linesVectorScaled;
    private int totalLength;

    public LinesBuilder(Roi roi) {
        this.roi = roi;
    }

    public List<Segment> getLines() {
        return this.lines;
    }

    public List<Integer> getLinesLength() {
        return this.linesLength;
    }

    public List<double[]> getLinesVectorScaled() {
        return this.linesVectorScaled;
    }

    public int getTotalLength() {
        return this.totalLength;
    }

    public int getlineWidth() {
        return this.lineWidth;
    }

    public void build() {
        this.buildLines();
        this.buildVector();
        this.lineWidth = Math.round(this.roi.getStrokeWidth());
        this.lineWidth = this.lineWidth < 1 ? 1 : this.lineWidth;
    }

    private void buildLines() {
        this.lines = new ArrayList<Segment>();
        if (this.roi.getTypeAsString().equals("Straight Line")) {
            Line lineRoi = (Line)this.roi;
            Segment line = new Segment(lineRoi.x1, lineRoi.y1, lineRoi.x2, lineRoi.y2);
            this.lines.add(line);
        } else {
            PolygonRoi roiPoly = (PolygonRoi)this.roi;
            for (int i = 0; i < roiPoly.getPolygon().npoints - 1; ++i) {
                int xStart = roiPoly.getPolygon().xpoints[i];
                int yStart = roiPoly.getPolygon().ypoints[i];
                int xEnd = roiPoly.getPolygon().xpoints[i + 1];
                int yEnd = roiPoly.getPolygon().ypoints[i + 1];
                Segment line = new Segment(xStart, yStart, xEnd, yEnd);
                this.lines.add(line);
            }
        }
    }

    private void buildVector() {
        this.linesLength = new ArrayList<Integer>();
        this.linesVectorScaled = new ArrayList<double[]>();
        this.totalLength = 0;
        for (Segment line : this.lines) {
            int length = (int)Math.round(line.getLength());
            this.linesLength.add(length);
            this.linesVectorScaled.add(line.getScaledVector());
            this.totalLength += length;
        }
    }
}

