/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import ij.ImagePlus;
import ij.gui.GenericDialog;
import ini.trakem2.ControlWindow;
import ini.trakem2.Project;
import ini.trakem2.display.Bucket;
import ini.trakem2.display.Bucketable;
import ini.trakem2.display.Coordinate;
import ini.trakem2.display.DLabel;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.DoStep;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Overlay;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Profile;
import ini.trakem2.persistence.DBObject;
import ini.trakem2.persistence.XMLOptions;
import ini.trakem2.tree.LayerThing;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.M;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import mpicbg.models.NoninvertibleModelException;

public final class Layer
extends DBObject
implements Bucketable,
Comparable<Layer> {
    private final ArrayList<Displayable> al_displayables = new ArrayList();
    Bucket root = null;
    private HashMap<Displayable, HashSet<Bucket>> db_map = null;
    private double z = 0.0;
    private double thickness = 0.0;
    private LayerSet parent;
    public static final Comparator<Layer> COMPARATOR = new Comparator<Layer>(){

        @Override
        public final int compare(Layer l1, Layer l2) {
            if (l1 == l2) {
                return 0;
            }
            if (l1.getZ() < l2.getZ()) {
                return -1;
            }
            return 1;
        }

        @Override
        public final boolean equals(Object ob) {
            return this == ob;
        }
    };
    public static final int IMAGEPROCESSOR = 0;
    public static final int PIXELARRAY = 1;
    public static final int IMAGE = 2;
    public static final int IMAGEPLUS = 3;
    private boolean use_buckets = true;
    private Overlay overlay = null;

    public Layer(Project project, double z, double thickness, LayerSet parent) {
        super(project);
        this.z = z;
        this.thickness = thickness;
        this.parent = parent;
        this.addToDatabase();
    }

    public Layer(Project project, long id, double z, double thickness) {
        super(project, id);
        this.z = z;
        this.thickness = thickness;
        this.parent = null;
    }

    public Layer(Project project, long id, HashMap<String, String> ht_attributes) {
        super(project, id);
        this.parent = null;
        String data = ht_attributes.get("z");
        if (null != data) {
            this.z = Double.parseDouble(data);
        } else {
            Displayable.xmlError(this, "z", this.z);
        }
        data = ht_attributes.get("thickness");
        if (null != data) {
            this.thickness = Double.parseDouble(data);
        } else {
            Displayable.xmlError(this, "thickness", this.thickness);
        }
    }

    public static Layer create(Project project, LayerSet parent) {
        if (null == parent) {
            return null;
        }
        GenericDialog gd = ControlWindow.makeGenericDialog("New Layer");
        gd.addMessage("In pixels:");
        gd.addNumericField("z coordinate: ", 0.0, 3);
        gd.addNumericField("thickness: ", 1.0, 3);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        try {
            double z = gd.getNextNumber();
            double thickness = gd.getNextNumber();
            if (Double.isNaN(z) || Double.isNaN(thickness)) {
                return null;
            }
            Layer layer = new Layer(project, z, thickness, parent);
            parent.add(layer);
            parent.recreateBuckets(layer, true);
            return layer;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static List<Layer> createMany(Project project, LayerSet parent) {
        if (null == parent) {
            return null;
        }
        GenericDialog gd = ControlWindow.makeGenericDialog("Many new layers");
        gd.addNumericField("First Z coord: ", 0.0, 3);
        gd.addNumericField("thickness: ", 1.0, 3);
        gd.addNumericField("Number of layers: ", 1.0, 0);
        gd.addCheckbox("Skip existing layers", true);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        double z = gd.getNextNumber();
        double thickness = gd.getNextNumber();
        int n_layers = (int)gd.getNextNumber();
        boolean skip = gd.getNextBoolean();
        if (thickness < 0.0) {
            Utils.log("Can't create layers with negative thickness");
            return null;
        }
        if (n_layers < 1) {
            Utils.log("Invalid number of layers");
            return null;
        }
        ArrayList<Layer> layers = new ArrayList<Layer>(n_layers);
        for (int i = 0; i < n_layers; ++i) {
            Layer la = null;
            la = skip ? (null == (la = parent.getLayer(z)) ? new Layer(project, z, thickness, parent) : null) : new Layer(project, z, thickness, parent);
            if (null != la) {
                parent.addSilently(la);
                layers.add(la);
            }
            z += thickness;
        }
        parent.recreateBuckets(layers, true);
        Display.updateLayerScroller(parent);
        return layers;
    }

    public String getPrintableTitle() {
        LayerThing lt = this.project.findLayerThing(this);
        if (null == lt) {
            return this.toString();
        }
        String title = lt.getTitle();
        title = null == title ? "" : title.replace(' ', '_');
        StringBuilder sb = new StringBuilder().append(this.parent.indexOf(this) + 1);
        int s_size = Integer.toString(this.parent.size()).length();
        while (sb.length() < s_size) {
            sb.insert(0, '0');
        }
        sb.append('_').append('_').append(title).append('_').append('_').append('z').append(Utils.cutNumber(this.z, 3, true));
        return sb.toString();
    }

    public String toString() {
        if (null == this.parent) {
            return "z=" + Utils.cutNumber(this.z, 4);
        }
        String unit = this.parent.getCalibration().getUnit();
        if (unit.equals("pixel")) {
            return "z=" + Utils.cutNumber(this.z, 4);
        }
        return "z=" + this.z * this.parent.getCalibration().pixelWidth + " " + unit + " (" + Utils.cutNumber(this.z, 4) + " px)";
    }

    public void add(Displayable displ) {
        this.add(displ, true);
    }

    public void add(Displayable displ, boolean update_displays) {
        this.add(displ, update_displays, true);
    }

    public void add(Displayable displ, boolean update_displays, boolean update_db) {
        if (null == displ || -1 != this.al_displayables.indexOf(displ)) {
            return;
        }
        if (displ.getProject() != this.project) {
            throw new IllegalArgumentException("Layer rejected a Displayable: belongs to a different project.");
        }
        int i = -1;
        int j = -1;
        Displayable[] d = new Displayable[this.al_displayables.size()];
        this.al_displayables.toArray(d);
        int stack_index = 0;
        if (displ instanceof Patch) {
            i = 0;
            while (i < d.length && d[i] instanceof Patch) {
                j = i++;
            }
            if (-1 != j) {
                if (++j >= d.length) {
                    this.al_displayables.add(displ);
                    stack_index = d.length;
                } else {
                    this.al_displayables.add(j, displ);
                    stack_index = j;
                }
            } else {
                this.al_displayables.add(0, displ);
                stack_index = 0;
            }
        } else if (displ instanceof Profile) {
            for (i = d.length - 1; i > -1; --i) {
                if (d[i] instanceof DLabel || d[i] instanceof LayerSet) continue;
                j = i;
                break;
            }
            if (-1 != j) {
                if (++j >= d.length) {
                    this.al_displayables.add(displ);
                    stack_index = d.length;
                } else {
                    this.al_displayables.add(j, displ);
                    stack_index = j;
                }
            } else {
                this.al_displayables.add(displ);
                stack_index = d.length;
            }
        } else if (displ instanceof LayerSet) {
            for (i = d.length - 1; i > -1; --i) {
                if (d[i] instanceof DLabel) continue;
                j = i;
                break;
            }
            if (-1 != j) {
                if (++j >= d.length) {
                    this.al_displayables.add(displ);
                    stack_index = d.length;
                } else {
                    this.al_displayables.add(j, displ);
                    stack_index = j;
                }
            } else {
                this.al_displayables.add(displ);
                stack_index = d.length;
            }
        } else {
            this.al_displayables.add(displ);
            stack_index = d.length;
        }
        if (update_db) {
            this.updateInDatabase("stack_index");
            displ.setLayer(this);
        } else {
            displ.setLayer(this, false);
        }
        if (null != this.root) {
            if (d.length == stack_index) {
                this.root.put(stack_index, displ, this, this.db_map);
            } else {
                this.root.put(d.length, displ, this, this.db_map);
                this.root.updateRange((Bucketable)this, displ, stack_index, d.length);
            }
        }
        if (update_displays) {
            Display.add(this, displ);
        }
    }

    @Override
    public HashMap<Displayable, HashSet<Bucket>> getBucketMap(Layer layer) {
        return this.db_map;
    }

    public void addSilently(DBObject displ) {
        if (null == displ || -1 != this.al_displayables.indexOf(displ)) {
            return;
        }
        try {
            ((Displayable)displ).setLayer(this, false);
            this.al_displayables.add((Displayable)displ);
        }
        catch (Exception e) {
            Utils.log("Layer.addSilently: Not a Displayable/LayerSet, not adding DBObject id=" + displ.getId());
            return;
        }
    }

    public synchronized boolean remove(Displayable displ) {
        if (null == displ || null == this.al_displayables) {
            Utils.log2("Layer can't remove Displayable " + displ.getId());
            return false;
        }
        int old_stack_index = this.al_displayables.indexOf(displ);
        if (-1 == old_stack_index) {
            Utils.log2("Layer.remove: not found: " + displ);
            return false;
        }
        this.al_displayables.remove(old_stack_index);
        if (null != this.root) {
            this.recreateBuckets();
        }
        this.parent.removeFromOffscreens(this);
        Display.remove(this, displ);
        return true;
    }

    public synchronized boolean removeAll(Set<Displayable> ds) {
        if (null == ds || null == this.al_displayables) {
            return false;
        }
        Iterator<Displayable> it = this.al_displayables.iterator();
        while (it.hasNext()) {
            Displayable d = it.next();
            if (!ds.contains(d)) continue;
            it.remove();
            this.parent.removeFromOffscreens(this);
            Display.remove(this, d);
        }
        if (null != this.root) {
            this.recreateBuckets();
        }
        Display.updateVisibleTabs(this.project);
        return true;
    }

    public void setParentSilently(LayerSet layer_set) {
        if (layer_set == this.parent) {
            return;
        }
        this.parent = layer_set;
    }

    public void setParent(LayerSet layer_set) {
        if (layer_set == this.parent) {
            return;
        }
        this.parent = layer_set;
        this.updateInDatabase("layer_set_id");
    }

    public LayerSet getParent() {
        return this.parent;
    }

    public double getZ() {
        return this.z;
    }

    public double getThickness() {
        return this.thickness;
    }

    public double getCalibratedZ() {
        return this.z * this.parent.getCalibration().pixelWidth;
    }

    public double getCalibratedThickness() {
        return this.thickness * this.parent.getCalibration().pixelWidth;
    }

    @Override
    public boolean remove(boolean check) {
        try {
            if (check && !Utils.check("Really delete " + this.toString() + " and all its children?")) {
                return false;
            }
            Display.remove(this);
            Displayable[] displ = new Displayable[this.al_displayables.size()];
            this.al_displayables.toArray(displ);
            for (int i = 0; i < displ.length; ++i) {
                if (displ[i].remove2(false)) continue;
                Utils.log("Could not delete " + displ[i]);
                return false;
            }
            this.al_displayables.clear();
            this.parent.remove(this);
            Display.updateLayerScroller(this.parent);
            this.removeFromDatabase();
        }
        catch (Exception e) {
            IJError.print(e);
            return false;
        }
        return true;
    }

    public void setZ(double z) {
        if (Double.isNaN(z) || z == this.z) {
            return;
        }
        this.z = z;
        if (null != this.parent) {
            LayerThing p;
            this.parent.reposition(this);
            LayerThing lt = this.project.findLayerThing(this);
            if (null != lt && null != (p = (LayerThing)lt.getParent())) {
                p.removeChild(lt);
                p.addChild(lt);
            }
        }
        this.updateInDatabase("z");
    }

    public void setThickness(double thickness) {
        if (Double.isNaN(thickness) || thickness == this.thickness) {
            return;
        }
        this.thickness = thickness;
        this.updateInDatabase("thickness");
    }

    public boolean contains(int x, int y, int inset) {
        if (inset < 0) {
            inset = -inset;
        }
        return x >= inset && y >= inset && (float)x <= this.parent.getLayerWidth() - (float)inset && (float)y <= this.parent.getLayerHeight() - (float)inset;
    }

    public boolean contains(Displayable displ) {
        return -1 != this.al_displayables.indexOf(displ);
    }

    public boolean contains(Class<?> c) {
        for (Displayable ob : this.al_displayables) {
            if (ob.getClass() != c) continue;
            return true;
        }
        return false;
    }

    public boolean contains(Class<?> c, boolean visible_only) {
        for (Displayable d : this.al_displayables) {
            if (visible_only && !d.isVisible() || d.getClass() != c) continue;
            return true;
        }
        return false;
    }

    public int count(Class<?> c) {
        int n = 0;
        for (Displayable ob : this.al_displayables) {
            if (ob.getClass() != c) continue;
            ++n;
        }
        return n;
    }

    public boolean isEmpty() {
        return 0 == this.al_displayables.size() && this.parent.isEmptyAt(this);
    }

    public synchronized ArrayList<Displayable> getDisplayables() {
        return new ArrayList<Displayable>(this.al_displayables);
    }

    public final ArrayList<Displayable> getDisplayableList() {
        return this.al_displayables;
    }

    public synchronized int getNDisplayables() {
        return this.al_displayables.size();
    }

    public synchronized <T extends Displayable> ArrayList<T> getAll(Class<T> c) {
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        if (null == c) {
            return al;
        }
        if (Displayable.class == c) {
            al.addAll(this.al_displayables);
            return al;
        }
        for (Displayable d : this.al_displayables) {
            if (d.getClass() != c) continue;
            al.add(d);
        }
        return al;
    }

    public synchronized ArrayList<Displayable> getDisplayables(Class<?> c) {
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        if (null == c) {
            return al;
        }
        if (Displayable.class == c) {
            al.addAll(this.al_displayables);
            return al;
        }
        for (Displayable d : this.al_displayables) {
            if (d.getClass() != c) continue;
            al.add(d);
        }
        return al;
    }

    public synchronized ArrayList<Displayable> getDisplayables(Class<?> c, boolean visible_only, boolean instance_of) {
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        if (null == c) {
            return al;
        }
        if (instance_of) {
            for (Displayable d : this.al_displayables) {
                if (visible_only && !d.isVisible() || !c.isAssignableFrom(d.getClass())) continue;
                al.add(d);
            }
        } else {
            for (Displayable d : this.al_displayables) {
                if (visible_only && !d.isVisible() || d.getClass() != c) continue;
                al.add(d);
            }
        }
        return al;
    }

    public synchronized ArrayList<Patch> getPatches(boolean visible_only) {
        ArrayList<Patch> al = new ArrayList<Patch>();
        for (Displayable d : this.al_displayables) {
            if (visible_only && !d.isVisible() || d.getClass() != Patch.class) continue;
            al.add((Patch)d);
        }
        return al;
    }

    public Collection<Displayable> getDisplayables(Class<?> c, Rectangle roi) {
        return this.getDisplayables(c, new Area(roi), true, false);
    }

    public synchronized Collection<Displayable> getDisplayables(Class<?> c, Area aroi, boolean visible_only) {
        return this.getDisplayables(c, aroi, visible_only, false);
    }

    public synchronized Collection<Displayable> getDisplayables(Class<?> c, Area aroi, boolean visible_only, boolean instance_of) {
        if (null != this.root) {
            return this.root.find(c, aroi, this, visible_only, instance_of);
        }
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        if (Displayable.class == c) {
            for (Displayable d : this.al_displayables) {
                if (visible_only && !d.isVisible()) continue;
                Area area = d.getArea();
                area.intersect(aroi);
                Rectangle b = area.getBounds();
                if (0 == b.width || 0 == b.height) continue;
                al.add(d);
            }
            return al;
        }
        if (instance_of) {
            for (Displayable d : this.al_displayables) {
                if (visible_only && !d.isVisible() || !c.isAssignableFrom(d.getClass())) continue;
                Area area = d.getArea();
                area.intersect(aroi);
                Rectangle b = area.getBounds();
                if (0 == b.width || 0 == b.height) continue;
                al.add(d);
            }
        } else {
            for (Displayable d : this.al_displayables) {
                if (visible_only && !d.isVisible() || d.getClass() != c) continue;
                Area area = d.getArea();
                area.intersect(aroi);
                Rectangle b = area.getBounds();
                if (0 == b.width || 0 == b.height) continue;
                al.add(d);
            }
        }
        return al;
    }

    public synchronized ArrayList<Displayable> getDisplayables(Class<?> c, boolean visible_only) {
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (Displayable d : this.al_displayables) {
            if (d.getClass() != c || visible_only && !d.isVisible()) continue;
            al.add(d);
        }
        return al;
    }

    public Displayable get(long id) {
        for (Displayable d : this.al_displayables) {
            if (d.getId() != id) continue;
            return d;
        }
        return null;
    }

    @Override
    public float getLayerWidth() {
        return this.parent.getLayerWidth();
    }

    @Override
    public float getLayerHeight() {
        return this.parent.getLayerHeight();
    }

    public Collection<Displayable> find(double x, double y) {
        return this.find(x, y, false);
    }

    public synchronized Collection<Displayable> find(double x, double y, boolean visible_only) {
        if (null != this.root) {
            return this.root.find(x, y, this, visible_only);
        }
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (int i = this.al_displayables.size() - 1; i > -1; --i) {
            Displayable d = this.al_displayables.get(i);
            if (visible_only && !d.isVisible() || !d.contains(x, y)) continue;
            al.add(d);
        }
        return al;
    }

    public Collection<Displayable> find(Class<?> c, double x, double y) {
        return this.find(c, x, y, false, false);
    }

    public synchronized Collection<Displayable> find(Class<?> c, double x, double y, boolean visible_only) {
        return this.find(c, x, y, visible_only, false);
    }

    public synchronized Collection<Displayable> find(Class<?> c, double x, double y, boolean visible_only, boolean instance_of) {
        if (null != this.root) {
            return this.root.find(c, x, y, this, visible_only, instance_of);
        }
        if (Displayable.class == c) {
            return this.find(x, y, visible_only);
        }
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (int i = this.al_displayables.size() - 1; i > -1; --i) {
            Displayable d = this.al_displayables.get(i);
            if (visible_only && !d.isVisible() || d.getClass() != c || !d.contains(x, y)) continue;
            al.add(d);
        }
        return al;
    }

    public Collection<Displayable> find(Rectangle r) {
        return this.find(r, false);
    }

    public synchronized Collection<Displayable> find(Rectangle r, boolean visible_only) {
        if (null != this.root && this.root.isBetter(r, this)) {
            return this.root.find(r, this, visible_only);
        }
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (Displayable d : this.al_displayables) {
            if (visible_only && !d.isVisible() || !d.getBoundingBox().intersects(r)) continue;
            al.add(d);
        }
        return al;
    }

    public synchronized Collection<Displayable> find(Class<?> c, Rectangle r, boolean visible_only) {
        return this.find(c, r, visible_only, false);
    }

    public synchronized Collection<Displayable> find(Class<?> c, Rectangle r, boolean visible_only, boolean instance_of) {
        if (Displayable.class == c) {
            return this.find(r, visible_only);
        }
        if (null != this.root && this.root.isBetter(r, this)) {
            return this.root.find(c, r, this, visible_only, instance_of);
        }
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (Displayable d : this.al_displayables) {
            if (visible_only && !d.isVisible() || d.getClass() != c || !d.getBoundingBox().intersects(r)) continue;
            al.add(d);
        }
        return al;
    }

    public synchronized <T extends Displayable> Collection<T> getIntersecting(Displayable d, Class<T> target) {
        Area area;
        if (null != this.root && this.root.isBetter((area = new Area(d.getPerimeter())).getBounds(), this)) {
            return this.root.find(target, area, this, false, true);
        }
        ArrayList<Displayable> al = new ArrayList<Displayable>();
        for (int i = this.al_displayables.size() - 1; i > -1; --i) {
            Displayable da;
            Displayable ob = this.al_displayables.get(i);
            if (target.isAssignableFrom(ob.getClass()) || !d.intersects(da = ob)) continue;
            al.add(da);
        }
        return al;
    }

    public final int indexOf(Displayable d) {
        return this.al_displayables.indexOf(d);
    }

    public void moveUp(Displayable d) {
        int i = this.al_displayables.indexOf(d);
        if (null == d || -1 == i || this.al_displayables.size() - 1 == i) {
            return;
        }
        if (this.al_displayables.get(i + 1).getClass() != d.getClass()) {
            return;
        }
        this.al_displayables.remove(d);
        this.al_displayables.add(i + 1, d);
        this.updateInDatabase("stack_index");
        Display.updatePanelIndex(d.getLayer(), d);
        if (null != this.root) {
            this.root.updateRange((Bucketable)this, d, i, i + 1);
        }
    }

    public void moveDown(Displayable d) {
        int i = this.al_displayables.indexOf(d);
        if (null == d || -1 == i || 0 == i) {
            return;
        }
        if (this.al_displayables.get(i - 1).getClass() != d.getClass()) {
            return;
        }
        Displayable o = this.al_displayables.remove(i - 1);
        this.al_displayables.add(i, o);
        this.updateInDatabase("stack_index");
        Display.updatePanelIndex(d.getLayer(), d);
        if (null != this.root) {
            this.root.updateRange((Bucketable)this, d, i - 1, i);
        }
    }

    public void moveTop(Displayable d) {
        int j;
        int i = this.al_displayables.indexOf(d);
        int size = this.al_displayables.size();
        if (null == d || -1 == i || size - 1 == i) {
            return;
        }
        Class<?> c = d.getClass();
        boolean done = false;
        for (j = i + 1; j < size; ++j) {
            if (this.al_displayables.get(j).getClass() == c) continue;
            this.al_displayables.remove(d);
            this.al_displayables.add(--j, d);
            done = true;
            break;
        }
        if (!done) {
            this.al_displayables.remove(d);
            this.al_displayables.add(d);
            j = size - 1;
        }
        this.updateInDatabase("stack_index");
        Display.updatePanelIndex(d.getLayer(), d);
        if (null != this.root) {
            this.root.updateRange((Bucketable)this, d, i, j);
        }
    }

    public void moveBottom(Displayable d) {
        int j;
        int i = this.al_displayables.indexOf(d);
        if (null == d || -1 == i || 0 == i) {
            return;
        }
        Class<?> c = d.getClass();
        boolean done = false;
        for (j = i - 1; j > -1; --j) {
            if (this.al_displayables.get(j).getClass() == c) continue;
            this.al_displayables.remove(d);
            this.al_displayables.add(++j, d);
            done = true;
            break;
        }
        if (!done) {
            this.al_displayables.remove(d);
            this.al_displayables.add(0, d);
            j = 0;
        }
        this.updateInDatabase("stack_index");
        Display.updatePanelIndex(d.getLayer(), d);
        if (null != this.root) {
            this.root.updateRange((Bucketable)this, d, j, i);
        }
    }

    public boolean isTop(Displayable d) {
        int i = this.al_displayables.indexOf(d);
        int size = this.al_displayables.size();
        if (size - 1 == i) {
            return true;
        }
        return this.al_displayables.get(i + 1).getClass() != d.getClass();
    }

    public boolean isBottom(Displayable d) {
        int i = this.al_displayables.indexOf(d);
        if (0 == i) {
            return true;
        }
        return this.al_displayables.get(i - 1).getClass() != d.getClass();
    }

    public int relativeIndexOf(Displayable d) {
        int i;
        int k = this.al_displayables.indexOf(d);
        if (-1 == k) {
            return -1;
        }
        Class<?> c = d.getClass();
        int size = this.al_displayables.size();
        for (i = k + 1; i < size; ++i) {
            if (this.al_displayables.get(i).getClass() == c) continue;
            return i - k - 1;
        }
        if (i == size) {
            return i - k - 1;
        }
        Utils.log2("relativeIndexOf: return 0");
        return 0;
    }

    public HashSet<Displayable> setVisible(String type, boolean visible, boolean repaint) {
        if ((type = type.toLowerCase()).equals("image")) {
            type = "patch";
        }
        HashSet<Displayable> hs = new HashSet<Displayable>();
        for (Displayable d : this.al_displayables) {
            if (visible == d.isVisible() || !d.getClass().getName().toLowerCase().endsWith(type)) continue;
            d.setVisible(visible, false);
            hs.add(d);
        }
        if (repaint) {
            Display.repaint(this);
        }
        Display.updateCheckboxes(hs, 2, visible);
        return hs;
    }

    public Collection<Displayable> setAllVisible(boolean repaint) {
        ArrayList<Displayable> col = new ArrayList<Displayable>();
        for (Displayable d : this.al_displayables) {
            if (d.isVisible()) continue;
            d.setVisible(true, repaint);
            col.add(d);
        }
        return col;
    }

    public HashSet<Displayable> hideExcept(ArrayList<Class<?>> type, boolean repaint) {
        HashSet<Displayable> hs = new HashSet<Displayable>();
        for (Displayable d : this.al_displayables) {
            if (type.contains(d.getClass()) || !d.isVisible()) continue;
            d.setVisible(false, repaint);
            hs.add(d);
        }
        return hs;
    }

    @Override
    public void exportXML(StringBuilder sb_body, String indent, XMLOptions options) {
        String in = indent + "\t";
        sb_body.append(indent).append("<t2_layer oid=\"").append(this.id).append("\"\n").append(in).append(" thickness=\"").append(this.thickness).append("\"\n").append(in).append(" z=\"").append(this.z).append("\"\n");
        LayerThing lt = this.project.findLayerThing(this);
        String title = null == lt ? null : lt.getTitle();
        if (null == title) {
            title = "";
        }
        sb_body.append(in).append(" title=\"").append(title).append("\"\n");
        sb_body.append(indent).append(">\n");
        if (null != this.al_displayables) {
            for (Displayable d : this.al_displayables) {
                d.exportXML(sb_body, in, options);
            }
        }
        sb_body.append(indent).append("</t2_layer>\n");
    }

    public static void exportDTD(StringBuilder sb_header, HashSet<String> hs, String indent) {
        String type = "t2_layer";
        if (hs.contains("t2_layer")) {
            return;
        }
        hs.add("t2_layer");
        sb_header.append(indent).append("<!ELEMENT t2_layer (t2_patch,t2_label,t2_layer_set,t2_profile)>\n").append(indent).append("<!ATTLIST ").append("t2_layer").append(" oid").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer").append(" thickness").append(" NMTOKEN #REQUIRED>\n").append(indent).append("<!ATTLIST ").append("t2_layer").append(" z").append(" NMTOKEN #REQUIRED>\n");
    }

    protected String getLayerThingTitle() {
        LayerThing lt = this.project.findLayerThing(this);
        if (null == lt || null == lt.getTitle() || 0 == lt.getTitle().trim().length()) {
            return "";
        }
        return lt.getTitle();
    }

    @Override
    public String getTitle() {
        LayerThing lt = this.project.findLayerThing(this);
        if (null == lt || null == lt.getTitle() || 0 == lt.getTitle().trim().length()) {
            return this.toString();
        }
        return lt.getTitle();
    }

    public void destroy() {
        for (Displayable d : this.al_displayables) {
            d.destroy();
        }
    }

    public Rectangle getMinimalBoundingBox(Class<?> c) {
        return this.getMinimalBoundingBox(c, true);
    }

    public Rectangle getMinimalBoundingBox(Class<?> c, boolean visible_only) {
        Rectangle box = null;
        Rectangle tmp = new Rectangle();
        for (Displayable d : this.getDisplayables(c, visible_only)) {
            tmp = d.getBoundingBox(tmp);
            if (null == box) {
                box = (Rectangle)tmp.clone();
                continue;
            }
            box.add(tmp);
        }
        return box;
    }

    public Area getPatchArea(boolean visible_only) {
        Area area = new Area();
        for (Patch p : this.getAll(Patch.class)) {
            if (!visible_only || !p.isVisible()) continue;
            area.add(p.getArea());
        }
        return area;
    }

    public void apply(Class<?> c, AffineTransform at) {
        boolean all = Displayable.class == c;
        for (Displayable d : this.al_displayables) {
            if (!all && d.getClass() != c) continue;
            d.at.preConcatenate(at);
        }
        this.recreateBuckets();
    }

    public Layer clone(Project pr, LayerSet ls, Rectangle roi, boolean copy_id, boolean ignore_hidden_patches) {
        long nid = copy_id ? this.id : pr.getLoader().getNextId();
        Layer copy = new Layer(pr, nid, this.z, this.thickness);
        copy.parent = ls;
        for (Displayable d : this.find(roi)) {
            if (ignore_hidden_patches && !d.isVisible() && d.getClass() == Patch.class) continue;
            copy.addSilently(d.clone(pr, copy_id));
        }
        AffineTransform transform = new AffineTransform();
        transform.translate(-roi.x, -roi.y);
        copy.apply(Displayable.class, transform);
        return copy;
    }

    public Object grab(Rectangle r, double scale, Class<?> c, int c_alphas, int format, int type) {
        this.project.getLoader().releaseToFit(r.width, r.height, type, 1.1f);
        if (2 == format) {
            return this.project.getLoader().getFlatAWTImage(this, r, scale, c_alphas, type, c, null, true, Color.black);
        }
        ImagePlus imp = this.project.getLoader().getFlatImage(this, r, scale, c_alphas, type, c, null, true);
        switch (format) {
            case 3: {
                return imp;
            }
            case 0: {
                return imp.getProcessor();
            }
            case 1: {
                return imp.getProcessor().getPixels();
            }
        }
        return null;
    }

    public DBObject findById(long id) {
        if (this.id == id) {
            return this;
        }
        for (Displayable d : this.al_displayables) {
            if (d.getId() != id) continue;
            return d;
        }
        return null;
    }

    void linkPatchesR() {
        for (Displayable d : this.al_displayables) {
            if (d.getClass() == LayerSet.class) {
                ((LayerSet)d).linkPatchesR();
            }
            d.linkPatches();
        }
    }

    public void updateLayerTree() {
        this.project.getLayerTree().addLayer(this.parent, this);
        for (Displayable d : this.getDisplayables(LayerSet.class)) {
            ((LayerSet)d).updateLayerTree();
        }
    }

    public int[] getPixel(int x, int y, double mag) {
        Collection<Displayable> under = this.find(Patch.class, (double)x, y);
        if (null == under || under.isEmpty()) {
            return new int[3];
        }
        Patch pa = (Patch)under.iterator().next();
        return pa.getPixel(x, y, mag);
    }

    public synchronized void recreateBuckets() {
        this.root = new Bucket(0, 0, (int)(5.0E-5 + (double)this.getLayerWidth()), (int)(5.0E-5 + (double)this.getLayerHeight()), Bucket.getBucketSide(this, this));
        this.db_map = new HashMap();
        this.root.populate(this, this, this.db_map);
    }

    @Override
    public void updateBucket(Displayable d, Layer layer) {
        if (null != this.root) {
            this.root.updatePosition(d, this, this.db_map);
        }
    }

    public void checkBuckets() {
        if (this.use_buckets && (null == this.root || null == this.db_map)) {
            this.recreateBuckets();
        }
    }

    public void setBucketsEnabled(boolean b) {
        this.use_buckets = b;
        if (!this.use_buckets) {
            this.root = null;
        }
    }

    public synchronized Overlay getOverlay() {
        if (null == this.overlay) {
            this.overlay = new Overlay();
        }
        return this.overlay;
    }

    Overlay getOverlay2() {
        return this.overlay;
    }

    public synchronized Overlay setOverlay(Overlay o) {
        Overlay old = this.overlay;
        this.overlay = o;
        return old;
    }

    @Override
    public int compareTo(Layer layer) {
        double diff = this.z - layer.z;
        if (diff < 0.0) {
            return -1;
        }
        if (diff > 0.0) {
            return 1;
        }
        return 0;
    }

    public Coordinate<Patch> toPatchCoordinate(double world_x, double world_y) throws NoninvertibleTransformException, NoninvertibleModelException {
        Collection<Displayable> ps = this.find(Patch.class, world_x, world_y, true, false);
        Patch patch = null;
        if (ps.isEmpty()) {
            ArrayList<Patch> patches = this.getAll(Patch.class);
            if (patches.isEmpty()) {
                return null;
            }
            double minSqDist = Double.MAX_VALUE;
            for (Patch p : patches) {
                double d4;
                double d3;
                double d2;
                Rectangle b = p.getBoundingBox();
                double d1 = Math.pow((double)b.x - world_x, 2.0) + Math.pow((double)b.y - world_y, 2.0);
                double d = Math.min(d1, Math.min(d2 = Math.pow((double)(b.x + b.width) - world_x, 2.0) + Math.pow((double)b.y - world_y, 2.0), Math.min(d3 = Math.pow((double)b.x - world_x, 2.0) + Math.pow((double)(b.y + b.height) - world_y, 2.0), d4 = Math.pow((double)(b.x + b.width) - world_x, 2.0) + Math.pow((double)(b.y + b.height) - world_y, 2.0))));
                if (d < minSqDist) {
                    patch = p;
                    minSqDist = d;
                }
                if (!p.hasCoordinateTransform()) continue;
                for (Polygon pol : M.getPolygons(p.getArea())) {
                    for (int i = 0; i < pol.npoints; ++i) {
                        double sqDist = Math.pow((double)pol.xpoints[0] - world_x, 2.0) + Math.pow((double)pol.ypoints[1] - world_y, 2.0);
                        if (!(sqDist < minSqDist)) continue;
                        minSqDist = sqDist;
                        patch = p;
                    }
                }
            }
        } else {
            patch = (Patch)ps.iterator().next();
        }
        double[] point = patch.toPixelCoordinate(world_x, world_y);
        return new Coordinate<Patch>(point[0], point[1], patch.getLayer(), patch);
    }

    protected static class DoMoveDisplayable
    implements DoStep {
        final ArrayList<Displayable> al_displayables;
        final Layer layer;
        HashSet<DoStep> dependents = null;

        DoMoveDisplayable(Layer layer) {
            this.layer = layer;
            this.al_displayables = new ArrayList(layer.al_displayables);
        }

        @Override
        public boolean apply(int action) {
            this.layer.al_displayables.clear();
            this.layer.al_displayables.addAll(this.al_displayables);
            Display.update(this.layer);
            return true;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public Displayable getD() {
            return null;
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            if (!(ob instanceof DoMoveDisplayable)) {
                return false;
            }
            DoMoveDisplayable dm = (DoMoveDisplayable)ob;
            if (dm.layer != this.layer) {
                return false;
            }
            if (dm.al_displayables.size() != this.al_displayables.size()) {
                return false;
            }
            for (int i = 0; i < this.al_displayables.size(); ++i) {
                if (dm.al_displayables.get(i) == this.al_displayables.get(i)) continue;
                return false;
            }
            return true;
        }
    }

    static class DoContentChange
    implements DoStep {
        final Layer la;
        final ArrayList<Displayable> al;

        DoContentChange(Layer la) {
            this.la = la;
            this.al = la.getDisplayables();
        }

        @Override
        public Displayable getD() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            if (!(ob instanceof DoContentChange)) {
                return false;
            }
            DoContentChange dad = (DoContentChange)ob;
            if (this.la != dad.la || this.al.size() != dad.al.size()) {
                return false;
            }
            Iterator<Displayable> it1 = this.al.iterator();
            Iterator<Displayable> it2 = dad.al.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (it1.next() == it2.next()) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean apply(int action) {
            HashSet sub1 = new HashSet(this.la.al_displayables);
            sub1.removeAll(this.al);
            HashSet<Displayable> sub2 = new HashSet<Displayable>(this.al);
            sub2.removeAll(this.la.al_displayables);
            HashSet<Object> subA = null;
            HashSet<Displayable> subB = null;
            if (action == 0) {
                subA = sub1;
                subB = sub2;
            } else if (action == 1) {
                subA = sub2;
                subB = sub1;
            }
            if (null != subA && null != subB) {
                for (Displayable displayable : subA) {
                    if (displayable.getClass() != Patch.class) continue;
                    displayable.getProject().getLoader().queueForMipmapRemoval((Patch)displayable, true);
                }
                for (Displayable displayable : subB) {
                    if (displayable.getClass() != Patch.class) continue;
                    displayable.getProject().getLoader().queueForMipmapRemoval((Patch)displayable, false);
                }
            }
            this.la.al_displayables.clear();
            this.la.al_displayables.addAll(this.al);
            this.la.recreateBuckets();
            Display.updateVisibleTabs();
            Display.clearSelection();
            Display.update(this.la);
            return true;
        }
    }

    static class DoEditLayers
    implements DoStep {
        final ArrayList<DoEditLayer> all = new ArrayList();

        DoEditLayers(List<Layer> all) {
            for (Layer la : all) {
                this.all.add(new DoEditLayer(la));
            }
        }

        @Override
        public Displayable getD() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.all.isEmpty();
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            if (!(ob instanceof DoEditLayers)) {
                return false;
            }
            DoEditLayers other = (DoEditLayers)ob;
            if (this.all.size() != other.all.size()) {
                return false;
            }
            Iterator<DoEditLayer> it1 = this.all.iterator();
            Iterator<DoEditLayer> it2 = other.all.iterator();
            while (it1.hasNext() && it2.hasNext()) {
                if (it1.next().isIdenticalTo(it2.next())) continue;
                return false;
            }
            return true;
        }

        @Override
        public boolean apply(int action) {
            boolean failed = false;
            for (DoEditLayer one : this.all) {
                if (one.apply(action)) continue;
                failed = true;
            }
            return !failed;
        }
    }

    static class DoEditLayer
    implements DoStep {
        final double z;
        final double thickness;
        final Layer la;

        DoEditLayer(Layer layer) {
            this.la = layer;
            this.z = layer.z;
            this.thickness = layer.thickness;
        }

        @Override
        public Displayable getD() {
            return null;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean isIdenticalTo(Object ob) {
            if (!(ob instanceof Layer)) {
                return false;
            }
            Layer layer = (Layer)ob;
            return this.la.id == layer.id && this.z == layer.z && this.thickness == layer.thickness;
        }

        @Override
        public boolean apply(int action) {
            this.la.z = this.z;
            this.la.thickness = this.thickness;
            this.la.getProject().getLayerTree().updateUILater();
            Display.update(this.la.getParent());
            return true;
        }
    }
}

