/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.display;

import features.ComputeCurvatures;
import ij.ImagePlus;
import ij.measure.Calibration;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.display.Polyline;
import ini.trakem2.imaging.LayerStack;
import ini.trakem2.imaging.Segmentation;
import ini.trakem2.utils.Bureaucrat;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import ini.trakem2.utils.Worker;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashMap;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.display.imagej.ImageJFunctions;
import sc.fiji.snt.Path;
import sc.fiji.snt.SNT;
import sc.fiji.snt.SearchProgressCallback;
import sc.fiji.snt.tracing.SearchInterface;
import sc.fiji.snt.tracing.TracerThread;
import sc.fiji.snt.tracing.cost.Cost;
import sc.fiji.snt.tracing.cost.Reciprocal;
import sc.fiji.snt.tracing.heuristic.Euclidean;
import sc.fiji.snt.tracing.heuristic.Heuristic;

class SNTFunctions {
    SNTFunctions() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void trace(final Polyline line, Project project, Layer layer, final Display display, MouseEvent me, int x_pd, int y_pd) {
        Polyline.TraceParameters tr;
        if (line.layer_set.getDisplayables(Patch.class).isEmpty()) {
            Utils.log("No images are present!");
            return;
        }
        final double scale = line.layer_set.getVirtualizationScale();
        final Worker[] worker = new Worker[2];
        Polyline.TraceParameters tr_ = Polyline.tr_map.get(line.layer_set);
        Polyline.TraceParameters traceParameters = tr = null == tr_ ? new Polyline.TraceParameters() : tr_;
        if (null == tr_) {
            HashMap<LayerSet, Polyline.TraceParameters> hashMap = Polyline.tr_map;
            synchronized (hashMap) {
                Polyline.tr_map.put(line.layer_set, tr);
            }
        }
        if (tr.update) {
            worker[0] = new Worker("Preparing Hessian..."){

                @Override
                public void run() {
                    this.startedWorking();
                    try {
                        Utils.log("Push ESCAPE key to cancel autotrace anytime.");
                        ImagePlus virtual = new LayerStack(line.layer_set, scale, 0, Patch.class, display.getDisplayChannelAlphas(), Segmentation.fmp.SNT_invert_image).getImagePlus();
                        Calibration cal = virtual.getCalibration();
                        double minimumSeparation = 1.0;
                        if (cal != null) {
                            minimumSeparation = Math.min(cal.pixelWidth, Math.min(cal.pixelHeight, cal.pixelDepth));
                        }
                        ComputeCurvatures hessian = new ComputeCurvatures(virtual, minimumSeparation, null, cal != null);
                        hessian.run();
                        tr.virtual = virtual;
                        tr.hessian = hessian;
                        tr.update = false;
                    }
                    catch (Exception e) {
                        IJError.print(e);
                    }
                    this.finishedWorking();
                }
            };
            Bureaucrat.createAndStart(worker[0], project);
        }
        Point2D.Double po = line.transformPoint(line.p[0][line.n_points - 1], line.p[1][line.n_points - 1]);
        final int start_x = (int)po.x;
        final int start_y = (int)po.y;
        final int start_z = line.layer_set.indexOf(line.layer_set.getLayer(line.p_layer[line.n_points - 1]));
        final int goal_x = (int)((double)x_pd * scale);
        final int goal_y = (int)((double)y_pd * scale);
        final int goal_z = line.layer_set.indexOf(layer);
        final boolean simplify = me.isAltDown();
        worker[1] = new Worker("Tracer - waiting on hessian"){

            @Override
            public void run() {
                this.startedWorking();
                try {
                    int i;
                    if (null != worker[0]) {
                        worker[0].join();
                    }
                    this.setTaskName("Tracing path");
                    Img image = ImageJFunctions.wrap((ImagePlus)tr.virtual);
                    Calibration calibration = tr.virtual.getCalibration();
                    int timeoutSeconds = 120;
                    int reportEveryMilliseconds = 2000;
                    SNT.SearchImageType searchImageType = SNT.SearchImageType.ARRAY;
                    Reciprocal costFunction = new Reciprocal(0.0, 255.0);
                    Euclidean heuristic = new Euclidean(calibration);
                    tr.tracer = new TracerThread((RandomAccessibleInterval)image, calibration, start_x, start_y, start_z, goal_x, goal_y, goal_z, 120, 2000L, searchImageType, (Cost)costFunction, (Heuristic)heuristic);
                    ((TracerThread)tr.tracer).addProgressListener(new SearchProgressCallback(){

                        public void pointsInSearch(SearchInterface source, long inOpen, long inClosed) {
                            worker[1].setTaskName("Tracing path: open=" + inOpen + " closed=" + inClosed);
                        }

                        public void finished(SearchInterface source, boolean success) {
                            if (!success) {
                                Utils.logAll("Could NOT trace a path");
                            }
                        }

                        public void threadStatus(SearchInterface source, int currentStatus) {
                            if (worker[1].hasQuitted() && source instanceof Thread) {
                                ((Thread)source).interrupt();
                            }
                        }
                    });
                    ((TracerThread)tr.tracer).run();
                    Path result = ((TracerThread)tr.tracer).getResult();
                    tr.tracer = null;
                    if (null == result) {
                        Utils.log("Finding a path failed");
                        return;
                    }
                    int len = result.size();
                    double[][] pos = new double[3][len];
                    for (i = len - 1; i > -1; --i) {
                        pos[0][i] = result.getXUnscaledDouble(i);
                        pos[1][i] = result.getYUnscaledDouble(i);
                        pos[2][i] = result.getZUnscaledDouble(i);
                    }
                    for (i = len - 1; i > -1 && 0.0 == pos[0][i] && 0.0 == pos[1][i]; --i) {
                        --len;
                    }
                    AffineTransform aff = new AffineTransform();
                    aff.concatenate(line.at.createInverse());
                    aff.scale(1.0 / scale, 1.0 / scale);
                    double[] po = new double[len * 2];
                    int i2 = 0;
                    int j = 0;
                    while (i2 < len) {
                        po[j] = pos[0][i2];
                        po[j + 1] = pos[1][i2];
                        ++i2;
                        j += 2;
                    }
                    double[] po2 = new double[len * 2];
                    aff.transform(po, 0, po2, 0, len);
                    long[] p_layer_ids = new long[len];
                    double[] pox = new double[len];
                    double[] poy = new double[len];
                    int i3 = 0;
                    int j2 = 0;
                    while (i3 < len) {
                        p_layer_ids[i3] = line.layer_set.getLayer((int)pos[2][i3]).getId();
                        pox[i3] = po2[j2];
                        poy[i3] = po2[j2 + 1];
                        ++i3;
                        j2 += 2;
                    }
                    if (simplify) {
                        this.setTaskName("Simplifying path");
                        Object[] ob = Polyline.simplify(pox, poy, p_layer_ids, 10000, line.layer_set);
                        pox = (double[])ob[0];
                        poy = (double[])ob[1];
                        p_layer_ids = (long[])ob[2];
                        len = pox.length;
                    }
                    line.last_autotrace_start = line.n_points;
                    line.appendPoints(pox, poy, p_layer_ids, len);
                    line.repaint(true, null);
                    Utils.logAll("Added " + len + " new points.");
                }
                catch (Exception e) {
                    IJError.print(e);
                }
                this.finishedWorking();
            }
        };
        Bureaucrat.createAndStart(worker[1], project);
        Polyline.index = -1;
    }
}

