/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import ini.trakem2.utils.Utils;

public final class FastIntegralImage {
    public static final double[] doubleIntegralImage(byte[] b, int w, int h) {
        int w2 = w + 1;
        int h2 = h + 1;
        double[] f = new double[w2 * h2];
        int offset1 = 0;
        int offset2 = w2 + 1;
        for (int y = 0; y < h; ++y) {
            double s;
            f[offset2] = s = (double)(b[offset1] & 0xFF);
            for (int x = 1; x < w; ++x) {
                f[offset2 + x] = s += (double)(b[offset1 + x] & 0xFF);
            }
            offset1 += w;
            offset2 += w2;
        }
        for (int x = 1; x < w2; ++x) {
            double s = 0.0;
            int i = w2 + x;
            for (int y = 1; y < h2; ++y) {
                f[i] = s += f[i];
                i += w2;
            }
        }
        return f;
    }

    public static final double[] doubleIntegralImage(float[] b, int w, int h) {
        int w2 = w + 1;
        int h2 = h + 1;
        double[] f = new double[w2 * h2];
        int offset1 = 0;
        int offset2 = w2 + 1;
        for (int y = 0; y < h; ++y) {
            double s;
            f[offset2] = s = (double)b[offset1];
            for (int x = 1; x < w; ++x) {
                f[offset2 + x] = s += (double)b[offset1 + x];
            }
            offset1 += w;
            offset2 += w2;
        }
        for (int x = 1; x < w2; ++x) {
            double s = 0.0;
            int i = w2 + x;
            for (int y = 1; y < h2; ++y) {
                f[i] = s += f[i];
                i += w2;
            }
        }
        return f;
    }

    public static final long[] longIntegralImage(byte[] b, int w, int h) {
        int w2 = w + 1;
        int h2 = h + 1;
        long[] f = new long[w2 * h2];
        int offset1 = 0;
        int offset2 = w2 + 1;
        for (int y = 0; y < h; ++y) {
            long s;
            f[offset2] = s = (long)(b[offset1] & 0xFF);
            for (int x = 1; x < w; ++x) {
                f[offset2 + x] = s += (long)(b[offset1 + x] & 0xFF);
            }
            offset1 += w;
            offset2 += w2;
        }
        for (int x = 1; x < w2; ++x) {
            long s = 0L;
            int i = w2 + x;
            for (int y = 1; y < h2; ++y) {
                f[i] = s += f[i];
                i += w2;
            }
        }
        return f;
    }

    public static final long[] longIntegralImage(short[] b, int w, int h) {
        int w2 = w + 1;
        int h2 = h + 1;
        long[] f = new long[w2 * h2];
        int offset1 = 0;
        int offset2 = w2 + 1;
        for (int y = 0; y < h; ++y) {
            long s;
            f[offset2] = s = (long)(b[offset1] & 0xFFFF);
            for (int x = 1; x < w; ++x) {
                f[offset2 + x] = s += (long)(b[offset1 + x] & 0xFFFF);
            }
            offset1 += w;
            offset2 += w2;
        }
        for (int x = 1; x < w2; ++x) {
            long s = 0L;
            int i = w2 + x;
            for (int y = 1; y < h2; ++y) {
                f[i] = s += f[i];
                i += w2;
            }
        }
        return f;
    }

    public static final void test(String image_file_path) {
        int i;
        Object[] b = new byte[9];
        for (int i2 = 0; i2 < b.length; ++i2) {
            b[i2] = 1;
        }
        double[] f = FastIntegralImage.doubleIntegralImage(b, 3, 3);
        System.out.println("IntegralImage is correct: " + (9.0 == f[f.length - 1]));
        System.out.println(Utils.toString(f));
        ByteProcessor bp = (ByteProcessor)IJ.openImage((String)image_file_path).getProcessor();
        Object[] pix = (byte[])bp.getPixels();
        double[] fii = FastIntegralImage.doubleIntegralImage(pix, bp.getWidth(), bp.getHeight());
        byte[] scaled = FastIntegralImage.scaleAreaAverage(fii, bp.getWidth() + 1, bp.getHeight() + 1, bp.getWidth() / 4, bp.getHeight() / 4);
        float[] fpix = new float[fii.length];
        for (i = 0; i < fpix.length; ++i) {
            fpix[i] = (float)fii[i];
        }
        new ImagePlus("integral double", (ImageProcessor)new FloatProcessor(bp.getWidth() + 1, bp.getHeight() + 1, fpix, null)).show();
        new ImagePlus("scaled double", (ImageProcessor)new ByteProcessor(bp.getWidth() / 4, bp.getHeight() / 4, scaled, null)).show();
        b = new byte[9];
        for (int i3 = 0; i3 < b.length; ++i3) {
            b[i3] = 1;
        }
        long[] f2 = FastIntegralImage.longIntegralImage(b, 3, 3);
        System.out.println("IntegralImage is correct: " + (9L == f2[f2.length - 1]));
        System.out.println(Utils.toString(f2));
        bp = (ByteProcessor)IJ.openImage((String)image_file_path).getProcessor();
        pix = (byte[])bp.getPixels();
        long[] lii = FastIntegralImage.longIntegralImage(pix, bp.getWidth(), bp.getHeight());
        scaled = FastIntegralImage.scaleAreaAverage(lii, bp.getWidth() + 1, bp.getHeight() + 1, bp.getWidth() / 4, bp.getHeight() / 4);
        fpix = new float[lii.length];
        for (i = 0; i < fpix.length; ++i) {
            fpix[i] = lii[i];
        }
        new ImagePlus("integral long", (ImageProcessor)new FloatProcessor(bp.getWidth() + 1, bp.getHeight() + 1, fpix, null)).show();
        new ImagePlus("scaled long", (ImageProcessor)new ByteProcessor(bp.getWidth() / 4, bp.getHeight() / 4, scaled, null)).show();
        b = new short[9];
        for (int i4 = 0; i4 < b.length; ++i4) {
            b[i4] = 1;
        }
        long[] f3 = FastIntegralImage.longIntegralImage((short[])b, 3, 3);
        System.out.println("IntegralImage of a short[] is correct: " + (9L == f3[f3.length - 1]));
        System.out.println(Utils.toString(f3));
        bp = (ShortProcessor)IJ.openImage((String)image_file_path).getProcessor().convertToShort(true);
        pix = (short[])bp.getPixels();
        int i5 = 0;
        while (i5 < pix.length) {
            int n = i5++;
            pix[n] = (short)(pix[n] * 255);
        }
        lii = FastIntegralImage.longIntegralImage((short[])pix, bp.getWidth(), bp.getHeight());
        scaled = FastIntegralImage.scaleAreaAverage(lii, bp.getWidth() + 1, bp.getHeight() + 1, bp.getWidth() / 4, bp.getHeight() / 4);
        fpix = new float[lii.length];
        for (i = 0; i < fpix.length; ++i) {
            fpix[i] = lii[i];
        }
        new ImagePlus("integral long of short", (ImageProcessor)new FloatProcessor(bp.getWidth() + 1, bp.getHeight() + 1, fpix, null)).show();
        new ImagePlus("scaled long of short", (ImageProcessor)new ByteProcessor(bp.getWidth() / 4, bp.getHeight() / 4, scaled, null)).show();
    }

    public static final void main(String[] args) {
        new ImageJ();
        FastIntegralImage.test("/home/albert/Desktop/t2/test-mipmaps/src.tif");
    }

    public static final byte[] scaleAreaAverage(double[] f, int fw, int fh, int tw, int th) {
        byte[] b = new byte[tw * th];
        if (0 == (fw - 1) % tw && 0 == (fh - 1) % th) {
            int stepSizeX = (fw - 1) / tw;
            int stepSizeY = (fh - 1) / th;
            int area = stepSizeX * stepSizeY;
            int startY = 0;
            int o3 = 0;
            for (int y = 0; y < th; ++y) {
                int startX = 0;
                int o1 = startY * fw;
                int o2 = (startY + stepSizeY) * fw;
                for (int x = 0; x < tw; ++x) {
                    b[o3 + x] = (byte)((f[o1 + startX] - f[o1 + startX + stepSizeX] + f[o2 + startX + stepSizeX] - f[o2 + startX]) / (double)area + 0.5);
                    startX += stepSizeX;
                }
                startY += stepSizeY;
                o3 += tw;
            }
        } else {
            double stepSizeX = ((double)fw - 1.0) / (double)tw;
            double stepSizeY = ((double)fh - 1.0) / (double)th;
            double tmp2 = 0.5;
            int o3 = 0;
            for (int y = 0; y < th; ++y) {
                int startY = (int)tmp2;
                int vY = (int)(tmp2 + stepSizeY) - startY;
                int o1 = startY * fw;
                int o2 = (startY + vY) * fw;
                double tmp1 = 0.5;
                for (int x = 0; x < tw; ++x) {
                    int startX = (int)tmp1;
                    int vX = (int)(tmp1 + stepSizeX) - startX;
                    b[o3 + x] = (byte)((f[o1 + startX] - f[o1 + startX + vX] + f[o2 + startX + vX] - f[o2 + startX]) / (double)(vX * vY) + 0.5);
                    tmp1 += stepSizeX;
                }
                tmp2 += stepSizeY;
                o3 += tw;
            }
        }
        return b;
    }

    public static final byte[] scaleAreaAverage(long[] f, int fw, int fh, int tw, int th) {
        byte[] b = new byte[tw * th];
        if (0 == (fw - 1) % tw && 0 == (fh - 1) % th) {
            int stepSizeX = (fw - 1) / tw;
            int stepSizeY = (fh - 1) / th;
            int area = stepSizeX * stepSizeY;
            int startY = 0;
            int o3 = 0;
            for (int y = 0; y < th; ++y) {
                int startX = 0;
                int o1 = startY * fw;
                int o2 = (startY + stepSizeY) * fw;
                for (int x = 0; x < tw; ++x) {
                    b[o3 + x] = (byte)((float)((f[o1 + startX] - f[o1 + startX + stepSizeX] + f[o2 + startX + stepSizeX] - f[o2 + startX]) / (long)area) + 0.5f);
                    startX += stepSizeX;
                }
                startY += stepSizeY;
                o3 += tw;
            }
        } else {
            double stepSizeX = ((double)fw - 1.0) / (double)tw;
            double stepSizeY = ((double)fh - 1.0) / (double)th;
            double tmp2 = 0.5;
            int o3 = 0;
            for (int y = 0; y < th; ++y) {
                int startY = (int)tmp2;
                int vY = (int)(tmp2 + stepSizeY) - startY;
                int o1 = startY * fw;
                int o2 = (startY + vY) * fw;
                double tmp1 = 0.5;
                for (int x = 0; x < tw; ++x) {
                    int startX = (int)tmp1;
                    int vX = (int)(tmp1 + stepSizeX) - startX;
                    b[o3 + x] = (byte)((double)((f[o1 + startX] - f[o1 + startX + vX] + f[o2 + startX + vX] - f[o2 + startX]) / (long)(vX * vY)) + 0.5);
                    tmp1 += stepSizeX;
                }
                tmp2 += stepSizeY;
                o3 += tw;
            }
        }
        return b;
    }
}

