/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.ImagePlus;
import ij.process.ImageProcessor;
import ini.trakem2.imaging.filters.IFilter;
import java.util.Map;
import mpicbg.ij.clahe.Flat;

public class CLAHE
implements IFilter {
    protected int blockRadius = 63;
    protected int bins = 255;
    protected float slope = 3.0f;
    protected boolean fast = true;

    public CLAHE() {
    }

    public CLAHE(boolean fast, int blockRadius, int bins, float slope) {
        this.fast = fast;
        this.blockRadius = blockRadius;
        this.bins = bins;
        this.slope = slope;
    }

    public CLAHE(Map<String, String> params) {
        try {
            this.fast = Boolean.parseBoolean(params.get("fast"));
            this.blockRadius = Integer.parseInt(params.get("blockradius"));
            this.bins = Integer.parseInt(params.get("bins"));
            this.slope = Float.parseFloat(params.get("slope"));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Could not create CLAHE filter!", nfe);
        }
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        if (this.fast) {
            Flat.getFastInstance().run(new ImagePlus("", ip), this.blockRadius, this.bins, this.slope, null, false);
        } else {
            Flat.getInstance().run(new ImagePlus("", ip), this.blockRadius, this.bins, this.slope, null, false);
        }
        return ip;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" fast=\"" + this.fast + "\" blockradius=\"" + this.blockRadius + "\" bins=\"" + this.bins + "\" slope=\"" + this.slope + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() == CLAHE.class) {
            CLAHE c = (CLAHE)o;
            return this.bins == c.bins && this.blockRadius == c.blockRadius && this.slope == c.slope && this.fast == c.fast;
        }
        return false;
    }
}

