/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.process.ImageProcessor;
import ini.trakem2.imaging.filters.IFilter;
import java.util.Map;

public class RobustNormalizeLocalContrast
implements IFilter {
    protected int scaleLevel = 2;
    protected int brx1 = 1000;
    protected int bry1 = 1000;
    protected int brx2 = 500;
    protected int bry2 = 500;
    protected float stds1 = 2.0f;
    protected float stds2 = 3.0f;

    public RobustNormalizeLocalContrast() {
    }

    public RobustNormalizeLocalContrast(int scaleLevel, int blockRadiusX1, int blockRadiusY1, float stdDevs1, int blockRadiusX2, int blockRadiusY2, float stdDevs2) {
        this.set(scaleLevel, blockRadiusX1, blockRadiusY1, stdDevs1, blockRadiusX2, blockRadiusY2, stdDevs2);
    }

    private final void set(int scaleLevel, int blockRadiusX1, int blockRadiusY1, float stdDevs1, int blockRadiusX2, int blockRadiusY2, float stdDevs2) {
        this.scaleLevel = scaleLevel;
        this.brx1 = blockRadiusX1;
        this.bry1 = blockRadiusY1;
        this.stds1 = stdDevs1;
        this.brx2 = blockRadiusX2;
        this.bry2 = blockRadiusY2;
        this.stds2 = stdDevs2;
    }

    public RobustNormalizeLocalContrast(Map<String, String> params) {
        try {
            this.set(Integer.parseInt(params.get("scalelevel")), Integer.parseInt(params.get("brx1")), Integer.parseInt(params.get("bry1")), Float.parseFloat(params.get("stds1")), Integer.parseInt(params.get("brx2")), Integer.parseInt(params.get("bry2")), Float.parseFloat(params.get("stds2")));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalArgumentException("Could not create LocalContrast filter!", nfe);
        }
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        try {
            mpicbg.trakem2.util.RobustNormalizeLocalContrast.run(ip, this.scaleLevel, this.brx1, this.bry1, this.stds1, this.brx2, this.bry2, this.stds2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ip;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" scalelevel=\"" + this.scaleLevel + "\" brx1=\"" + this.brx1 + "\" bry1=\"" + this.bry1 + "\" stds1=\"" + this.stds1 + "\" brx2=\"" + this.brx2 + "\" bry2=\"" + this.bry2 + "\" stds2=\"" + this.stds2 + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() == RobustNormalizeLocalContrast.class) {
            RobustNormalizeLocalContrast c = (RobustNormalizeLocalContrast)o;
            return this.scaleLevel == c.scaleLevel && this.brx1 == c.brx1 && this.bry1 == c.bry1 && this.stds1 == c.stds1 && this.brx2 == c.brx2 && this.bry2 == c.bry2 && this.stds2 == c.stds2;
        }
        return false;
    }
}

