/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.imaging.filters;

import ij.plugin.filter.BackgroundSubtracter;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.imaging.filters.IFilter;
import java.util.Map;

public class SubtractBackground
implements IFilter {
    protected int radius = 50;

    public SubtractBackground() {
    }

    public SubtractBackground(int radius) {
        this.radius = radius;
    }

    public SubtractBackground(Map<String, String> params) {
        String s = params.get("radius");
        if (null != s) {
            try {
                this.radius = Integer.parseInt(s);
                return;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Could not create filter " + this.getClass().getName() + ": invalid or undefined radius!");
    }

    @Override
    public ImageProcessor process(ImageProcessor ip) {
        BackgroundSubtracter bs = new BackgroundSubtracter();
        if (ip instanceof ColorProcessor) {
            bs.subtractRGBBackround((ColorProcessor)ip, this.radius);
        } else {
            bs.subtractBackround(ip, this.radius);
        }
        return ip;
    }

    @Override
    public String toXML(String indent) {
        return indent + "<t2_filter class=\"" + this.getClass().getName() + "\" radius=\"" + this.radius + "\" />\n";
    }

    public boolean equals(Object o) {
        if (null == o) {
            return false;
        }
        if (o.getClass() == this.getClass()) {
            return ((SubtractBackground)o).radius == this.radius;
        }
        return false;
    }
}

