/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.io;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LoggingInputStream
extends BufferedInputStream {
    private long last = System.currentTimeMillis();
    private long n = 0L;
    private long accum_time = 0L;
    private long accum_bytes = 0L;

    public LoggingInputStream(InputStream in) {
        super(in);
    }

    @Override
    public int read() throws IOException {
        int m = super.read();
        this.n += (long)m;
        return m;
    }

    @Override
    public int read(byte[] b) throws IOException {
        int m = super.read(b);
        this.n += (long)m;
        return m;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int m = super.read(b, off, len);
        this.n += (long)m;
        return m;
    }

    public void resetInfo() {
        this.n = 0L;
        this.accum_bytes = 0L;
        this.last = System.currentTimeMillis();
        this.accum_time = 0L;
    }

    public void getInfo(long[] info) {
        long now = System.currentTimeMillis();
        this.accum_time += now - this.last;
        this.accum_bytes += this.n;
        info[0] = now;
        info[1] = now - this.last;
        info[2] = this.n;
        info[3] = this.accum_time;
        info[4] = this.accum_bytes;
        this.n = 0L;
        this.last = now;
    }
}

