/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.parallel;

import ini.trakem2.parallel.TaskFactory;
import ini.trakem2.utils.Utils;
import java.util.Collection;
import java.util.LinkedList;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;

public class Process {
    private static final int MIN_AHEAD = 4;
    public static final int NUM_PROCESSORS = Runtime.getRuntime().availableProcessors();

    static final int sensible(int nproc) {
        return Math.max(1, Math.min(nproc, NUM_PROCESSORS + 2));
    }

    public static final <I, O> void progressive(Iterable<I> inputs, TaskFactory<I, O> generator, Collection<O> outputs) throws Exception {
        Process.progressive(inputs, generator, outputs, NUM_PROCESSORS);
    }

    public static final <I, O> void progressive(Iterable<I> inputs, TaskFactory<I, O> generator, Collection<O> outputs, int n_proc) throws Exception {
        Process.process(inputs, generator, outputs, n_proc, true);
    }

    public static final <I, O> void unbound(Iterable<I> inputs, TaskFactory<I, O> generator, Collection<O> outputs, int n_proc) throws Exception {
        Process.process(inputs, generator, outputs, n_proc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <I, O> void process(Iterable<I> inputs, TaskFactory<I, O> generator, Collection<O> outputs, int n_proc, boolean bound) throws Exception {
        int nproc = Process.sensible(n_proc);
        ThreadPoolExecutor exec = Utils.newFixedThreadPool(nproc, "Process." + (bound ? "progressive" : "unbound"));
        try {
            LinkedList<Future<O>> fus = new LinkedList<Future<O>>();
            int ahead = Math.max(nproc + nproc, 4);
            for (I i : inputs) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                fus.add(exec.submit(generator.create(i)));
                if (!bound) continue;
                while (fus.size() > ahead) {
                    outputs.add(((Future)fus.removeFirst()).get());
                }
            }
            for (Future future : fus) {
                if (null != future) {
                    outputs.add(future.get());
                    continue;
                }
                outputs.add(null);
            }
        }
        finally {
            exec.shutdown();
        }
    }

    public static final <I, O> void progressive(Iterable<I> inputs, TaskFactory<I, O> generator) throws Exception {
        Process.progressive(inputs, generator, NUM_PROCESSORS);
    }

    public static final <I, O> void progressive(Iterable<I> inputs, TaskFactory<I, O> generator, int n_proc) throws Exception {
        Process.process(inputs, generator, n_proc, true);
    }

    public static final <I, O> void unbound(Iterable<I> inputs, TaskFactory<I, O> generator) throws Exception {
        Process.unbound(inputs, generator, NUM_PROCESSORS);
    }

    public static final <I, O> void unbound(Iterable<I> inputs, TaskFactory<I, O> generator, int n_proc) throws Exception {
        Process.process(inputs, generator, n_proc, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final <I, O> void process(Iterable<I> inputs, TaskFactory<I, O> generator, int n_proc, boolean bound) throws Exception {
        int nproc = Process.sensible(n_proc);
        ThreadPoolExecutor exec = Utils.newFixedThreadPool(nproc, "Process." + (bound ? "progressive" : "unbound"));
        try {
            LinkedList<Future<O>> fus = new LinkedList<Future<O>>();
            int ahead = Math.max(nproc + nproc, 4);
            for (I i : inputs) {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                fus.add(exec.submit(generator.create(i)));
                if (!bound) continue;
                while (fus.size() > ahead) {
                    ((Future)fus.removeFirst()).get();
                }
            }
            for (Future future : fus) {
                if (null == future) continue;
                future.get();
            }
        }
        finally {
            exec.shutdown();
        }
    }
}

