/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ini.trakem2.tree.DNDTree;
import ini.trakem2.tree.TransferableNode;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;

public abstract class AbstractTreeTransferHandler
implements DragGestureListener,
DragSourceListener,
DropTargetListener {
    private DNDTree tree;
    private DragSource dragSource;
    private DropTarget dropTarget;
    private static DefaultMutableTreeNode draggedNode;
    private DefaultMutableTreeNode draggedNodeParent;
    private static BufferedImage image;
    private Rectangle rect2D = new Rectangle();
    private boolean drawImage;
    private DragGestureRecognizer dgr;

    protected AbstractTreeTransferHandler(DNDTree tree, int action, boolean drawIcon) {
        this.tree = tree;
        this.drawImage = drawIcon;
        if (!GraphicsEnvironment.getLocalGraphicsEnvironment().isHeadlessInstance()) {
            this.dragSource = new DragSource();
            this.dgr = this.dragSource.createDefaultDragGestureRecognizer(tree, action, this);
            this.dropTarget = new DropTarget(tree, action, this);
        } else {
            this.dragSource = null;
            this.dgr = null;
            this.dropTarget = null;
        }
    }

    protected void destroy() {
        if (this.dgr != null) {
            this.dgr.removeDragGestureListener(this);
            this.dgr = null;
        }
        this.tree = null;
        this.dragSource = null;
        if (this.dropTarget != null) {
            this.dropTarget.removeDropTargetListener(this);
            this.dropTarget = null;
        }
        draggedNode = null;
        this.draggedNodeParent = null;
        image = null;
        this.rect2D = null;
    }

    @Override
    public void dragDropEnd(DragSourceDropEvent dsde) {
        if (dsde.getDropSuccess() && dsde.getDropAction() == 2 && this.draggedNodeParent != null) {
            ((DefaultTreeModel)this.tree.getModel()).nodeStructureChanged(this.draggedNodeParent);
            this.tree.expandPath(new TreePath(this.draggedNodeParent.getPath()));
            this.tree.expandPath(new TreePath(draggedNode.getPath()));
        }
    }

    @Override
    public final void dragEnter(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragOver(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dropActionChanged(DragSourceDragEvent dsde) {
        int action = dsde.getDropAction();
        if (action == 1) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultCopyDrop);
        } else if (action == 2) {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
        } else {
            dsde.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
        }
    }

    @Override
    public final void dragExit(DragSourceEvent dse) {
        dse.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
    }

    @Override
    public final void dragGestureRecognized(DragGestureEvent dge) {
        TreePath path = this.tree.getSelectionPath();
        if (path != null) {
            draggedNode = (DefaultMutableTreeNode)path.getLastPathComponent();
            this.draggedNodeParent = (DefaultMutableTreeNode)draggedNode.getParent();
            if (this.drawImage) {
                Rectangle pathBounds = this.tree.getPathBounds(path);
                JComponent lbl = (JComponent)this.tree.getCellRenderer().getTreeCellRendererComponent(this.tree, draggedNode, false, this.tree.isExpanded(path), ((DefaultTreeModel)this.tree.getModel()).isLeaf(path.getLastPathComponent()), 0, false);
                lbl.setBounds(pathBounds);
                image = new BufferedImage(lbl.getWidth(), lbl.getHeight(), 3);
                Graphics2D graphics = image.createGraphics();
                graphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                lbl.setOpaque(false);
                lbl.paint(graphics);
                graphics.dispose();
            }
            this.dragSource.startDrag(dge, DragSource.DefaultMoveNoDrop, image, new Point(0, 0), new TransferableNode(draggedNode), this);
        }
    }

    @Override
    public final void dragEnter(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void dragExit(DropTargetEvent dte) {
        if (this.drawImage) {
            this.clearImage();
        }
    }

    @Override
    public final void dragOver(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        this.tree.autoscroll(pt);
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void dropActionChanged(DropTargetDragEvent dtde) {
        Point pt = dtde.getLocation();
        int action = dtde.getDropAction();
        if (this.drawImage) {
            this.paintImage(pt);
        }
        if (this.canPerformAction(this.tree, draggedNode, action, pt)) {
            dtde.acceptDrag(action);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public final void drop(DropTargetDropEvent dtde) {
        try {
            if (this.drawImage) {
                this.clearImage();
            }
            int action = dtde.getDropAction();
            Transferable transferable = dtde.getTransferable();
            Point pt = dtde.getLocation();
            if (transferable.isDataFlavorSupported(TransferableNode.NODE_FLAVOR) && this.canPerformAction(this.tree, draggedNode, action, pt)) {
                DefaultMutableTreeNode newParentNode;
                TreePath pathTarget = this.tree.getPathForLocation(pt.x, pt.y);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)transferable.getTransferData(TransferableNode.NODE_FLAVOR);
                if (this.executeDrop(this.tree, node, newParentNode = (DefaultMutableTreeNode)pathTarget.getLastPathComponent(), action)) {
                    dtde.acceptDrop(action);
                    dtde.dropComplete(true);
                    return;
                }
            }
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
        catch (Exception e) {
            System.out.println(e);
            dtde.rejectDrop();
            dtde.dropComplete(false);
        }
    }

    private final void paintImage(Point pt) {
        if (null == this.rect2D || null == image) {
            return;
        }
        this.tree.paintImmediately(this.rect2D.getBounds());
        this.rect2D.setRect((int)pt.getX(), (int)pt.getY(), image.getWidth(), image.getHeight());
        this.tree.getGraphics().drawImage(image, (int)pt.getX(), (int)pt.getY(), this.tree);
    }

    private final void clearImage() {
        this.tree.paintImmediately(this.rect2D.getBounds());
    }

    public abstract boolean canPerformAction(DNDTree var1, DefaultMutableTreeNode var2, int var3, Point var4);

    public abstract boolean executeDrop(DNDTree var1, DefaultMutableTreeNode var2, DefaultMutableTreeNode var3, int var4);

    static {
        image = null;
    }
}

