/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.tree;

import ini.trakem2.Project;
import ini.trakem2.tree.DefaultTreeTransferHandler;
import ini.trakem2.tree.ProjectThing;
import ini.trakem2.tree.Thing;
import ini.trakem2.utils.Dispatcher;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public abstract class DNDTree
extends JTree
implements TreeExpansionListener,
KeyListener {
    Insets autoscrollInsets = new Insets(20, 20, 20, 20);
    DefaultTreeTransferHandler dtth = null;
    protected final Dispatcher dispatcher = new Dispatcher();
    protected final Project project;
    protected final Color background;
    private static final Field f_expandedState = DNDTree.getExpandedStateField();

    public DNDTree(Project project, DefaultMutableTreeNode root, final Color background) {
        this.project = project;
        this.background = background;
        this.setAutoscrolls(true);
        this.setModel(new DefaultTreeModel(root));
        this.setRootVisible(true);
        this.setShowsRootHandles(false);
        this.getSelectionModel().setSelectionMode(1);
        this.setEditable(true);
        this.dtth = new DefaultTreeTransferHandler(project, this, 3);
        this.setScrollsOnExpand(true);
        KeyListener[] kls = this.getKeyListeners();
        if (null != kls) {
            for (KeyListener kl : kls) {
                Utils.log2("removing kl: " + kl);
                this.removeKeyListener(kl);
            }
        }
        this.addKeyListener(this);
        if (null != background) {
            final NodeRenderer renderer = this.createNodeRenderer();
            renderer.setBackground(background);
            renderer.setBackgroundNonSelectionColor(background);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DNDTree.this.setCellRenderer(renderer);
                }
            });
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DNDTree.this.setBackground(background);
                }
            });
        }
    }

    @Override
    protected void processKeyEvent(KeyEvent ke) {
        if (ke.isConsumed()) {
            return;
        }
        if (401 == ke.getID()) {
            this.keyPressed(ke);
        }
    }

    @Override
    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        Utils.log2("intercepted binding: " + e.getKeyChar() + " " + ks.getKeyChar());
        return false;
    }

    protected NodeRenderer createNodeRenderer() {
        return new NodeRenderer();
    }

    public void autoscroll(Point cursorLocation) {
        Insets insets = this.getAutoscrollInsets();
        Rectangle outer = this.getVisibleRect();
        Rectangle inner = new Rectangle(outer.x + insets.left, outer.y + insets.top, outer.width - (insets.left + insets.right), outer.height - (insets.top + insets.bottom));
        if (!inner.contains(cursorLocation)) {
            Rectangle scrollRect = new Rectangle(cursorLocation.x - insets.left, cursorLocation.y - insets.top, insets.left + insets.right, insets.top + insets.bottom);
            this.scrollRectToVisible(scrollRect);
        }
    }

    public Insets getAutoscrollInsets() {
        return this.autoscrollInsets;
    }

    public static void expandAllNodes(JTree tree, TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        TreeModel tree_model = tree.getModel();
        if (tree_model.isLeaf(node)) {
            return;
        }
        tree.expandPath(path);
        int n_children = tree_model.getChildCount(node);
        for (int i = 0; i < n_children; ++i) {
            DNDTree.expandAllNodes(tree, path.pathByAddingChild(tree_model.getChild(node, i)));
        }
    }

    public static boolean expandNode(DNDTree tree, DefaultMutableTreeNode node) {
        TreeModel tree_model = tree.getModel();
        if (tree_model.isLeaf(node)) {
            return false;
        }
        tree.expandPath(new TreePath(node.getPath()));
        tree.updateUILater();
        return true;
    }

    public static void expandAllNodes(DNDTree tree, DefaultMutableTreeNode root_node) {
        DNDTree.expandAllNodes((JTree)tree, new TreePath(root_node.getPath()));
        tree.updateUILater();
    }

    public static DefaultMutableTreeNode makeNode(Thing thing) {
        return DNDTree.makeNode(thing, false);
    }

    public static DefaultMutableTreeNode makeNode(Thing thing, boolean childless_nested) {
        ArrayList<? extends Thing> al_children;
        DefaultMutableTreeNode node = new DefaultMutableTreeNode(thing);
        if (childless_nested) {
            String type = thing.getType();
            for (Thing parent = thing.getParent(); null != parent; parent = parent.getParent()) {
                if (!type.equals(parent.getType())) continue;
                return node;
            }
        }
        if (null == (al_children = thing.getChildren())) {
            return node;
        }
        for (Thing thing2 : al_children) {
            node.add(DNDTree.makeNode(thing2, childless_nested));
        }
        return node;
    }

    public static DefaultMutableTreeNode findNode(Object thing_ob, JTree tree) {
        if (null != thing_ob) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
            if (node.getUserObject().equals(thing_ob)) {
                return node;
            }
            Enumeration<TreeNode> e = node.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                node = (DefaultMutableTreeNode)e.nextElement();
                if (!node.getUserObject().equals(thing_ob)) continue;
                return node;
            }
        }
        return null;
    }

    public static DefaultMutableTreeNode findNode2(Object project_ob, JTree tree) {
        if (null != project_ob) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)tree.getModel().getRoot();
            Object o = node.getUserObject();
            if (null != o && o instanceof Thing && project_ob.equals(((Thing)o).getObject())) {
                return node;
            }
            Enumeration<TreeNode> e = node.depthFirstEnumeration();
            while (e.hasMoreElements()) {
                node = (DefaultMutableTreeNode)e.nextElement();
                o = node.getUserObject();
                if (null == o || !(o instanceof Thing) || project_ob != ((Thing)o).getObject()) continue;
                return node;
            }
        }
        return null;
    }

    public static void selectNode(final Object ob, final DNDTree tree) {
        if (null == ob) {
            Utils.log2("DNDTree.selectNode: null ob?");
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                tree.setSelectionPath(null);
                DefaultMutableTreeNode node = DNDTree.findNode(ob, tree);
                if (null != node) {
                    TreePath path = new TreePath(node.getPath());
                    try {
                        tree.scrollPathToVisible(path);
                        tree.setSelectionPath(path);
                    }
                    catch (Exception e) {
                        Utils.log2("Swing, swing, until you hit the building in front.");
                    }
                }
            }
        });
    }

    public void destroy() {
        this.dtth.destroy();
        this.dtth = null;
        this.dispatcher.quit();
    }

    public void updateUILater() {
        Utils.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    DNDTree.this.updateUI();
                }
                catch (Exception e) {
                    IJError.print(e);
                }
            }
        });
    }

    public void rebuild() {
        this.rebuild((DefaultMutableTreeNode)this.getModel().getRoot(), false);
        this.updateUILater();
    }

    public void rebuild(Thing thing) {
        this.rebuild(DNDTree.findNode(thing, this), false);
        this.updateUILater();
    }

    public void rebuild(DefaultMutableTreeNode node, boolean repaint) {
        Thing thing;
        ArrayList<? extends Thing> al_children;
        if (null == node) {
            return;
        }
        if (0 != node.getChildCount()) {
            node.removeAllChildren();
        }
        if (null == (al_children = (thing = (Thing)node.getUserObject()).getChildren())) {
            return;
        }
        for (Thing thing2 : al_children) {
            DefaultMutableTreeNode childnode = new DefaultMutableTreeNode(thing2);
            node.add(childnode);
            this.rebuild(childnode, false);
        }
        if (repaint) {
            this.updateUILater();
        }
    }

    public void updateList(Thing thing) {
        this.updateList(DNDTree.findNode(thing, this));
    }

    public void updateList(DefaultMutableTreeNode node) {
        if (null == node) {
            return;
        }
        Thing thing = (Thing)node.getUserObject();
        Container c = this.getParent();
        Point point = null;
        if (c instanceof JScrollPane) {
            point = ((JScrollPane)c).getViewport().getViewPosition();
        }
        HashMap<Object, DefaultMutableTreeNode> ht = new HashMap<Object, DefaultMutableTreeNode>();
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)e.nextElement();
            ht.put(defaultMutableTreeNode.getUserObject(), defaultMutableTreeNode);
        }
        node.removeAllChildren();
        for (Thing thing2 : thing.getChildren()) {
            Object ob = ht.remove(thing2);
            if (null == ob) {
                Utils.log2("Adding missing node for " + thing2);
                node.add(new DefaultMutableTreeNode(thing2));
                continue;
            }
            node.add((DefaultMutableTreeNode)ob);
        }
        if (0 != ht.size()) {
            Utils.log2("WARNING DNDTree.updateList: did not end up adding this nodes:");
            Iterator<Thing> it = ht.keySet().iterator();
            while (it.hasNext()) {
                Utils.log2(((Object)it.next()).toString());
            }
        }
        this.updateUILater();
        if (null != point) {
            ((JScrollPane)c).getViewport().setViewPosition(point);
        }
    }

    public DefaultMutableTreeNode getRootNode() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    public void setExpandedSilently(Thing thing, boolean b) {
        DefaultMutableTreeNode node = DNDTree.findNode(thing, this);
        if (null == node) {
            return;
        }
        this.setExpandedSilently(node, b);
    }

    private static final Field getExpandedStateField() {
        try {
            Field f = JTree.class.getDeclaredField("expandedState");
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            Utils.log2("ERROR: " + e);
            return null;
        }
    }

    public void setExpandedSilently(DefaultMutableTreeNode node, boolean b) {
        try {
            Hashtable ht = (Hashtable)f_expandedState.get(this);
            ht.put(new TreePath(node.getPath()), b);
        }
        catch (Exception e) {
            Utils.log2("ERROR: " + e);
        }
    }

    public HashMap<Thing, Boolean> getExpandedStates() {
        return this.getExpandedStates(new HashMap<Thing, Boolean>());
    }

    public HashMap<Thing, Boolean> getExpandedStates(HashMap<Thing, Boolean> m) {
        try {
            Hashtable ht = (Hashtable)f_expandedState.get(this);
            for (Map.Entry e : ht.entrySet()) {
                Thing t = (Thing)((DefaultMutableTreeNode)((TreePath)e.getKey()).getLastPathComponent()).getUserObject();
                if (!t.hasChildren()) continue;
                m.put(t, (Boolean)e.getValue());
            }
            return m;
        }
        catch (Exception e) {
            IJError.print(e);
            return null;
        }
    }

    public boolean isExpanded(Thing thing) {
        DefaultMutableTreeNode node = DNDTree.findNode(thing, this);
        if (null == node) {
            return false;
        }
        return this.isExpanded(node);
    }

    public boolean isExpanded(DefaultMutableTreeNode node) {
        try {
            Hashtable ht = (Hashtable)f_expandedState.get(this);
            return Boolean.TRUE.equals(ht.get(new TreePath(node.getPath())));
        }
        catch (Exception e) {
            Utils.log2("ERROR: " + e);
            return false;
        }
    }

    @Override
    public void treeCollapsed(TreeExpansionEvent tee) {
        TreePath path = tee.getPath();
        this.updateInDatabase(path);
    }

    @Override
    public void treeExpanded(TreeExpansionEvent tee) {
        TreePath path = tee.getPath();
        this.updateInDatabase(path);
    }

    private void updateInDatabase(TreePath path) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
        ProjectThing thing = (ProjectThing)node.getUserObject();
        thing.updateInDatabase(new StringBuffer("expanded='").append(this.isExpanded(thing)).append('\'').toString());
    }

    public String getInfo() {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.getModel().getRoot();
        int n_basic = 0;
        int n_abstract = 0;
        Enumeration<TreeNode> e = node.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            Object ob = child.getUserObject();
            if (ob instanceof Thing && Project.isBasicType(((Thing)ob).getType())) {
                ++n_basic;
                continue;
            }
            ++n_abstract;
        }
        return this.getClass().getName() + ": \n\tAbstract nodes: " + n_abstract + "\n\tBasic nodes: " + n_basic + "\n";
    }

    public final DefaultMutableTreeNode getRoot() {
        return (DefaultMutableTreeNode)this.getModel().getRoot();
    }

    protected DefaultMutableTreeNode addChild(Thing child, DefaultMutableTreeNode parent_node) {
        try {
            DefaultMutableTreeNode node_child = new DefaultMutableTreeNode(child);
            ((DefaultTreeModel)this.getModel()).insertNodeInto(node_child, parent_node, parent_node.getChildCount());
            try {
                this.updateUI();
            }
            catch (Exception e) {
                IJError.print(e, true);
            }
            return node_child;
        }
        catch (Exception e) {
            IJError.print(e, true);
            return null;
        }
    }

    public void addLeafs(final List<? extends Thing> leafs, final Runnable after) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (Thing th : leafs) {
                    DefaultMutableTreeNode parent = DNDTree.findNode(th.getParent(), DNDTree.this);
                    if (null == parent) {
                        Utils.log("Ignoring node " + th + " : null parent!");
                        continue;
                    }
                    boolean exists = false;
                    if (parent.getChildCount() > 0) {
                        Enumeration<TreeNode> e = parent.children();
                        while (e.hasMoreElements()) {
                            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
                            if (!child.getUserObject().equals(th)) continue;
                            exists = true;
                            break;
                        }
                    }
                    if (!exists) {
                        DNDTree.this.addChild(th, parent);
                    }
                    if (null == after) continue;
                    try {
                        after.run();
                    }
                    catch (Throwable t) {
                        IJError.print(t);
                    }
                }
            }
        });
    }

    protected boolean removeNode(DefaultMutableTreeNode node) {
        if (null == node) {
            return false;
        }
        ((DefaultTreeModel)this.getModel()).removeNodeFromParent(node);
        this.updateUILater();
        return true;
    }

    public Thing duplicate(HashMap<Thing, Boolean> expanded_state) {
        DefaultMutableTreeNode root_node = (DefaultMutableTreeNode)this.getModel().getRoot();
        return this.duplicate(root_node, expanded_state);
    }

    private Thing duplicate(DefaultMutableTreeNode node, HashMap<Thing, Boolean> expanded_state) {
        Thing thing = (Thing)node.getUserObject();
        Thing copy = thing.shallowCopy();
        if (null != expanded_state) {
            expanded_state.put(copy, this.isExpanded(node));
        }
        Enumeration<TreeNode> e = node.children();
        while (e.hasMoreElements()) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)e.nextElement();
            copy.addChild(this.duplicate(child, expanded_state));
        }
        return copy;
    }

    public void reset(HashMap<Thing, Boolean> expanded_state) {
        DefaultMutableTreeNode root_node = (DefaultMutableTreeNode)this.getModel().getRoot();
        root_node.removeAllChildren();
        this.set(root_node, this.getRootThing(), expanded_state);
        this.updateUILater();
    }

    protected abstract Thing getRootThing();

    protected void set(DefaultMutableTreeNode root, Thing root_thing, HashMap<Thing, Boolean> expanded_state) {
        Boolean b;
        root.setUserObject(root_thing);
        ArrayList<? extends Thing> al_children = root_thing.getChildren();
        if (null != al_children) {
            for (Thing thing : al_children) {
                DefaultMutableTreeNode child = new DefaultMutableTreeNode(thing);
                root.add(child);
                this.set(child, thing, expanded_state);
            }
        }
        if (null != expanded_state && null != (b = expanded_state.get(root_thing))) {
            this.setExpandedSilently(root, (boolean)b);
        }
    }

    @Override
    public void keyPressed(KeyEvent ke) {
        if (!ke.getSource().equals(this) || !this.project.isInputEnabled()) {
            ke.consume();
            return;
        }
        int key_code = ke.getKeyCode();
        switch (key_code) {
            case 83: {
                this.project.getLoader().saveTask(this.project, "Save");
                ke.consume();
            }
        }
    }

    @Override
    public void keyReleased(KeyEvent ke) {
    }

    @Override
    public void keyTyped(KeyEvent ke) {
    }

    protected class NodeRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;

        protected NodeRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean isExpanded, boolean isLeaf, int row, boolean hasTheFocus) {
            JLabel label = (JLabel)super.getTreeCellRendererComponent(tree, value, isSelected, isExpanded, isLeaf, row, hasTheFocus);
            label.setText(label.getText().replace('_', ' '));
            return label;
        }

        @Override
        public void setText(String text) {
            super.setText(text);
            this.setToolTipText(text);
        }
    }
}

