/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

import ini.trakem2.utils.CachingThread;
import ini.trakem2.utils.IJError;
import ini.trakem2.utils.Utils;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.swing.SwingUtilities;

public class Dispatcher {
    private final ExecutorService exec;

    public Dispatcher(String tag) {
        this.exec = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>(), new DispatcherThreadFactory("T2-Dispatcher" + (null != tag ? " " + tag : "")));
    }

    public Dispatcher() {
        this(null);
    }

    public void quit() {
        this.exec.shutdownNow();
    }

    public boolean isQuit() {
        return this.exec.isShutdown();
    }

    public void quitWhenDone() {
        this.exec.shutdown();
    }

    public void exec(Runnable run) {
        this.exec(run, false);
    }

    public void execSwing(Runnable run) {
        this.exec(run, true);
    }

    public void exec(Runnable run, boolean swing) {
        if (this.exec.isShutdown()) {
            Utils.log2("Dispatcher: NOT accepting more tasks!");
            return;
        }
        this.exec.submit(new Task(run, swing));
    }

    public static class DispatcherThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final String tag;

        public DispatcherThreadFactory(String tag) {
            this.tag = tag;
            SecurityManager s = System.getSecurityManager();
            this.group = null != s ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public final Thread newThread(Runnable r) {
            CachingThread t = new CachingThread(this.group, r, this.tag);
            if (t.isDaemon()) {
                t.setDaemon(false);
            }
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }

    private final class Task
    implements Runnable {
        final Runnable run;
        final boolean swing;

        private Task(Runnable run, boolean swing) {
            this.run = run;
            this.swing = swing;
        }

        @Override
        public void run() {
            try {
                if (this.swing) {
                    SwingUtilities.invokeAndWait(this.run);
                } else {
                    this.run.run();
                }
            }
            catch (InterruptedException ie) {
                Utils.log2("Sayonara!");
            }
            catch (Throwable e) {
                IJError.print(e);
            }
        }
    }
}

