/*
 * Decompiled with CFR 0.152.
 */
package ini.trakem2.utils;

public class Vector3 {
    public double x;
    public double y;
    public double z;

    public Vector3(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Vector3() {
        this(0.0, 0.0, 0.0);
    }

    public Vector3(Vector3 v) {
        this(v.x, v.y, v.z);
    }

    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y + this.z * this.z);
    }

    public Vector3 normalize(Vector3 r) {
        double vlen;
        if (r == null) {
            r = new Vector3();
        }
        if ((vlen = this.length()) != 0.0) {
            return r.set(this.x / vlen, this.y / vlen, this.z / vlen);
        }
        return null;
    }

    public Vector3 scale(double s, Vector3 r) {
        if (r == null) {
            r = new Vector3();
        }
        return r.set(s * this.x, s * this.y, s * this.z);
    }

    public Vector3 add(Vector3 v, Vector3 r) {
        if (r == null) {
            r = new Vector3();
        }
        return r.set(this.x + v.x, this.y + v.y, this.z + v.z);
    }

    public Vector3 set(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        return this;
    }

    public static final Vector3 rotate_v_around_axis(Vector3 v, Vector3 axis, double sin, double cos) {
        Vector3 result = new Vector3();
        Vector3 r = axis.normalize(axis);
        result.set((cos + (1.0 - cos) * r.x * r.x) * v.x + ((1.0 - cos) * r.x * r.y - r.z * sin) * v.y + ((1.0 - cos) * r.x * r.z + r.y * sin) * v.z, ((1.0 - cos) * r.x * r.y + r.z * sin) * v.x + (cos + (1.0 - cos) * r.y * r.y) * v.y + ((1.0 - cos) * r.y * r.z - r.x * sin) * v.z, ((1.0 - cos) * r.y * r.z - r.y * sin) * v.x + ((1.0 - cos) * r.y * r.z + r.x * sin) * v.y + (cos + (1.0 - cos) * r.z * r.z) * v.z);
        return result;
    }
}

