/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.trakem2.align;

import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.Patch;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.persistence.Loader;
import ini.trakem2.utils.Utils;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import mpicbg.imagefeatures.Feature;
import mpicbg.models.AbstractModel;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.HomographyModel2D;
import mpicbg.models.PointMatch;
import mpicbg.models.RigidModel2D;
import mpicbg.models.SimilarityModel2D;
import mpicbg.models.TranslationModel2D;
import mpicbg.trakem2.transform.AffineModel2D;
import mpicbg.trakem2.transform.CoordinateTransformList;

public class Util {
    public static final boolean serializeFeatures(Project project, Object key, String prefix, long id, Collection<Feature> f) {
        ArrayList<Feature> list = new ArrayList<Feature>();
        list.addAll(f);
        String name = prefix == null ? "features" : prefix + ".features";
        Loader loader = project.getLoader();
        Features fe = new Features(key, list);
        return loader.serialize(fe, loader.getUNUIdFolder() + "features.ser/" + FSLoader.createIdPath(Long.toString(id), name, ".ser"));
    }

    protected static final ArrayList<Feature> deserializeFeatures(Project project, Object key, String prefix, long id) {
        String name = prefix == null ? "features" : prefix + ".features";
        Loader loader = project.getLoader();
        Object ob = loader.deserialize(loader.getUNUIdFolder() + "features.ser/" + FSLoader.createIdPath(Long.toString(id), name, ".ser"));
        if (ob != null) {
            try {
                Features fe = (Features)ob;
                if (fe.key != null && key.equals(fe.key)) {
                    return fe.features;
                }
            }
            catch (Exception e) {
                Utils.log("Exception during feature deserialization.");
                e.printStackTrace();
            }
        } else {
            Utils.log("features file null");
        }
        return null;
    }

    public static final boolean serializePointMatches(Project project, Object key, String prefix, long id1, long id2, Collection<PointMatch> m) {
        ArrayList<PointMatch> list = new ArrayList<PointMatch>();
        list.addAll(m);
        ArrayList<PointMatch> tsil = new ArrayList<PointMatch>();
        PointMatch.flip(m, tsil);
        String name = prefix == null ? "pointmatches" : prefix + ".pointmatches";
        Loader loader = project.getLoader();
        return loader.serialize(new PointMatches(key, list), loader.getUNUIdFolder() + "pointmatches.ser/" + FSLoader.createIdPath(Long.toString(id1) + "_" + Long.toString(id2), name, ".ser")) && loader.serialize(new PointMatches(key, tsil), loader.getUNUIdFolder() + "pointmatches.ser/" + FSLoader.createIdPath(Long.toString(id2) + "_" + Long.toString(id1), name, ".ser"));
    }

    protected static final ArrayList<PointMatch> deserializePointMatches(Project project, Object key, String prefix, long id1, long id2) {
        String name = prefix == null ? "pointmatches" : prefix + ".pointmatches";
        Loader loader = project.getLoader();
        Object ob = loader.deserialize(loader.getUNUIdFolder() + "pointmatches.ser/" + FSLoader.createIdPath(Long.toString(id1) + "_" + Long.toString(id2), name, ".ser"));
        if (null != ob) {
            try {
                PointMatches pm = (PointMatches)ob;
                if (pm.key != null && key.equals(pm.key)) {
                    return pm.pointMatches;
                }
            }
            catch (Exception e) {
                Utils.log("Exception during pointmatch deserialization.");
                e.printStackTrace();
            }
        }
        return null;
    }

    public static final void imageToFloatAndMask(Image input, FloatProcessor output, FloatProcessor alpha) {
        ColorProcessor cp = new ColorProcessor(input);
        int[] inputPixels = (int[])cp.getPixels();
        for (int i = 0; i < inputPixels.length; ++i) {
            int argb = inputPixels[i];
            int a = argb >> 24 & 0xFF;
            int r = argb >> 16 & 0xFF;
            int g = argb >> 8 & 0xFF;
            int b = argb & 0xFF;
            float v = (float)(r + g + b) / 3.0f;
            float w = (float)a / 255.0f;
            output.setf(i, v);
            alpha.setf(i, w);
        }
    }

    public static final void applyLayerTransformToPatch(Patch patch, mpicbg.trakem2.transform.CoordinateTransform ct) throws Exception {
        Rectangle pbox = patch.getCoordinateTransformBoundingBox();
        AffineTransform pat = new AffineTransform();
        pat.translate(-pbox.x, -pbox.y);
        pat.preConcatenate(patch.getAffineTransform());
        AffineModel2D toWorld = new AffineModel2D();
        toWorld.set(pat);
        CoordinateTransformList ctl = new CoordinateTransformList();
        ctl.add((CoordinateTransform)toWorld);
        ctl.add((CoordinateTransform)ct);
        ctl.add((CoordinateTransform)toWorld.createInverse());
        patch.appendCoordinateTransform((mpicbg.trakem2.transform.CoordinateTransform)ctl);
    }

    public static final AbstractModel<?> createModel(int modelIndex) {
        switch (modelIndex) {
            case 0: {
                return new TranslationModel2D();
            }
            case 1: {
                return new RigidModel2D();
            }
            case 2: {
                return new SimilarityModel2D();
            }
            case 3: {
                return new AffineModel2D();
            }
            case 4: {
                return new HomographyModel2D();
            }
        }
        return null;
    }

    protected static final class PointMatches
    implements Serializable {
        private static final long serialVersionUID = 7905488521562090982L;
        final Object key;
        final ArrayList<PointMatch> pointMatches;

        PointMatches(Object key, ArrayList<PointMatch> pointMatches) {
            this.key = key;
            this.pointMatches = pointMatches;
        }
    }

    protected static final class Features
    implements Serializable {
        private static final long serialVersionUID = -5707602842402593215L;
        final Object key;
        final ArrayList<Feature> features;

        Features(Object key, ArrayList<Feature> features) {
            this.key = key;
            this.features = features;
        }
    }
}

