/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.intensity;

import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ini.trakem2.Project;
import ini.trakem2.display.Display;
import ini.trakem2.display.Displayable;
import ini.trakem2.display.Layer;
import ini.trakem2.display.LayerSet;
import ini.trakem2.display.Patch;
import ini.trakem2.persistence.FSLoader;
import ini.trakem2.plugin.TPlugIn;
import ini.trakem2.utils.Utils;
import java.awt.Rectangle;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import mpicbg.models.Affine1D;
import mpicbg.models.AffineModel1D;
import mpicbg.models.IdentityModel;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InterpolatedAffineModel1D;
import mpicbg.models.Model;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointMatch;
import mpicbg.models.Tile;
import mpicbg.models.TileConfiguration;
import mpicbg.models.TranslationModel1D;
import net.imglib2.img.list.ListImg;
import net.imglib2.img.list.ListRandomAccess;
import net.imglib2.util.ValuePair;
import org.janelia.intensity.PointMatchFilter;
import org.janelia.intensity.RansacRegressionReduceFilter;
import org.janelia.intensity.Render;

public class MatchIntensities
implements TPlugIn {
    protected LayerSet layerset = null;
    protected static int numCoefficients = 8;
    protected static double lambda1 = 0.01;
    protected static double lambda2 = 0.01;
    protected static double neighborWeight = 0.1;
    protected static int radius = 5;
    protected static int iterations = 2000;
    protected static double scale = -1.0;

    private Layer currentLayer(Object ... params) {
        Display front;
        Object param;
        Layer layer = params != null && params[0] != null ? (Layer.class.isInstance(param = params[0]) ? (Layer)param : (LayerSet.class.isInstance(param) ? ((LayerSet)param).getLayer(0) : (Displayable.class.isInstance(param) ? ((Displayable)param).getLayer() : null))) : ((front = Display.getFront()) == null ? Project.getProjects().get(0).getRootLayerSet().getLayer(0) : front.getLayer());
        return layer;
    }

    private static Rectangle getRoi(LayerSet layerset) {
        Display front = Display.getFront();
        Roi roi = front == null ? null : front.getRoi();
        if (roi == null) {
            return new Rectangle(0, 0, (int)layerset.getLayerWidth(), (int)layerset.getLayerHeight());
        }
        return roi.getBounds();
    }

    private double suggestScale(List<Layer> layers) {
        if (layers.size() < 2) {
            return 0.0;
        }
        Layer layer1 = layers.get(0);
        Layer layer2 = layers.get(1);
        Calibration calib = layer1.getParent().getCalibration();
        double width = (calib.pixelWidth + calib.pixelHeight) * 0.5;
        double depth = calib.pixelDepth;
        return (layer2.getZ() - layer1.getZ()) * width / depth;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean setup(Object ... params) {
        if (params != null && params[0] != null) {
            Object param = params[0];
            if (LayerSet.class.isInstance(param)) {
                this.layerset = (LayerSet)param;
                return true;
            } else {
                if (!Displayable.class.isInstance(param)) return false;
                this.layerset = ((Displayable)param).getLayerSet();
            }
            return true;
        } else {
            Display front = Display.getFront();
            this.layerset = front == null ? Project.getProjects().get(0).getRootLayerSet() : front.getLayerSet();
        }
        return true;
    }

    protected static final <T extends Model<T> & Affine1D<T>> HashMap<Patch, ArrayList<Tile<T>>> generateCoefficientsTiles(Collection<Patch> patches, T template, int nCoefficients) {
        HashMap<Patch, ArrayList<Tile<T>>> map = new HashMap<Patch, ArrayList<Tile<T>>>();
        for (Patch p : patches) {
            ArrayList<Tile> coefficientModels = new ArrayList<Tile>();
            for (int i = 0; i < nCoefficients; ++i) {
                coefficientModels.add(new Tile(template.copy()));
            }
            map.put(p, coefficientModels);
        }
        return map;
    }

    protected static final void identityConnect(Tile<?> t1, Tile<?> t2, double weight) {
        ArrayList<PointMatch> matches = new ArrayList<PointMatch>();
        matches.add(new PointMatch(new Point(new double[]{0.0}), new Point(new double[]{0.0})));
        matches.add(new PointMatch(new Point(new double[]{1.0}), new Point(new double[]{1.0})));
        t1.connect(t2, matches);
    }

    @Override
    public Object invoke(Object ... params) {
        if (!this.setup(params)) {
            return null;
        }
        Layer layer = this.currentLayer(params);
        GenericDialog gd = new GenericDialog("Match intensities");
        Utils.addLayerRangeChoices(layer, gd);
        gd.addMessage("Layer range :");
        gd.addNumericField("scale : ", scale > 0.0 ? scale : this.suggestScale(this.layerset.getLayers()), 3, 6, "");
        gd.addNumericField("coefficient resolution : ", (double)numCoefficients, 0, 6, "");
        gd.addNumericField("test_maximally :", (double)radius, 0, 6, "layers");
        gd.addMessage("Optimizer :");
        gd.addNumericField("iterations :", (double)iterations, 0, 6, "");
        gd.addNumericField("scale_regularization :", lambda1, 2, 6, "");
        gd.addNumericField("translation_regularization :", lambda2, 2, 6, "");
        gd.addNumericField("smoothness_regularization :", neighborWeight, 2, 6, "");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        List<Layer> layers = this.layerset.getLayers().subList(gd.getNextChoiceIndex(), gd.getNextChoiceIndex() + 1);
        System.out.println(layers.size());
        scale = gd.getNextNumber();
        numCoefficients = (int)gd.getNextNumber();
        radius = (int)gd.getNextNumber();
        iterations = (int)gd.getNextNumber();
        lambda1 = gd.getNextNumber();
        lambda2 = gd.getNextNumber();
        neighborWeight = gd.getNextNumber();
        try {
            this.run(layers, radius, scale, numCoefficients, lambda1, lambda2, neighborWeight, MatchIntensities.getRoi(this.layerset));
        }
        catch (InterruptedException e) {
            Utils.log("Match intensities interrupted.");
            e.printStackTrace(System.out);
        }
        catch (ExecutionException e) {
            Utils.log("Match intenities ExecutiuonException occurred:");
            e.printStackTrace(System.out);
        }
        return null;
    }

    @Override
    public boolean applies(Object ob) {
        return true;
    }

    public <M extends Model<M> & Affine1D<M>> void run(List<Layer> layers, int radius, double scale, int numCoefficients, double lambda1, double lambda2, double neighborWeight, Rectangle roi) throws InterruptedException, ExecutionException {
        int firstLayerIndex = this.layerset.getLayerIndex(layers.get(0).getId());
        int lastLayerIndex = this.layerset.getLayerIndex(layers.get(layers.size() - 1).getId());
        RansacRegressionReduceFilter filter = new RansacRegressionReduceFilter();
        Utils.log("Collecting patches ... ");
        ArrayList<Patch> patches = new ArrayList<Patch>();
        for (Layer layer : layers) {
            patches.addAll(layer.getDisplayables(Patch.class, roi));
        }
        Utils.log("Clearing existing intensity maps ... ");
        for (Patch p : patches) {
            p.clearIntensityMap();
        }
        HashMap<Patch, ArrayList<Tile<?>>> coefficientsTiles = MatchIntensities.generateCoefficientsTiles(patches, new InterpolatedAffineModel1D((Model)new InterpolatedAffineModel1D((Model)new AffineModel1D(), (Model)new TranslationModel1D(), lambda1), (Model)new IdentityModel(), lambda2), numCoefficients * numCoefficients);
        HashSet<Patch> completedPatches = new HashSet<Patch>();
        Utils.log("Collecting patch pairs ... ");
        ArrayList<ValuePair> patchPairs = new ArrayList<ValuePair>();
        for (Patch p1 : patches) {
            completedPatches.add(p1);
            Rectangle box1 = p1.getBoundingBox().intersection(roi);
            Iterator<Displayable> p2s = new ArrayList();
            int n = this.layerset.getLayerIndex(p1.getLayer().getId());
            for (int i = Math.max(firstLayerIndex, n - radius); i <= Math.min(lastLayerIndex, n + radius); ++i) {
                Layer layer = this.layerset.getLayer(i);
                if (layer == null) continue;
                ((ArrayList)((Object)p2s)).addAll(layer.getDisplayables(Patch.class, box1));
            }
            Iterator i = ((ArrayList)((Object)p2s)).iterator();
            while (i.hasNext()) {
                Patch p2 = (Patch)i.next();
                if (completedPatches.contains(p2)) continue;
                patchPairs.add(new ValuePair((Object)p1, (Object)p2));
            }
        }
        int numThreads = Integer.parseInt(this.layerset.getProperty("n_mipmap_threads", Integer.toString(Runtime.getRuntime().availableProcessors())));
        Utils.log("Matching intensities using " + numThreads + " threads ... ");
        ExecutorService exec = Executors.newFixedThreadPool(numThreads);
        ArrayList futures = new ArrayList();
        for (ValuePair valuePair : patchPairs) {
            futures.add(exec.submit(new Matcher(roi, (ValuePair<Patch, Patch>)valuePair, coefficientsTiles, filter, scale, numCoefficients)));
        }
        for (Future future : futures) {
            future.get();
        }
        Utils.log("Connecting coefficient tiles in the same patch  ... ");
        for (Patch patch : completedPatches) {
            int n;
            int yr;
            int y;
            ArrayList<Tile<?>> p1CoefficientsTiles = coefficientsTiles.get(patch);
            for (y = 1; y < numCoefficients; ++y) {
                yr = numCoefficients * y;
                int yr1 = yr - numCoefficients;
                for (n = 0; n < numCoefficients; ++n) {
                    MatchIntensities.identityConnect(p1CoefficientsTiles.get(yr1 + n), p1CoefficientsTiles.get(yr + n), neighborWeight);
                }
            }
            for (y = 0; y < numCoefficients; ++y) {
                yr = numCoefficients * y;
                for (int x = 1; x < numCoefficients; ++x) {
                    n = yr + x;
                    MatchIntensities.identityConnect(p1CoefficientsTiles.get(n), p1CoefficientsTiles.get(n - 1), neighborWeight);
                }
            }
        }
        Utils.log("Optimizing ... ");
        TileConfiguration tc = new TileConfiguration();
        for (ArrayList<Tile<?>> coefficients : coefficientsTiles.values()) {
            tc.addTiles(coefficients);
        }
        try {
            tc.optimize((double)0.01f, iterations, iterations, 0.75);
        }
        catch (NotEnoughDataPointsException notEnoughDataPointsException) {
            notEnoughDataPointsException.printStackTrace();
        }
        catch (IllDefinedDataPointsException illDefinedDataPointsException) {
            illDefinedDataPointsException.printStackTrace();
        }
        double[] dArray = new double[2];
        FSLoader loader = (FSLoader)this.layerset.getProject().getLoader();
        String itsDir = loader.getUNUIdFolder() + "trakem2.its/";
        for (Map.Entry<Patch, ArrayList<Tile<?>>> entry : coefficientsTiles.entrySet()) {
            FloatProcessor floatProcessor = new FloatProcessor(numCoefficients, numCoefficients);
            FloatProcessor bs = new FloatProcessor(numCoefficients, numCoefficients);
            Patch p = entry.getKey();
            double min = p.getMin();
            double max = p.getMax();
            ArrayList<Tile<?>> tiles = entry.getValue();
            for (int i = 0; i < numCoefficients * numCoefficients; ++i) {
                Tile<?> t = tiles.get(i);
                Affine1D affine = (Affine1D)t.getModel();
                affine.toArray(dArray);
                floatProcessor.setf(i, (float)dArray[0]);
                bs.setf(i, (float)((max - min) * dArray[1] + min - dArray[0] * min));
            }
            ImageStack coefficientsStack = new ImageStack(numCoefficients, numCoefficients);
            coefficientsStack.addSlice((ImageProcessor)floatProcessor);
            coefficientsStack.addSlice((ImageProcessor)bs);
            String itsPath = itsDir + FSLoader.createIdPath(Long.toString(p.getId()), "it", ".tif");
            new File(itsPath).getParentFile().mkdirs();
            IJ.saveAs((ImagePlus)new ImagePlus("", coefficientsStack), (String)"tif", (String)itsPath);
        }
        for (Patch p : patches) {
            p.getProject().getLoader().decacheImagePlus(p.getId());
        }
        ArrayList<Future<Boolean>> mipmapFutures = new ArrayList<Future<Boolean>>();
        for (Patch patch : patches) {
            mipmapFutures.add(patch.updateMipMaps());
        }
        for (Future future : mipmapFutures) {
            future.get();
        }
        Utils.log("Matching intensities done.");
    }

    public static final void main(String ... args) {
        new ImageJ();
        Project project = Project.openFSProject("/home/saalfeld/tmp/intensity-corrected/elastic.xml", true);
        MatchIntensities matcher = new MatchIntensities();
        matcher.invoke(project.getRootLayerSet());
    }

    private final class Matcher
    implements Runnable {
        private final Rectangle roi;
        private final ValuePair<Patch, Patch> patchPair;
        private final HashMap<Patch, ArrayList<Tile<?>>> coefficientsTiles;
        private final PointMatchFilter filter;
        private final double scale;
        private final int numCoefficients;

        public Matcher(Rectangle roi, ValuePair<Patch, Patch> patchPair, HashMap<Patch, ArrayList<Tile<?>>> coefficientsTiles, PointMatchFilter filter, double scale, int numCoefficients) {
            this.roi = roi;
            this.patchPair = patchPair;
            this.coefficientsTiles = coefficientsTiles;
            this.filter = filter;
            this.scale = scale;
            this.numCoefficients = numCoefficients;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            Patch p1 = (Patch)this.patchPair.getA();
            Patch p2 = (Patch)this.patchPair.getB();
            Rectangle box1 = p1.getBoundingBox().intersection(this.roi);
            ArrayList<Tile<?>> p1CoefficientsTiles = this.coefficientsTiles.get(p1);
            Rectangle box2 = p2.getBoundingBox();
            Rectangle box = box1.intersection(box2);
            int w = (int)((double)box.width * this.scale + 0.5);
            int h = (int)((double)box.height * this.scale + 0.5);
            int n = w * h;
            FloatProcessor pixels1 = new FloatProcessor(w, h);
            FloatProcessor weights1 = new FloatProcessor(w, h);
            ColorProcessor coefficients1 = new ColorProcessor(w, h);
            FloatProcessor pixels2 = new FloatProcessor(w, h);
            FloatProcessor weights2 = new FloatProcessor(w, h);
            ColorProcessor coefficients2 = new ColorProcessor(w, h);
            Render.render(p1, this.numCoefficients, this.numCoefficients, pixels1, weights1, coefficients1, box.x, box.y, this.scale);
            Render.render(p2, this.numCoefficients, this.numCoefficients, pixels2, weights2, coefficients2, box.x, box.y, this.scale);
            ArrayList list = new ArrayList();
            for (int i = 0; i < this.numCoefficients * this.numCoefficients * this.numCoefficients * this.numCoefficients; ++i) {
                list.add(new ArrayList());
            }
            ListImg matrix = new ListImg(list, new long[]{this.numCoefficients * this.numCoefficients, this.numCoefficients * this.numCoefficients});
            ListRandomAccess ra = matrix.randomAccess();
            for (int i = 0; i < n; ++i) {
                double w2;
                double w1;
                int c2;
                int c1 = coefficients1.get(i);
                if (c1 <= 0 || (c2 = coefficients2.get(i)) <= 0 || !((w1 = (double)weights1.getf(i)) > 0.0) || !((w2 = (double)weights2.getf(i)) > 0.0)) continue;
                double p = pixels1.getf(i);
                double q = pixels2.getf(i);
                PointMatch pq = new PointMatch(new Point(new double[]{p}), new Point(new double[]{q}), w1 * w2);
                ra.setPosition(c1 - 1, 0);
                ra.setPosition(c2 - 1, 1);
                ((ArrayList)ra.get()).add(pq);
            }
            ArrayList<PointMatch> inliers = new ArrayList<PointMatch>();
            for (ArrayList candidates : matrix) {
                inliers.clear();
                this.filter.filter(candidates, inliers);
                candidates.clear();
                candidates.addAll(inliers);
            }
            ArrayList<Tile<?>> p2CoefficientsTiles = this.coefficientsTiles.get(p2);
            for (int i = 0; i < this.numCoefficients * this.numCoefficients; ++i) {
                Tile<?> t1 = p1CoefficientsTiles.get(i);
                ra.setPosition(i, 0);
                for (int j = 0; j < this.numCoefficients * this.numCoefficients; ++j) {
                    ra.setPosition(j, 1);
                    ArrayList matches = (ArrayList)ra.get();
                    if (matches.size() <= 0) continue;
                    Tile<?> t2 = p2CoefficientsTiles.get(j);
                    MatchIntensities matchIntensities = MatchIntensities.this;
                    synchronized (matchIntensities) {
                        t1.connect(t2, (Collection)ra.get());
                        IJ.log((String)("Connected patch " + p1.getId() + ", coefficient " + i + "  +  patch " + p2.getId() + ", coefficient " + j + " by " + matches.size() + " samples."));
                        continue;
                    }
                }
            }
        }
    }
}

