/*
 * Decompiled with CFR 0.152.
 */
package loci.plugins.util;

import com.jgoodies.forms.layout.CellConstraints;
import com.jgoodies.forms.layout.FormLayout;
import ij.text.TextPanel;
import ij.text.TextWindow;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Menu;
import java.awt.MenuBar;
import java.awt.MenuItem;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SearchableWindow
extends TextWindow {
    protected TextPanel panel = this.getTextPanel();
    protected int index = -1;

    public SearchableWindow(String title, String headings, String data, int w, int h) {
        super(title, headings, data, w, h);
        MenuBar menubar = this.getMenuBar();
        Menu menu = menubar.getMenu(0);
        MenuItem search = new MenuItem("Search...");
        search.setActionCommand("search");
        search.addActionListener((ActionListener)((Object)this));
        menu.add(search);
    }

    public void actionPerformed(ActionEvent e) {
        if ("search".equals(e.getActionCommand())) {
            new SearchBox(this);
        } else {
            this.panel.actionPerformed(e);
        }
    }

    public void selectLine(int index) {
        Scrollbar ss = null;
        Component[] components = this.panel.getComponents();
        for (int i = 0; i < components.length; ++i) {
            Scrollbar s;
            if (!(components[i] instanceof Scrollbar) || (s = (Scrollbar)components[i]).getOrientation() != 1) continue;
            ss = s;
        }
        int min = ss.getMinimum();
        int scrollValue = min + index;
        ss.setValue(scrollValue);
        this.panel.adjustmentValueChanged(null);
    }

    class SearchBox
    extends JDialog
    implements ActionListener,
    ChangeListener {
        private JTextField searchBox;
        private JCheckBox ignore;
        private boolean ignoreCase;
        private SearchableWindow searchPane;

        public SearchBox(SearchableWindow searchPane) {
            this.setTitle("Search...");
            this.searchPane = searchPane;
            FormLayout layout = new FormLayout("pref,pref:grow,pref,pref:grow,pref", "pref,pref:grow,pref,pref:grow,pref,pref:grow,pref");
            JPanel panel = new JPanel((LayoutManager)layout);
            CellConstraints cc = new CellConstraints();
            this.searchBox = new JTextField();
            this.ignore = new JCheckBox("Ignore Case", false);
            this.ignore.addChangeListener(this);
            JButton next = new JButton("Find Next");
            next.setActionCommand("next");
            next.addActionListener(this);
            JButton previous = new JButton("Find Previous");
            previous.setActionCommand("previous");
            previous.addActionListener(this);
            JButton cancel = new JButton("Cancel");
            cancel.setActionCommand("cancel");
            cancel.addActionListener(this);
            panel.add((Component)this.searchBox, cc.xy(2, 2));
            panel.add((Component)this.ignore, cc.xy(2, 4));
            panel.add((Component)next, cc.xy(4, 2));
            panel.add((Component)previous, cc.xy(4, 4));
            panel.add((Component)cancel, cc.xywh(2, 6, 3, 1));
            panel.setSize(new Dimension(350, 200));
            this.setContentPane(panel);
            this.setDefaultCloseOperation(2);
            this.setSize(new Dimension(350, 200));
            this.setVisible(true);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd.equals("next")) {
                this.searchPane.panel.resetSelection();
                String text = this.searchBox.getText();
                boolean found = false;
                int original = this.searchPane.index;
                while (!found) {
                    ++this.searchPane.index;
                    if (this.searchPane.index >= this.searchPane.panel.getLineCount()) {
                        this.searchPane.index = 0;
                    }
                    if (this.searchPane.index == original) {
                        return;
                    }
                    String line = this.searchPane.panel.getLine(this.searchPane.index);
                    found = this.ignoreCase ? line.toLowerCase().indexOf(text.toLowerCase()) >= 0 : line.indexOf(text) >= 0;
                }
                this.searchPane.selectLine(this.searchPane.index);
            } else if (cmd.equals("previous")) {
                this.searchPane.panel.resetSelection();
                String text = this.searchBox.getText();
                boolean found = false;
                int original = this.searchPane.index;
                while (!found) {
                    --this.searchPane.index;
                    if (this.searchPane.index < 0) {
                        this.searchPane.index = this.searchPane.panel.getLineCount() - 1;
                    }
                    if (this.searchPane.index == original) {
                        return;
                    }
                    String line = this.searchPane.panel.getLine(this.searchPane.index);
                    found = this.ignoreCase ? line.toLowerCase().indexOf(text.toLowerCase()) >= 0 : line.indexOf(text) >= 0;
                }
                this.searchPane.selectLine(this.searchPane.index);
            } else if (cmd.equals("cancel")) {
                this.dispose();
            }
        }

        @Override
        public void stateChanged(ChangeEvent e) {
            if (e.getSource().equals(this.ignore)) {
                this.ignoreCase = this.ignore.isSelected();
            }
        }
    }
}

