/*
 * Decompiled with CFR 0.152.
 */
import java.text.DecimalFormat;
import java.text.FieldPosition;

public class KLT {
    double[][] m;
    private int size;
    private EigenRaum[] ers;

    private static double[][] makeAutoCovarianceMatrice_(double[][] vec) {
        int i;
        int dim = vec[0].length;
        double[][] out = new double[dim][dim];
        double _n = 1.0 / (double)vec.length;
        for (int k = 0; k < vec.length; ++k) {
            double[] x = vec[k];
            for (int i2 = 0; i2 < dim; ++i2) {
                for (int j = i2; j < dim; ++j) {
                    double[] dArray = out[i2];
                    int n = j;
                    dArray[n] = dArray[n] + x[i2] * x[j];
                }
            }
        }
        for (i = 0; i < dim; ++i) {
            int j = i;
            while (j < dim) {
                double[] dArray = out[i];
                int n = j++;
                dArray[n] = dArray[n] * _n;
            }
        }
        for (i = 0; i < dim; ++i) {
            for (int j = i; j < dim; ++j) {
                out[j][i] = out[i][j];
            }
        }
        return out;
    }

    public KLT(double[][] vecs) {
        this.size = vecs[0].length;
        this.m = KLT.makeAutoCovarianceMatrice_(vecs);
        double[] d_ = new double[this.size];
        double[] e_ = new double[this.size];
        SymMat.tred2_(this.m, this.size, d_, e_);
        SymMat.tqli_(d_, e_, this.size, this.m);
        this.ers = new EigenRaum[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.ers[i] = new EigenRaum(d_[i], i);
        }
    }

    public double[] getEigenValues() {
        double[] ev = new double[this.ers.length];
        for (int i = 0; i < ev.length; ++i) {
            ev[i] = this.ers[i].ew;
        }
        return ev;
    }

    public double[][] getEigenVectors() {
        double[][] ev = new double[this.ers.length][this.size];
        for (int i = 0; i < ev.length; ++i) {
            for (int j = 0; j < ev[0].length; ++j) {
                ev[i][j] = this.m[i][j];
            }
        }
        return ev;
    }

    public double[] transform(double[] x) {
        double[] erg = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                int n = i;
                erg[n] = erg[n] + this.m[j][i] * x[j];
            }
        }
        return erg;
    }

    public void transform(double[][] in, double[][] out, double[] mean) {
        double[] x = new double[this.size];
        for (int n = 0; n < in.length; ++n) {
            int i;
            double[] erg = out[n];
            double[] in_ = in[n];
            for (i = 0; i < this.size; ++i) {
                x[i] = in_[i] - mean[i];
            }
            for (i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    int n2 = i;
                    erg[n2] = erg[n2] + this.m[j][i] * x[j];
                }
            }
        }
    }

    public double[] inverseTransform(double[] x) {
        double[] erg = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                int n = i;
                erg[n] = erg[n] + this.m[i][j] * x[j];
            }
        }
        return erg;
    }

    public void inverseTransform(double[][] in, double[][] out, double[] mean, double[] weights) {
        for (int n = 0; n < in.length; ++n) {
            double[] x = in[n];
            double[] erg = out[n];
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    int n2 = i;
                    erg[n2] = erg[n2] + this.m[i][j] * x[j] * weights[j];
                }
                int n3 = i;
                erg[n3] = erg[n3] + mean[i];
            }
        }
    }

    public void inverseTransform(double[][] in, double[][] out, double[] mean) {
        for (int n = 0; n < in.length; ++n) {
            double[] x = in[n];
            double[] erg = out[n];
            for (int i = 0; i < this.size; ++i) {
                for (int j = 0; j < this.size; ++j) {
                    int n2 = i;
                    erg[n2] = erg[n2] + this.m[i][j] * x[j];
                }
                int n3 = i;
                erg[n3] = erg[n3] + mean[i];
            }
        }
    }

    public double[] inverseTransform(double[] x, double[] weights) {
        double[] erg = new double[this.size];
        for (int i = 0; i < this.size; ++i) {
            for (int j = 0; j < this.size; ++j) {
                int n = i;
                erg[n] = erg[n] + this.m[i][j] * x[j] * weights[j];
            }
        }
        return erg;
    }

    public void printBase() {
        for (int x = 0; x < this.size; ++x) {
            for (int y = 0; y < this.size; ++y) {
                System.err.print(KLT.format(this.m[x][y]) + " ");
            }
            System.err.println();
        }
        System.err.println();
    }

    public static double[][] normalize(double[][] vecs, double[] mean) {
        int k;
        int i;
        if (vecs == null || vecs.length == 0 || mean.length < vecs[0].length) {
            return null;
        }
        double[][] out = new double[vecs.length][vecs[0].length];
        int n = vecs.length;
        for (i = 0; i < vecs[0].length; ++i) {
            mean[i] = 0.0;
        }
        for (i = 0; i < vecs[0].length; ++i) {
            for (k = 0; k < n; ++k) {
                int n2 = i;
                mean[n2] = mean[n2] + vecs[k][i];
            }
        }
        i = 0;
        while (i < vecs[0].length) {
            int n3 = i++;
            mean[n3] = mean[n3] / (double)n;
        }
        for (i = 0; i < vecs[0].length; ++i) {
            for (k = 0; k < n; ++k) {
                out[k][i] = vecs[k][i] - mean[i];
            }
        }
        return out;
    }

    public static double[] denormal(double[] v, double[] mean) {
        double[] out = new double[v.length];
        for (int i = 0; i < v.length; ++i) {
            out[i] = v[i] + mean[i];
        }
        return out;
    }

    private static String format(double x, int vor, int nach) {
        char[] sp = new char[vor];
        for (int i = 0; i < vor; ++i) {
            sp[i] = 32;
        }
        String spaces = new String(sp);
        DecimalFormat f = new DecimalFormat();
        f.setMinimumFractionDigits(nach);
        StringBuffer buf = new StringBuffer();
        FieldPosition fpos = new FieldPosition(0);
        f.format(x, buf, fpos);
        int anzSp = vor - (fpos.getEndIndex() - fpos.getBeginIndex());
        if (x < 0.0) {
            --anzSp;
        }
        if (anzSp < 0) {
            return buf.toString();
        }
        return spaces.substring(0, anzSp) + buf.toString();
    }

    private static final String format(double x) {
        return KLT.format(x, 10, 5);
    }

    private class EigenRaum
    implements Comparable {
        double ew;
        int evindex;

        EigenRaum(double ew, int evindex) {
            this.ew = ew;
            this.evindex = evindex;
        }

        public int compareTo(Object o) throws ClassCastException {
            if (!(o instanceof EigenRaum)) {
                throw new ClassCastException();
            }
            EigenRaum er = (EigenRaum)o;
            if (Math.abs(this.ew) == Math.abs(er.ew)) {
                return 0;
            }
            return Math.abs(this.ew) > Math.abs(er.ew) ? -1 : 1;
        }
    }
}

