/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.FftComplex;
import edu.mines.jtk.dsp.FftReal;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class Fft {
    private FftReal _fft1r;
    private FftComplex _fft1c;
    private FftComplex _fft2;
    private FftComplex _fft3;
    private Sampling _sx1;
    private Sampling _sx2;
    private Sampling _sx3;
    private Sampling _sk1;
    private Sampling _sk2;
    private Sampling _sk3;
    private int _sign1;
    private int _sign2;
    private int _sign3;
    private int _nfft1;
    private int _nfft2;
    private int _nfft3;
    private int _padding1;
    private int _padding2;
    private int _padding3;
    private boolean _center1;
    private boolean _center2;
    private boolean _center3;
    private boolean _complex;
    private boolean _overwrite;

    public Fft(float[] f) {
        this(f.length);
    }

    public Fft(float[][] f) {
        this(f[0].length, f.length);
    }

    public Fft(float[][][] f) {
        this(f[0][0].length, f[0].length, f.length);
    }

    public Fft(boolean complex, float[] f) {
        this(f.length / 2);
        this.setComplex(complex);
    }

    public Fft(boolean complex, float[][] f) {
        this(f[0].length / 2, f.length);
        this.setComplex(complex);
    }

    public Fft(boolean complex, float[][][] f) {
        this(f[0][0].length / 2, f[0].length, f.length);
        this.setComplex(complex);
    }

    public Fft(int nx1) {
        this(new Sampling(nx1, 1.0, 0.0));
    }

    public Fft(int nx1, int nx2) {
        this(new Sampling(nx1, 1.0, 0.0), new Sampling(nx2, 1.0, 0.0));
    }

    public Fft(int nx1, int nx2, int nx3) {
        this(new Sampling(nx1, 1.0, 0.0), new Sampling(nx2, 1.0, 0.0), new Sampling(nx3, 1.0, 0.0));
    }

    public Fft(Sampling sx1) {
        this(sx1, null, null);
    }

    public Fft(Sampling sx1, Sampling sx2) {
        this(sx1, sx2, null);
    }

    public Fft(Sampling sx1, Sampling sx2, Sampling sx3) {
        this._sx1 = sx1;
        this._sx2 = sx2;
        this._sx3 = sx3;
        this._sign1 = -1;
        this._sign2 = -1;
        this._sign3 = -1;
        this.updateSampling1();
        this.updateSampling2();
        this.updateSampling3();
    }

    public void setComplex(boolean complex) {
        if (this._complex != complex) {
            this._complex = complex;
            this.updateSampling1();
        }
    }

    public void setOverwrite(boolean overwrite) {
        this._overwrite = overwrite;
    }

    public Sampling getFrequencySampling1() {
        return this._sk1;
    }

    public Sampling getFrequencySampling2() {
        return this._sk2;
    }

    public Sampling getFrequencySampling3() {
        return this._sk3;
    }

    public void setSign(int sign) {
        this.setSign1(sign);
        this.setSign2(sign);
        this.setSign3(sign);
    }

    public void setSign1(int sign) {
        this._sign1 = sign >= 0 ? 1 : -1;
    }

    public void setSign2(int sign) {
        this._sign2 = sign >= 0 ? 1 : -1;
    }

    public void setSign3(int sign) {
        this._sign3 = sign >= 0 ? 1 : -1;
    }

    public void setCenter(boolean center) {
        this.setCenter1(center);
        this.setCenter2(center);
        this.setCenter3(center);
    }

    public void setCenter1(boolean center) {
        if (this._center1 != center) {
            this._center1 = center;
            this.updateSampling1();
        }
    }

    public void setCenter2(boolean center) {
        if (this._center2 != center) {
            this._center2 = center;
            this.updateSampling2();
        }
    }

    public void setCenter3(boolean center) {
        if (this._center3 != center) {
            this._center3 = center;
            this.updateSampling3();
        }
    }

    public void setPadding(int padding) {
        this.setPadding1(padding);
        this.setPadding2(padding);
        this.setPadding3(padding);
    }

    public void setPadding1(int padding) {
        if (this._padding1 != padding) {
            this._padding1 = padding;
            this.updateSampling1();
        }
    }

    public void setPadding2(int padding) {
        if (this._padding2 != padding) {
            this._padding2 = padding;
            this.updateSampling2();
        }
    }

    public void setPadding3(int padding) {
        if (this._padding3 != padding) {
            this._padding3 = padding;
            this.updateSampling3();
        }
    }

    public float[] applyForward(float[] f) {
        this.ensureSamplingX1(f);
        float[] fpad = this.pad(f);
        if (this._complex) {
            this._fft1c.complexToComplex(this._sign1, fpad, fpad);
        } else {
            this._fft1r.realToComplex(this._sign1, fpad, fpad);
        }
        this.phase(fpad);
        this.center(fpad);
        return fpad;
    }

    public float[][] applyForward(float[][] f) {
        this.ensureSamplingX2(f);
        float[][] fpad = this.pad(f);
        int nx2 = this._sx2.getCount();
        if (this._complex) {
            this._fft1c.complexToComplex1(this._sign1, nx2, fpad, fpad);
            this._fft2.complexToComplex2(this._sign2, this._nfft1, fpad, fpad);
        } else {
            this._fft1r.realToComplex1(this._sign1, nx2, fpad, fpad);
            this._fft2.complexToComplex2(this._sign2, this._nfft1 / 2 + 1, fpad, fpad);
        }
        this.phase(fpad);
        this.center(fpad);
        return fpad;
    }

    public float[][][] applyForward(float[][][] f) {
        this.ensureSamplingX3(f);
        float[][][] fpad = this.pad(f);
        int nx2 = this._sx2.getCount();
        int nx3 = this._sx3.getCount();
        if (this._complex) {
            this._fft1c.complexToComplex1(this._sign1, nx2, nx3, fpad, fpad);
            this._fft2.complexToComplex2(this._sign2, this._nfft1, nx3, fpad, fpad);
            this._fft3.complexToComplex3(this._sign3, this._nfft1, this._nfft2, fpad, fpad);
        } else {
            this._fft1r.realToComplex1(this._sign1, nx2, nx3, fpad, fpad);
            this._fft2.complexToComplex2(this._sign2, this._nfft1 / 2 + 1, nx3, fpad, fpad);
            this._fft3.complexToComplex3(this._sign3, this._nfft1 / 2 + 1, this._nfft2, fpad, fpad);
        }
        this.phase(fpad);
        this.center(fpad);
        return fpad;
    }

    public float[] applyInverse(float[] g) {
        this.ensureSamplingK1(g);
        int nx1 = this._sx1.getCount();
        float[] gpad = this._overwrite ? g : ArrayMath.copy(g);
        this.uncenter(gpad);
        this.unphase(gpad);
        if (this._complex) {
            this._fft1c.complexToComplex(-this._sign1, gpad, gpad);
            this._fft1c.scale(nx1, gpad);
            return ArrayMath.ccopy(nx1, gpad);
        }
        this._fft1r.complexToReal(-this._sign1, gpad, gpad);
        this._fft1r.scale(nx1, gpad);
        return ArrayMath.copy(nx1, gpad);
    }

    public float[][] applyInverse(float[][] g) {
        this.ensureSamplingK2(g);
        float[][] gpad = this._overwrite ? g : ArrayMath.copy(g);
        int nx1 = this._sx1.getCount();
        int nx2 = this._sx2.getCount();
        this.uncenter(gpad);
        this.unphase(gpad);
        if (this._complex) {
            this._fft2.complexToComplex2(-this._sign2, this._nfft1, gpad, gpad);
            this._fft2.scale(this._nfft1, nx2, gpad);
            this._fft1c.complexToComplex1(-this._sign1, nx2, gpad, gpad);
            this._fft1c.scale(nx1, nx2, gpad);
            return ArrayMath.ccopy(nx1, nx2, gpad);
        }
        this._fft2.complexToComplex2(-this._sign2, this._nfft1 / 2 + 1, gpad, gpad);
        this._fft2.scale(this._nfft1 / 2 + 1, nx2, gpad);
        this._fft1r.complexToReal1(-this._sign1, nx2, gpad, gpad);
        this._fft1r.scale(nx1, nx2, gpad);
        return ArrayMath.copy(nx1, nx2, gpad);
    }

    public float[][][] applyInverse(float[][][] g) {
        this.ensureSamplingK3(g);
        float[][][] gpad = this._overwrite ? g : ArrayMath.copy(g);
        int nx1 = this._sx1.getCount();
        int nx2 = this._sx2.getCount();
        int nx3 = this._sx3.getCount();
        this.uncenter(gpad);
        this.unphase(gpad);
        if (this._complex) {
            this._fft3.complexToComplex3(-this._sign3, this._nfft1, this._nfft2, gpad, gpad);
            this._fft3.scale(this._nfft1, this._nfft2, nx3, gpad);
            this._fft2.complexToComplex2(-this._sign2, this._nfft1, nx3, gpad, gpad);
            this._fft2.scale(this._nfft1, nx2, nx3, gpad);
            this._fft1c.complexToComplex1(-this._sign1, nx2, nx3, gpad, gpad);
            this._fft1c.scale(nx1, nx2, nx3, gpad);
            return ArrayMath.ccopy(nx1, nx2, nx3, gpad);
        }
        this._fft3.complexToComplex3(-this._sign3, this._nfft1 / 2 + 1, this._nfft2, gpad, gpad);
        this._fft3.scale(this._nfft1 / 2 + 1, this._nfft2, nx3, gpad);
        this._fft2.complexToComplex2(-this._sign2, this._nfft1 / 2 + 1, nx3, gpad, gpad);
        this._fft2.scale(this._nfft1 / 2 + 1, nx2, nx3, gpad);
        this._fft1r.complexToReal1(-this._sign1, nx2, nx3, gpad, gpad);
        this._fft1r.scale(nx1, nx2, nx3, gpad);
        return ArrayMath.copy(nx1, nx2, nx3, gpad);
    }

    private void updateSampling1() {
        double fk;
        int nk;
        double dk;
        if (this._sx1 == null) {
            return;
        }
        int nx = this._sx1.getCount();
        double dx = this._sx1.getDelta();
        int npad = nx + this._padding1;
        if (this._complex) {
            int nfft = FftComplex.nfftSmall(npad);
            dk = 1.0 / ((double)nfft * dx);
            if (this._center1) {
                boolean even = nfft % 2 == 0;
                nk = even ? nfft + 1 : nfft;
                fk = even ? -0.5 / dx : -0.5 / dx + 0.5 * dk;
            } else {
                nk = nfft;
                fk = 0.0;
            }
            if (this._fft1c == null || this._nfft1 != nfft) {
                this._fft1c = new FftComplex(nfft);
                this._fft1r = null;
                this._nfft1 = nfft;
            }
        } else {
            int nfft = FftReal.nfftSmall(npad);
            dk = 1.0 / ((double)nfft * dx);
            if (this._center1) {
                nk = nfft + 1;
                fk = -0.5 / dx;
            } else {
                nk = nfft / 2 + 1;
                fk = 0.0;
            }
            if (this._fft1r == null || this._nfft1 != nfft) {
                this._fft1r = new FftReal(nfft);
                this._fft1c = null;
                this._nfft1 = nfft;
            }
        }
        this._sk1 = new Sampling(nk, dk, fk);
    }

    private void updateSampling2() {
        double fk;
        int nk;
        if (this._sx2 == null) {
            return;
        }
        int nx = this._sx2.getCount();
        double dx = this._sx2.getDelta();
        int npad = nx + this._padding2;
        int nfft = FftComplex.nfftSmall(npad);
        double dk = 1.0 / ((double)nfft * dx);
        if (this._center2) {
            boolean even = nfft % 2 == 0;
            nk = even ? nfft + 1 : nfft;
            fk = even ? -0.5 / dx : -0.5 / dx + 0.5 * dk;
        } else {
            nk = nfft;
            fk = 0.0;
        }
        if (this._fft2 == null || this._nfft2 != nfft) {
            this._fft2 = new FftComplex(nfft);
            this._nfft2 = nfft;
        }
        this._sk2 = new Sampling(nk, dk, fk);
    }

    private void updateSampling3() {
        double fk;
        int nk;
        if (this._sx3 == null) {
            return;
        }
        int nx = this._sx3.getCount();
        double dx = this._sx3.getDelta();
        int npad = nx + this._padding3;
        int nfft = FftComplex.nfftSmall(npad);
        double dk = 1.0 / ((double)nfft * dx);
        if (this._center3) {
            boolean even = nfft % 2 == 0;
            nk = even ? nfft + 1 : nfft;
            fk = even ? -0.5 / dx : -0.5 / dx + 0.5 * dk;
        } else {
            nk = nfft;
            fk = 0.0;
        }
        if (this._fft3 == null || this._nfft3 != nfft) {
            this._fft3 = new FftComplex(nfft);
            this._nfft3 = nfft;
        }
        this._sk3 = new Sampling(nk, dk, fk);
    }

    private float[] pad(float[] f) {
        int nk1 = this._sk1.getCount();
        float[] fpad = new float[2 * nk1];
        if (this._complex) {
            ArrayMath.ccopy(f.length / 2, f, fpad);
        } else {
            ArrayMath.copy(f.length, f, fpad);
        }
        return fpad;
    }

    private float[][] pad(float[][] f) {
        int nk1 = this._sk1.getCount();
        int nk2 = this._sk2.getCount();
        float[][] fpad = new float[nk2][2 * nk1];
        if (this._complex) {
            ArrayMath.ccopy(f[0].length / 2, f.length, f, fpad);
        } else {
            ArrayMath.copy(f[0].length, f.length, f, fpad);
        }
        return fpad;
    }

    private float[][][] pad(float[][][] f) {
        int nk1 = this._sk1.getCount();
        int nk2 = this._sk2.getCount();
        int nk3 = this._sk3.getCount();
        float[][][] fpad = new float[nk3][nk2][2 * nk1];
        if (this._complex) {
            ArrayMath.ccopy(f[0][0].length / 2, f[0].length, f.length, f, fpad);
        } else {
            ArrayMath.copy(f[0][0].length, f[0].length, f.length, f, fpad);
        }
        return fpad;
    }

    private void ensureSamplingX1(float[] f) {
        Check.state(this._sx1 != null, "sampling sx1 exists for 1st dimension");
        int l1 = f.length;
        int n1 = this._sx1.getCount();
        if (this._complex) {
            n1 *= 2;
        }
        Check.argument(n1 == l1, "array length consistent with sampling sx1");
    }

    private void ensureSamplingX2(float[][] f) {
        Check.state(this._sx2 != null, "sampling sx2 exists for 2nd dimension");
        this.ensureSamplingX1(f[0]);
        int l2 = f.length;
        int n2 = this._sx2.getCount();
        Check.argument(n2 == l2, "array length consistent with sampling sx2");
    }

    private void ensureSamplingX3(float[][][] f) {
        Check.state(this._sx3 != null, "sampling sx3 exists for 3rd dimension");
        this.ensureSamplingX2(f[0]);
        int l3 = f.length;
        int n3 = this._sx3.getCount();
        Check.argument(n3 == l3, "array length consistent with sampling sx3");
    }

    private void ensureSamplingK1(float[] f) {
        Check.state(this._sk1 != null, "sampling sk1 exists for 1st dimension");
        int l1 = f.length;
        int n1 = this._sk1.getCount();
        Check.argument(2 * n1 == l1, "array length consistent with sampling sk1");
    }

    private void ensureSamplingK2(float[][] f) {
        Check.state(this._sk2 != null, "sampling sk2 exists for 2nd dimension");
        this.ensureSamplingK1(f[0]);
        int l2 = f.length;
        int n2 = this._sk2.getCount();
        Check.argument(n2 == l2, "array length consistent with sampling sk2");
    }

    private void ensureSamplingK3(float[][][] f) {
        Check.state(this._sk3 != null, "sampling sk3 exists for 3rd dimension");
        this.ensureSamplingK2(f[0]);
        int l3 = f.length;
        int n3 = this._sk3.getCount();
        Check.argument(n3 == l3, "array length consistent with sampling sk3");
    }

    private void center(float[] f) {
        this.center1(f);
        if (this._center1 && !this._complex) {
            Fft.creflect(this._nfft1 / 2, this._nfft1 / 2, f);
        }
    }

    private void center1(float[] f) {
        boolean even1;
        if (!this._center1) {
            return;
        }
        int nk1 = this._sk1.getCount();
        int nfft1 = this._nfft1;
        boolean bl = even1 = nfft1 % 2 == 0;
        if (this._complex) {
            if (even1) {
                Fft.cswap(nfft1 / 2, 0, nfft1 / 2, f);
                f[2 * (nk1 - 1)] = f[0];
                f[2 * (nk1 - 1) + 1] = f[1];
            } else {
                Fft.cswap((nfft1 - 1) / 2, 0, (nfft1 + 1) / 2, f);
                Fft.crotateLeft((nfft1 + 1) / 2, (nfft1 - 1) / 2, f);
            }
        } else {
            Fft.cshift(nfft1 / 2 + 1, 0, nfft1 / 2, f);
        }
    }

    private void uncenter(float[] f) {
        this.uncenter1(f);
    }

    private void uncenter1(float[] f) {
        boolean even1;
        if (!this._center1) {
            return;
        }
        int nfft1 = this._nfft1;
        boolean bl = even1 = nfft1 % 2 == 0;
        if (this._complex) {
            if (even1) {
                Fft.cswap(nfft1 / 2, 0, nfft1 / 2, f);
            } else {
                Fft.crotateRight((nfft1 + 1) / 2, (nfft1 - 1) / 2, f);
                Fft.cswap((nfft1 - 1) / 2, 0, (nfft1 + 1) / 2, f);
            }
        } else {
            Fft.cshift(nfft1 / 2 + 1, nfft1 / 2, 0, f);
        }
    }

    private static void creflect(int n, int i, float[] f) {
        int ir = 2 * (i + 1);
        int ii = ir + 1;
        int jr = 2 * (i - 1);
        int ji = jr + 1;
        int k = 0;
        while (k < n) {
            f[jr] = f[ir];
            f[ji] = -f[ii];
            ++k;
            ir += 2;
            ii += 2;
            jr -= 2;
            ji -= 2;
        }
    }

    private static void cshift(int n, int i, int j, float[] f) {
        if (i < j) {
            int ir = 2 * (i + n - 1);
            int ii = ir + 1;
            int jr = 2 * (j + n - 1);
            int ji = jr + 1;
            int k = 0;
            while (k < n) {
                f[jr] = f[ir];
                f[ji] = f[ii];
                ++k;
                ir -= 2;
                ii -= 2;
                jr -= 2;
                ji -= 2;
            }
        } else {
            int ir = 2 * i;
            int ii = ir + 1;
            int jr = 2 * j;
            int ji = jr + 1;
            int k = 0;
            while (k < n) {
                f[jr] = f[ir];
                f[ji] = f[ii];
                ++k;
                ir += 2;
                ii += 2;
                jr += 2;
                ji += 2;
            }
        }
    }

    private static void cswap(int n, int i, int j, float[] f) {
        int ir = 2 * i;
        int ii = ir + 1;
        int jr = 2 * j;
        int ji = jr + 1;
        int k = 0;
        while (k < n) {
            float fir = f[ir];
            f[ir] = f[jr];
            f[jr] = fir;
            float fii = f[ii];
            f[ii] = f[ji];
            f[ji] = fii;
            ++k;
            ir += 2;
            ii += 2;
            jr += 2;
            ji += 2;
        }
    }

    private static void crotateLeft(int n, int j, float[] f) {
        float fjr = f[j * 2];
        float fji = f[j * 2 + 1];
        int i = j + 1;
        int ir = 2 * i;
        int ii = ir + 1;
        int k = 1;
        while (k < n) {
            f[ir - 2] = f[ir];
            f[ii - 2] = f[ii];
            ++k;
            ir += 2;
            ii += 2;
        }
        f[ir - 2] = fjr;
        f[ii - 2] = fji;
    }

    private static void crotateRight(int n, int j, float[] f) {
        int m = j + n - 1;
        float fmr = f[m * 2];
        float fmi = f[m * 2 + 1];
        int i = m;
        int ir = 2 * i;
        int ii = ir + 1;
        int k = 1;
        while (k < n) {
            f[ir] = f[ir - 2];
            f[ii] = f[ii - 2];
            ++k;
            ir -= 2;
            ii -= 2;
        }
        f[ir] = fmr;
        f[ii] = fmi;
    }

    private void center(float[][] f) {
        if (this._center1) {
            for (int i2 = 0; i2 < this._nfft2; ++i2) {
                this.center1(f[i2]);
            }
        }
        this.center2(f);
        if (this._center1 && !this._complex) {
            Fft.creflect(this._nfft1 / 2, this._nfft1 / 2, f);
        }
    }

    private void uncenter(float[][] f) {
        this.uncenter2(f);
        if (this._center1) {
            for (int i2 = 0; i2 < this._nfft2; ++i2) {
                this.uncenter1(f[i2]);
            }
        }
    }

    private void center2(float[][] f) {
        boolean even2;
        if (!this._center2) {
            return;
        }
        int nk2 = this._sk2.getCount();
        int nfft2 = this._nfft2;
        boolean bl = even2 = nfft2 % 2 == 0;
        if (even2) {
            Fft.cswap(nfft2 / 2, 0, nfft2 / 2, f);
            ArrayMath.ccopy(f[0], f[nk2 - 1]);
        } else {
            Fft.cswap((nfft2 - 1) / 2, 0, (nfft2 + 1) / 2, f);
            Fft.crotateLeft((nfft2 + 1) / 2, (nfft2 - 1) / 2, f);
        }
    }

    private void uncenter2(float[][] f) {
        boolean even2;
        if (!this._center2) {
            return;
        }
        int nfft2 = this._nfft2;
        boolean bl = even2 = nfft2 % 2 == 0;
        if (even2) {
            Fft.cswap(nfft2 / 2, 0, nfft2 / 2, f);
        } else {
            Fft.crotateRight((nfft2 + 1) / 2, (nfft2 - 1) / 2, f);
            Fft.cswap((nfft2 - 1) / 2, 0, (nfft2 + 1) / 2, f);
        }
    }

    private static void creflect(int n, int i, float[][] f) {
        int n2 = f.length;
        int i2 = 0;
        int j2 = n2 - 1;
        while (i2 < n2) {
            int ir = 2 * (i + 1);
            int ii = ir + 1;
            int jr = 2 * (i - 1);
            int ji = jr + 1;
            float[] fj2 = f[j2];
            float[] fi2 = f[i2];
            int k = 0;
            while (k < n) {
                fj2[jr] = fi2[ir];
                fj2[ji] = -fi2[ii];
                ++k;
                ir += 2;
                ii += 2;
                jr -= 2;
                ji -= 2;
            }
            ++i2;
            --j2;
        }
    }

    private static void cswap(int n, int i, int j, float[][] f) {
        int k = 0;
        while (k < n) {
            float[] fi = f[i];
            f[i] = f[j];
            f[j] = fi;
            ++k;
            ++i;
            ++j;
        }
    }

    private static void crotateLeft(int n, int j, float[][] f) {
        float[] fj = f[j];
        int m = j + n;
        for (int i = j + 1; i < m; ++i) {
            f[i - 1] = f[i];
        }
        f[i - 1] = fj;
    }

    private static void crotateRight(int n, int j, float[][] f) {
        int m = j + n - 1;
        float[] fm = f[m];
        for (int i = m; i > j; --i) {
            f[i] = f[i - 1];
        }
        f[i] = fm;
    }

    private void center(float[][][] f) {
        int i3;
        if (this._center1) {
            for (i3 = 0; i3 < this._nfft3; ++i3) {
                for (int i2 = 0; i2 < this._nfft2; ++i2) {
                    this.center1(f[i3][i2]);
                }
            }
        }
        if (this._center2) {
            for (i3 = 0; i3 < this._nfft3; ++i3) {
                this.center2(f[i3]);
            }
        }
        this.center3(f);
        if (this._center1 && !this._complex) {
            Fft.creflect(this._nfft1 / 2, this._nfft1 / 2, f);
        }
    }

    private void uncenter(float[][][] f) {
        int i3;
        this.uncenter3(f);
        if (this._center2) {
            for (i3 = 0; i3 < this._nfft3; ++i3) {
                this.uncenter2(f[i3]);
            }
        }
        if (this._center1) {
            for (i3 = 0; i3 < this._nfft3; ++i3) {
                for (int i2 = 0; i2 < this._nfft2; ++i2) {
                    this.uncenter1(f[i3][i2]);
                }
            }
        }
    }

    private void center3(float[][][] f) {
        boolean even3;
        if (!this._center3) {
            return;
        }
        int nk3 = this._sk3.getCount();
        int nfft3 = this._nfft3;
        boolean bl = even3 = nfft3 % 2 == 0;
        if (even3) {
            Fft.cswap(nfft3 / 2, 0, nfft3 / 2, f);
            ArrayMath.ccopy(f[0], f[nk3 - 1]);
        } else {
            Fft.cswap((nfft3 - 1) / 2, 0, (nfft3 + 1) / 2, f);
            Fft.crotateLeft((nfft3 + 1) / 2, (nfft3 - 1) / 2, f);
        }
    }

    private void uncenter3(float[][][] f) {
        boolean even3;
        if (!this._center3) {
            return;
        }
        int nfft3 = this._nfft3;
        boolean bl = even3 = nfft3 % 2 == 0;
        if (even3) {
            Fft.cswap(nfft3 / 2, 0, nfft3 / 2, f);
        } else {
            Fft.crotateRight((nfft3 + 1) / 2, (nfft3 - 1) / 2, f);
            Fft.cswap((nfft3 - 1) / 2, 0, (nfft3 + 1) / 2, f);
        }
    }

    private static void creflect(int n, int i, float[][][] f) {
        int n2 = f[0].length;
        int n3 = f.length;
        int i3 = 0;
        int j3 = n3 - 1;
        while (i3 < n3) {
            int i2 = 0;
            int j2 = n2 - 1;
            while (i2 < n2) {
                int ir = 2 * (i + 1);
                int ii = ir + 1;
                int jr = 2 * (i - 1);
                int ji = jr + 1;
                float[] fj3j2 = f[j3][j2];
                float[] fi3i2 = f[i3][i2];
                int k = 0;
                while (k < n) {
                    fj3j2[jr] = fi3i2[ir];
                    fj3j2[ji] = -fi3i2[ii];
                    ++k;
                    ir += 2;
                    ii += 2;
                    jr -= 2;
                    ji -= 2;
                }
                ++i2;
                --j2;
            }
            ++i3;
            --j3;
        }
    }

    private static void cswap(int n, int i, int j, float[][][] f) {
        int k = 0;
        while (k < n) {
            float[][] fi = f[i];
            f[i] = f[j];
            f[j] = fi;
            ++k;
            ++i;
            ++j;
        }
    }

    private static void crotateLeft(int n, int j, float[][][] f) {
        float[][] fj = f[j];
        int m = j + n;
        for (int i = j + 1; i < m; ++i) {
            f[i - 1] = f[i];
        }
        f[i - 1] = fj;
    }

    private static void crotateRight(int n, int j, float[][][] f) {
        int m = j + n - 1;
        float[][] fm = f[m];
        for (int i = m; i > j; --i) {
            f[i] = f[i - 1];
        }
        f[i] = fm;
    }

    private void phase(float[] f) {
        this.phase(this._sign1, f);
    }

    private void unphase(float[] f) {
        this.phase(-this._sign1, f);
    }

    private void phase(int sign1, float[] f) {
        double fx = this._sx1.getFirst();
        if (fx == 0.0) {
            return;
        }
        int nk = this._complex ? this._nfft1 : this._nfft1 / 2 + 1;
        double dp = (double)sign1 * 2.0 * Math.PI * this._sk1.getDelta() * fx;
        int i = 0;
        int ir = 0;
        int ii = 1;
        while (i < nk) {
            float p = (float)((double)i * dp);
            float cosp = ArrayMath.cos(p);
            float sinp = ArrayMath.sin(p);
            float fr = f[ir];
            float fi = f[ii];
            f[ir] = fr * cosp - fi * sinp;
            f[ii] = fi * cosp + fr * sinp;
            ++i;
            ir += 2;
            ii += 2;
        }
    }

    private void phase(float[][] f) {
        this.phase(this._sign1, this._sign2, f);
    }

    private void unphase(float[][] f) {
        this.phase(-this._sign1, -this._sign2, f);
    }

    private void phase(int sign1, int sign2, float[][] f) {
        double fx1 = this._sx1.getFirst();
        double fx2 = this._sx2.getFirst();
        if (fx1 == 0.0 && fx2 == 0.0) {
            return;
        }
        int nk1 = this._complex ? this._nfft1 : this._nfft1 / 2 + 1;
        int nk2 = this._nfft2;
        double dp1 = (double)sign1 * 2.0 * Math.PI * this._sk1.getDelta() * fx1;
        double dp2 = (double)sign2 * 2.0 * Math.PI * this._sk2.getDelta() * fx2;
        for (int i2 = 0; i2 < nk2; ++i2) {
            double p2 = (double)i2 * dp2;
            float[] f2 = f[i2];
            int i1 = 0;
            int ir = 0;
            int ii = 1;
            while (i1 < nk1) {
                float p = (float)((double)i1 * dp1 + p2);
                float cosp = ArrayMath.cos(p);
                float sinp = ArrayMath.sin(p);
                float fr = f2[ir];
                float fi = f2[ii];
                f2[ir] = fr * cosp - fi * sinp;
                f2[ii] = fi * cosp + fr * sinp;
                ++i1;
                ir += 2;
                ii += 2;
            }
        }
    }

    private void phase(float[][][] f) {
        this.phase(this._sign1, this._sign2, this._sign3, f);
    }

    private void unphase(float[][][] f) {
        this.phase(-this._sign1, -this._sign2, -this._sign3, f);
    }

    private void phase(int sign1, int sign2, int sign3, float[][][] f) {
        double fx1 = this._sx1.getFirst();
        double fx2 = this._sx2.getFirst();
        double fx3 = this._sx3.getFirst();
        if (fx1 == 0.0 && fx2 == 0.0 && fx3 == 0.0) {
            return;
        }
        int nk1 = this._complex ? this._nfft1 : this._nfft1 / 2 + 1;
        int nk2 = this._nfft2;
        int nk3 = this._nfft3;
        double dp1 = (double)sign1 * 2.0 * Math.PI * this._sk1.getDelta() * fx1;
        double dp2 = (double)sign2 * 2.0 * Math.PI * this._sk2.getDelta() * fx2;
        double dp3 = (double)sign3 * 2.0 * Math.PI * this._sk3.getDelta() * fx3;
        for (int i3 = 0; i3 < nk3; ++i3) {
            for (int i2 = 0; i2 < nk2; ++i2) {
                double p23 = (double)i2 * dp2 + (double)i3 * dp3;
                float[] f32 = f[i3][i2];
                int i1 = 0;
                int ir = 0;
                int ii = 1;
                while (i1 < nk1) {
                    float p = (float)((double)i1 * dp1 + p23);
                    float cosp = ArrayMath.cos(p);
                    float sinp = ArrayMath.sin(p);
                    float fr = f32[ir];
                    float fi = f32[ii];
                    f32[ir] = fr * cosp - fi * sinp;
                    f32[ii] = fi * cosp + fr * sinp;
                    ++i1;
                    ir += 2;
                    ii += 2;
                }
            }
        }
    }
}

