/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.dsp.Eigen;
import edu.mines.jtk.dsp.EigenTensors2;
import edu.mines.jtk.dsp.EigenTensors3;
import edu.mines.jtk.dsp.RecursiveGaussianFilter;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Parallel;

public class LocalOrientFilter {
    private RecursiveGaussianFilter _rgfGradient1;
    private RecursiveGaussianFilter _rgfGradient2;
    private RecursiveGaussianFilter _rgfGradient3;
    private RecursiveGaussianFilter _rgfSmoother1;
    private RecursiveGaussianFilter _rgfSmoother2;
    private RecursiveGaussianFilter _rgfSmoother3;

    public LocalOrientFilter(double sigma) {
        this(sigma, sigma, sigma);
    }

    public LocalOrientFilter(double sigma1, double sigma2) {
        this(sigma1, sigma2, sigma2);
    }

    public LocalOrientFilter(double sigma1, double sigma2, double sigma3) {
        RecursiveGaussianFilter recursiveGaussianFilter = this._rgfSmoother1 = sigma1 >= 1.0 ? new RecursiveGaussianFilter(sigma1) : null;
        if (sigma2 == sigma1) {
            this._rgfSmoother2 = this._rgfSmoother1;
        } else {
            RecursiveGaussianFilter recursiveGaussianFilter2 = this._rgfSmoother2 = sigma2 >= 1.0 ? new RecursiveGaussianFilter(sigma2) : null;
        }
        this._rgfSmoother3 = sigma3 == sigma2 ? this._rgfSmoother2 : (sigma3 >= 1.0 ? new RecursiveGaussianFilter(sigma3) : null);
        this.setGradientSmoothing(1.0);
    }

    public void setGradientSmoothing(double sigma) {
        this.setGradientSmoothing(sigma, sigma, sigma);
    }

    public void setGradientSmoothing(double sigma1, double sigma2) {
        this.setGradientSmoothing(sigma1, sigma2, sigma2);
    }

    public void setGradientSmoothing(double sigma1, double sigma2, double sigma3) {
        this._rgfGradient1 = new RecursiveGaussianFilter(sigma1);
        this._rgfGradient2 = sigma2 == sigma1 ? this._rgfGradient1 : new RecursiveGaussianFilter(sigma2);
        this._rgfGradient3 = sigma3 == sigma2 ? this._rgfGradient2 : new RecursiveGaussianFilter(sigma3);
    }

    public void applyForTheta(float[][] x, float[][] theta) {
        this.apply(x, theta, null, null, null, null, null, null, null);
    }

    public void applyForNormal(float[][] x, float[][] u1, float[][] u2) {
        this.apply(x, null, u1, u2, null, null, null, null, null);
    }

    public void applyForNormalLinear(float[][] x, float[][] u1, float[][] u2, float[][] el) {
        this.apply(x, null, u1, u2, null, null, null, null, el);
    }

    public EigenTensors2 applyForTensors(float[][] x) {
        int n1 = x[0].length;
        int n2 = x.length;
        float[][] u1 = new float[n2][n1];
        float[][] u2 = new float[n2][n1];
        float[][] eu = new float[n2][n1];
        float[][] ev = new float[n2][n1];
        this.apply(x, null, u1, u2, null, null, eu, ev, null);
        return new EigenTensors2(u1, u2, eu, ev);
    }

    public void apply(float[][] x, float[][] theta, float[][] u1, float[][] u2, float[][] v1, float[][] v2, float[][] eu, float[][] ev, float[][] el) {
        float[][][] t = new float[8][][];
        int nt = 0;
        if (theta != null) {
            t[nt++] = theta;
        }
        if (u1 != null) {
            t[nt++] = u1;
        }
        if (u2 != null) {
            t[nt++] = u2;
        }
        if (v1 != null) {
            t[nt++] = v1;
        }
        if (v2 != null) {
            t[nt++] = v2;
        }
        if (eu != null) {
            t[nt++] = eu;
        }
        if (ev != null) {
            t[nt++] = ev;
        }
        if (el != null) {
            t[nt++] = el;
        }
        int n1 = x[0].length;
        int n2 = x.length;
        float[][] g1 = nt > 0 ? t[0] : new float[n2][n1];
        float[][] g2 = nt > 1 ? t[1] : new float[n2][n1];
        this._rgfGradient1.apply10(x, g1);
        this._rgfGradient2.apply01(x, g2);
        float[][] g11 = g1;
        float[][] g22 = g2;
        float[][] g12 = nt > 2 ? t[2] : new float[n2][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                float g1i = g1[i2][i1];
                float g2i = g2[i2][i1];
                g11[i2][i1] = g1i * g1i;
                g22[i2][i1] = g2i * g2i;
                g12[i2][i1] = g1i * g2i;
            }
        }
        if (this._rgfSmoother1 != null || this._rgfSmoother2 != null) {
            float[][][] gs;
            float[][] h = nt > 3 ? t[3] : new float[n2][n1];
            for (float[][] g : gs = new float[][][]{g11, g22, g12}) {
                if (this._rgfSmoother1 != null) {
                    this._rgfSmoother1.apply0X(g, h);
                } else {
                    ArrayMath.copy(g, h);
                }
                if (this._rgfSmoother2 != null) {
                    this._rgfSmoother2.applyX0(h, g);
                    continue;
                }
                ArrayMath.copy(h, g);
            }
        }
        float[][] a = new float[2][2];
        float[][] z = new float[2][2];
        float[] e = new float[2];
        for (int i2 = 0; i2 < n2; ++i2) {
            for (int i1 = 0; i1 < n1; ++i1) {
                a[0][0] = g11[i2][i1];
                a[0][1] = g12[i2][i1];
                a[1][0] = g12[i2][i1];
                a[1][1] = g22[i2][i1];
                Eigen.solveSymmetric22(a, z, e);
                float u1i = z[0][0];
                float u2i = z[0][1];
                if (u1i < 0.0f) {
                    u1i = -u1i;
                    u2i = -u2i;
                }
                float v1i = -u2i;
                float v2i = u1i;
                float eui = e[0];
                float evi = e[1];
                if (evi < 0.0f) {
                    evi = 0.0f;
                }
                if (eui < evi) {
                    eui = evi;
                }
                if (theta != null) {
                    theta[i2][i1] = ArrayMath.asin(u2i);
                }
                if (u1 != null) {
                    u1[i2][i1] = u1i;
                }
                if (u2 != null) {
                    u2[i2][i1] = u2i;
                }
                if (v1 != null) {
                    v1[i2][i1] = v1i;
                }
                if (v2 != null) {
                    v2[i2][i1] = v2i;
                }
                if (eu != null) {
                    eu[i2][i1] = eui;
                }
                if (ev != null) {
                    ev[i2][i1] = evi;
                }
                if (el == null) continue;
                el[i2][i1] = (eui - evi) / eui;
            }
        }
    }

    public void applyForThetaPhi(float[][][] x, float[][][] theta, float[][][] phi) {
        this.apply(x, theta, phi, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
    }

    public void applyForNormal(float[][][] x, float[][][] u1, float[][][] u2, float[][][] u3) {
        this.apply(x, null, null, u1, u2, u3, null, null, null, null, null, null, null, null, null, null, null);
    }

    public void applyForNormalPlanar(float[][][] x, float[][][] u1, float[][][] u2, float[][][] u3, float[][][] ep) {
        this.apply(x, null, null, u1, u2, u3, null, null, null, null, null, null, null, null, null, ep, null);
    }

    public void applyForInline(float[][][] x, float[][][] w1, float[][][] w2, float[][][] w3) {
        this.apply(x, null, null, null, null, null, null, null, null, w1, w2, w3, null, null, null, null, null);
    }

    public void applyForInlineLinear(float[][][] x, float[][][] w1, float[][][] w2, float[][][] w3, float[][][] el) {
        this.apply(x, null, null, null, null, null, null, null, null, w1, w2, w3, null, null, null, null, el);
    }

    public EigenTensors3 applyForTensors(float[][][] x) {
        return this.applyForTensors(x, true);
    }

    public EigenTensors3 applyForTensors(float[][][] x, boolean compressed) {
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        float[][][] u2 = new float[n3][n2][n1];
        float[][][] u3 = new float[n3][n2][n1];
        float[][][] w1 = new float[n3][n2][n1];
        float[][][] w2 = new float[n3][n2][n1];
        float[][][] eu = new float[n3][n2][n1];
        float[][][] ev = new float[n3][n2][n1];
        float[][][] ew = new float[n3][n2][n1];
        this.apply(x, null, null, null, u2, u3, null, null, null, w1, w2, null, eu, ev, ew, null, null);
        float[][][] u1 = u3;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float u1i;
                    float u2i = u2[i3][i2][i1];
                    float u3i = u3[i3][i2][i1];
                    float u1s = 1.0f - u2i * u2i - u3i * u3i;
                    float f = u1i = u1s > 0.0f ? ArrayMath.sqrt(u1s) : 0.0f;
                    if (u3i < 0.0f) {
                        u1i = -u1i;
                        u2i = -u2i;
                    }
                    u1[i3][i2][i1] = u1i;
                    u2[i3][i2][i1] = u2i;
                }
            }
        }
        return new EigenTensors3(u1, u2, w1, w2, eu, ev, ew, compressed);
    }

    public void apply(float[][][] x, float[][][] theta, float[][][] phi, float[][][] u1, float[][][] u2, float[][][] u3, float[][][] v1, float[][][] v2, float[][][] v3, float[][][] w1, float[][][] w2, float[][][] w3, float[][][] eu, float[][][] ev, float[][][] ew, float[][][] ep, float[][][] el) {
        float[][][][] t = new float[16][][][];
        int nt = 0;
        if (theta != null) {
            t[nt++] = theta;
        }
        if (phi != null) {
            t[nt++] = phi;
        }
        if (u1 != null) {
            t[nt++] = u1;
        }
        if (u2 != null) {
            t[nt++] = u2;
        }
        if (u3 != null) {
            t[nt++] = u3;
        }
        if (v1 != null) {
            t[nt++] = v1;
        }
        if (v2 != null) {
            t[nt++] = v2;
        }
        if (v3 != null) {
            t[nt++] = v3;
        }
        if (w1 != null) {
            t[nt++] = w1;
        }
        if (w2 != null) {
            t[nt++] = w2;
        }
        if (w3 != null) {
            t[nt++] = w3;
        }
        if (eu != null) {
            t[nt++] = eu;
        }
        if (ev != null) {
            t[nt++] = ev;
        }
        if (ew != null) {
            t[nt++] = ew;
        }
        if (ep != null) {
            t[nt++] = ep;
        }
        if (el != null) {
            t[nt++] = el;
        }
        int n1 = x[0][0].length;
        int n2 = x[0].length;
        int n3 = x.length;
        float[][][] g1 = nt > 0 ? t[0] : new float[n3][n2][n1];
        float[][][] g2 = nt > 1 ? t[1] : new float[n3][n2][n1];
        float[][][] g3 = nt > 2 ? t[2] : new float[n3][n2][n1];
        this._rgfGradient1.apply100(x, g1);
        this._rgfGradient2.apply010(x, g2);
        this._rgfGradient3.apply001(x, g3);
        float[][][] g11 = g1;
        float[][][] g22 = g2;
        float[][][] g33 = g3;
        float[][][] g12 = nt > 3 ? t[3] : new float[n3][n2][n1];
        float[][][] g13 = nt > 4 ? t[4] : new float[n3][n2][n1];
        float[][][] g23 = nt > 5 ? t[5] : new float[n3][n2][n1];
        this.computeGradientProducts(g1, g2, g3, g11, g12, g13, g22, g23, g33);
        if (this._rgfSmoother1 != null || this._rgfSmoother2 != null || this._rgfSmoother3 != null) {
            float[][][][] gs;
            float[][][] h = nt > 6 ? t[6] : new float[n3][n2][n1];
            for (float[][][] g : gs = new float[][][][]{g11, g22, g33, g12, g13, g23}) {
                if (this._rgfSmoother1 != null) {
                    this._rgfSmoother1.apply0XX(g, h);
                } else {
                    ArrayMath.copy(g, h);
                }
                if (this._rgfSmoother2 != null) {
                    this._rgfSmoother2.applyX0X(h, g);
                } else {
                    ArrayMath.copy(h, g);
                }
                if (this._rgfSmoother3 == null) continue;
                this._rgfSmoother3.applyXX0(g, h);
                ArrayMath.copy(h, g);
            }
        }
        this.solveEigenproblems(g11, g12, g13, g22, g23, g33, theta, phi, u1, u2, u3, v1, v2, v3, w1, w2, w3, eu, ev, ew, ep, el);
    }

    private void computeGradientProducts(final float[][][] g1, final float[][][] g2, final float[][][] g3, final float[][][] g11, final float[][][] g12, final float[][][] g13, final float[][][] g22, final float[][][] g23, final float[][][] g33) {
        final int n1 = g1[0][0].length;
        final int n2 = g1[0].length;
        int n3 = g1.length;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    float[] g1i = g1[i3][i2];
                    float[] g2i = g2[i3][i2];
                    float[] g3i = g3[i3][i2];
                    float[] g11i = g11[i3][i2];
                    float[] g12i = g12[i3][i2];
                    float[] g13i = g13[i3][i2];
                    float[] g22i = g22[i3][i2];
                    float[] g23i = g23[i3][i2];
                    float[] g33i = g33[i3][i2];
                    for (int i1 = 0; i1 < n1; ++i1) {
                        float g1ii = g1i[i1];
                        float g2ii = g2i[i1];
                        float g3ii = g3i[i1];
                        g11i[i1] = g1ii * g1ii;
                        g22i[i1] = g2ii * g2ii;
                        g33i[i1] = g3ii * g3ii;
                        g12i[i1] = g1ii * g2ii;
                        g13i[i1] = g1ii * g3ii;
                        g23i[i1] = g2ii * g3ii;
                    }
                }
            }
        });
    }

    private void solveEigenproblems(final float[][][] g11, final float[][][] g12, final float[][][] g13, final float[][][] g22, final float[][][] g23, final float[][][] g33, final float[][][] theta, final float[][][] phi, final float[][][] u1, final float[][][] u2, final float[][][] u3, final float[][][] v1, final float[][][] v2, final float[][][] v3, final float[][][] w1, final float[][][] w2, final float[][][] w3, final float[][][] eu, final float[][][] ev, final float[][][] ew, final float[][][] ep, final float[][][] el) {
        final int n1 = g11[0][0].length;
        final int n2 = g11[0].length;
        int n3 = g11.length;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                double[][] a = new double[3][3];
                double[][] z = new double[3][3];
                double[] e = new double[3];
                for (int i2 = 0; i2 < n2; ++i2) {
                    for (int i1 = 0; i1 < n1; ++i1) {
                        float esi;
                        a[0][0] = g11[i3][i2][i1];
                        a[0][1] = g12[i3][i2][i1];
                        a[0][2] = g13[i3][i2][i1];
                        a[1][0] = g12[i3][i2][i1];
                        a[1][1] = g22[i3][i2][i1];
                        a[1][2] = g23[i3][i2][i1];
                        a[2][0] = g13[i3][i2][i1];
                        a[2][1] = g23[i3][i2][i1];
                        a[2][2] = g33[i3][i2][i1];
                        Eigen.solveSymmetric33(a, z, e);
                        float u1i = (float)z[0][0];
                        float u2i = (float)z[0][1];
                        float u3i = (float)z[0][2];
                        float v1i = (float)z[1][0];
                        float v2i = (float)z[1][1];
                        float v3i = (float)z[1][2];
                        float w1i = (float)z[2][0];
                        float w2i = (float)z[2][1];
                        float w3i = (float)z[2][2];
                        if (u1i < 0.0f) {
                            u1i = -u1i;
                            u2i = -u2i;
                            u3i = -u3i;
                        }
                        if (v2i < 0.0f) {
                            v1i = -v1i;
                            v2i = -v2i;
                            v3i = -v3i;
                        }
                        if (w3i < 0.0f) {
                            w1i = -w1i;
                            w2i = -w2i;
                            w3i = -w3i;
                        }
                        float eui = (float)e[0];
                        float evi = (float)e[1];
                        float ewi = (float)e[2];
                        if (ewi < 0.0f) {
                            ewi = 0.0f;
                        }
                        if (evi < ewi) {
                            evi = ewi;
                        }
                        if (eui < evi) {
                            eui = evi;
                        }
                        if (theta != null) {
                            theta[i3][i2][i1] = ArrayMath.acos(u1i);
                        }
                        if (phi != null) {
                            phi[i3][i2][i1] = ArrayMath.atan2(u3i, u2i);
                        }
                        if (u1 != null) {
                            u1[i3][i2][i1] = u1i;
                        }
                        if (u2 != null) {
                            u2[i3][i2][i1] = u2i;
                        }
                        if (u3 != null) {
                            u3[i3][i2][i1] = u3i;
                        }
                        if (v1 != null) {
                            v1[i3][i2][i1] = v1i;
                        }
                        if (v2 != null) {
                            v2[i3][i2][i1] = v2i;
                        }
                        if (v3 != null) {
                            v3[i3][i2][i1] = v3i;
                        }
                        if (w1 != null) {
                            w1[i3][i2][i1] = w1i;
                        }
                        if (w2 != null) {
                            w2[i3][i2][i1] = w2i;
                        }
                        if (w3 != null) {
                            w3[i3][i2][i1] = w3i;
                        }
                        if (eu != null) {
                            eu[i3][i2][i1] = eui;
                        }
                        if (ev != null) {
                            ev[i3][i2][i1] = evi;
                        }
                        if (ew != null) {
                            ew[i3][i2][i1] = ewi;
                        }
                        if (ep == null && el == null) continue;
                        float f = esi = eui > 0.0f ? 1.0f / eui : 1.0f;
                        if (ep != null) {
                            ep[i3][i2][i1] = (eui - evi) * esi;
                        }
                        if (el == null) continue;
                        el[i3][i2][i1] = (evi - ewi) * esi;
                    }
                }
            }
        });
    }
}

