/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.Parallel;

public class RecursiveExponentialFilter {
    private float _sigma1;
    private float _a1;
    private float _sigma2;
    private float _a2;
    private float _sigma3;
    private float _a3;
    private boolean _ei = false;
    private boolean _zs = true;

    public RecursiveExponentialFilter(double sigma) {
        this(sigma, sigma, sigma);
    }

    public RecursiveExponentialFilter(double sigma1, double sigma23) {
        this(sigma1, sigma23, sigma23);
    }

    public RecursiveExponentialFilter(double sigma1, double sigma2, double sigma3) {
        Check.argument(sigma1 >= 0.0, "sigma is non-negative");
        Check.argument(sigma2 >= 0.0, "sigma is non-negative");
        Check.argument(sigma3 >= 0.0, "sigma is non-negative");
        this._sigma1 = (float)sigma1;
        this._sigma2 = (float)sigma2;
        this._sigma3 = (float)sigma3;
        this._a1 = RecursiveExponentialFilter.aFromSigma(sigma1);
        this._a2 = RecursiveExponentialFilter.aFromSigma(sigma2);
        this._a3 = RecursiveExponentialFilter.aFromSigma(sigma3);
    }

    public void setEdges(Edges edges) {
        this._ei = edges == Edges.INPUT_ZERO_VALUE || edges == Edges.INPUT_ZERO_SLOPE;
        this._zs = edges == Edges.INPUT_ZERO_SLOPE || edges == Edges.OUTPUT_ZERO_SLOPE;
    }

    public void apply(float[] x, float[] y) {
        this.apply1(x, y);
    }

    public void apply(float[][] x, float[][] y) {
        this.apply2(x, y);
        this.apply1(y, y);
    }

    public void apply(float[][][] x, float[][][] y) {
        this.apply3(x, y);
        this.apply2(y, y);
        this.apply1(y, y);
    }

    public void apply1(float[] x, float[] y) {
        RecursiveExponentialFilter.smooth1(this._ei, this._zs, this._a1, x, y);
    }

    public void apply1(float[][] x, float[][] y) {
        int n2 = x.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            float[] x2 = x[i2];
            float[] y2 = y[i2];
            RecursiveExponentialFilter.smooth1(this._ei, this._zs, this._a1, x2, y2);
        }
    }

    public void apply2(float[][] x, float[][] y) {
        RecursiveExponentialFilter.smooth2(this._ei, this._zs, this._a2, x, y);
    }

    public void apply1(float[][][] x, float[][][] y) {
        final float[][][] xx = x;
        final float[][][] yy = y;
        final int n2 = x[0].length;
        int n3 = x.length;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                for (int i2 = 0; i2 < n2; ++i2) {
                    float[] x32 = xx[i3][i2];
                    float[] y32 = yy[i3][i2];
                    RecursiveExponentialFilter.smooth1(RecursiveExponentialFilter.this._ei, RecursiveExponentialFilter.this._zs, RecursiveExponentialFilter.this._a1, x32, y32);
                }
            }
        });
    }

    public void apply2(float[][][] x, float[][][] y) {
        final float[][][] xx = x;
        final float[][][] yy = y;
        int n3 = x.length;
        Parallel.loop(n3, new Parallel.LoopInt(){

            @Override
            public void compute(int i3) {
                float[][] x3 = xx[i3];
                float[][] y3 = yy[i3];
                RecursiveExponentialFilter.smooth2(RecursiveExponentialFilter.this._ei, RecursiveExponentialFilter.this._zs, RecursiveExponentialFilter.this._a2, x3, y3);
            }
        });
    }

    public void apply3(float[][][] x, float[][][] y) {
        final float[][][] xx = x;
        final float[][][] yy = y;
        int n2 = x[0].length;
        final int n3 = x.length;
        Parallel.loop(n2, new Parallel.LoopInt(){

            @Override
            public void compute(int i2) {
                float[][] x2 = new float[n3][];
                float[][] y2 = new float[n3][];
                for (int i3 = 0; i3 < n3; ++i3) {
                    x2[i3] = xx[i3][i2];
                    y2[i3] = yy[i3][i2];
                }
                RecursiveExponentialFilter.smooth2(RecursiveExponentialFilter.this._ei, RecursiveExponentialFilter.this._zs, RecursiveExponentialFilter.this._a3, x2, y2);
            }
        });
    }

    private static float aFromSigma(double sigma) {
        if (sigma <= 0.0) {
            return 0.0f;
        }
        double ss = sigma * sigma;
        return (float)((1.0 + ss - ArrayMath.sqrt(1.0 + 2.0 * ss)) / ss);
    }

    private static void smooth1(boolean ei, boolean zs, float a, float[] x, float[] y) {
        if (a == 0.0f) {
            ArrayMath.copy(x, y);
        } else if (ei) {
            RecursiveExponentialFilter.smooth1Ei(zs, a, x, y);
        } else {
            RecursiveExponentialFilter.smooth1Eo(zs, a, x, y);
        }
    }

    private static void smooth2(boolean ei, boolean zs, float a, float[][] x, float[][] y) {
        if (a == 0.0f) {
            ArrayMath.copy(x, y);
        } else if (ei) {
            RecursiveExponentialFilter.smooth2Ei(zs, a, x, y);
        } else {
            RecursiveExponentialFilter.smooth2Eo(zs, a, x, y);
        }
    }

    private static void smooth1Ei(boolean zs, float a, float[] x, float[] y) {
        int i1;
        int n1 = x.length;
        float b = 1.0f - a;
        float sx = zs ? 1.0f : b;
        float sy = a;
        float yi = y[0] = sx * x[0];
        for (i1 = 1; i1 < n1 - 1; ++i1) {
            y[i1] = yi = a * yi + b * x[i1];
        }
        y[n1 - 1] = yi = (sy /= 1.0f + a) * yi + (sx /= 1.0f + a) * x[n1 - 1];
        for (i1 = n1 - 2; i1 >= 0; --i1) {
            y[i1] = yi = a * yi + b * y[i1];
        }
    }

    private static void smooth2Ei(boolean zs, float a, float[][] x, float[][] y) {
        int i1;
        int i2;
        int i12;
        int n1 = x[0].length;
        int n2 = x.length;
        float b = 1.0f - a;
        float sx = zs ? 1.0f : b;
        float sy = a;
        for (i12 = 0; i12 < n1; ++i12) {
            y[0][i12] = sx * x[0][i12];
        }
        for (i2 = 1; i2 < n2 - 1; ++i2) {
            for (i1 = 0; i1 < n1; ++i1) {
                y[i2][i1] = a * y[i2 - 1][i1] + b * x[i2][i1];
            }
        }
        sx /= 1.0f + a;
        sy /= 1.0f + a;
        for (i12 = 0; i12 < n1; ++i12) {
            y[n2 - 1][i12] = sy * y[n2 - 2][i12] + sx * x[n2 - 1][i12];
        }
        for (i2 = n2 - 2; i2 >= 0; --i2) {
            for (i1 = 0; i1 < n1; ++i1) {
                y[i2][i1] = a * y[i2 + 1][i1] + b * y[i2][i1];
            }
        }
    }

    private static void smooth1Eo(boolean zs, float a, float[] x, float[] y) {
        int m1;
        int i1;
        int n1 = x.length;
        float aa = a * a;
        float ss = zs ? 1.0f - a : 1.0f;
        float gg = zs ? aa - a : aa;
        float c = (1.0f - aa - ss) / ss;
        float d = 1.0f / (1.0f - aa + gg * (1.0f + c * ArrayMath.pow(aa, (float)(n1 - 1))));
        float e = (1.0f - a) * (1.0f - a) * 1.1920929E-7f / 4.0f;
        ArrayMath.mul((1.0f - a) * (1.0f - a), x, y);
        int k1 = ArrayMath.min((int)ArrayMath.ceil(ArrayMath.log(e) / ArrayMath.log(a)), 2 * n1 - 2);
        float ynm1 = 0.0f;
        for (i1 = m1 = k1 - n1 + 1; i1 > 0; --i1) {
            ynm1 = a * ynm1 + y[i1];
        }
        ynm1 *= c;
        if (n1 - k1 < 1) {
            ynm1 = a * ynm1 + (1.0f + c) * y[0];
        }
        for (i1 = m1 = ArrayMath.max(n1 - k1, 1); i1 < n1; ++i1) {
            ynm1 = a * ynm1 + y[i1];
        }
        int n = n1 - 1;
        y[n] = y[n] - gg * (ynm1 *= d);
        for (i1 = n1 - 2; i1 >= 0; --i1) {
            int n2 = i1;
            y[n2] = y[n2] + a * y[i1 + 1];
        }
        y[0] = y[0] / ss;
        for (i1 = 1; i1 < n1 - 1; ++i1) {
            int n3 = i1;
            y[n3] = y[n3] + a * y[i1 - 1];
        }
        y[n1 - 1] = ynm1;
    }

    private static void smooth2Eo(boolean zs, float a, float[][] x, float[][] y) {
        int i1;
        float[] yi;
        int m2;
        int i2;
        int n1 = x[0].length;
        int n2 = x.length;
        float aa = a * a;
        float ss = zs ? 1.0f - a : 1.0f;
        float gg = zs ? aa - a : aa;
        float c = (1.0f - aa - ss) / ss;
        float d = 1.0f / (1.0f - aa + gg * (1.0f + c * ArrayMath.pow(aa, (float)(n1 - 1))));
        float e = (1.0f - a) * (1.0f - a) * 1.1920929E-7f / 4.0f;
        ArrayMath.mul((1.0f - a) * (1.0f - a), x, y);
        int k2 = ArrayMath.min((int)ArrayMath.ceil(ArrayMath.log(e) / ArrayMath.log(a)), 2 * n2 - 2);
        float[] ynm1 = new float[n1];
        for (i2 = m2 = k2 - n2 + 1; i2 > 0; --i2) {
            yi = y[i2];
            for (i1 = 0; i1 < n1; ++i1) {
                ynm1[i1] = a * ynm1[i1] + yi[i1];
            }
        }
        int i12 = 0;
        while (i12 < n1) {
            int n = i12++;
            ynm1[n] = ynm1[n] * c;
        }
        if (n2 - k2 < 1) {
            for (i12 = 0; i12 < n1; ++i12) {
                ynm1[i12] = a * ynm1[i12] + (1.0f + c) * y[0][i12];
            }
        }
        for (i2 = m2 = ArrayMath.max(n2 - k2, 1); i2 < n2; ++i2) {
            yi = y[i2];
            for (i1 = 0; i1 < n1; ++i1) {
                ynm1[i1] = a * ynm1[i1] + yi[i1];
            }
        }
        i12 = 0;
        while (i12 < n1) {
            int n = i12++;
            ynm1[n] = ynm1[n] * d;
        }
        for (i12 = 0; i12 < n1; ++i12) {
            float[] fArray = y[n2 - 1];
            int n = i12;
            fArray[n] = fArray[n] - gg * ynm1[i12];
        }
        for (i2 = n2 - 2; i2 >= 0; --i2) {
            yi = y[i2];
            float[] yp = y[i2 + 1];
            for (int i13 = 0; i13 < n1; ++i13) {
                int n = i13;
                yi[n] = yi[n] + a * yp[i13];
            }
        }
        float oss = 1.0f / ss;
        int i14 = 0;
        while (i14 < n1) {
            float[] fArray = y[0];
            int n = i14++;
            fArray[n] = fArray[n] * oss;
        }
        for (int i22 = 1; i22 < n2 - 1; ++i22) {
            float[] yi2 = y[i22];
            float[] ym = y[i22 - 1];
            for (int i15 = 0; i15 < n1; ++i15) {
                int n = i15;
                yi2[n] = yi2[n] + a * ym[i15];
            }
        }
        for (i14 = 0; i14 < n1; ++i14) {
            y[n2 - 1][i14] = ynm1[i14];
        }
    }

    public static enum Edges {
        INPUT_ZERO_VALUE,
        INPUT_ZERO_SLOPE,
        OUTPUT_ZERO_VALUE,
        OUTPUT_ZERO_SLOPE;

    }
}

