/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.dsp;

import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;

public class RecursiveRectangleFilter {
    private int _l;
    private int _m;

    public RecursiveRectangleFilter(int l, int m) {
        Check.argument(l <= m, "l<=m");
        this._l = l;
        this._m = m;
    }

    public void apply(float[] x, float[] y) {
        int i;
        RecursiveRectangleFilter.checkArrays(x, y);
        if (x == y) {
            x = ArrayMath.copy(x);
        }
        int n = x.length;
        int m = this._m;
        int l = this._l;
        int l1 = l - 1;
        float s = 1.0f / (float)(1 + m - l);
        y[0] = 0.0f;
        int ilo = ArrayMath.max(0, l);
        int ihi = ArrayMath.min(n, m + 1);
        for (i = ilo; i < ihi; ++i) {
            y[0] = y[0] + s * x[i];
        }
        ilo = 1;
        ihi = ArrayMath.min(n, -m);
        for (i = ilo; i < ihi; ++i) {
            y[i] = y[i - 1];
        }
        ilo = ArrayMath.max(1, -m);
        ihi = ArrayMath.min(n, n - m, 1 - l);
        for (i = ilo; i < ihi; ++i) {
            y[i] = y[i - 1] + s * x[i + m];
        }
        if (1 - l > n - m) {
            ilo = ArrayMath.max(1, n - m);
            ihi = ArrayMath.min(n, 1 - l);
            for (i = ilo; i < ihi; ++i) {
                y[i] = y[i - 1];
            }
        } else {
            ilo = ArrayMath.max(1, 1 - l);
            ihi = ArrayMath.min(n, n - m);
            for (i = ilo; i < ihi; ++i) {
                y[i] = y[i - 1] + s * (x[i + m] - x[i + l1]);
            }
        }
        ilo = ArrayMath.max(1, n - m, 1 - l);
        ihi = ArrayMath.min(n, n + 1 - l);
        for (i = ilo; i < ihi; ++i) {
            y[i] = y[i - 1] - s * x[i + l1];
        }
        ilo = ArrayMath.max(1, n + 1 - l);
        ihi = n;
        for (i = ilo; i < ihi; ++i) {
            y[i] = y[i - 1];
        }
    }

    public void apply1(float[][] x, float[][] y) {
        RecursiveRectangleFilter.checkArrays(x, y);
        int n2 = x.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            this.apply(x[i2], y[i2]);
        }
    }

    public void apply2(float[][] x, float[][] y) {
        float[] y2p;
        int i1;
        float[] y2;
        int i2;
        RecursiveRectangleFilter.checkArrays(x, y);
        int n1 = x[0].length;
        int n2 = x.length;
        if (x == y) {
            x = ArrayMath.copy(x);
        }
        int m = this._m;
        int l = this._l;
        float s = 1.0f / (float)(1 + m - l);
        ArrayMath.zero(y[0]);
        int i2lo = ArrayMath.max(0, l);
        int i2hi = ArrayMath.min(n2, m + 1);
        for (i2 = i2lo; i2 < i2hi; ++i2) {
            y2 = y[0];
            float[] x2 = x[i2];
            for (i1 = 0; i1 < n1; ++i1) {
                int n = i1;
                y2[n] = y2[n] + s * x2[i1];
            }
        }
        i2lo = 1;
        i2hi = ArrayMath.min(n2, -m);
        for (i2 = i2lo; i2 < i2hi; ++i2) {
            y2 = y[i2];
            y2p = y[i2 - 1];
            for (i1 = 0; i1 < n1; ++i1) {
                y2[i1] = y2p[i1];
            }
        }
        i2lo = ArrayMath.max(1, -m);
        i2hi = ArrayMath.min(n2, n2 - m, 1 - l);
        for (i2 = i2lo; i2 < i2hi; ++i2) {
            y2 = y[i2];
            y2p = y[i2 - 1];
            float[] x2m = x[i2 + m];
            for (int i12 = 0; i12 < n1; ++i12) {
                y2[i12] = y2p[i12] + s * x2m[i12];
            }
        }
        if (1 - l > n2 - m) {
            i2lo = ArrayMath.max(1, n2 - m);
            i2hi = ArrayMath.min(n2, 1 - l);
            for (i2 = i2lo; i2 < i2hi; ++i2) {
                y2 = y[i2];
                y2p = y[i2 - 1];
                for (int i13 = 0; i13 < n1; ++i13) {
                    y2[i13] = y2p[i13];
                }
            }
        } else {
            i2lo = ArrayMath.max(1, 1 - l);
            i2hi = ArrayMath.min(n2, n2 - m);
            for (i2 = i2lo; i2 < i2hi; ++i2) {
                y2 = y[i2];
                y2p = y[i2 - 1];
                float[] x2m = x[i2 + m];
                float[] x2l = x[i2 + l - 1];
                for (int i14 = 0; i14 < n1; ++i14) {
                    y2[i14] = y2p[i14] + s * (x2m[i14] - x2l[i14]);
                }
            }
        }
        i2lo = ArrayMath.max(1, n2 - m, 1 - l);
        i2hi = ArrayMath.min(n2, n2 + 1 - l);
        for (i2 = i2lo; i2 < i2hi; ++i2) {
            y2 = y[i2];
            y2p = y[i2 - 1];
            float[] x2l = x[i2 + l - 1];
            for (int i15 = 0; i15 < n1; ++i15) {
                y2[i15] = y2p[i15] - s * x2l[i15];
            }
        }
        i2lo = ArrayMath.max(1, n2 + 1 - l);
        i2hi = n2;
        for (i2 = i2lo; i2 < i2hi; ++i2) {
            y2 = y[i2];
            y2p = y[i2 - 1];
            for (int i16 = 0; i16 < n1; ++i16) {
                y2[i16] = y2p[i16];
            }
        }
    }

    public void apply1(float[][][] x, float[][][] y) {
        RecursiveRectangleFilter.checkArrays(x, y);
        int n3 = y.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            this.apply1(x[i3], y[i3]);
        }
    }

    public void apply2(float[][][] x, float[][][] y) {
        RecursiveRectangleFilter.checkArrays(x, y);
        int n3 = y.length;
        for (int i3 = 0; i3 < n3; ++i3) {
            this.apply2(x[i3], y[i3]);
        }
    }

    public void apply3(float[][][] x, float[][][] y) {
        RecursiveRectangleFilter.checkArrays(x, y);
        int n3 = y.length;
        int n2 = y[0].length;
        int n1 = y[0][0].length;
        float[][] x2 = new float[n3][n1];
        float[][] y2 = new float[n3][n1];
        for (int i2 = 0; i2 < n2; ++i2) {
            int i1;
            int i3;
            for (i3 = 0; i3 < n3; ++i3) {
                float[] x32 = x[i3][i2];
                float[] x23 = x2[i3];
                for (i1 = 0; i1 < n1; ++i1) {
                    x23[i1] = x32[i1];
                }
            }
            this.apply2(x2, y2);
            for (i3 = 0; i3 < n3; ++i3) {
                float[] y32 = y[i3][i2];
                float[] y23 = y2[i3];
                for (i1 = 0; i1 < n1; ++i1) {
                    y32[i1] = y23[i1];
                }
            }
        }
    }

    private static void checkArrays(float[] x, float[] y) {
        Check.argument(x.length == y.length, "x.length==y.length");
    }

    private static void checkArrays(float[][] x, float[][] y) {
        Check.argument(x.length == y.length, "x.length==y.length");
        Check.argument(x[0].length == y[0].length, "x[0].length==y[0].length");
        Check.argument(ArrayMath.isRegular(x), "x is regular");
        Check.argument(ArrayMath.isRegular(y), "y is regular");
    }

    private static void checkArrays(float[][][] x, float[][][] y) {
        Check.argument(x.length == y.length, "x.length==y.length");
        Check.argument(x[0].length == y[0].length, "x[0].length==y[0].length");
        Check.argument(x[0][0].length == y[0][0].length, "x[0][0].length==y[0][0].length");
        Check.argument(ArrayMath.isRegular(x), "x is regular");
        Check.argument(ArrayMath.isRegular(y), "y is regular");
    }
}

