/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.LocalDiffusionKernel;
import edu.mines.jtk.dsp.LocalSmoothingFilter;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.dsp.Tensors3;
import edu.mines.jtk.interp.Gridder3;
import edu.mines.jtk.interp.SimpleGridder3;
import edu.mines.jtk.interp.TimeMarker3;
import edu.mines.jtk.interp.TimeMarker3X;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.Stopwatch;

public class BlendedGridder3
implements Gridder3 {
    private boolean _tmx;
    private double _tms;
    private Tensors3 _tensors;
    private float[] _f;
    private float[] _x1;
    private float[] _x2;
    private float[] _x3;
    private boolean _blending = true;
    private float _tmax = Float.MAX_VALUE;
    private float _c = 0.5f;
    private LocalDiffusionKernel _ldk = new LocalDiffusionKernel(LocalDiffusionKernel.Stencil.D22);

    public BlendedGridder3() {
        this(null);
    }

    public BlendedGridder3(float[] f, float[] x1, float[] x2, float[] x3) {
        this(null);
        this.setScattered(f, x1, x2, x3);
    }

    public BlendedGridder3(Tensors3 tensors) {
        this.setTensors(tensors);
    }

    public BlendedGridder3(Tensors3 tensors, float[] f, float[] x1, float[] x2, float[] x3) {
        this.setTensors(tensors);
        this.setScattered(f, x1, x2, x3);
    }

    public void setTensors(Tensors3 tensors) {
        this._tensors = tensors;
        if (this._tensors == null) {
            this._tensors = new Tensors3(){

                @Override
                public void getTensor(int i1, int i2, int i3, float[] d) {
                    d[0] = 1.0f;
                    d[1] = 0.0f;
                    d[2] = 0.0f;
                    d[3] = 1.0f;
                    d[4] = 0.0f;
                    d[5] = 1.0f;
                }
            };
        }
    }

    public void setBlending(boolean blending) {
        this._blending = blending;
    }

    public void setBlendingKernel(LocalDiffusionKernel ldk) {
        this._ldk = ldk;
    }

    public void setSmoothness(double smoothness) {
        this._c = 0.25f / (float)smoothness;
    }

    public void setTimeMax(double tmax) {
        this._tmax = (float)tmax;
    }

    public void setTimeMarkerX(boolean tmx) {
        this._tmx = tmx;
    }

    public double getTimeMarkerS() {
        return this._tms;
    }

    public float[][][] gridNearest(float pnull, float[][][] p) {
        int n1 = p[0][0].length;
        int n2 = p[0].length;
        int n3 = p.length;
        int nmark = 0;
        float[][][] t = new float[n3][n2][n1];
        float tnull = -3.4028235E38f;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    if (p[i3][i2][i1] == pnull) {
                        t[i3][i2][i1] = tnull;
                        continue;
                    }
                    t[i3][i2][i1] = 0.0f;
                    ++nmark;
                }
            }
        }
        this.gridNearest(nmark, t, p);
        return t;
    }

    public void gridNearest(float[][][] t, float[][][] p) {
        int n1 = t[0][0].length;
        int n2 = t[0].length;
        int n3 = t.length;
        int nmark = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    if (t[i3][i2][i1] != 0.0f) continue;
                    ++nmark;
                }
            }
        }
        this.gridNearest(nmark, t, p);
    }

    public void gridBlended(float[][][] t, float[][][] p, float[][][] q) {
        int n1 = t[0][0].length;
        int n2 = t[0].length;
        int n3 = t.length;
        float[][][] s = ArrayMath.mul(t, t);
        if (this._ldk.getStencil() != LocalDiffusionKernel.Stencil.D21) {
            for (int i3 = n3 - 1; i3 > 0; --i3) {
                for (int i2 = n2 - 1; i2 > 0; --i2) {
                    for (int i1 = n1 - 1; i1 > 0; --i1) {
                        s[i3][i2][i1] = 0.125f * (s[i3][i2][i1] + s[i3][i2][i1 - 1] + s[i3][i2 - 1][i1] + s[i3][i2 - 1][i1 - 1] + s[i3 - 1][i2][i1] + s[i3 - 1][i2][i1 - 1] + s[i3 - 1][i2 - 1][i1] + s[i3 - 1][i2 - 1][i1 - 1]);
                    }
                }
            }
        }
        LocalSmoothingFilter lsf = new LocalSmoothingFilter(0.01, 10000, this._ldk);
        lsf.setPreconditioner(true);
        float pavg = ArrayMath.sum(p) / (float)n1 / (float)n2 / (float)n3;
        float[][][] r = ArrayMath.sub(p, pavg);
        if (this._ldk.getStencil() != LocalDiffusionKernel.Stencil.D21) {
            lsf.applySmoothS(r, r);
        }
        lsf.apply(this._tensors, this._c, s, r, q);
        ArrayMath.add(q, pavg, q);
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    if (t[i3][i2][i1] != 0.0f) continue;
                    q[i3][i2][i1] = p[i3][i2][i1];
                }
            }
        }
    }

    @Override
    public void setScattered(float[] f, float[] x1, float[] x2, float[] x3) {
        this._f = f;
        this._x1 = x1;
        this._x2 = x2;
        this._x3 = x3;
    }

    @Override
    public float[][][] grid(Sampling s1, Sampling s2, Sampling s3) {
        Check.argument(s1.isUniform(), "s1 is uniform");
        Check.argument(s2.isUniform(), "s2 is uniform");
        Check.argument(s3.isUniform(), "s3 is uniform");
        Check.state(this._f != null, "scattered samples have been set");
        Check.state(this._x1 != null, "scattered samples have been set");
        Check.state(this._x2 != null, "scattered samples have been set");
        Check.state(this._x3 != null, "scattered samples have been set");
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n3 = s3.getCount();
        SimpleGridder3 sg = new SimpleGridder3(this._f, this._x1, this._x2, this._x3);
        float pnull = -3.4028235E38f;
        float tnull = -3.4028235E38f;
        sg.setNullValue(pnull);
        float[][][] p = sg.grid(s1, s2, s3);
        float[][][] t = new float[n3][n2][n1];
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    t[i3][i2][i1] = p[i3][i2][i1] != pnull ? 0.0f : tnull;
                }
            }
        }
        this.gridNearest(t, p);
        float[][][] q = p;
        if (this._blending) {
            q = new float[n3][n2][n1];
            this.gridBlended(t, p, q);
        }
        return q;
    }

    private void gridNearest(int nmark, float[][][] t, float[][][] p) {
        Object tm;
        int n1 = t[0][0].length;
        int n2 = t[0].length;
        int n3 = t.length;
        float[] pmark = new float[nmark];
        int[][][] m = new int[n3][n2][n1];
        int mark = 0;
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    if (t[i3][i2][i1] != 0.0f) continue;
                    pmark[mark] = p[i3][i2][i1];
                    m[i3][i2][i1] = mark++;
                }
            }
        }
        Stopwatch sw = new Stopwatch();
        if (this._tmx) {
            tm = new TimeMarker3X(n1, n2, n3, this._tensors);
            sw.start();
            ((TimeMarker3X)tm).apply(t, m);
            sw.stop();
        } else {
            tm = new TimeMarker3(n1, n2, n3, this._tensors);
            sw.start();
            ((TimeMarker3)tm).apply(t, m);
            sw.stop();
        }
        this._tms = sw.time();
        this.adjustTimes(nmark, m, t);
        for (int i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    float ti = t[i3][i2][i1];
                    if (ti != 0.0f) {
                        p[i3][i2][i1] = pmark[m[i3][i2][i1]];
                    }
                    if (!(ti > this._tmax)) continue;
                    t[i3][i2][i1] = this._tmax;
                }
            }
        }
    }

    private void adjustTimes(int nmark, int[][][] m, float[][][] t) {
        int i3;
        int n1 = m[0][0].length;
        int n2 = m[0].length;
        int n3 = m.length;
        int n1m = n1 - 1;
        int n2m = n2 - 1;
        int n3m = n3 - 1;
        float[] s = new float[nmark];
        for (i3 = 0; i3 < n3; ++i3) {
            int i3m = i3 > 0 ? i3 - 1 : i3;
            int i3p = i3 < n3m ? i3 + 1 : i3;
            for (int i2 = 0; i2 < n2; ++i2) {
                int i2m = i2 > 0 ? i2 - 1 : i2;
                int i2p = i2 < n2m ? i2 + 1 : i2;
                for (int i1 = 0; i1 < n1; ++i1) {
                    int i1p;
                    int i1m = i1 > 0 ? i1 - 1 : i1;
                    int n = i1p = i1 < n1m ? i1 + 1 : i1;
                    if (t[i3][i2][i1] != 0.0f) continue;
                    float tmax = 0.0f;
                    tmax = ArrayMath.max(tmax, t[i3m][i2m][i1m]);
                    tmax = ArrayMath.max(tmax, t[i3m][i2m][i1]);
                    tmax = ArrayMath.max(tmax, t[i3m][i2m][i1p]);
                    tmax = ArrayMath.max(tmax, t[i3m][i2][i1m]);
                    tmax = ArrayMath.max(tmax, t[i3m][i2][i1]);
                    tmax = ArrayMath.max(tmax, t[i3m][i2][i1p]);
                    tmax = ArrayMath.max(tmax, t[i3m][i2p][i1m]);
                    tmax = ArrayMath.max(tmax, t[i3m][i2p][i1]);
                    tmax = ArrayMath.max(tmax, t[i3m][i2p][i1p]);
                    tmax = ArrayMath.max(tmax, t[i3][i2m][i1m]);
                    tmax = ArrayMath.max(tmax, t[i3][i2m][i1]);
                    tmax = ArrayMath.max(tmax, t[i3][i2m][i1p]);
                    tmax = ArrayMath.max(tmax, t[i3][i2][i1m]);
                    tmax = ArrayMath.max(tmax, t[i3][i2][i1p]);
                    tmax = ArrayMath.max(tmax, t[i3][i2p][i1m]);
                    tmax = ArrayMath.max(tmax, t[i3][i2p][i1]);
                    tmax = ArrayMath.max(tmax, t[i3][i2p][i1p]);
                    tmax = ArrayMath.max(tmax, t[i3p][i2m][i1m]);
                    tmax = ArrayMath.max(tmax, t[i3p][i2m][i1]);
                    tmax = ArrayMath.max(tmax, t[i3p][i2m][i1p]);
                    tmax = ArrayMath.max(tmax, t[i3p][i2][i1m]);
                    tmax = ArrayMath.max(tmax, t[i3p][i2][i1]);
                    tmax = ArrayMath.max(tmax, t[i3p][i2][i1p]);
                    tmax = ArrayMath.max(tmax, t[i3p][i2p][i1m]);
                    tmax = ArrayMath.max(tmax, t[i3p][i2p][i1]);
                    s[m[i3][i2][i1]] = tmax = ArrayMath.max(tmax, t[i3p][i2p][i1p]);
                }
            }
        }
        for (i3 = 0; i3 < n3; ++i3) {
            for (int i2 = 0; i2 < n2; ++i2) {
                for (int i1 = 0; i1 < n1; ++i1) {
                    if (!(t[i3][i2][i1] > 0.0f)) continue;
                    t[i3][i2][i1] = ArrayMath.max(Float.MIN_VALUE, t[i3][i2][i1] - s[m[i3][i2][i1]]);
                }
            }
        }
    }
}

