/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.interp.CubicInterpolator;
import edu.mines.jtk.util.ArrayMath;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class CubicInterpolatorTest
extends TestCase {
    public static void main(String[] args) {
        TestSuite suite = new TestSuite(CubicInterpolatorTest.class);
        TestRunner.run((Test)suite);
    }

    public void testArrayMethods() {
        int i;
        int nc = 10;
        int ni = 100;
        float[] xc = ArrayMath.randfloat(nc);
        float[] yc = ArrayMath.randfloat(nc);
        ArrayMath.quickSort(xc);
        CubicInterpolator ci = new CubicInterpolator(xc, yc);
        float[] xi = ArrayMath.randfloat(ni);
        float[] yi = ArrayMath.zerofloat(ni);
        ci.interpolate(xi, yi);
        for (i = 0; i < ni; ++i) {
            CubicInterpolatorTest.assertEqual(yi[i], ci.interpolate(xi[i]));
        }
        ci.interpolate1(xi, yi);
        for (i = 0; i < ni; ++i) {
            CubicInterpolatorTest.assertEqual(yi[i], ci.interpolate1(xi[i]));
        }
        ci.interpolate2(xi, yi);
        for (i = 0; i < ni; ++i) {
            CubicInterpolatorTest.assertEqual(yi[i], ci.interpolate2(xi[i]));
        }
        ci.interpolate3(xi, yi);
        for (i = 0; i < ni; ++i) {
            CubicInterpolatorTest.assertEqual(yi[i], ci.interpolate3(xi[i]));
        }
    }

    public void testLinearAndSpline() {
        int npoints = 100;
        Random generator = new Random(100L);
        float[] x = ArrayMath.randfloat(generator, npoints);
        float[] y = ArrayMath.randfloat(generator, npoints);
        ArrayMath.quickSort(x);
        CubicInterpolator.Method linear = CubicInterpolator.Method.LINEAR;
        CubicInterpolator.Method spline = CubicInterpolator.Method.SPLINE;
        CubicInterpolator cl = new CubicInterpolator(linear, npoints, x, y);
        CubicInterpolator cs = new CubicInterpolator(spline, npoints, x, y);
        for (int i = 0; i < npoints - 1; ++i) {
            float xpos = 0.5f * (x[i] + x[i + 1]);
            float xi = x[i] + 0.2f * (x[i + 1] - x[i]);
            float yi0 = cl.interpolate(xi);
            float yi1 = cl.interpolate1(xi);
            float xj = x[i + 1] - 0.2f * (x[i + 1] - x[i]);
            float yj0 = cl.interpolate(xj);
            float yj1 = cl.interpolate1(xj);
            float[] abcd = CubicInterpolatorTest.computeCoefficients(xi, yi0, yi1, xj, yj0, yj1);
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv0(abcd, xpos - xi), cl.interpolate(xpos));
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv1(abcd, xpos - xi), cl.interpolate1(xpos));
            CubicInterpolatorTest.assertEqual(0.0f, cl.interpolate2(xpos));
            CubicInterpolatorTest.assertEqual(0.0f, cl.interpolate3(xpos));
            yi0 = cs.interpolate(xi);
            yi1 = cs.interpolate1(xi);
            yj0 = cs.interpolate(xj);
            yj1 = cs.interpolate1(xj);
            abcd = CubicInterpolatorTest.computeCoefficients(xi, yi0, yi1, xj, yj0, yj1);
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv0(abcd, xpos - xi), cs.interpolate(xpos));
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv1(abcd, xpos - xi), cs.interpolate1(xpos));
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv2(abcd, xpos - xi), cs.interpolate2(xpos));
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv3(abcd, xpos - xi), cs.interpolate3(xpos));
        }
        float xinterval = 0.5f;
        CubicInterpolatorTest.checkExtrapolation(linear, cl, npoints, xinterval, x);
        CubicInterpolatorTest.checkExtrapolation(spline, cs, npoints, xinterval, x);
    }

    public void testMonotonic() {
        int npoints = 100;
        Random generator = new Random(100L);
        float[] x = ArrayMath.randfloat(generator, npoints);
        float[] y = ArrayMath.randfloat(generator, npoints);
        ArrayMath.quickSort(x);
        ArrayMath.quickSort(y);
        CubicInterpolator.Method monoto = CubicInterpolator.Method.MONOTONIC;
        CubicInterpolator cm = new CubicInterpolator(monoto, npoints, x, y);
        for (int i = 0; i < npoints - 1; ++i) {
            float xpos = 0.5f * (x[i] + x[i + 1]);
            float xi = x[i];
            float yi0 = cm.interpolate(xi);
            float yi1 = cm.interpolate1(xi);
            float xj = x[i + 1];
            float yj0 = cm.interpolate(xj);
            float yj1 = cm.interpolate1(xj);
            float[] abcd = CubicInterpolatorTest.computeCoefficients(xi, yi0, yi1, xj, yj0, yj1);
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv0(abcd, xpos - xi), cm.interpolate(xpos));
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv1(abcd, xpos - xi), cm.interpolate1(xpos));
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv2(abcd, xpos - xi), cm.interpolate2(xpos));
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv3(abcd, xpos - xi), cm.interpolate3(xpos));
        }
        float xinterval = 0.5f;
        CubicInterpolatorTest.checkExtrapolation(monoto, cm, npoints, xinterval, x);
    }

    private static void checkExtrapolation(CubicInterpolator.Method type, CubicInterpolator ci, int npoints, float xinterval, float[] x) {
        float xpos = x[0] - 0.5f * xinterval;
        float xi = x[0] - xinterval;
        float yi0 = ci.interpolate(xi);
        float yi1 = ci.interpolate1(xi);
        float xj = x[0];
        float yj0 = ci.interpolate(xj);
        float yj1 = ci.interpolate1(xj);
        float[] abcd = CubicInterpolatorTest.computeCoefficients(xi, yi0, yi1, xj, yj0, yj1);
        CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv0(abcd, xpos - xi), ci.interpolate(xpos));
        CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv1(abcd, xpos - xi), ci.interpolate1(xpos));
        if (type == CubicInterpolator.Method.LINEAR) {
            CubicInterpolatorTest.assertEqual(0.0f, ci.interpolate2(xpos));
            CubicInterpolatorTest.assertEqual(0.0f, ci.interpolate3(xpos));
        } else {
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv2(abcd, xpos - xi), ci.interpolate2(xpos));
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv3(abcd, xpos - xi), ci.interpolate3(xpos));
        }
        xpos = x[npoints - 1] + 0.5f * xinterval;
        xi = x[npoints - 1];
        yi0 = ci.interpolate(xi);
        yi1 = ci.interpolate1(xi);
        xj = x[npoints - 1] + xinterval;
        yj0 = ci.interpolate(xj);
        yj1 = ci.interpolate1(xj);
        abcd = CubicInterpolatorTest.computeCoefficients(xi, yi0, yi1, xj, yj0, yj1);
        CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv0(abcd, xpos - xi), ci.interpolate(xpos));
        CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv1(abcd, xpos - xi), ci.interpolate1(xpos));
        if (type == CubicInterpolator.Method.LINEAR) {
            CubicInterpolatorTest.assertEqual(0.0f, ci.interpolate2(xpos));
            CubicInterpolatorTest.assertEqual(0.0f, ci.interpolate3(xpos));
        } else {
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv2(abcd, xpos - xi), ci.interpolate2(xpos));
            CubicInterpolatorTest.assertEqual(CubicInterpolatorTest.deriv3(abcd, xpos - xi), ci.interpolate3(xpos));
        }
    }

    private static float[] computeCoefficients(float xi, float yi0, float yi1, float xj, float yj0, float yj1) {
        float dx = xj - xi;
        float dydx = (yj0 - yi0) / dx;
        float a = (yi1 + yj1 - 2.0f * dydx) / (dx * dx);
        float b = (3.0f * dydx - 2.0f * yi1 - yj1) / dx;
        float c = yi1;
        float d = yi0;
        return new float[]{a, b, c, d};
    }

    private static float deriv0(float[] abcd, float dx) {
        return ((abcd[0] * dx + abcd[1]) * dx + abcd[2]) * dx + abcd[3];
    }

    private static float deriv1(float[] abcd, float dx) {
        return (3.0f * abcd[0] * dx + 2.0f * abcd[1]) * dx + abcd[2];
    }

    private static float deriv2(float[] abcd, float dx) {
        return 6.0f * abcd[0] * dx + 2.0f * abcd[1];
    }

    private static float deriv3(float[] abcd, float dx) {
        return 6.0f * abcd[0];
    }

    private static void assertEqual(float x, float y) {
        CubicInterpolatorTest.assertTrue((String)(x + " = " + y), (boolean)CubicInterpolatorTest.almostEqual(x, y));
    }

    private static boolean almostEqual(float x, float y) {
        float ax = ArrayMath.abs(x);
        float ay = ArrayMath.abs(y);
        return ArrayMath.abs(x - y) <= 0.001f * ArrayMath.max(ax, ay);
    }
}

