/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.BlendedGridder2;
import edu.mines.jtk.interp.Gridder2;
import edu.mines.jtk.interp.NearestGridder2;
import edu.mines.jtk.interp.SibsonGridder2;
import edu.mines.jtk.interp.SimpleGridder2;
import edu.mines.jtk.interp.TestFunction;
import edu.mines.jtk.mosaic.PixelsView;
import edu.mines.jtk.mosaic.PointsView;
import edu.mines.jtk.mosaic.SimplePlot;
import edu.mines.jtk.util.ArrayMath;
import javax.swing.SwingUtilities;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;

public class Gridder2Test
extends TestCase {
    private static final float XMIN = 0.0f;
    private static final float XMAX = 1.0f;
    private static final int NS = 49;
    private static final int NX = 201;
    private static final double DX = (double)0.005f;
    private static final double FX = 0.0;
    private static final Sampling SX = new Sampling(201, 0.005f, 0.0);

    public static void main(String[] args) {
        if (args.length >= 1 && args[0].equals("demo")) {
            Gridder2Test.demo();
            return;
        }
        TestSuite suite = new TestSuite(Gridder2Test.class);
        TestRunner.run((Test)suite);
    }

    public void testNothing() {
    }

    public static void demo() {
        TestFunction[] tfa;
        TestFunction tfs = TestFunction.makeSine();
        TestFunction tfl = TestFunction.makeLinear();
        TestFunction tfq = TestFunction.makeSphericalQuadratic();
        for (TestFunction tf : tfa = new TestFunction[]{tfl, tfs}) {
            Gridder2Test.doScattered(tf);
            Gridder2Test.doUniform(tf);
        }
    }

    private static void doScattered(TestFunction tf) {
        float[][] fx = tf.sampleScattered2(49, 0.0f, 1.0f, 0.0f, 1.0f);
        Gridder2Test.doGridders(tf, fx);
    }

    private static void doUniform(TestFunction tf) {
        float[][] fx = tf.sampleUniform2(49, 0.0f, 1.0f, 0.0f, 1.0f);
        Gridder2Test.doGridders(tf, fx);
    }

    private static void doGridders(TestFunction tf, float[][] fx) {
        Gridder2[] gridders;
        float[] f = fx[0];
        float[] x1 = fx[1];
        float[] x2 = fx[2];
        float[][] fk = null;
        float fkmin = 0.0f;
        float fkmax = 0.0f;
        if (tf != null) {
            fk = tf.sampleUniform2(SX, SX);
            fkmin = ArrayMath.min(fk);
            fkmax = ArrayMath.max(fk);
            Gridder2Test.plot("known", fkmin, fkmax, fk, x1, x2);
        }
        SimpleGridder2 simple = new SimpleGridder2(f, x1, x2);
        NearestGridder2 nearest = new NearestGridder2(f, x1, x2);
        BlendedGridder2 blended = new BlendedGridder2(f, x1, x2);
        SibsonGridder2 sibson0 = new SibsonGridder2(f, x1, x2);
        SibsonGridder2 sibson1 = new SibsonGridder2(f, x1, x2);
        sibson1.setSmooth(true);
        for (Gridder2 gridder : gridders = new Gridder2[]{simple, nearest, blended, sibson0, sibson1}) {
            float[][] g = gridder.grid(SX, SX);
            Gridder2Test.plot(gridder.getClass().getName(), fkmin, fkmax, g, x1, x2);
        }
    }

    private static void plot(final String method, final float cmin, final float cmax, final float[][] g, final float[] x1, final float[] x2) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                System.out.println("min=" + ArrayMath.min(g) + " max=" + ArrayMath.max(g));
                SimplePlot sp = new SimplePlot();
                sp.setTitle(method);
                sp.setSize(847, 740);
                sp.addColorBar();
                sp.getPlotPanel().setColorBarWidthMinimum(100);
                PixelsView pv = sp.addPixels(SX, SX, g);
                pv.setColorModel(ColorMap.JET);
                pv.setInterpolation(PixelsView.Interpolation.LINEAR);
                if (cmin < cmax) {
                    pv.setClips(cmin, cmax);
                }
                PointsView px = sp.addPoints(x1, x2);
                px.setLineStyle(PointsView.Line.NONE);
                px.setMarkStyle(PointsView.Mark.FILLED_CIRCLE);
                px.setMarkSize(6.0f);
            }
        });
    }
}

