/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.interp;

import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.interp.Gridder3;
import edu.mines.jtk.mesh.TetMesh;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import java.util.logging.Logger;

public class NearestGridder3
implements Gridder3 {
    private static Logger log = Logger.getLogger(NearestGridder3.class.getName());
    private float[] _f;
    private TetMesh _mesh;

    public NearestGridder3(float[] f, float[] x1, float[] x2, float[] x3) {
        this.setScattered(f, x1, x2, x3);
    }

    public void computeDistancesAndValues(Sampling s1, Sampling s2, Sampling s3, float[][][] d, float[][][] g) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n3 = s3.getCount();
        for (int i3 = 0; i3 < n3; ++i3) {
            log.fine("computeDistancesAndValues: i3=" + i3);
            float x3 = (float)s3.getValue(i3);
            for (int i2 = 0; i2 < n2; ++i2) {
                log.finer("computeDistancesAndValues: i2=" + i2);
                float x2 = (float)s2.getValue(i2);
                for (int i1 = 0; i1 < n1; ++i1) {
                    float x1 = (float)s1.getValue(i1);
                    TetMesh.Node node = this._mesh.findNodeNearest(x1, x2, x3);
                    if (g != null) {
                        g[i3][i2][i1] = this._f[node.index];
                    }
                    if (d == null) continue;
                    float d1 = x1 - node.x();
                    float d2 = x2 - node.y();
                    float d3 = x3 - node.z();
                    d[i3][i2][i1] = ArrayMath.sqrt(d1 * d1 + d2 * d2 + d3 * d3);
                }
            }
        }
    }

    @Override
    public void setScattered(float[] f, float[] x1, float[] x2, float[] x3) {
        this._f = ArrayMath.copy(f);
        this._mesh = new TetMesh();
        int n = f.length;
        int i = 0;
        while (i < n) {
            TetMesh.Node node = new TetMesh.Node(x1[i], x2[i], x3[i]);
            node.index = i++;
            boolean added = this._mesh.addNode(node);
            Check.argument(added, "samples have unique coordinates (x1,x2,x3)");
        }
    }

    @Override
    public float[][][] grid(Sampling s1, Sampling s2, Sampling s3) {
        int n1 = s1.getCount();
        int n2 = s2.getCount();
        int n3 = s3.getCount();
        float[][][] g = new float[n3][n2][n1];
        this.computeDistancesAndValues(s1, s2, s3, null, g);
        return g;
    }
}

