/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.lapack;

import edu.mines.jtk.lapack.DMatrix;
import edu.mines.jtk.lapack.LapackInfo;
import edu.mines.jtk.util.ArrayMath;
import edu.mines.jtk.util.Check;
import org.netlib.lapack.LAPACK;
import org.netlib.util.intW;

public class DMatrixEvd {
    private static final LAPACK _lapack = LAPACK.getInstance();
    private int _n;
    private double[] _v;
    private double[] _d;
    private double[] _e;

    public DMatrixEvd(DMatrix a) {
        Check.argument(a.isSquare(), "A is square");
        this._n = a.getN();
        this._v = new double[this._n * this._n];
        this._d = new double[this._n];
        this._e = new double[this._n];
        double[] aa = a.getPackedColumns();
        LapackInfo li = new LapackInfo();
        intW mW = new intW(0);
        if (a.isSymmetric()) {
            int[] isuppz = new int[2 * this._n];
            double[] work = new double[1];
            int[] iwork = new int[1];
            _lapack.dsyevr("V", "A", "L", this._n, aa, this._n, 0.0, 0.0, 0, 0, 0.0, mW, this._d, this._v, this._n, isuppz, work, -1, iwork, -1, (intW)li);
            if (li.get("dsyevr") > 0) {
                throw new RuntimeException("internal error in LAPACK dsyevr");
            }
            int lwork = (int)work[0];
            work = new double[lwork];
            int liwork = iwork[0];
            iwork = new int[liwork];
            _lapack.dsyevr("V", "A", "L", this._n, aa, this._n, 0.0, 0.0, 0, 0, 0.0, mW, this._d, this._v, this._n, isuppz, work, lwork, iwork, liwork, (intW)li);
            if (li.get("dsyevr") > 0) {
                throw new RuntimeException("internal error in LAPACK dsyevr");
            }
        } else {
            double[] work = new double[1];
            _lapack.dgeev("N", "V", this._n, aa, this._n, this._d, this._e, this._v, this._n, this._v, this._n, work, -1, (intW)li);
            li.check("dgeev");
            int lwork = (int)work[0];
            work = new double[lwork];
            _lapack.dgeev("N", "V", this._n, aa, this._n, this._d, this._e, this._v, this._n, this._v, this._n, work, lwork, (intW)li);
            if (li.get("dgeev") > 0) {
                throw new RuntimeException("LAPACK dgeev failed to converge");
            }
        }
    }

    public DMatrix getV() {
        return new DMatrix(this._n, this._n, this._v);
    }

    public DMatrix getD() {
        double[] d = new double[this._n * this._n];
        for (int i = 0; i < this._n; ++i) {
            for (int j = 0; j < this._n; ++j) {
                d[i + j * this._n] = 0.0;
            }
            d[i + i * this._n] = this._d[i];
            if (this._e[i] > 0.0) {
                d[i + (i + 1) * this._n] = this._e[i];
                continue;
            }
            if (!(this._e[i] < 0.0)) continue;
            d[i + (i - 1) * this._n] = this._e[i];
        }
        return new DMatrix(this._n, this._n, d);
    }

    public double[] getRealEigenvalues() {
        return ArrayMath.copy(this._d);
    }

    public double[] getImagEigenvalues() {
        return ArrayMath.copy(this._e);
    }
}

